/********************************************************
 Title : LoanPartyBankConf
 Date  : 07/08/2013
 Author: Swati Bade

 ********************************************************/

package ibase.webitm.ejb.fin;

import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import javax.ejb.Stateless;

@Stateless
public class LoanPartyBankConf extends ActionHandlerEJB implements 
              LoanPartyBankConfLocal,LoanPartyBankConfRemote 
  {
	public String confirm(String tranId,String xtraParams, String forcedFlag) 
			              throws RemoteException, ITMException
		     {
		       
		        System.out.println("in LoanPartyBankConf EJB confirm action");
		        GenericUtility genericUtility;
		        Connection conn = null;
				PreparedStatement pStmt = null;
				ResultSet rs = null;
				String sql = "";
				String userId = "",confirmed="",activStatus="";
				String partyCode="",bankBenCode="";
				String[] temp;
				int count=0;
				String errString = "",errCode="";
				ITMDBAccessEJB itmDBAccessEJB = null;
		       try
		       {
		         itmDBAccessEJB = new ITMDBAccessEJB();
		         ConnDriver connDriver = new ConnDriver();
				 conn = connDriver.getConnectDB("DriverITM");
				 connDriver = null;
		         if(tranId.length()>0 && tranId!="")
		         {
		          temp =tranId.split(":");
		          partyCode=temp[0];
		          bankBenCode=temp[1];
		          genericUtility = GenericUtility.getInstance();
		          userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,
		        		                                          "loginEmpCode");
		          sql = "select confirmed,active_yn from loanparty_bank where " +
		          		"party_code=? and BANK_CODE__BEN=?";
		          pStmt = conn.prepareStatement(sql);
		          pStmt.setString(1, partyCode);
				  pStmt.setString(2, bankBenCode);
				  rs = pStmt.executeQuery();
					while(rs.next())
					{
						confirmed = rs.getString(1)==null?"":rs.getString(1);
						activStatus=rs.getString(2)==null?"":rs.getString(2);						
					}
					pStmt = null;
					rs.close();
					rs = null;
	                if(confirmed.equalsIgnoreCase("Y"))
					{
	                    errString = itmDBAccessEJB.getErrorString("","VTCONF8",
	                    		                                  "","",conn);	
	                    
					}else if(activStatus.equalsIgnoreCase("N")){
					errString = itmDBAccessEJB.getErrorString("","VMDECTRA",
							                                  "","",conn);	
					}
	                else if(activStatus.equalsIgnoreCase("Y") 
						    && (confirmed.equalsIgnoreCase("N") || 
						    		confirmed.equalsIgnoreCase("")))
	                {
	                	sql=" update loanparty_bank set confirmed='Y'," 
	                	   +" conf_date=sysdate,emp_code__aprv=? " 
	       		           +" where party_code=? and BANK_CODE__BEN=?";
	       		        pStmt = conn.prepareStatement(sql);
	       		        pStmt.setString(1, userId);
	       				pStmt.setString(2, partyCode);
	       				pStmt.setString(3, bankBenCode);
	       				count =pStmt.executeUpdate();	       				
	       				if(count>0)	{
	       				errString = itmDBAccessEJB.getErrorString("","CONFSUCC","",
	       							                                  "",conn);							
	       				}else{
	       				errString = itmDBAccessEJB.getErrorString("","VTTRATWINS","",
	       							                                  "",conn);
	       				}
	                }					  
				    
		         }
		         
		       }
		       catch(Exception e)
		       {
		    	    e.printStackTrace();
					System.out.println("Exception LoanPartyBankConf:confirm " 
		    	                       + e.getMessage());
					errString = e.getMessage();
					throw new ITMException(e);
		         
		       }
		       finally {
					try {
						if (rs != null) {
							rs.close();
							rs = null;
						}
						if (pStmt != null) {
							pStmt.close();
							pStmt = null;
						}
						if (conn != null) {
							conn.close();
						}
						conn = null;
					} catch (Exception d) {
						d.printStackTrace();
						System.out.println("Exception LoanPartyBankConf:confirm " 
						                     + d);
					}
				}
		       return errString;
		     }

	

}