
ALTER TABLE SPL_SALES_POR_HDR ADD REMARKS VARCHAR2(120);

ALTER TABLE SPL_SALES_POR_HDR MODIFY CUST_CODE__SOLTO CHAR(10);

COMMIT;

Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('proof_of_delivery','1  ','cust_code__solto','Y');

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,FILTER_STRING,SQL_INPUT,DEFAULT_COL,POP_ALIGN,QUERY_MODE,PAGE_CONTEXT,POPHELP_COLS,POPHELP_SOURCE,MULTI_OPT,HELP_OPTION,POPUP_XSL_NAME) 
VALUES ('CUSTOMER_CUST_CODE','W_PROOF_OF_DELIVERY','SELECT CUST_CODE,CUST_NAME FROM CUSTOMER',NULL,
'Customer Code',0,0,SYSDATE,'BASE','BASE',
null,null,null,null,null,null,null,null,null,null,'1',null);

INSERT INTO DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('999999','PROOF_OF_DELIVERY','N','10','Stockiest Margin of products to approve rate of Sales for Stockiest',NULL,SYSDATE,'BASE','SANKET');

INSERT INTO DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('999999','POD_PRD_DATE','D','01-NOV-14','POD Process activate w.e.f. 01-11-14',NULL,SYSDATE,'BASE','SANKET');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION)
VALUES ('VTREJNOTAB','Rejection Remark Is Blank','Reject Remark should Not be blank. When Status is Reject.','E',NULL,NULL,NULL,NULL,SYSDATE,'SANKET','SANKET',NULL,NULL);

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION)
VALUES ('VTREJNOTAC','Rejection Remark Should Blank','Reject Remark should be blank. When Status is Not Reject.','E',NULL,NULL,NULL,NULL,SYSDATE,'SANKET','SANKET',NULL,NULL);



COMMIT;


CREATE OR REPLACE FUNCTION DDF_GET_BALQTY_POD(TRAN_ID_1 varCHAR2 ,LINE_NO_1 number)
RETURN NUMBER IS
BAL_QTY NUMBER(14,3);
   BEGIN
     BAL_QTY := 0;
       SELECT (SPL_SALES_POR_DET.PEND_QTY - SPL_SALES_POR_DET.QUANTITY__RESALE) INTO BAL_QTY
       FROM SPL_SALES_POR_DET WHERE SPL_SALES_POR_DET.TRAN_ID= TRAN_ID_1 AND SPL_SALES_POR_DET.LINE_NO= LINE_NO_1;
     RETURN BAL_QTY;
END;

INSERT INTO TRANSETUP (	TRAN_WINDOW,SAVE_FLAG ,	VAL_FLAG ,	KEY_FLAG ,	KEY_STRING ,	REPEATE_ADD ,	CHG_DATE ,	CHG_USER ,	CHG_TERM ,	EDI_OPTION ,	WORKFLOW_OPT 	)
VALUES ('w_pod_process','2','2','A','seq10','Y',SYSDATE,'SANKET','SANKET ','0','2');

COMMIT;

create table spl_sales_por_hdr (
tran_id Char(10), 
tran_date Date NOT NULL,
invoice_id  Char(10) NOT NULL,
site_code Char(5) NOT NULL,
cust_code Char(10) NOT NULL,
curr_code Char(5),
exch_rate Number(14,6),
amount	number(14,3),
tran_id__drn char(10),
confirmed char(1),
conf_date date ,
emp_code__aprv char(10),
wf_status  char(1),
chg_date date NOT NULL,
chg_user char(10) NOT NULL,
CHG_TERM CHAR(15) NOT NULL
);
SELECT DDF_GET_BALQTY_POD('1000',1) FROM DUAL;


ALTER TABLE spl_sales_por_hdr ADD CONSTRAINT spl_sales_por_hdr_X PRIMARY KEY (TRAN_ID) USING INDEX; TABLESPACE ITM_DIS_I1;

ALTER TABLE spl_sales_por_hdr ADD CONSTRAINT FK_spl_sales_por_hdr_I FOREIGN KEY (INVOICE_ID) REFERENCES invoice (INVOICE_ID);

ALTER TABLE spl_sales_por_hdr ADD CONSTRAINT FK_spl_sales_por_hdr_S FOREIGN KEY (SITE_CODE) REFERENCES site (SITE_CODE);

ALTER TABLE spl_sales_por_hdr ADD CONSTRAINT FK_spl_sales_por_hdr_C FOREIGN KEY (CUST_CODE) REFERENCES customer (CUST_CODE);

ALTER TABLE spl_sales_por_hdr ADD CONSTRAINT FK_spl_sales_por_hdr_U FOREIGN KEY (CURR_CODE) REFERENCES currency (CURR_CODE);

ALTER TABLE spl_sales_por_hdr ADD CONSTRAINT FK_spl_sales_por_hdr_E FOREIGN KEY (EMP_CODE__APRV) REFERENCES employee (EMP_CODE);



create table spl_sales_por_det (
tran_id Char(10) not null,
line_no Number(3) NOT NULL,
line_no__trace Number(3) NOT NULL,
item_code Char(10) NOT NULL,
loc_code Char(8),
lot_no Char(15),
lot_sl Char(15),
bill_no Varchar2(40),
bil_date Date,
rate__inv  number(15,4),
rate__resale number(15,4),
quantity__inv number(14,3),
quantity__resale number(14,3),
AMOUNT NUMBER(14,3)
);

ALTER TABLE spl_sales_por_det ADD CONSTRAINT spl_sales_por_det_X PRIMARY KEY (TRAN_ID,LINE_NO) USING INDEX; TABLESPACE ITM_DIS_I1;

ALTER TABLE spl_sales_por_det ADD CONSTRAINT FK_spl_sales_por_det FOREIGN KEY (TRAN_ID) REFERENCES spl_sales_por_hdr (TRAN_ID) ON DELETE CASCADE;
ALTER TABLE spl_sales_por_det ADD CONSTRAINT FK_spl_sales_por_det_I FOREIGN KEY (ITEM_CODE) REFERENCES item (ITEM_CODE) ;
ALTER TABLE SPL_SALES_POR_DET ADD CONSTRAINT FK_SPL_SALES_POR_DET_L FOREIGN KEY (LOC_CODE) REFERENCES LOCATION (LOC_CODE) ;

alter table spl_sales_por_det add remarks varchar2(100);
alter table spl_sales_por_det add transit_day number(3);
alter table spl_sales_por_hdr add debit_note_amt number(14,3);
alter table spl_sales_por_det add debit_note_amt number(14,3);

ALTER TABLE SPL_SALES_POR_DET ADD APRV_RATE NUMBER(15,4);

commit;







