/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "bn" locale.
 */
public class LocalizedNamesImpl_bn extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "BD",
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "BQ",
        "CW",
        "SS",
        "SX",
        "AT",
        "AU",
        "AC",
        "CI",
        "IS",
        "QO",
        "AZ",
        "AF",
        "AS",
        "IE",
        "AW",
        "AR",
        "AM",
        "AL",
        "AX",
        "UA",
        "EU",
        "EC",
        "IT",
        "ID",
        "ET",
        "YE",
        "IQ",
        "IR",
        "ER",
        "IL",
        "UG",
        "UZ",
        "KP",
        "MP",
        "UY",
        "AQ",
        "AG",
        "DZ",
        "SV",
        "EE",
        "AI",
        "AO",
        "AD",
        "OM",
        "WF",
        "CG",
        "CD",
        "KM",
        "KZ",
        "QA",
        "CA",
        "KH",
        "CU",
        "KI",
        "KG",
        "EA",
        "CK",
        "KW",
        "KE",
        "CV",
        "KY",
        "CC",
        "CO",
        "CR",
        "IC",
        "CM",
        "CX",
        "HR",
        "CP",
        "GM",
        "GN",
        "GW",
        "GY",
        "GP",
        "GU",
        "GT",
        "GA",
        "GG",
        "GL",
        "GR",
        "GB",
        "GD",
        "GH",
        "TD",
        "CL",
        "CN",
        "CZ",
        "GE",
        "JO",
        "JP",
        "ZM",
        "DE",
        "JE",
        "DJ",
        "GI",
        "ZW",
        "JM",
        "TN",
        "TV",
        "TK",
        "TG",
        "TO",
        "TA",
        "DK",
        "DM",
        "DO",
        "TW",
        "TJ",
        "TZ",
        "TR",
        "TM",
        "TC",
        "TT",
        "TH",
        "ZA",
        "KR",
        "GS",
        "DG",
        "NO",
        "NE",
        "NG",
        "NR",
        "NA",
        "NC",
        "NZ",
        "NU",
        "NI",
        "GQ",
        "NF",
        "AN",
        "NP",
        "PT",
        "EH",
        "PK",
        "PA",
        "PG",
        "PW",
        "PN",
        "PE",
        "PR",
        "TL",
        "PL",
        "PY",
        "FK",
        "GF",
        "TF",
        "PF",
        "FJ",
        "FI",
        "PH",
        "PS",
        "FO",
        "FR",
        "BW",
        "BA",
        "BD",
        "BB",
        "BM",
        "BH",
        "BS",
        "BF",
        "BI",
        "BG",
        "BJ",
        "BE",
        "BZ",
        "BY",
        "BV",
        "BO",
        "BR",
        "IO",
        "VG",
        "BN",
        "VU",
        "IN",
        "VN",
        "BT",
        "VE",
        "VA",
        "MX",
        "MN",
        "CF",
        "MS",
        "ME",
        "MR",
        "MU",
        "FM",
        "MG",
        "MM",
        "YT",
        "VI",
        "US",
        "MQ",
        "MH",
        "MV",
        "MW",
        "ML",
        "MT",
        "MY",
        "EG",
        "MZ",
        "MC",
        "MA",
        "MD",
        "MO",
        "IM",
        "MK",
        "UM",
        "RU",
        "RE",
        "RO",
        "RW",
        "LR",
        "LA",
        "LU",
        "LV",
        "LI",
        "LT",
        "LY",
        "LB",
        "LS",
        "LK",
        "SK",
        "AE",
        "SB",
        "CY",
        "SA",
        "ST",
        "SM",
        "WS",
        "RS",
        "CS",
        "SG",
        "SL",
        "SY",
        "SC",
        "CH",
        "SE",
        "SD",
        "SR",
        "SN",
        "KN",
        "PM",
        "BL",
        "VC",
        "MF",
        "LC",
        "SH",
        "SO",
        "SZ",
        "ES",
        "SJ",
        "SI",
        "HK",
        "HN",
        "NL",
        "HT",
        "HU",
        "HM",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "পৃথিবী");
    namesMap.put("002", "আফ্রিকা");
    namesMap.put("003", "উত্তর আমেরিক");
    namesMap.put("005", "দক্ষিন আমেরিকা");
    namesMap.put("009", "ওসানিয়া");
    namesMap.put("011", "পশ্চিমাঞ্চলীয় আফ্রিকা");
    namesMap.put("013", "মধ্য আমেরিকা");
    namesMap.put("014", "পূর্ব আফ্রিকা");
    namesMap.put("015", "উত্তর আফ্রিকা");
    namesMap.put("017", "মধ্য আফ্রিকা");
    namesMap.put("018", "দক্ষিণাঞ্চলীয় আফ্রিকা");
    namesMap.put("019", "আমেরিকাস");
    namesMap.put("021", "উত্তরাঞ্চলীয় আমেরিকা");
    namesMap.put("029", "ক্যারাবিয়ান");
    namesMap.put("030", "পূর্ব এশিয়া");
    namesMap.put("034", "দক্ষিণাঞ্চলীয় এশিয়া");
    namesMap.put("035", "দক্ষিন পূর্ব এশিয়া");
    namesMap.put("039", "দক্ষিণাঞ্চলীয় ইউরোপ");
    namesMap.put("053", "অস্ট্রেলিয়া এবং নিউজিল্যান্ড");
    namesMap.put("054", "ম্যালেনেশিয়া");
    namesMap.put("057", "ম্যালেনিশা অঞ্চল");
    namesMap.put("061", "পলিনেশিয়া");
    namesMap.put("142", "এশিয়া");
    namesMap.put("143", "মধ্য এশিয়া");
    namesMap.put("145", "পশ্চিমাঞ্চলীয় এশিয়া");
    namesMap.put("150", "ইউরোপ");
    namesMap.put("151", "পূর্ব ইউরোপ");
    namesMap.put("154", "উত্তরাঞ্চলীয় ইউরোপ");
    namesMap.put("155", "পশ্চিমাঞ্চলীয় ইউরোপ");
    namesMap.put("419", "ল্যাটিন আমেরিকা এবং ক্যারাবিয়ান");
    namesMap.put("AC", "অ্যাসসেনশন আইল্যান্ড");
    namesMap.put("AD", "এ্যান্ডোরা");
    namesMap.put("AE", "সংযুক্ত আরব আমিরাত");
    namesMap.put("AF", "আফগানিস্তান");
    namesMap.put("AG", "এন্টিগুয়া ও বারবুডা");
    namesMap.put("AI", "এ্যাঙ্গুইলা");
    namesMap.put("AL", "আলব্যানিয়া");
    namesMap.put("AM", "আর্মেনিয়া");
    namesMap.put("AN", "নেদারল্যান্ডস এ্যান্টিলিস");
    namesMap.put("AO", "এ্যাঙ্গোলা");
    namesMap.put("AQ", "এন্টার্কটিকা");
    namesMap.put("AR", "আর্জেণ্টাইনা");
    namesMap.put("AS", "আমেরিকান সামোয়া");
    namesMap.put("AT", "অস্ট্রিয়া");
    namesMap.put("AU", "অস্ট্রেলিয়া");
    namesMap.put("AW", "আরুবা");
    namesMap.put("AX", "আলান্ড দ্বীপপুঞ্জ");
    namesMap.put("AZ", "আজারবাইজান");
    namesMap.put("BA", "বসনিয়া ও হার্জেগোভিনা");
    namesMap.put("BB", "বারবাদোস");
    namesMap.put("BD", "বাংলাদেশ");
    namesMap.put("BE", "বেলজিয়াম");
    namesMap.put("BF", "বুরকিনা ফাসো");
    namesMap.put("BG", "বুলগেরিয়া");
    namesMap.put("BH", "বাহরাইন");
    namesMap.put("BI", "বুরুন্ডি");
    namesMap.put("BJ", "বেনিন");
    namesMap.put("BL", "সেন্ট বারথেলিমি");
    namesMap.put("BM", "বারমুডা");
    namesMap.put("BN", "ব্রুনেই");
    namesMap.put("BO", "বোলিভিয়া");
    namesMap.put("BR", "ব্রাজিল");
    namesMap.put("BS", "বাহামা দ্বীপপুঞ্জ");
    namesMap.put("BT", "ভুটান");
    namesMap.put("BV", "বোভেট দ্বীপ");
    namesMap.put("BW", "বতসোয়ানা");
    namesMap.put("BY", "বেলোরুশিয়া");
    namesMap.put("BZ", "বেলিয");
    namesMap.put("CA", "কানাডা");
    namesMap.put("CC", "কোকোস দ্বীপপুঞ্জ");
    namesMap.put("CD", "কঙ্গো - কিনসাসা");
    namesMap.put("CF", "মধ্য আফ্রিকান প্রজাতন্ত্র");
    namesMap.put("CG", "কঙ্গো");
    namesMap.put("CH", "সুইজর্লণ্ড");
    namesMap.put("CI", "আইভরি কোস্ট");
    namesMap.put("CK", "কুক দ্বীপপুঞ্জ");
    namesMap.put("CL", "চিলি");
    namesMap.put("CM", "ক্যামেরুন");
    namesMap.put("CN", "চীন");
    namesMap.put("CO", "কোলোম্বিয়া");
    namesMap.put("CP", "ক্লিপারটন আইল্যান্ড");
    namesMap.put("CR", "কোস্টারিকা");
    namesMap.put("CS", "সারবিয়ান এবং মন্টেনিগ্রো");
    namesMap.put("CU", "কিউবা");
    namesMap.put("CV", "কেপভার্দে");
    namesMap.put("CX", "ক্রিসমাস দ্বীপ");
    namesMap.put("CY", "সাইপ্রাস");
    namesMap.put("CZ", "চেক প্রজাতন্ত্র");
    namesMap.put("DE", "জার্মানি");
    namesMap.put("DG", "দিয়েগো গার্সিয়া");
    namesMap.put("DJ", "জিবুতি");
    namesMap.put("DK", "ডেনমার্ক");
    namesMap.put("DM", "ডোমিনিকা");
    namesMap.put("DO", "ডোমেনিকান প্রজাতন্ত্র");
    namesMap.put("DZ", "এলজিরিয়া");
    namesMap.put("EA", "কুউটা এবং মেলিলা");
    namesMap.put("EC", "ইকুয়েডর");
    namesMap.put("EE", "এস্তোনিয়া");
    namesMap.put("EG", "মিশর");
    namesMap.put("EH", "পশ্চিমী সাহারা");
    namesMap.put("ER", "ইরিত্রিয়া");
    namesMap.put("ES", "স্পেন");
    namesMap.put("ET", "ইফিওপিয়া");
    namesMap.put("EU", "ইউরোপীয় ইউনিয়ন");
    namesMap.put("FI", "ফিন্ল্যাণ্ড");
    namesMap.put("FJ", "ফিজি");
    namesMap.put("FK", "ফকল্যান্ড দ্বীপপুঞ্জ");
    namesMap.put("FM", "মাইক্রোনেশিয়া");
    namesMap.put("FO", "ফ্যারও দ্বীপপুঞ্জ");
    namesMap.put("FR", "ফ্রান্স");
    namesMap.put("GA", "গ্যাবন");
    namesMap.put("GB", "গ্রেটবৃটেন");
    namesMap.put("GD", "গ্রেনাডা");
    namesMap.put("GE", "জর্জিয়া");
    namesMap.put("GF", "ফরাসী গায়ানা");
    namesMap.put("GG", "গ্রাঞ্জি");
    namesMap.put("GH", "ঘানা");
    namesMap.put("GI", "জিব্রাল্টার");
    namesMap.put("GL", "গ্রীনল্যান্ড");
    namesMap.put("GM", "গাম্বিয়া");
    namesMap.put("GN", "গিনি");
    namesMap.put("GP", "গুয়াদেলৌপ");
    namesMap.put("GQ", "নিরক্ষীয় গিনি");
    namesMap.put("GR", "গ্রীস্");
    namesMap.put("GS", "দক্ষিণ জর্জিয়া ও দক্ষিণ স্যান্ডউইচ দ্বীপপুঞ");
    namesMap.put("GT", "গোয়াটিমালা");
    namesMap.put("GU", "গুয়াম");
    namesMap.put("GW", "গিনি-বিসাউ");
    namesMap.put("GY", "গিয়ানা");
    namesMap.put("HK", "হংকং");
    namesMap.put("HM", "হার্ড দ্বীপ এবং ম্যাকডোনাল্ড দ্বীপপুঞ্জ");
    namesMap.put("HN", "হণ্ডুরাস");
    namesMap.put("HR", "ক্রোয়েশিয়া");
    namesMap.put("HT", "হাইতি");
    namesMap.put("HU", "হাঙ্গেরি");
    namesMap.put("IC", "ক্যানারি দ্বীপপুঞ্জ");
    namesMap.put("ID", "ইন্দোনেশিয়া");
    namesMap.put("IE", "আয়ার্লণ্ড");
    namesMap.put("IL", "ইস্রায়েল");
    namesMap.put("IM", "ম্যানদ্বীপ");
    namesMap.put("IN", "ভারত");
    namesMap.put("IO", "ব্রিটিশ ভারত মহাসাগরীয় অঞ্চল");
    namesMap.put("IQ", "ইরাক");
    namesMap.put("IR", "ইরান");
    namesMap.put("IS", "আইসলণ্ড");
    namesMap.put("IT", "ইতালী");
    namesMap.put("JE", "জার্সি");
    namesMap.put("JM", "জ্যামেকা");
    namesMap.put("JO", "জর্ডন");
    namesMap.put("JP", "জাপান");
    namesMap.put("KE", "কেনিয়া");
    namesMap.put("KG", "কির্গিজিয়া");
    namesMap.put("KH", "কাম্বোজ");
    namesMap.put("KI", "কিরিবাতি");
    namesMap.put("KM", "কমোরোস");
    namesMap.put("KN", "সেন্ট কিটস ও নেভিস");
    namesMap.put("KP", "উত্তর কোরিয়া");
    namesMap.put("KR", "দক্ষিণ কোরিয়া");
    namesMap.put("KW", "কুয়েত");
    namesMap.put("KY", "কেম্যান দ্বীপপুঞ্জ");
    namesMap.put("KZ", "কাজাকস্থান");
    namesMap.put("LA", "লাওস");
    namesMap.put("LB", "লেবানন");
    namesMap.put("LC", "সেন্ট লুসিয়া");
    namesMap.put("LI", "লিচেনস্টেইন");
    namesMap.put("LK", "শ্রীলঙ্কা");
    namesMap.put("LR", "লাইবেরিয়া");
    namesMap.put("LS", "লেসোথো");
    namesMap.put("LT", "লিত্ভা");
    namesMap.put("LU", "লাক্সেমবার্গ");
    namesMap.put("LV", "লাত্ভিয়া");
    namesMap.put("LY", "লিবিয়া");
    namesMap.put("MA", "মোরক্কো");
    namesMap.put("MC", "মোনাকো");
    namesMap.put("MD", "মোল্দাভিয়া");
    namesMap.put("ME", "মন্টিনিগ্রো");
    namesMap.put("MF", "সেন্ট মার্টিন");
    namesMap.put("MG", "মাদাগাস্কার");
    namesMap.put("MH", "মার্শাল দ্বীপপুঞ্জ");
    namesMap.put("MK", "ম্যাসাডোনিয়া");
    namesMap.put("ML", "মালি");
    namesMap.put("MM", "মায়ানমার");
    namesMap.put("MN", "মঙ্গোলিয়া");
    namesMap.put("MO", "ম্যাকাও");
    namesMap.put("MP", "উত্তরাঞ্চলীয় মারিয়ানা দ্বীপপুঞ্জ");
    namesMap.put("MQ", "মার্টিনিক");
    namesMap.put("MR", "মরিতানিয়া");
    namesMap.put("MS", "মন্টসেরাট");
    namesMap.put("MT", "মাল্টা");
    namesMap.put("MU", "মরিশাস");
    namesMap.put("MV", "মালদ্বীপ");
    namesMap.put("MW", "মালাউই");
    namesMap.put("MX", "মক্সিকো");
    namesMap.put("MY", "মাল্যাশিয়া");
    namesMap.put("MZ", "মোজাম্বিক");
    namesMap.put("NA", "নামিবিয়া");
    namesMap.put("NC", "নিউ ক্যালেডোনিয়া");
    namesMap.put("NE", "নাইজার");
    namesMap.put("NF", "নিরফোক দ্বীপ");
    namesMap.put("NG", "নাইজেরিয়া");
    namesMap.put("NI", "নিকারাগুয়া");
    namesMap.put("NL", "হলণ্ড");
    namesMap.put("NO", "নরওয়ে");
    namesMap.put("NP", "নেপাল");
    namesMap.put("NR", "নাউরু");
    namesMap.put("NU", "নিউয়ে");
    namesMap.put("NZ", "নিউ জিলণ্ড");
    namesMap.put("OM", "ওমান");
    namesMap.put("PA", "পানামা");
    namesMap.put("PE", "পিরু");
    namesMap.put("PF", "ফরাসী পলিনেশিয়া");
    namesMap.put("PG", "পাপুয়া নিউ গিনি");
    namesMap.put("PH", "ফিলিপাইন");
    namesMap.put("PK", "পাকিস্তান");
    namesMap.put("PL", "পোল্যাণ্ড");
    namesMap.put("PM", "সেন্ট পিয়ের ও মিকুয়েলন");
    namesMap.put("PN", "পিটকেয়ার্ন");
    namesMap.put("PR", "পুয়ের্টোরিকো");
    namesMap.put("PS", "ফিলিস্তিন অঞ্চল");
    namesMap.put("PT", "পর্তুগাল");
    namesMap.put("PW", "পালাউ");
    namesMap.put("PY", "প্যারাগোয়ে");
    namesMap.put("QA", "কাতার");
    namesMap.put("QO", "আউটলাইনিং ওসানিয়া");
    namesMap.put("RE", "রিইউনিয়ন");
    namesMap.put("RO", "রুমানিয়া");
    namesMap.put("RS", "সারবিয়া");
    namesMap.put("RU", "রাশিয়া");
    namesMap.put("RW", "রুয়ান্ডা");
    namesMap.put("SA", "সাউদি আরব");
    namesMap.put("SB", "সলোমন দ্বীপপুঞ্জ");
    namesMap.put("SC", "সিসিলি");
    namesMap.put("SD", "সুদান");
    namesMap.put("SE", "সুইডেন");
    namesMap.put("SG", "সিঙ্গাপুর");
    namesMap.put("SH", "সেন্ট হেলেনা");
    namesMap.put("SI", "স্লোভানিয়া");
    namesMap.put("SJ", "স্বালবার্ড ও জান মেয়েন");
    namesMap.put("SK", "শ্লোভাকিয়া");
    namesMap.put("SL", "সিয়েরালিওন");
    namesMap.put("SM", "সান মারিনো");
    namesMap.put("SN", "সেনেগাল");
    namesMap.put("SO", "সোমালি");
    namesMap.put("SR", "সুরিনাম");
    namesMap.put("ST", "সাওটোমা ও প্রিন্সিপি");
    namesMap.put("SV", "এল সালভেদর");
    namesMap.put("SY", "সিরিয়া");
    namesMap.put("SZ", "সোয়াজিল্যান্ড");
    namesMap.put("TA", "ট্রিস্টান ডা কুনা");
    namesMap.put("TC", "তুর্কস ও কাইকোস দ্বীপপুঞ্জ");
    namesMap.put("TD", "চাদ");
    namesMap.put("TF", "ফরাসী দক্ষিণাঞ্চল");
    namesMap.put("TG", "টোগো");
    namesMap.put("TH", "থাই");
    namesMap.put("TJ", "তাজিকস্থান");
    namesMap.put("TK", "টোকেলাউ");
    namesMap.put("TL", "পূর্ব-তিমুর");
    namesMap.put("TM", "তুর্কমেনিয়া");
    namesMap.put("TN", "টিউনিস্");
    namesMap.put("TO", "টোঙ্গা");
    namesMap.put("TR", "তুরস্ক");
    namesMap.put("TT", "ত্রিনিনাদ ও টোব্যাগো");
    namesMap.put("TV", "টুভালু");
    namesMap.put("TW", "তাইওয়ান");
    namesMap.put("TZ", "তাঞ্জানিয়া");
    namesMap.put("UA", "ইউক্রেইন");
    namesMap.put("UG", "উগান্ডা");
    namesMap.put("UM", "যুক্তরাষ্ট্রের ক্ষুদ্র ও পার্শ্ববর্তী দ্বীপপুঞ্জ");
    namesMap.put("US", "মার্কিন যুক্তরাষ্ট্র");
    namesMap.put("UY", "উরুগোয়ে");
    namesMap.put("UZ", "উজ্বেকিস্থান");
    namesMap.put("VA", "ভ্যাটিকান সিটি");
    namesMap.put("VC", "সেন্ট ভিনসেন্ট ও দ্যা গ্রেনাডিনস");
    namesMap.put("VE", "ভেনেজুয়েলা");
    namesMap.put("VG", "ব্রিটিশ ভার্জিন দ্বীপপুঞ্জ");
    namesMap.put("VI", "মার্কিন ভার্জিন দ্বীপপুঞ্জ");
    namesMap.put("VN", "ভিয়েতনাম");
    namesMap.put("VU", "ভানুয়াটু");
    namesMap.put("WF", "ওয়ালিস ও ফুটুনা");
    namesMap.put("WS", "সামোয়া");
    namesMap.put("YE", "ইমেন");
    namesMap.put("YT", "মায়োত্তে");
    namesMap.put("ZA", "দক্ষিণ আফ্রিকা");
    namesMap.put("ZM", "জাম্বিয়া");
    namesMap.put("ZW", "জিম্বাবুয়ে");
    namesMap.put("ZZ", "অজানা অথবা ভুল স্থান");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "পৃথিবী",
        "002": "আফ্রিকা",
        "003": "উত্তর আমেরিক",
        "005": "দক্ষিন আমেরিকা",
        "009": "ওসানিয়া",
        "011": "পশ্চিমাঞ্চলীয় আফ্রিকা",
        "013": "মধ্য আমেরিকা",
        "014": "পূর্ব আফ্রিকা",
        "015": "উত্তর আফ্রিকা",
        "017": "মধ্য আফ্রিকা",
        "018": "দক্ষিণাঞ্চলীয় আফ্রিকা",
        "019": "আমেরিকাস",
        "021": "উত্তরাঞ্চলীয় আমেরিকা",
        "029": "ক্যারাবিয়ান",
        "030": "পূর্ব এশিয়া",
        "034": "দক্ষিণাঞ্চলীয় এশিয়া",
        "035": "দক্ষিন পূর্ব এশিয়া",
        "039": "দক্ষিণাঞ্চলীয় ইউরোপ",
        "053": "অস্ট্রেলিয়া এবং নিউজিল্যান্ড",
        "054": "ম্যালেনেশিয়া",
        "057": "ম্যালেনিশা অঞ্চল",
        "061": "পলিনেশিয়া",
        "142": "এশিয়া",
        "143": "মধ্য এশিয়া",
        "145": "পশ্চিমাঞ্চলীয় এশিয়া",
        "150": "ইউরোপ",
        "151": "পূর্ব ইউরোপ",
        "154": "উত্তরাঞ্চলীয় ইউরোপ",
        "155": "পশ্চিমাঞ্চলীয় ইউরোপ",
        "419": "ল্যাটিন আমেরিকা এবং ক্যারাবিয়ান",
        "AC": "অ্যাসসেনশন আইল্যান্ড",
        "AD": "এ্যান্ডোরা",
        "AE": "সংযুক্ত আরব আমিরাত",
        "AF": "আফগানিস্তান",
        "AG": "এন্টিগুয়া ও বারবুডা",
        "AI": "এ্যাঙ্গুইলা",
        "AL": "আলব্যানিয়া",
        "AM": "আর্মেনিয়া",
        "AN": "নেদারল্যান্ডস এ্যান্টিলিস",
        "AO": "এ্যাঙ্গোলা",
        "AQ": "এন্টার্কটিকা",
        "AR": "আর্জেণ্টাইনা",
        "AS": "আমেরিকান সামোয়া",
        "AT": "অস্ট্রিয়া",
        "AU": "অস্ট্রেলিয়া",
        "AW": "আরুবা",
        "AX": "আলান্ড দ্বীপপুঞ্জ",
        "AZ": "আজারবাইজান",
        "BA": "বসনিয়া ও হার্জেগোভিনা",
        "BB": "বারবাদোস",
        "BD": "বাংলাদেশ",
        "BE": "বেলজিয়াম",
        "BF": "বুরকিনা ফাসো",
        "BG": "বুলগেরিয়া",
        "BH": "বাহরাইন",
        "BI": "বুরুন্ডি",
        "BJ": "বেনিন",
        "BL": "সেন্ট বারথেলিমি",
        "BM": "বারমুডা",
        "BN": "ব্রুনেই",
        "BO": "বোলিভিয়া",
        "BR": "ব্রাজিল",
        "BS": "বাহামা দ্বীপপুঞ্জ",
        "BT": "ভুটান",
        "BV": "বোভেট দ্বীপ",
        "BW": "বতসোয়ানা",
        "BY": "বেলোরুশিয়া",
        "BZ": "বেলিয",
        "CA": "কানাডা",
        "CC": "কোকোস দ্বীপপুঞ্জ",
        "CD": "কঙ্গো - কিনসাসা",
        "CF": "মধ্য আফ্রিকান প্রজাতন্ত্র",
        "CG": "কঙ্গো",
        "CH": "সুইজর্লণ্ড",
        "CI": "আইভরি কোস্ট",
        "CK": "কুক দ্বীপপুঞ্জ",
        "CL": "চিলি",
        "CM": "ক্যামেরুন",
        "CN": "চীন",
        "CO": "কোলোম্বিয়া",
        "CP": "ক্লিপারটন আইল্যান্ড",
        "CR": "কোস্টারিকা",
        "CS": "সারবিয়ান এবং মন্টেনিগ্রো",
        "CU": "কিউবা",
        "CV": "কেপভার্দে",
        "CX": "ক্রিসমাস দ্বীপ",
        "CY": "সাইপ্রাস",
        "CZ": "চেক প্রজাতন্ত্র",
        "DE": "জার্মানি",
        "DG": "দিয়েগো গার্সিয়া",
        "DJ": "জিবুতি",
        "DK": "ডেনমার্ক",
        "DM": "ডোমিনিকা",
        "DO": "ডোমেনিকান প্রজাতন্ত্র",
        "DZ": "এলজিরিয়া",
        "EA": "কুউটা এবং মেলিলা",
        "EC": "ইকুয়েডর",
        "EE": "এস্তোনিয়া",
        "EG": "মিশর",
        "EH": "পশ্চিমী সাহারা",
        "ER": "ইরিত্রিয়া",
        "ES": "স্পেন",
        "ET": "ইফিওপিয়া",
        "EU": "ইউরোপীয় ইউনিয়ন",
        "FI": "ফিন্ল্যাণ্ড",
        "FJ": "ফিজি",
        "FK": "ফকল্যান্ড দ্বীপপুঞ্জ",
        "FM": "মাইক্রোনেশিয়া",
        "FO": "ফ্যারও দ্বীপপুঞ্জ",
        "FR": "ফ্রান্স",
        "GA": "গ্যাবন",
        "GB": "গ্রেটবৃটেন",
        "GD": "গ্রেনাডা",
        "GE": "জর্জিয়া",
        "GF": "ফরাসী গায়ানা",
        "GG": "গ্রাঞ্জি",
        "GH": "ঘানা",
        "GI": "জিব্রাল্টার",
        "GL": "গ্রীনল্যান্ড",
        "GM": "গাম্বিয়া",
        "GN": "গিনি",
        "GP": "গুয়াদেলৌপ",
        "GQ": "নিরক্ষীয় গিনি",
        "GR": "গ্রীস্",
        "GS": "দক্ষিণ জর্জিয়া ও দক্ষিণ স্যান্ডউইচ দ্বীপপুঞ",
        "GT": "গোয়াটিমালা",
        "GU": "গুয়াম",
        "GW": "গিনি-বিসাউ",
        "GY": "গিয়ানা",
        "HK": "হংকং",
        "HM": "হার্ড দ্বীপ এবং ম্যাকডোনাল্ড দ্বীপপুঞ্জ",
        "HN": "হণ্ডুরাস",
        "HR": "ক্রোয়েশিয়া",
        "HT": "হাইতি",
        "HU": "হাঙ্গেরি",
        "IC": "ক্যানারি দ্বীপপুঞ্জ",
        "ID": "ইন্দোনেশিয়া",
        "IE": "আয়ার্লণ্ড",
        "IL": "ইস্রায়েল",
        "IM": "ম্যানদ্বীপ",
        "IN": "ভারত",
        "IO": "ব্রিটিশ ভারত মহাসাগরীয় অঞ্চল",
        "IQ": "ইরাক",
        "IR": "ইরান",
        "IS": "আইসলণ্ড",
        "IT": "ইতালী",
        "JE": "জার্সি",
        "JM": "জ্যামেকা",
        "JO": "জর্ডন",
        "JP": "জাপান",
        "KE": "কেনিয়া",
        "KG": "কির্গিজিয়া",
        "KH": "কাম্বোজ",
        "KI": "কিরিবাতি",
        "KM": "কমোরোস",
        "KN": "সেন্ট কিটস ও নেভিস",
        "KP": "উত্তর কোরিয়া",
        "KR": "দক্ষিণ কোরিয়া",
        "KW": "কুয়েত",
        "KY": "কেম্যান দ্বীপপুঞ্জ",
        "KZ": "কাজাকস্থান",
        "LA": "লাওস",
        "LB": "লেবানন",
        "LC": "সেন্ট লুসিয়া",
        "LI": "লিচেনস্টেইন",
        "LK": "শ্রীলঙ্কা",
        "LR": "লাইবেরিয়া",
        "LS": "লেসোথো",
        "LT": "লিত্ভা",
        "LU": "লাক্সেমবার্গ",
        "LV": "লাত্ভিয়া",
        "LY": "লিবিয়া",
        "MA": "মোরক্কো",
        "MC": "মোনাকো",
        "MD": "মোল্দাভিয়া",
        "ME": "মন্টিনিগ্রো",
        "MF": "সেন্ট মার্টিন",
        "MG": "মাদাগাস্কার",
        "MH": "মার্শাল দ্বীপপুঞ্জ",
        "MK": "ম্যাসাডোনিয়া",
        "ML": "মালি",
        "MM": "মায়ানমার",
        "MN": "মঙ্গোলিয়া",
        "MO": "ম্যাকাও",
        "MP": "উত্তরাঞ্চলীয় মারিয়ানা দ্বীপপুঞ্জ",
        "MQ": "মার্টিনিক",
        "MR": "মরিতানিয়া",
        "MS": "মন্টসেরাট",
        "MT": "মাল্টা",
        "MU": "মরিশাস",
        "MV": "মালদ্বীপ",
        "MW": "মালাউই",
        "MX": "মক্সিকো",
        "MY": "মাল্যাশিয়া",
        "MZ": "মোজাম্বিক",
        "NA": "নামিবিয়া",
        "NC": "নিউ ক্যালেডোনিয়া",
        "NE": "নাইজার",
        "NF": "নিরফোক দ্বীপ",
        "NG": "নাইজেরিয়া",
        "NI": "নিকারাগুয়া",
        "NL": "হলণ্ড",
        "NO": "নরওয়ে",
        "NP": "নেপাল",
        "NR": "নাউরু",
        "NU": "নিউয়ে",
        "NZ": "নিউ জিলণ্ড",
        "OM": "ওমান",
        "PA": "পানামা",
        "PE": "পিরু",
        "PF": "ফরাসী পলিনেশিয়া",
        "PG": "পাপুয়া নিউ গিনি",
        "PH": "ফিলিপাইন",
        "PK": "পাকিস্তান",
        "PL": "পোল্যাণ্ড",
        "PM": "সেন্ট পিয়ের ও মিকুয়েলন",
        "PN": "পিটকেয়ার্ন",
        "PR": "পুয়ের্টোরিকো",
        "PS": "ফিলিস্তিন অঞ্চল",
        "PT": "পর্তুগাল",
        "PW": "পালাউ",
        "PY": "প্যারাগোয়ে",
        "QA": "কাতার",
        "QO": "আউটলাইনিং ওসানিয়া",
        "RE": "রিইউনিয়ন",
        "RO": "রুমানিয়া",
        "RS": "সারবিয়া",
        "RU": "রাশিয়া",
        "RW": "রুয়ান্ডা",
        "SA": "সাউদি আরব",
        "SB": "সলোমন দ্বীপপুঞ্জ",
        "SC": "সিসিলি",
        "SD": "সুদান",
        "SE": "সুইডেন",
        "SG": "সিঙ্গাপুর",
        "SH": "সেন্ট হেলেনা",
        "SI": "স্লোভানিয়া",
        "SJ": "স্বালবার্ড ও জান মেয়েন",
        "SK": "শ্লোভাকিয়া",
        "SL": "সিয়েরালিওন",
        "SM": "সান মারিনো",
        "SN": "সেনেগাল",
        "SO": "সোমালি",
        "SR": "সুরিনাম",
        "ST": "সাওটোমা ও প্রিন্সিপি",
        "SV": "এল সালভেদর",
        "SY": "সিরিয়া",
        "SZ": "সোয়াজিল্যান্ড",
        "TA": "ট্রিস্টান ডা কুনা",
        "TC": "তুর্কস ও কাইকোস দ্বীপপুঞ্জ",
        "TD": "চাদ",
        "TF": "ফরাসী দক্ষিণাঞ্চল",
        "TG": "টোগো",
        "TH": "থাই",
        "TJ": "তাজিকস্থান",
        "TK": "টোকেলাউ",
        "TL": "পূর্ব-তিমুর",
        "TM": "তুর্কমেনিয়া",
        "TN": "টিউনিস্",
        "TO": "টোঙ্গা",
        "TR": "তুরস্ক",
        "TT": "ত্রিনিনাদ ও টোব্যাগো",
        "TV": "টুভালু",
        "TW": "তাইওয়ান",
        "TZ": "তাঞ্জানিয়া",
        "UA": "ইউক্রেইন",
        "UG": "উগান্ডা",
        "UM": "যুক্তরাষ্ট্রের ক্ষুদ্র ও পার্শ্ববর্তী দ্বীপপুঞ্জ",
        "US": "মার্কিন যুক্তরাষ্ট্র",
        "UY": "উরুগোয়ে",
        "UZ": "উজ্বেকিস্থান",
        "VA": "ভ্যাটিকান সিটি",
        "VC": "সেন্ট ভিনসেন্ট ও দ্যা গ্রেনাডিনস",
        "VE": "ভেনেজুয়েলা",
        "VG": "ব্রিটিশ ভার্জিন দ্বীপপুঞ্জ",
        "VI": "মার্কিন ভার্জিন দ্বীপপুঞ্জ",
        "VN": "ভিয়েতনাম",
        "VU": "ভানুয়াটু",
        "WF": "ওয়ালিস ও ফুটুনা",
        "WS": "সামোয়া",
        "YE": "ইমেন",
        "YT": "মায়োত্তে",
        "ZA": "দক্ষিণ আফ্রিকা",
        "ZM": "জাম্বিয়া",
        "ZW": "জিম্বাবুয়ে",
        "ZZ": "অজানা অথবা ভুল স্থান"
    };
  }-*/;
}
