

/********************************************************
	Title     : WOTrackStatusIC(M14GSUN005)
	Date      : 06-10-2014
	Developer : mahendra Jadhav
	
********************************************************/

package ibase.webitm.ejb.sys;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
@Stateless  
public class WOTrackStatusIC extends ValidatorEJB implements WOTrackStatusICLocal,WOTrackStatusICRemote
{
	//changes and commented by sarita on 01/06/2017
	//GenericUtility genericUtility = GenericUtility.getInstance();
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		System.out.println("wfValdata() called for facility");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			if (xmlString != null && xmlString.trim().length() > 0 )
			{
				dom = parseString(xmlString);
				
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0 )
			{
				dom1 = parseString(xmlString1);
				
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
				
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}
	
	
	
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		String userId = "";
		String sql = "";
		String errorType = "";
		String refSer ="",refId="",actCode="",roleCode="",trackLevel="",tranId="",trackSet="";
		int lineNo=0;
		int cnt = 0;
		int ctr=0;
		int childNodeListLength;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
    
		int currentFormNo =0,recCnt=0,ct=0;
		
		String facilityCode="",facilityDescr="",keyFlag="",stanCode="" ;
		
		double exchRate=0;

		try
		{
			
			System.out.println("WOTrackStatusIC.java ::wfvaldata called !!!!!!");
			//changes and commented by sarita for DBConnection on 01/06/2017 :START
			//conn = connDriver.getConnectDB("DriverITM");
			//connDriver = null;
			conn = getConnection();
			//changes and commented by sarita for DBConnection on 01/06/2017 :END
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
	
					System.out.println("childNodeName : "+childNodeName);
					if(childNodeName.equalsIgnoreCase("facility_code"))
					{   
						tranId = checkNull(genericUtility.getColumnValue("tran_id", dom));
						System.out.println("tranId !!!! "+tranId);

						sql = "select key_flag from transetup where tran_window='w_wo_track_status'";
						
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							keyFlag = rs.getString("key_flag");									
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						if("M".equalsIgnoreCase(keyFlag) && "A".equalsIgnoreCase(editFlag))
						{
							if(tranId == null || tranId.trim().length() == 0  )
							{
								errCode = "VMEMTTRAN";//Tran id should not be null for manually transetup
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
								errString = getErrorString("tran id should not be blank", errCode, userId);
								System.out.println("Error due to tran id blank!!");
							}
							else
							{
								sql = " select count (*) from wo_track_status where tran_id = ?   ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, facilityCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									ct = rs.getInt(1);	
								}
								pstmt.close();
								pstmt = null;
								rs.close();
								rs = null;
								
								if(ct > 0)
								{
									errCode = "VMINVTRAN";//Invalid tran id!!!
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
									errString = getErrorString("Invalid facility code", errCode, userId);
									System.out.println("Error due to tran id already exist in master!!");
								}

							 }

						}//end of case transetup


					}
					
					if(childNodeName.equalsIgnoreCase("line_no"))
					{    
						
						if(genericUtility.getColumnValue("line_no", dom) == null)
						{
							errCode = "VMEMTLINO";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
							System.out.println("line no can not be null");
						}
						
					}
					
					if(childNodeName.equalsIgnoreCase("ref_ser"))
					{    
						refSer = genericUtility.getColumnValue("ref_ser", dom);
						System.out.println("refSer ::"+refSer);
						if(genericUtility.getColumnValue("ref_ser", dom) == null)
						{
							errCode = "VMEMTRFSR";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
							System.out.println("ref ser can not be null");
						}
						
					}
					
					if(childNodeName.equalsIgnoreCase("ref_id"))
					{    
						refId = genericUtility.getColumnValue("ref_id", dom);
						System.out.println("refId ::"+refId);
						if(genericUtility.getColumnValue("ref_id", dom) == null)
						{
							errCode = "VMEMTRFID";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
							System.out.println("ref id can not be null");
						}
						else
						{
							
							sql = " select count (*) from workorder where work_order = ?   ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, refId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								ct = rs.getInt(1);	
							}
							pstmt.close();
							pstmt = null;
							rs.close();
							rs = null;
							
							if(ct == 0)
							{
								errCode = "VMINVWOID";//Invalid Facility code!!!
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
								errString = getErrorString("Invalid work order", errCode, userId);
								System.out.println("Error due to work order not exist in master!!");
							}
							
							
						}
						
						
					}
					
					if(childNodeName.equalsIgnoreCase("ref_line_no"))
					{    
						System.out.println("ref_line_no :"+genericUtility.getColumnValue("ref_line_no", dom));
						if(genericUtility.getColumnValue("ref_line_no", dom) == null)
						{
							errCode = "VMEMTRFLN";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
							System.out.println("ref line no can not be null");
						}
						
					}
					
					if(childNodeName.equalsIgnoreCase("track_set"))
					{    


						trackSet = genericUtility.getColumnValue("track_set", dom);
						System.out.println("trackSet :: "+trackSet);
						
						
						if(trackSet == null)
						{
							errCode = "VMEMTS";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
							System.out.println("Empty Track set");
						}
						else
						{
							
							sql = " select count (*) from tran_track_set where track_set = ?   ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, trackSet);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								ct = rs.getInt(1);	
							}
							pstmt.close();
							pstmt = null;
							rs.close();
							rs = null;
							
							
							if(ct == 0)
							{
								errCode = "VMINVTKID";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
								errString = getErrorString("Invalid track set", errCode, userId);
								System.out.println("Error due to  track set not exist in master!!");
							}
							
						}
					}
					
					
					
					
					
					if(childNodeName.equalsIgnoreCase("act_code"))
					{
					
						actCode = genericUtility.getColumnValue("act_code", dom);
						System.out.println("actCode :: "+actCode);
						System.out.println("trackSet :: "+trackSet);
						
						if(genericUtility.getColumnValue("act_code", dom) == null)
						{
							errCode = "VMEMTACNO";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
							System.out.println("act code can not be null");
						}
						 
						
						if(actCode != null && trackSet != null)
						{
						sql = " select count (*) from tran_track_acts act ,tran_track_set_det tsd" +
								" where tsd.act_code = act.act_code and tsd.act_code=? and tsd.track_set=?   ";
						
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, actCode);
						pstmt.setString(2, trackSet);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							ct = rs.getInt(1);	
						}
						pstmt.close();
						pstmt = null;
						rs.close();
						rs = null;
						
						if(ct == 0)
						{
							errCode = "VMINVACID";//
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
							errString = getErrorString("Invalid ACT code", errCode, userId);
							System.out.println("Error due to  act code not exist in master!!");
						}
						}
					}
					
					
					
					if(childNodeName.equalsIgnoreCase("seq_no"))
					{    
						System.out.println("seq_no :"+genericUtility.getColumnValue("seq_no", dom));
						if(genericUtility.getColumnValue("seq_no", dom) == null)
						{
							errCode = "VMEMTSQNO";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
							System.out.println("seq no can not be null");
						}
						
					}
					
					
					if(childNodeName.equalsIgnoreCase("role_code"))
					{    
						roleCode = genericUtility.getColumnValue("role_code", dom);
						System.out.println("roleCode ::"+roleCode);
						if(genericUtility.getColumnValue("role_code", dom) == null)
						{
							errCode = "VMEMTRLCD";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
							System.out.println("role code can not be null");
						}
						
					}
					
					if(childNodeName.equalsIgnoreCase("track_level"))
					{    
						trackLevel = genericUtility.getColumnValue("track_level", dom);
						System.out.println("roleCode ::"+trackLevel);
						if(genericUtility.getColumnValue("track_level", dom) == null)
						{
							errCode = "VMEMTRLVL";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
							System.out.println("track level can not be null");
						}
						
					}
					
					
					if(childNodeName.equalsIgnoreCase("days_required"))
					{    
						System.out.println("days_required :"+genericUtility.getColumnValue("days_required", dom));
						if(genericUtility.getColumnValue("days_required", dom) == null)
						{
							errCode = "VMEMTDRQ";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
							System.out.println("days required can not be null");
						}
						
					}
					
					
					if(childNodeName.equalsIgnoreCase("plan_end_date"))
					{    
						System.out.println("plan_end_date :"+genericUtility.getColumnValue("plan_end_date", dom));
						if(genericUtility.getColumnValue("plan_end_date", dom) == null)
						{
							errCode = "VMEMTPLDT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
							System.out.println("plan end date can not be null");
						}
						
					}
					
						
					
					
				} // end for
				break;  // case 1 end

			}//end of switch 

			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType = errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}
	
	
	
	
	public String itemChanged(String xmlString,String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("@@@@@@@ default itemChanged called");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{   
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [TrainingEJB][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
		return valueXmlString;
	}
	
	
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		
		System.out.println("@@@@@@@ itemChanged called@@@@@");
		String sql="",refId="",lotNo="",itemCode="",itemDescr="",actCode="",trackSet="",refSer="";
		String trackReq="",trackBasis="";
		int expCompsDays=0;
		int seqNo=0;
		int expCompdays=0;
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null,pstmt1=null;
		ResultSet rs = null,rs1=null ;
		String childNodeName = null;
		Date dueDate=null;
		Date planDate=null;
		//changes and commented by sarita on 01/06/2017
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new E12GenericUtility();
		ConnDriver connDriver = new ConnDriver();
		int currentFormNo =0;
		int childNodeListLength = 0;
		int ctr=0;
		DistCommon distcommon=null;
		String relAutoConfirm="",trackLevel="",roleCode="";
		SimpleDateFormat sdf;
		SimpleDateFormat sdfAppl ;
		try
		{  
			//changes and commented by sarita for DBConnection on 01/06/2017 :START
			//conn = connDriver.getConnectDB("DriverITM");
			//conn.setAutoCommit(false);
			//connDriver=null;
			conn = getConnection();
			//changes and commented by sarita for DBConnection on 01/06/2017 :END
			distcommon=new DistCommon();
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext.trim());
			}
			
			refSer="W-ORD";
			
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");				
			System.out.println("**********ITEMCHANGE FOR CASE :::: "+currentFormNo+"**************");
			switch(currentFormNo)
			{
			case 1:
			    	parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					valueXmlString.append("<Detail1>");
					childNodeListLength = childNodeList.getLength();
					do
					{   
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						ctr ++;
					}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
	
	                System.out.println("currentColumn : "+currentColumn);
	                
	                if(currentColumn.trim().equalsIgnoreCase("itm_default"))
					{
	                	
	                	valueXmlString.append( "<ref_ser><![CDATA["+refSer+"]]></ref_ser>" );
	                //	valueXmlString.append( "<chg_user><![CDATA[]]></chg_user>" );
	                //	valueXmlString.append( "<chg_date><![CDATA[]]></chg_date>" );
	                //	valueXmlString.append( "<chg_term><![CDATA[]]></chg_term>" );
	                	
					}
	                
	               System.out.println("currentColumn :: "+currentColumn);
					if(currentColumn.trim().equalsIgnoreCase("ref_id"))
					{
						refId=checkNull(genericUtility.getColumnValue("ref_id", dom));
						System.out.println("refId :"+refId);
						
						sql = "select lot_no,item_code,due_date from workorder where work_order=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, refId);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							
							lotNo=rs.getString("lot_no");
							itemCode=rs.getString("item_code");
							dueDate=rs.getDate("due_date");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						
						sql = "select descr from item where item_code=?";
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1, itemCode);
						rs1 = pstmt1.executeQuery();
						if (rs1.next()) 
						{
							itemDescr=rs1.getString("descr");
							
						}
						rs1.close();
						rs1 = null;
						pstmt1.close();
						pstmt1 = null;
						System.out.println("itemDescr :"+itemDescr);
						System.out.println("dueDate :"+dueDate);
						System.out.println("formated dueDate :"+sdf.format(dueDate));
						System.out.println("lotNo :"+lotNo);
						
						valueXmlString.append("<context_1><![CDATA["+itemCode+"-"+itemDescr+"]]></context_1>");
						valueXmlString.append("<context_2><![CDATA["+lotNo+"]]></context_2>");
						valueXmlString.append("<context_3><![CDATA["+dueDate+"]]></context_3>");
						
						
						
						
					}
					
					if(currentColumn.trim().equalsIgnoreCase("track_set") ) 
					{
						trackSet=checkNull(genericUtility.getColumnValue("track_set", dom));
						System.out.println("trackSet :"+trackSet);
						
						sql = "select track_req ,track_basis_value from  obj_track_req_det where track_set =?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, trackSet);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							
							trackReq=rs.getString("track_req");
							trackBasis=rs.getString("track_basis_value");
														
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						System.out.println("trackReq :: "+trackReq);
						System.out.println("trackBasis :: "+trackBasis);
						
				    	valueXmlString.append("<track_req><![CDATA["+trackReq+"]]></track_req>");
						valueXmlString.append("<context_value><![CDATA["+trackBasis+"]]></context_value>");
						
						
					}
					
					
					
					if(currentColumn.trim().equalsIgnoreCase("act_code") ) 
					{
						actCode=checkNull(genericUtility.getColumnValue("act_code", dom));
						trackSet=checkNull(genericUtility.getColumnValue("track_set", dom));
						System.out.println("actCode :"+actCode);
						System.out.println("trackSet :"+trackSet);
						
						sql = "select act.role_code,act.track_level,tsd.seq_no,tsd.exp_comp_days  " +
								"from tran_track_acts act ,tran_track_set_det tsd  where tsd.act_code = act.act_code" +
								" and tsd.act_code= ? and tsd.track_set= ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, actCode);
						pstmt.setString(2, trackSet);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							seqNo=rs.getInt("seq_no");
							expCompdays=rs.getInt("exp_comp_days");
							trackLevel=rs.getString("track_level");
							roleCode=rs.getString("role_code");
							
														
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						planDate = getDates(new Date(),expCompdays);
						System.out.println("planDate  :: "+planDate);
						System.out.println("seqNo :: "+seqNo);
						System.out.println("expCompdays :: "+expCompdays);
						
						valueXmlString.append("<track_level><![CDATA["+trackLevel+"]]></track_level>");
						valueXmlString.append("<role_code><![CDATA["+roleCode+"]]></role_code>");
						valueXmlString.append("<days_required><![CDATA["+expCompdays+"]]></days_required>");
						valueXmlString.append("<seq_no><![CDATA["+seqNo+"]]></seq_no>");
						valueXmlString.append("<plan_end_date><![CDATA["+sdf.format(planDate)+"]]></plan_end_date>");
				    	
						
						
						
						
					}
					
				

					
					valueXmlString.append("</Detail1>");
					
			}
			valueXmlString.append("</Root>");
			System.out.println("valueXmlString @@@@@    "+valueXmlString);
			
			
			
		}
	    catch(Exception e)
	   {
		   e.printStackTrace();
		   System.out.println("Exception ::"+e.getMessage());
		   throw new ITMException(e);
	   }
		finally
		{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;

						}
						conn.close();
					}
					conn = null;
				} catch (Exception e)
				{
					e.printStackTrace();
					throw new ITMException(e);
				}
		}
		
		
		return valueXmlString.toString();	
	}
	
	
	
	public static java.util.Date getDates( java.util.Date dt, int addDay)
	{
		 Calendar cal = Calendar.getInstance();
	        cal.setTime(dt);
	        cal.add(Calendar.DATE, addDay);
	        dt = cal.getTime();
	        
	        return dt;
	}
	
	
	

	
	private String checkNull(String input) 
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}

	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	
	
	private boolean isExist(Connection conn, String tableName, String columnName, String value) throws ITMException, RemoteException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		boolean status = false;
		try
		{
			sql = "SELECT count(*) from " + tableName + " where " + columnName + "  = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, value);
			rs = pstmt.executeQuery();

			if (rs.next())
			{
				if (rs.getBoolean(1))
				{
					status = true;
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		} catch (Exception e)
		{
			System.out.println("Exception in isExist ");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning String from isExist ");
		return status;
	}
	
	

 
}	