package ibase.dashboard.sfa.ejb;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;

import javax.ejb.Stateless;
import org.json.simple.JSONObject;

@Stateless
public class LiveEventMgrWiseDetails extends ValidatorEJB implements LiveEventMgrWiseDetailsLocal, LiveEventMgrWiseDetailsRemote
{
    @SuppressWarnings("unchecked")
	
    public JSONObject getActiveEvent(String dataSourceName, String loginCode, String month, String year) throws RemoteException, ITMException
    {
		JSONObject rawDataActiveEventlJson = new JSONObject();
		JSONObject rowData      = null;
		String sql         		= "";
		ResultSet rs       		= null;
		PreparedStatement pstmt = null;
		Connection conn    		= null;
		ConnDriver connDriver 	= new ConnDriver();
		loginCode 				= checkNull(loginCode);
		month 					= checkNull(month);
		year 					= checkNull(year);
		int count 				= 0;
		Calendar calendar       = null;
		
		try
		{			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			if("".equalsIgnoreCase(month) && "".equalsIgnoreCase(year)){
				calendar = Calendar.getInstance(); 
		        month = String.valueOf((calendar.get(Calendar.MONTH) + 1)); 
		        year = String.valueOf(calendar.get(Calendar.YEAR));
			}
			
			
			sql = "WITH N ( LEVEL , EMP_CODE ) AS ( SELECT 1 , EMP_CODE FROM EMPLOYEE " +
				  "WHERE EMP_CODE = ( SELECT EMP_CODE FROM USERS WHERE CODE='"+loginCode+"' ) UNION ALL SELECT N . LEVEL + 1 , NPLUS1 . EMP_CODE " +
				  "FROM EMPLOYEE AS NPLUS1 , N WHERE N . EMP_CODE = NPLUS1 . REPORT_TO ) " +
				  "SELECT CONVERT(VARCHAR(19),st.eff_from,110) , st.survey_templ, st.descr AS active_event, " +
				  "( SELECT LEN(SCOPE_VAL_DESCR) - LEN(REPLACE(SCOPE_VAL_DESCR, ',', ''))+1 AS No_Of_PARTICIPANTS FROM " +
				  "SCOPE_VALUE WHERE SCOPE_CODE= ( SELECT MAX(SCOPE_CODE) FROM survey_config_appl WHERE APPL_ENTITY ='E' AND " +
				  "SURVEY_ID = ( SELECT MAX(SURVEY_ID) FROM survey_config WHERE SURVEY_TEMPL=st.survey_templ ) ) )" +
				  "AS No_Of_PARTICIPANTS, CONVERT(VARCHAR(19),st.valid_upto,110) AS exp_date " +
				  "FROM survey_config sc INNER JOIN survey_template st ON st.survey_templ=sc.survey_templ " +
				  "INNER JOIN ( SELECT * FROM survey_config_appl WHERE appl_entity='E' ) sca ON " +
				  "sca.survey_id=sc.SURVEY_ID INNER JOIN SURVEY_FORM sf ON sf.SURVEY_ID=sc.SURVEY_ID INNER JOIN " +
				  "SURVEY_RESULT sr ON sr.tran_id__form=sf.tran_id INNER JOIN SURVEY_RESULT_DET srd ON " +
				  "srd.TRAN_ID=sr.TRAN_ID INNER JOIN ( SELECT * FROM survey_result_appl WHERE appl_entity='E' ) sra ON " +
				  "sra.TRAN_ID=srd.tran_id INNER JOIN SCOPE_VALUE sv ON sv.scope_code=sca.scope_code INNER JOIN employee emp ON " +
				  "emp.emp_code =sra.ENTITY_CODE INNER JOIN N ON emp.emp_code=N.EMP_CODE WHERE " +
				  "REPLACE (LEFT(CONVERT(VARCHAR(19),EFF_FROM,112),6),' ','-')= '"+year+month+"' " +
				  "GROUP BY st.descr , st.survey_templ, st.valid_upto, st.eff_from " ;
			/*sql="WITH N ( LEVEL , EMP_CODE ) AS ( SELECT 1 , EMP_CODE FROM DBO.EMPLOYEE WHERE EMP_CODE = ( SELECT EMP_CODE FROM dbo.USERS WHERE CODE='"+loginCode+"' ) " +
				"UNION ALL SELECT N . LEVEL + 1 , NPLUS1 . EMP_CODE FROM dbo.EMPLOYEE AS NPLUS1 , N " +
				"WHERE N . EMP_CODE = NPLUS1 . REPORT_TO ) SELECT st.survey_templ, st.descr AS active_event, " +
				"( SELECT LEN(SCOPE_VAL_DESCR) - LEN(REPLACE(SCOPE_VAL_DESCR, ',', ''))+1 AS No_Of_PARTICIPANTS " +
				"FROM dbo.SCOPE_VALUE WHERE SCOPE_CODE= ( SELECT MAX(SCOPE_CODE) FROM dbo.survey_config_appl " +
				"WHERE APPL_ENTITY ='E' AND SURVEY_ID = ( SELECT MAX(SURVEY_ID) FROM dbo.survey_config " +
				"WHERE SURVEY_TEMPL=st.survey_templ ) ) ) AS No_Of_PARTICIPANTS, CONVERT(VARCHAR(19),st.valid_upto,110) AS exp_date " +
				"FROM dbo.survey_config sc INNER JOIN dbo.survey_template st ON st.survey_templ=sc.survey_templ " +
				"INNER JOIN ( SELECT * FROM dbo.survey_config_appl WHERE appl_entity='E' ) sca ON sca.survey_id=sc.SURVEY_ID " +
				"INNER JOIN dbo.SURVEY_FORM sf ON sf.SURVEY_ID=sc.SURVEY_ID INNER JOIN dbo.SURVEY_RESULT sr " +
				"ON sr.tran_id__form=sf.tran_id INNER JOIN dbo.SURVEY_RESULT_DET srd ON srd.TRAN_ID=sr.TRAN_ID " +
				"INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE appl_entity='E' ) sra ON sra.TRAN_ID=srd.tran_id " +
				"INNER JOIN dbo.SCOPE_VALUE sv ON sv.scope_code=sca.scope_code INNER JOIN dbo.employee emp ON emp.emp_code =sra.ENTITY_CODE " +
				"INNER JOIN N ON emp.emp_code=N.EMP_CODE WHERE REPLACE (CONVERT(VARCHAR(19),GETDATE(),6),' ','-') " +
				"BETWEEN REPLACE(CONVERT( nvarchar,DATEADD(MONTH,"+month+"            -1,DATEADD(YEAR,"+year+"-1900,0)),6),' ','-') " +
				"AND REPLACE(CONVERT(nvarchar,DATEADD(DAY,-1,DATEADD(MONTH,"+month+",DATEADD(YEAR,"+year+"- 1900,0))),6),' ','-') " +
				"GROUP BY st.descr , st.survey_templ, st.valid_upto ";*/
		
			pstmt = conn.prepareStatement(sql);
			rs    = pstmt.executeQuery();
							
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("active_event",checkNull (rs.getString("ACTIVE_EVENT")));
				rowData.put("no_of_participants",checkNull (rs.getString("NO_OF_PARTICIPANTS")));
				rowData.put("exp_date",checkNull (rs.getString("EXP_DATE")));
				rowData.put("survey_templ",checkNull (rs.getString("SURVEY_TEMPL")));
				rawDataActiveEventlJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :LiveEventMgrWiseDetails getActiveEvent :" + d.getMessage());
				throw new ITMException(d);
			}
		}		
		return rawDataActiveEventlJson;		
	}
    
    @SuppressWarnings("unchecked")    
    public JSONObject getParticipentEventSummary(String dataSourceName,String eventCode,String loginCode) throws RemoteException, ITMException
    {
    	JSONObject rawDataParticipentEventSummaryJson = new JSONObject();
		JSONObject rowData      = null;
		String sql              = "";
		ResultSet rs            = null;
		PreparedStatement pstmt = null;
		Connection conn         = null;
		ConnDriver connDriver   = null;
		int count = 0;
		
		try
		{
			connDriver   = new ConnDriver();
			conn         = connDriver.getConnectDB (dataSourceName);
			connDriver   = null;
			
			sql = "WITH N ( LEVEL , EMP_CODE ) AS ( SELECT 1 , EMP_CODE FROM DBO.EMPLOYEE WHERE EMP_CODE = " +
					"( SELECT EMP_CODE FROM DBO.USERS WHERE CODE='"+loginCode+"' ) UNION ALL SELECT N . LEVEL + 1 , NPLUS1 . EMP_CODE " +
					"FROM DBO.EMPLOYEE AS NPLUS1 , N WHERE N . EMP_CODE = NPLUS1 . REPORT_TO ) SELECT code, PARTICIPANTS_NAME, result, " +
					"count_m AS No_of_Evaluation, perce, RANK() over (order by perce DESC ) AS rank " +
					"FROM ( SELECT code, PARTICIPANTS_NAME, COUNT(DISTINCT TRAN_ID) AS count_m, SUM(result) AS result, " +
					"SUM(result)*100/( COUNT(DISTINCT TRAN_ID))/ ( SELECT SUM(result_range_max) FROM dbo.survey_master " +
					"WHERE survey_code IN ( SELECT survey_code FROM dbo.survey_templ_det WHERE survey_templ='"+eventCode+"' ) ) " +
					"AS perce FROM ( SELECT srd.TRAN_ID, emp.code, emp.firstname +' '+ emp.lastname AS PARTICIPANTS_NAME, " +
					"CASE WHEN ISNUMERIC(RESULT)=1 THEN (srd.result ) ELSE 0 END AS result, srd.TRAN_ID AS count_m " +
					"FROM dbo.SURVEY_CONFIG sc INNER JOIN ( SELECT * FROM dbo.survey_config_appl WHERE appl_entity='E' ) sca " +
					"ON sca.survey_id=sc.SURVEY_ID INNER JOIN dbo.SURVEY_FORM sf ON sf.SURVEY_ID=sc.SURVEY_ID " +
					"INNER JOIN dbo.SURVEY_RESULT sr ON sr.tran_id__form=sf.tran_id INNER JOIN dbo.SURVEY_RESULT_DET srd " +
					"ON srd.TRAN_ID=sr.TRAN_ID INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE appl_entity='E' ) sra " +
					"ON sra.TRAN_ID=srd.tran_id INNER JOIN dbo.SCOPE_VALUE sv ON sv.scope_code=sca.scope_code " +
					"INNER JOIN ( SELECT SCOPE_CODE AS CODE, LTRIM(RTRIM(m.n.value('.[1]','varchar(8000)'))) AS EMP_CODE " +
					"FROM ( SELECT SCOPE_CODE, CAST('<XMLRoot><RowData>' + REPLACE(SCOPE_VAL_DESCR,',', '</RowData><RowData>')    + '</RowData></XMLRoot>' " +
					"AS XML) AS x FROM dbo.SCOPE_VALUE ) t CROSS APPLY x.nodes('/XMLRoot/RowData')m(n) ) A " +
					"ON a.code =sv.scope_code AND A.EMP_CODE=sra.ENTITY_CODE INNER JOIN dbo.employee emp ON emp.code =A.EMP_CODE " +
					"INNER JOIN N ON EMP.CODE=N.EMP_CODE WHERE SURVEY_TEMPL='"+eventCode+"' ) b GROUP BY code, PARTICIPANTS_NAME ) a ORDER BY rank";
				
					pstmt     = conn.prepareStatement(sql);
					rs        = pstmt.executeQuery();
									
					while (rs.next())
					{
						rowData = new JSONObject();
						rowData.put("participants_code",checkNull (rs.getString("CODE")));
						rowData.put("participants_name",checkNull (rs.getString("PARTICIPANTS_NAME")));
						rowData.put("no_of_evaluation",checkNull (rs.getString("NO_OF_EVALUATION")));
						rowData.put("marks_obtained",checkNull (rs.getString("RESULT")));	 
						rowData.put("perce",checkNull (rs.getString("PERCE")));
						rowData.put("rank", checkNull(rs.getString("RANK")));				
						rawDataParticipentEventSummaryJson.put(count, rowData);
						count++;
					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;
		}			
		catch (Exception  e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getParticipentEventSummary:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		System.out.println("LiveEventMgrWiseDetails  rawDataParticipentEventSummaryJson String======>>"+rawDataParticipentEventSummaryJson.toString());
	    return rawDataParticipentEventSummaryJson;
    }
          
    @SuppressWarnings("unchecked")
    public JSONObject getParticipentEventDetail(String dataSourceName,String eventCode,String participentCode,String loginCode) throws RemoteException, ITMException
    {
    	JSONObject rawDataParticipentEventDetailJson = new JSONObject();
		JSONObject rowData      = null;
		String sql              = "";
		ResultSet rs            = null;
		PreparedStatement pstmt = null;
		Connection conn         = null;
		ConnDriver connDriver   = new ConnDriver();
		loginCode               = checkNull(loginCode);      			
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
		
			if(participentCode!=null && eventCode!=null)
			{
				sql=" WITH as_det (zone,region,team,emp_code,name,FIRSTNAME,MGR,nos,total)AS ( SELECT e.ZONECODE ZONE, r.Name AS REGION, e.teamcode TEAM, " +
					"e.code AS emp_code, (e.FIRSTNAME +' '+ e.LASTNAME) NAME, SUR.MGR , (emp.FIRSTNAME+' '+ emp.LASTNAME) ," +
					" COUNT(SUR.MGR) NOS, SUM(SUR.RESULT) TOTAL FROM dbo.employee e INNER JOIN dbo.REGION r ON e.regionid = r.id " +
					"INNER JOIN ( SELECT APP.ENTITY_CODE EMP_CODE, SRE.EMP_CODE MGR , SUM(CAST(SRD.result AS INT)) RESULT " +
					"FROM dbo.survey_result_EMP SRE INNER JOIN dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
					"INNER JOIN ( SELECT code, a, b, PARTICIPANTS_NAME, SUM( result) AS result, count_m " +
					"FROM ( SELECT emp.code, srd.TRAN_ID AS a, sra.TRAN_ID AS b, emp.firstname +' '+ emp.lastname AS " +
					"PARTICIPANTS_NAME, CASE WHEN ISNUMERIC(RESULT)=1 THEN (srd.result ) ELSE 0 END AS result, " +
					"COUNT(DISTINCT srd.TRAN_ID) AS count_m FROM dbo.SURVEY_CONFIG sc INNER JOIN ( SELECT * FROM dbo.survey_config_appl " +
					"WHERE appl_entity='E' ) sca ON sca.survey_id=sc.SURVEY_ID INNER JOIN dbo.SURVEY_FORM sf ON sf.SURVEY_ID=sc.SURVEY_ID " +
					"INNER JOIN dbo.SURVEY_RESULT sr ON sr.tran_id__form=sf.tran_id INNER JOIN dbo.SURVEY_RESULT_DET srd ON srd.TRAN_ID=sr.TRAN_ID " +
					"LEFT JOIN ( SELECT * FROM dbo.survey_result_appl WHERE appl_entity='E' ) sra ON sra.TRAN_ID=srd.tran_id INNER JOIN dbo.SCOPE_VALUE sv " +
					"ON sv.scope_code=sca.scope_code LEFT JOIN ( SELECT SCOPE_CODE AS CODE, LTRIM(RTRIM(m.n.value('.[1]','varchar(8000)'))) AS EMP_CODE " +
					"FROM ( SELECT SCOPE_CODE, CAST('<XMLRoot><RowData>'  + REPLACE(SCOPE_VAL_DESCR, ',','</RowData><RowData>') + '</RowData></XMLRoot>' AS XML) " +
					"AS x FROM dbo.SCOPE_VALUE ) t CROSS APPLY x.nodes('/XMLRoot/RowData')m(n) ) A ON a.code      =sv.scope_code AND A.EMP_CODE=sra.ENTITY_CODE " +
					"LEFT JOIN dbo.employee emp ON emp.code =A.EMP_CODE WHERE SURVEY_TEMPL='"+eventCode+"' GROUP BY srd.TRAN_ID, sra.TRAN_ID, emp.code, emp.firstname +' '+ emp.lastname, " +
					"sca.scope_code, srd.result ) a GROUP BY code, a, b, PARTICIPANTS_NAME, count_m ) SRD ON SR.TRAN_ID = SRD.B " +
					"INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE APPL_ENTITY = 'E' ) APP ON SRD.B = APP.TRAN_ID GROUP BY APP.ENTITY_CODE, SRE.EMP_CODE ) SUR ON e.code = SUR.EMP_CODE " +
					"INNER JOIN dbo.Employee emp ON emp.code =sur.mgr WHERE e.code='"+participentCode+"' GROUP BY e.ZONECODE, r.Name, e.teamcode, e.code, SUR.MGR, emp.FIRSTNAME, (e.FIRSTNAME +' '+ e.LASTNAME), emp.LASTNAME ) , " +
					"N ( LEVEL , EMP_CODE ) AS ( SELECT 1 , EMP_CODE FROM dbo.EMPLOYEE WHERE EMP_CODE = ( SELECT EMP_CODE FROM dbo.USERS WHERE CODE='"+loginCode+"' ) UNION ALL SELECT N . LEVEL + 1 , NPLUS1 . EMP_CODE " +
					"FROM dbo.EMPLOYEE AS NPLUS1 , N WHERE N . EMP_CODE = NPLUS1 . REPORT_TO ) SELECT as_det.* FROM as_det, n WHERE as_det.emp_code=n.emp_code";
			
		            pstmt = conn.prepareStatement(sql);
					rs    = pstmt.executeQuery();
					int count = 0;	
				    while (rs.next())
				     {		    	
				    	rowData = new JSONObject();	
				    	rowData.put("participants_code",checkNull (rs.getString("EMP_CODE")));
				    	rowData.put("mgr",checkNull( rs.getString("MGR")));
				        rowData.put("zone",checkNull (rs.getString("ZONE")));						
						rowData.put("region", checkNull(rs.getString("REGION")));
						rowData.put("team",checkNull( rs.getString("TEAM")));
						rowData.put("name", checkNull(rs.getString("NAME")));
						rowData.put("total", checkNull(rs.getString("TOTAL")));
						rowData.put("nos", checkNull(rs.getString("NOS")));
						rawDataParticipentEventDetailJson.put(count, rowData);
						count++;
				     }
				    rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;
		}
 	}//closed if block	
	catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getParticipentEventDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		System.out.println("LiveEventMgrWiseDetails rawDataParticipentEventDetailJson String======>>"+rawDataParticipentEventDetailJson.toString());
	    return rawDataParticipentEventDetailJson;
    }
       
    @SuppressWarnings("unchecked")
    
    public JSONObject getParticipentProductDetail(String dataSourceName,String eventCode,String participentCode,String loginCode) throws RemoteException, ITMException
    {
    	JSONObject rawDataParticipentProductDetailJson = new JSONObject();
		JSONObject rowData      = null;
		String sql              = "";
		ResultSet rs            = null;
		PreparedStatement pstmt = null;
		Connection conn         = null;
		ConnDriver connDriver   = null;
		double percntVal        = 0.0;				
		try
		{
			connDriver   = new ConnDriver();
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			if(participentCode!=null && eventCode!=null)
			{
				sql="WITH as_det1 (code,prd_name,mgr_name,mgr_code,perc,report,resultcnt,total,NEW_TRAN_ID) AS ( SELECT CODE, PRD_NAME, mgr_name, " +
					"mgr_code, PERC, REPORT, RESULTCNT, TOTAL, NEW_TRAN_ID FROM ( SELECT DET_PRD.CODE,DET_PRD.b as NEW_TRAN_ID," +
					" DET_PRD.NAME , DET_PRD.mgr_name, DET_PRD.EMP_CODE AS mgr_code, " +
					"DET_PRD.PRD_NAME, RESULT, TOTAL, Str((RESULT * 100.0/TOTAL),4,1) AS PERC, 'Marks' AS REPORT, (RESULT) AS RESULTCNT " +
					"FROM ( SELECT e.CODE, SUM(SUR.RESULT) TOTAL FROM dbo.employee e INNER JOIN dbo.REGION r " +
					"ON e.regionid = r.id INNER JOIN ( SELECT APP.ENTITY_CODE EMP_CODE, SRE.EMP_CODE MGR, SUM(CAST(SRD.result AS INT)) " +
					"RESULT, APPR.ENTITY_CODE PRD_CODE, APPR.ENTITY_DESCR PRD_DESC, SR.TRAN_ID FROM dbo.survey_result_EMP SRE " +
					"INNER JOIN dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM INNER JOIN ( SELECT code, a, b, PARTICIPANTS_NAME, SUM(result) AS result, count_m " +
					"FROM ( SELECT emp.code, srd.TRAN_ID AS a, sra.TRAN_ID AS b, emp.firstname +' '+ emp.lastname AS PARTICIPANTS_NAME , " +
					"CASE WHEN ISNUMERIC(srd.result)=1 THEN (srd.result ) ELSE 0 END AS result, COUNT(DISTINCT srd.TRAN_ID) AS count_m FROM dbo.SURVEY_CONFIG sc " +
					"INNER JOIN ( SELECT * FROM dbo.survey_config_appl WHERE appl_entity='E' ) sca ON sca.survey_id=sc.SURVEY_ID " +
					"INNER JOIN dbo.SURVEY_FORM sf ON sf.SURVEY_ID=sc.SURVEY_ID INNER JOIN dbo.SURVEY_RESULT sr ON sr.tran_id__form=sf.tran_id " +
					"INNER JOIN dbo.SURVEY_RESULT_DET srd ON srd.TRAN_ID=sr.TRAN_ID LEFT JOIN ( SELECT * FROM dbo.survey_result_appl " +
					"WHERE appl_entity='E' ) sra ON sra.TRAN_ID=srd.tran_id INNER JOIN dbo.SCOPE_VALUE sv ON sv.scope_code=sca.scope_code " +
					"LEFT JOIN ( SELECT SCOPE_CODE AS CODE, LTRIM(RTRIM(m.n.value('.[1]','varchar(8000)'))) AS EMP_CODE FROM " +
					"( SELECT SCOPE_CODE, CAST('<XMLRoot><RowData>' + REPLACE( SCOPE_VAL_DESCR,',','</RowData><RowData>') + '</RowData></XMLRoot>' AS XML) AS x " +
					"FROM dbo.SCOPE_VALUE ) t CROSS APPLY x.nodes('/XMLRoot/RowData')m(n) ) A ON a.code =sv.scope_code AND A.EMP_CODE=sra.ENTITY_CODE LEFT JOIN dbo.employee emp " +
					"ON emp.code =A.EMP_CODE WHERE SURVEY_TEMPL='"+eventCode+"' GROUP BY srd.TRAN_ID, sra.TRAN_ID, emp.code, srd.result, emp.firstname +' '+ emp.lastname, sca.scope_code ) " +
					"a GROUP BY code, a, b, PARTICIPANTS_NAME, count_m ) SRD ON SR.TRAN_ID = SRD.b INNER JOIN ( SELECT * FROM dbo.survey_result_appl " +
					"WHERE APPL_ENTITY = 'E' ) APP ON SRD.b = APP.TRAN_ID INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE APPL_ENTITY = 'I' ) APPR ON SRD.b = APPR.TRAN_ID " +
					"GROUP BY APP.ENTITY_CODE, SRE.EMP_CODE, APPR.ENTITY_CODE, APPR.ENTITY_DESCR, SR.TRAN_ID ) SUR ON e.code = SUR.EMP_CODE WHERE e.code = '"+participentCode+"' GROUP BY e.CODE ) HDR " +
					"INNER JOIN ( SELECT (e.FIRSTNAME +' '+ e.LASTNAME) NAME, APPR.ENTITY_DESCR AS PRD_NAME , SUM(CAST(SRD.result AS INT)) RESULT , " +
					"( SELECT firstname+ +''+lastname FROM dbo.employee WHERE emp_code= SRE.emp_code ) AS mgr_name, SRE.emp_code, e.code, SRD.b FROM dbo.survey_result_EMP SRE " +
					"INNER JOIN dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM INNER JOIN ( SELECT code, a, b, SURVEY_CODE, PARTICIPANTS_NAME, result, count_m " +
					"FROM ( SELECT code, a, b, SURVEY_CODE, PARTICIPANTS_NAME, SUM(result) AS result, count_m FROM ( SELECT emp.code, srd.TRAN_ID AS a, sra.TRAN_ID AS b, srd.SURVEY_CODE, emp.firstname +' '+ emp.lastname " +
					"AS PARTICIPANTS_NAME , CASE WHEN ISNUMERIC(srd.RESULT)=1 THEN (srd.result ) ELSE 0 END AS result , COUNT(DISTINCT srd.TRAN_ID) AS count_m FROM dbo.SURVEY_CONFIG sc " +
					"INNER JOIN ( SELECT * FROM dbo.survey_config_appl WHERE appl_entity='E' ) sca ON sca.survey_id=sc.SURVEY_ID INNER JOIN dbo.SURVEY_FORM sf ON sf.SURVEY_ID=sc.SURVEY_ID " +
					"INNER JOIN dbo.SURVEY_RESULT sr ON sr.tran_id__form=sf.tran_id INNER JOIN dbo.SURVEY_RESULT_DET srd ON srd.TRAN_ID=sr.TRAN_ID LEFT JOIN ( SELECT * FROM dbo.survey_result_appl WHERE appl_entity='E' ) sra " +
					"ON sra.TRAN_ID=srd.tran_id INNER JOIN dbo.SCOPE_VALUE sv ON sv.scope_code=sca.scope_code LEFT JOIN ( SELECT SCOPE_CODE AS CODE, LTRIM(RTRIM(m.n.value('.[1]','varchar(8000)'))) AS EMP_CODE " +
					"FROM ( SELECT SCOPE_CODE, CAST('<XMLRoot><RowData>' + REPLACE( SCOPE_VAL_DESCR,',','</RowData><RowData>') + '</RowData></XMLRoot>' AS XML) AS x FROM dbo.SCOPE_VALUE ) t CROSS APPLY x.nodes('/XMLRoot/RowData')m(n) ) A " +
					"ON a.code      =sv.scope_code AND A.EMP_CODE=sra.ENTITY_CODE LEFT JOIN dbo.employee emp ON emp.code =A.EMP_CODE WHERE SURVEY_TEMPL='"+eventCode+"' GROUP BY srd.TRAN_ID, sra.TRAN_ID, srd.SURVEY_CODE, emp.code, srd.result, " +
					"emp.firstname +' '+ emp.lastname, sca.scope_code ) b GROUP BY code, a, b, SURVEY_CODE, PARTICIPANTS_NAME, count_m ) a ) SRD " +
					"ON SR.TRAN_ID = SRD.b INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE APPL_ENTITY = 'E' ) APP " +
					"ON SRD.b = APP.TRAN_ID INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE APPL_ENTITY = 'I' ) APPR ON SRD.b = APPR.TRAN_ID " +
					"INNER JOIN dbo.employee e ON APP.ENTITY_CODE = e.code INNER JOIN dbo.survey_master sm " +
					"ON SRD.SURVEY_CODE = sm.SURVEY_CODE WHERE APP.ENTITY_CODE = '"+participentCode+"' GROUP BY (e.FIRSTNAME +' '+ e.LASTNAME) , " +
					"APPR.ENTITY_DESCR , e.code, SRE.emp_code, SRD.b ) DET_PRD ON HDR.CODE = DET_PRD.CODE ) X WHERE upper(report)='MARKS' ) , " +
					"N ( LEVEL , EMP_CODE ) AS ( SELECT 1 , EMP_CODE FROM dbo.EMPLOYEE WHERE EMP_CODE = ( SELECT EMP_CODE FROM dbo.USERS WHERE " +
					"CODE='"+loginCode+"' ) UNION ALL SELECT N . LEVEL + 1 , NPLUS1 . EMP_CODE " +
					"FROM EMPLOYEE AS NPLUS1 , N WHERE N . EMP_CODE = NPLUS1 . REPORT_TO ) SELECT as_det1.code, as_det1.prd_name, " +
					"as_det1.mgr_name, as_det1.mgr_code, as_det1.perc, as_det1.report, as_det1.resultcnt,as_det1.total, ( SELECT SUM(result_range_max) AS " +
					"tot_marks FROM dbo.survey_master WHERE survey_code IN ( SELECT survey_code FROM dbo.survey_templ_det WHERE survey_templ='"+eventCode+"' ) ) " +
					"outof_marks , ( employee.firstname +' '+ employee.lastname) AS emp_name, '"+eventCode+"' AS survey_templ, as_det1.NEW_TRAN_ID FROM AS_DET1 INNER JOIN " +
					"dbo.employee ON as_det1.code=employee.code INNER JOIN N ON employee.emp_code=n.emp_code ";
			
				
		            pstmt = conn.prepareStatement(sql);
					rs    = pstmt.executeQuery();
					int count = 0;	
					double totalCircle = 629.0D, dashOffSet = 0.0D, rsltCnt = 0.0D, total = 0.0D, percentage = 0.0D;
				    while (rs.next())
				    {
						rowData = new JSONObject();
				        rsltCnt = Double.parseDouble(checkNull(rs.getString("RESULTCNT")));
				        total   = Double.parseDouble(checkNull(rs.getString("OUTOF_MARKS")));
				        System.out.println("rsltCnt:" + rsltCnt);
				        System.out.println("total:" + total);
				        percntVal = rsltCnt / total * 100.0D;
				        System.out.println("percntVal:" + percntVal);
				        percentage = Double.parseDouble(checkNull(rs.getString("PERC")));
				        dashOffSet = totalCircle * percntVal / 100.0D;
				        rowData.put("dashOffSet", Double.valueOf(dashOffSet));
				        System.out.println(" dashOffSet :" + dashOffSet);
				        rowData.put("descr", "Marks");
				        rowData.put("percentage", Long.valueOf(Math.round(percntVal)));
				        rowData.put("spanvalue", Math.round(percntVal) + "%");        
				        rowData.put("ontimeval", checkNull(rs.getString("RESULTCNT")));
				        rowData.put("totalval", checkNull(rs.getString("OUTOF_MARKS")));
				        rowData.put("person_name", checkNull(rs.getString("EMP_NAME")));
				        rowData.put("prd_name", checkNull(rs.getString("PRD_NAME")));
				        rowData.put("magagerName",checkNull( rs.getString("MGR_NAME")));
				        rowData.put("uniqueCode",checkNull( rs.getString("MGR_CODE")));
				        rowData.put("survey_templ",checkNull( rs.getString("SURVEY_TEMPL")));
				        rowData.put("tbldisplay", "style='display: visible'");
				        rowData.put("new_tran_id", checkNull(rs.getString("NEW_TRAN_ID")));
				        rowData.put("circledisplay", "c100");
				        rawDataParticipentProductDetailJson.put(Integer.valueOf(count), rowData);
				        count++;
					}
				    rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;
			  }
	 	}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in getParticipentEventDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
	    return rawDataParticipentProductDetailJson;
    }
    
    @SuppressWarnings("unchecked")    
    public JSONObject getProductDetail(String dataSourceName,String personName,String productName,String mgrCode,String eventCode, String loginCode, String newTranId) throws RemoteException, ITMException
    {
    	JSONObject rawDataProductDetailJson = new JSONObject();
		JSONObject rowData                  = null;
		String sql                          = "";
		ResultSet rs                        = null;
		PreparedStatement pstmt             = null;
		Connection conn                     = null;
		ConnDriver connDriver               = null;
		
		try
		{
			connDriver = new ConnDriver();
			conn       = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			if(mgrCode!=null && mgrCode!="")
			{
				System.out.println(" Inside LiveEventDetails for getParticipentEventDetail Data Soruc Name ="+dataSourceName+ "==== personName :"+personName+"productName==="+productName);
			
				sql =   " SELECT EMP_CODE, SURVEY, SURVEY_CODE, (CASE WHEN SUM(result)=0 THEN result1 " +
						" ELSE (CAST (SUM(result) AS VARCHAR(10)))END) AS result FROM (SELECT SRE.EMP_CODE, sm.SURVEY_CODE, " +
						" RTRIM(LTRIM(upper(sm.DESCR))) AS SURVEY , CASE WHEN ISNUMERIC(srd.result)=1 THEN (srd.result ) " +
						" ELSE 0 END AS result, CASE WHEN ISNUMERIC(srd.result)<>1 THEN (srd.result ) ELSE '' END AS result1, " +
						" srd.TRAN_ID FROM dbo.survey_result_EMP SRE INNER JOIN dbo.survey_result SR ON SRE.TRAN_ID = SR.TRAN_ID__FORM " +
						" INNER JOIN dbo.survey_result_det SRD ON SR.TRAN_ID = SRD.TRAN_ID " +
						" INNER JOIN ( SELECT * FROM dbo.survey_result_appl WHERE APPL_ENTITY = 'E' ) " +
						" APP ON SRD.TRAN_ID = APP.TRAN_ID INNER JOIN ( SELECT * FROM dbo.survey_result_appl " +
						" WHERE APPL_ENTITY = 'I' ) APPR ON SRD.TRAN_ID = APPR.TRAN_ID " +
						" INNER JOIN dbo.employee e ON APP.ENTITY_CODE = e.code " +
						" INNER JOIN dbo.survey_master sm ON SRD.SURVEY_CODE = sm.SURVEY_CODE " +
						" INNER JOIN dbo.SURVEY_TEMPL_DET std ON std.SURVEY_CODE = sm.SURVEY_CODE " +
						" WHERE RTRIM(LTRIM(e.FIRSTNAME +' '+ e.LASTNAME)) = '"+personName+"' " +
						" AND RTRIM(LTRIM(APPR.ENTITY_DESCR))              = '"+productName+"' " +
						" AND SRE.EMP_CODe = '"+mgrCode+"' " +
						" AND std.SURVEY_TEMPL ='"+eventCode+"' " +
						" and srd.tran_id='"+newTranId+"')a " +
						" GROUP BY EMP_CODE, SURVEY_CODE, SURVEY, result1 ";	
				
				pstmt = conn.prepareStatement(sql);
				rs    = pstmt.executeQuery();
				int count = 0;		
				while (rs.next())
				{
					rowData = new JSONObject();
					rowData.put("survey", checkNull(rs.getString("SURVEY")));
					rowData.put("result", checkNull(rs.getString("RESULT")));
					rawDataProductDetailJson.put(count, rowData);
					count++;
				}
				rs.close();
				rs=null;
				pstmt.close();
				pstmt=null;
			}
	
		}		
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getProductDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		System.out.println("LiveEventMgrWiseDetails rawDataProductDetailJson String======>>"+rawDataProductDetailJson.toString());
	    return rawDataProductDetailJson;
    }
    private String checkNull(String str)
   	{
   		if(str == null)
   		{
   			return "";
   		}
   		else
   		{
   			return str.trim() ;
   		}
   	}
}
