package ibase.dashboard.metadata.servlet;
import ibase.webitm.bean.PopUpBean;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.utility.UserInfoBean;

public class DashboardFilterServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{ 
		PopUpBean popUpBean = null;
	    String xmlString = null;
	    String[] parameters = null;
	    String keyString = null;
	    String objName = null;
	    StringTokenizer st = null;
	    HttpSession session = request.getSession(true);
	    try
	    {
	        String fieldName = request.getParameter("FIELDNAME");
	        UserInfoBean userInfo = (UserInfoBean) session.getAttribute("USER_INFO");
	        fieldName = fieldName.trim();
	
	        objName = request.getParameter("OBJ_NAME");
	        //keyString = request.getParameter("KEYSTRING");
	       
	        //Add new code By sachin  on dated 23/6/2015   
	        keyString = new DashboardUtility().getKeyString("W_" + objName, fieldName, userInfo);
	        //Add new code By sachin  on dated 23/6/2015   
	        int pos = fieldName.lastIndexOf(".");
	
	        fieldName = fieldName.substring(pos + 1, fieldName.length());
	        //Add new code By Birendra Pandey on dated 27/06/2014       
	       
	        if (objName != null && (objName != (String) session.getAttribute("OBJ_NAME")))
	        {
	            objName = request.getParameter("OBJ_NAME");
	        } else
	        {
	            objName = (String) session.getAttribute("OBJ_NAME");
	        }
	        //END new code By Birendra Pandey on dated 27/06/2014   
	   
	        objName = objName.trim();
	
	        System.out.println("objName=====" + objName + "  fieldName=====" + fieldName + "  keyString is =====" + keyString);
	
	        if (keyString != null && keyString.trim().length()!=0)
	        {
	            keyString = keyString.substring(1).trim();
	            st = new StringTokenizer(keyString, ":");
	        }
	        if (st != null && st.countTokens() > 1)
	        {
	            parameters = new String[st.countTokens()];
	            int ctr = 0;
	            boolean flag = false;
	            while (st.hasMoreTokens())
	            {
	                String curToken = st.nextToken();
	                if (curToken.indexOf(".") != -1)
	                {
	                    curToken = curToken.substring(curToken.indexOf(".") + 1);
	                }
	                flag = true;
	                //changed by Monif on 3/9/2009.[Simulate it as RCP]
	                curToken = (curToken.indexOf(",") != -1) ? curToken.substring(0, curToken.indexOf(",")) : curToken;
	                parameters[ctr] = request.getParameter(curToken);
	                ctr++;
	
	            }
	        } else
	        {
	            parameters = new String[1];
	            if ((keyString != null) && (keyString.indexOf(".") != -1))
	            {
	                keyString = keyString.substring(keyString.indexOf(".") + 1);
	                parameters[0] = request.getParameter(keyString);
	            } else
	            {
	                parameters[0] = request.getParameter(keyString);
	            }
	        }
	        popUpBean = new PopUpBean();
	        popUpBean.setObjName(objName);
	        popUpBean.setUserInfoBean(userInfo);
	
	        xmlString = popUpBean.getPopUpXML(fieldName, parameters);
	
	        if (xmlString == null)
	        {
	            xmlString = "<Root> </Root>";
	        }
	        System.out.println("Pop help xml string==" + xmlString);
	        OutputStream outputStreampop = response.getOutputStream();
	        outputStreampop.write(xmlString.toString().getBytes());
	        outputStreampop.flush();
	        outputStreampop.close();
	    } catch (Exception e)
	    {
	        System.out.println("Exception : SalesPerfrmncFilterServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e.getMessage());
	        try
	        {
	            throw new ITMException(e);
	        } catch (ITMException e1)
	        {
	            e1.printStackTrace();
	        }
	    }
    }

}