/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentFixedCache
implements Serializable {
    protected int maxSize;
    protected Map cache;

    public ConcurrentFixedCache() {
        this(100);
    }

    public ConcurrentFixedCache(int maxSize) {
        this.cache = new ConcurrentHashMap(maxSize);
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public Object get(Object key) {
        return this.cache.get(key);
    }

    public void put(Object key, Object value) {
        if (this.maxSize == 0) {
            return;
        }
        this.cache.put(key, value);
        if (this.cache.size() > this.maxSize) {
            Iterator iterator = this.cache.keySet().iterator();
            try {
                while (this.cache.size() > this.maxSize && iterator.hasNext()) {
                    Object next = iterator.next();
                    if (next == key) continue;
                    this.cache.remove(next);
                }
            }
            catch (Exception exception) {}
        }
    }

    public Map getCache() {
        return this.cache;
    }
}

