package ibase.e12ria.e12widgets.client;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWordWrap;
import com.google.gwt.user.client.ui.Widget;

/**
 * Used for WallToWall panel.
 * A Label/HTML replacement that does not sink events. By default, the standard
 * Label and HTML widgets call sinkEvents() in their constructors. On the
 * iPhone, this causes the browser to render these elements with a dark
 * background and display an "action bubble" when the user performs a
 * tap-and-hold gesture on these elements. The UnsunkLabel exists to replace the
 * basic functions of Label and HTML without adding this unwanted UI behavior.
 */
public class UnsunkLabel extends Widget implements HasText, HasHTML, HasWordWrap{

	public UnsunkLabel() {
		setElement( DOM.createDiv() );
	}
	
	public UnsunkLabel( String contents ) {
		this();
		setText( contents );
	}

	public UnsunkLabel( String contents, boolean asHTML ) {
		this();
		if ( asHTML ) {
			setHTML( contents );
		}
		else {
			setText( contents );
		}
	}
	
	public String getHTML() {
		return DOM.getInnerHTML( getElement() );
	}
	
	public String getText() {
		return DOM.getInnerText( getElement() );
	}
	
	public void setHTML( String html ) {
		DOM.setInnerHTML( getElement(), html );
	}
	
	public void setText( String text ) {
		DOM.setInnerText( getElement(), text );
	}
	
	public boolean getWordWrap() 
	{
		return ! getElement().getStyle().getProperty( "whiteSpace" ).equals( "nowrap" );
	}

	public void setWordWrap(boolean wrap) 
	{
		getElement().getStyle().setProperty( "whiteSpace" , wrap ? "normal" : "nowrap" );
	}
}
