package ibase.e12ria.e12widgets.collections;

import java.util.ArrayList;

public class DynamicArrayList<E> extends ArrayList<E> {
	private static final long serialVersionUID = -9157677764636762577L;
	
	@Override
	public E set(int index, E element) {
		ensureSize(index);
		super.set(index, element);
		return element;
	}
	
	@Override
	public E get(int index) {
		ensureSize(index + 1);
		return super.get(index);
	}

	protected void ensureSize(int index) {
		int size = size();
		if (index >= size) {
			for (int i = 0; i <= index - size; i++) {
				add(null);
			}
		}
	}
	
}
