/********************************************************
Title 	 : BankGauranteeIC [F15DSUN018]
Date  	 : 22/JUL/15
Developer: Pankaj R.
********************************************************/
package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class BankGuaranteeIC extends ValidatorEJB implements BankGuaranteeICLocal, BankGuaranteeICRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();

	//method for validation
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("Val xmlStrling :: " + xmlString);
			System.out.println("Val xmlString1 :: " + xmlString1);
			System.out.println("Val xmlString2 :: " + xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
	
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		String errorType = "";
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		String userId = "";
		String sql = "",sql1="";
		String siteCode = "",siteCodeFor="",confirmed="",effDateStr="";
		String purcOrder="",prdCode="";
		String keyFlag="",tranId="",noOfDays="",currCode="",tranDateStr="",dueDateStr="",lcAmt="";
		String currDate="",statFin="";
		Date dueDate=null,tranDate=null,trDate=null;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		
		String t1Str="";
		Date t1Date=null;
		Timestamp t1Ts=null;
		
		
		SimpleDateFormat sdf = null;
		Timestamp duedt=null,timestamp = null,trandt=null,effdt=null,tranDateTs=null,dts=null;
		
		int ctr=0,noDays=0;
		int cnt = 0;
		int currentFormNo = 0;
		int childNodeListLength;
		double lcAmtVal=0;
String bankNameIss="",bankAdd="";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null,pstmt1=null;
		ResultSet rs = null,rs1=null;
		
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		try
		{
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			timestamp = new Timestamp(System.currentTimeMillis());
			currDate = (sdf.format(timestamp).toString()).trim();
			System.out.println("Current Date>>>>>>>>>"+currDate);
			siteCode =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					
					if(childNodeName.equalsIgnoreCase("tran_id"))
					{  
						sql1="select key_flag from transetup where tran_window='w_bank_guarantee'";
						pstmt1=conn.prepareStatement(sql1);
						rs1=pstmt1.executeQuery();
						if(rs1.next())
						{
							keyFlag=rs1.getString("key_flag");
							System.out.println("Key Flag>>>>>>>>>"+keyFlag);
						}
						rs1.close();
						rs1 = null;
						pstmt1.close();
						pstmt1 = null;
											
						if(keyFlag.equalsIgnoreCase("M"))
						{
							tranId= genericUtility.getColumnValue("tran_id", dom);
							System.out.println("Tran Id:>>"+tranId);
							if(tranId == null || (tranId.length() == 0))
							{
								errList.add("VMTRANID");
								errFields.add(childNodeName.toLowerCase());
							}
							System.out.println("Edit Flag>>>>"+editFlag);
							if(editFlag.equalsIgnoreCase("A"))
							{
								System.out.println("Edit Flag"+editFlag);
								sql = " select count(1) from lc_voucher where tran_id = ?";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,tranId);
								rs = pstmt.executeQuery();
								if(rs.next())
									{
									cnt =  rs.getInt(1);
									if(cnt > 0) 
									{
										errCode = "VMTRANIDEX";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());	
									}									
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
					}
					
					else if(childNodeName.equalsIgnoreCase("tran_date"))
					{
						tranDateStr = genericUtility.getColumnValue("tran_date",dom, "1");
						tranDateTs = Timestamp.valueOf(genericUtility.getValidDateString(tranDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");

						sql = "Select code from period where ? between fr_date and to_date ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1, tranDateTs);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							prdCode = rs.getString(1);
							System.out.println("Period Code>>>>>>"+prdCode);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if (prdCode != null && prdCode.trim().length() > 0) 
						{
							sql = "Select count(1) from period_stat where prd_code = ? "
									+ " AND site_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, prdCode.trim());
							pstmt.setString(2, siteCode.trim());
							rs = pstmt.executeQuery();
							if (rs.next()) {
								cnt = rs.getInt(1);
								System.out.println("Count for prdCode>>>>>>>>>>"+cnt);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if (cnt > 0) 
							{
								sql = "Select stat_fin from period_stat where prd_code = ? and site_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, prdCode.trim());
								pstmt.setString(2, siteCode.trim());
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									statFin = rs.getString(1);
									System.out.println("Status Fin>>>>>>>"+statFin);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								if(statFin != null && statFin.equalsIgnoreCase("N"))
								{
									errString = itmDBAccessEJB.getErrorString("","VTPRDFIN","","",conn);
									return errString;
								}
							} 
							else 
							{
								errCode = "VMSTATSND";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						} 
						else 
						{
							errCode = "VMPRDNTDF";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if(childNodeName.equalsIgnoreCase("site_code__for"))
					{ 
						siteCodeFor = genericUtility.getColumnValue("site_code__for", dom);
						System.out.println("Site Code For>>>>>>>>"+siteCodeFor);
						if(siteCodeFor == null || (siteCodeFor.trim().length() == 0))
						{
							errList.add("NULLBGBENF");
							errFields.add(childNodeName.toLowerCase());
						}
						if(siteCodeFor != null && (siteCodeFor.trim().length() > 0))
						{
							sql = " select count(*) from site where site_code = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,siteCodeFor);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0) 
							{
								errCode = "VTBGBENF";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("purc_order"))
					{ 
						purcOrder = genericUtility.getColumnValue("purc_order", dom);
						System.out.println("Purchase Order>>>>>>>>"+purcOrder);
						if(purcOrder== null || (purcOrder.trim().length() == 0))
						{
							errList.add("NULLPURORD");  
							errFields.add(childNodeName.toLowerCase());
						}
						if(purcOrder != null && (purcOrder.trim().length() > 0))
						{
							sql1 = " select confirmed from porder where purc_order = ? ";
							pstmt1 =  conn.prepareStatement(sql1);
							pstmt1.setString(1,purcOrder);
							rs1 = pstmt1.executeQuery();
							if(rs1.next())
							{
								confirmed =  rs1.getString("confirmed");
								System.out.println("Confirmed>>>>>>>"+confirmed);
							}
							rs1.close();
							rs1 = null;
							pstmt1.close();
							pstmt1 = null;
							if(confirmed.equalsIgnoreCase("N"))
							{
								System.out.println("Confirmed inside ifff");
								errCode = "VTMCONF";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
							
							sql = " select count(*) from porder where purc_order = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,purcOrder);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0)
							{
								errCode = "VTPORD1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
							sql = " select count(*) from porder where status not in ('C','X' ) and purc_order = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,purcOrder);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0) 
							{
								errCode = "VTPORCPCX";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}	
						}
					}
					else if(childNodeName.equalsIgnoreCase("no_days"))
					{
						noOfDays=genericUtility.getColumnValue("no_days", dom);
						System.out.println("No. of Days>>>>>>>>"+noOfDays);
						if(noOfDays!=null && noOfDays.trim().length() > 0)
						{
							noDays=Integer.parseInt(noOfDays);
							System.out.println("No of Days>>>"+noDays);
						}
						//if(noDays <= 0) //comment by cpatil... for validate only upto two digit  
						if(noDays <= 0 || noDays > 99)
						{
							errCode = "VTBGVAL";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
					}	
					else if(childNodeName.equalsIgnoreCase("due_date"))
					{
						tranDateStr=(genericUtility.getColumnValue("tran_date", dom));
						System.out.println("Tran Date>>>>>>>>>"+tranDateStr);
						
						dueDateStr=(genericUtility.getColumnValue("due_date", dom));
						System.out.println("Due Date in String>>>>>"+dueDateStr);
						if(dueDateStr==null || (dueDateStr.length()==0))
						{
							System.out.println("Date is null>>>>>>>");
							errCode = "VTCLAIMDT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
						else //(dueDateStr!=null && (dueDateStr.length() > 0))
						{
							dueDate=sdf.parse(dueDateStr);
							System.out.println("Due date>>>>>>>>"+dueDate);
							tranDate=sdf.parse(tranDateStr);
							System.out.println("Tran date>>>>>>>>"+tranDate);

							sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
							duedt = java.sql.Timestamp.valueOf(sdf.format(dueDate).toString() + " 00:00:00.0");
							trandt = java.sql.Timestamp.valueOf(sdf.format(tranDate).toString() + " 00:00:00.0");
						
							if(duedt.before(trandt))
							{
								System.out.println("Due Date < Tran Date  : "+duedt+" < "+trandt);
								errCode = "VTCLAIMDT1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
						}
					}
					
					else if(childNodeName.equalsIgnoreCase("eff_date"))
					{
						effDateStr = genericUtility.getColumnValue("eff_date",dom);
						effdt = Timestamp.valueOf(genericUtility.getValidDateString(effDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");
						timestamp = new Timestamp(System.currentTimeMillis());
						System.out.println("TIMESTAMP>>>>>>>>"+timestamp);
						if(effdt.after(timestamp))
						{
							System.out.println("Eff Date < Tran Date  : "+effdt+" < "+timestamp);
							errCode = "VTSUBMDT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
					}
					else if(childNodeName.equalsIgnoreCase("curr_code"))
					{
						currCode=genericUtility.getColumnValue("curr_code", dom);
						System.out.println("Currency Code>>>>"+currCode);
						if(currCode==null || (currCode.trim().length()==0))
						{
							errCode = "VTCURR";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
						if(currCode != null && (currCode.trim().length() > 0))
						{
							sql = " select count(*) from currency where curr_code= ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,currCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0) 
							{
								errCode = "VTCURRCD1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}	
						}
					}
					//lc_amt should be gratere than 0
					else if(childNodeName.equalsIgnoreCase("lc_amt"))
					{
						lcAmt=genericUtility.getColumnValue("lc_amt", dom);
						System.out.println("lcAmt(Value)>>>>>>>>"+lcAmt);
						if(lcAmt!=null && lcAmt.trim().length() > 0)
						{
							lcAmtVal=Double.parseDouble(lcAmt);
							System.out.println("lcAmtVal>>>"+lcAmtVal);
						}
						if(lcAmtVal <= 0)
						{
							errCode = "VTBGAMT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
					}
					

					//bank_name_iss should not be blank
					else if(childNodeName.equalsIgnoreCase("bank_name_iss"))
					{
						bankNameIss=genericUtility.getColumnValue("bank_name_iss", dom);
						System.out.println("Bank Issuing Name>>>>"+bankNameIss);
						if(bankNameIss==null || bankNameIss.trim().length()==0)
						{
							errCode = "VTBGISS";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
					
					}
					
					//bank_address should not be blank
					else if(childNodeName.equalsIgnoreCase("bank_address"))
					{
						bankAdd=genericUtility.getColumnValue("bank_address", dom);
						System.out.println("Bank Address>>>>"+bankAdd);
						if(bankAdd==null || bankAdd.trim().length()==0)
						{
							errCode = "VTBGADDR";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
					
					}
					
				}			
				break;
			}//end switch
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}//end try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}//end of validation

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println("XML STRING@@@@@@@@@");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{   
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			System.out.println("XML STRING@@@@@@@@@@@@@!1"+xmlString1);
			dom2 = parseString(xmlString2);
			System.out.println("XML STRING@@@@@@@@@@@@@@@2"+xmlString2);
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [JvVal][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		System.out.println("valueXmlStringvalueXmlStrin ST"+valueXmlString);
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		SimpleDateFormat sdf =null;
		Timestamp timestamp = null,ordDate=null;
		String currDate="";
		String childNodeName = null;
		String siteCode = "",siteCodeFor="",ordDateStr="";
		String chgUser = "";
		String chgTerm = "";
		String sql = "";
		String siteDescr = "",siteDescrFor="",columnValue="",tranId="";
		String purcOrder="";
		int ctr = 0;
		int currentFormNo = 0;
		String currCode="",bgDate="";
		double mexrate=0;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		FinCommon fin=new FinCommon();
		try
		{			 
			System.out.println("@@@@@@@@@@@ itemchange method called for ---->>>>["+currentColumn+"]");
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			conn.setAutoCommit(false);
			connDriver = null;
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			timestamp = new Timestamp(System.currentTimeMillis());	
		
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			siteCode =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			siteDescr = findValue(conn, "descr" ,"site", "site_code", siteCode);
			System.out.println("@@@@@@ 1 siteCode["+siteCode+"]::::::siteDescr["+siteDescr+"]");
			
			chgUser =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			chgTerm =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm"));
			
			currDate = (sdf.format(timestamp).toString()).trim();
			System.out.println("Current Date>>>>"+currDate);
			
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");

			switch(currentFormNo)
			{
			case 1 : 
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				int childNodeListLength = childNodeList.getLength();
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(currentColumn))
					{
						if(childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();  
						}
					}
					ctr++;
				}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					System.out.println("@@@@@@  itm_default itemchange called");
					System.out.println("@@@@@@ siteCode["+siteCode+"]");
					
					siteCodeFor =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode")); 
					siteDescr = findValue(conn, "descr" ,"site", "site_code", siteCode);
					
					System.out.println("@@@@@@ 1 siteCode["+siteCode+"]::::::siteDescr["+siteDescr+"]");
					valueXmlString.append("<site_code__for>").append("<![CDATA[" +  siteCodeFor + "]]>").append("</site_code__for>");
					valueXmlString.append("<site_descr>").append("<![CDATA[" +  siteDescr + "]]>").append("</site_descr>");
					
					valueXmlString.append("<tran_date>").append("<![CDATA[" + currDate + "]]>").append("</tran_date>"); // tran_date for Transaction Date
					
					valueXmlString.append("<open_date>").append("<![CDATA[" + currDate + "]]>").append("</open_date>"); // open_date for BG Date
					
					valueXmlString.append("<eff_date>").append("<![CDATA[" + currDate + "]]>").append("</eff_date>"); // eff_date for BG Submission date
					
//					valueXmlString.append("<add_date>").append("<![CDATA[" + currDate + "]]>").append("</add_date>");
//					
//					valueXmlString.append("<add_user>").append("<![CDATA[" + chgUser + "]]>").append("</add_user>");
//					
//					valueXmlString.append("<add_term>").append("<![CDATA[" + chgTerm + "]]>").append("</add_term>");
					
				}//end of if
				if(currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				{
					valueXmlString.append("<chg_date>").append("<![CDATA[" + currDate + "]]>").append("</chg_date>");
					
					tranId=genericUtility.getColumnValue("tran_id", dom);
					valueXmlString.append("<tran_id protect = \"1\">").append("<![CDATA[" + tranId + "]]>").append("</tran_id>");
					
//					purcOrder=genericUtility.getColumnValue("purc_order", dom);
//					valueXmlString.append("<purc_order protect = \"1\">").append("<![CDATA[" + purcOrder + "]]>").append("</purc_order>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("site_code__for"))
				{
					siteCodeFor = genericUtility.getColumnValue("site_code__for", dom);
					siteDescrFor = findValue(conn, "descr" ,"site", "site_code", siteCodeFor);
					System.out.println("@@@@@ siteCodeFor["+siteCodeFor+"]siteDescrFor["+siteDescrFor+"]");
					valueXmlString.append("<site_descr>").append("<![CDATA[" +  siteDescrFor + "]]>").append("</site_descr>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("purc_order"))
				{
					System.out.println("@@@@@@  purc_order itemchange called");
					purcOrder = genericUtility.getColumnValue("purc_order", dom);
					
					sql = "select ord_date from porder where purc_order= ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, purcOrder);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						ordDate= rs.getTimestamp("ord_date");
						System.out.println("Ordered Date>>>>>"+ordDate);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if(ordDate != null)
					{
						ordDateStr=sdf.format(ordDate).toString();
						System.out.println("OrderDateStr@@@@@@@"+ordDateStr);
					}
					else
					{
						ordDateStr="";						
						System.out.println("OrderDateStr@@@@@@@"+ordDateStr);
					}
					valueXmlString.append("<ord_date>").append("<![CDATA[" +  ordDateStr + "]]>").append("</ord_date>");
				
				
				
				}
				// added by priyanka shinde
				//exc_rate set on itemchange o curr code
				else if(currentColumn.trim().equalsIgnoreCase("curr_code"))
				{
					System.out.println("@@@@@@  curr_code itemchange called");
					currCode = genericUtility.getColumnValue("curr_code", dom);
					siteCodeFor = genericUtility.getColumnValue("site_code__for", dom);
					bgDate = genericUtility.getColumnValue("open_date", dom);
					System.out.println("CurrCode======="+currCode);
					System.out.println("siteCodeFor======="+siteCodeFor);
					System.out.println("bgDate======="+bgDate);
					
					mexrate=fin.getDailyExchRateSellBuy(currCode, "", siteCodeFor, bgDate, "B", conn);//through itemchange
					System.out.println("ExcRate from getDailyExchRateSellBuy========="+mexrate);
					valueXmlString.append("<exch_rate>").append("<![CDATA[" +  mexrate + "]]>").append("</exch_rate>");
					
				}
				
				
				valueXmlString.append("</Detail1>");
				break;
			}//end of switch-case
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(pstmt != null)
						pstmt.close();
					if(rs != null)
						rs.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}//end of itemChanged

	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}//end of errorType

	private String findValue(Connection conn, String columnName ,String tableName, String columnName2, String value) throws  ITMException, RemoteException
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";
		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{					
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
			if (findValue == null )
			{
				findValue = "";
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e); 
		}
		System.out.println("returning String from findValue " + findValue);
		return findValue;
	}//end of findValue

	private String checkNull( String input )
	{
		if (input == null )
		{
			input = "";
		}
		return input;
	}//end of checkNull
}



