package ibase.dashboard.sfa.servlet;
import ibase.dashboard.sfa.ejb.RejectionTemplSummaryRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class RejectionTemplSummServlet extends HttpServlet
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		RejectionTemplSummaryRemote rejectionRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String projectmngr = "", fromDate = "", toDate = "";
		HttpSession session = null;
		UserInfoBean userInfo = null;
		try
		{
			response.setContentType("application/xml");
			dataSourceName  = request.getParameter("dataSourceName");
			projectmngr     = request.getParameter("PROJECT_MANAGER");
			fromDate        = request.getParameter("fromDate");
			toDate          = request.getParameter("toDate");
			if (projectmngr == null || projectmngr.trim().length() == 0)
				{
					session     	= request.getSession(true);
					userInfo 		= (UserInfoBean) session.getAttribute("USER_INFO");
					projectmngr 	= userInfo.getEmpCode();
				}
					
			context = new InitialContext(appConnectParm.getProperty());
			rejectionRemote = (RejectionTemplSummaryRemote) context.lookup("ibase/RejectionTemplSummary/remote");
			JSONObject jsonObjData = (JSONObject) rejectionRemote.getTemplSummary(dataSourceName,fromDate,toDate,projectmngr);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("JSON data for RejectionTemplSummServlet is ==" + jsonObjData);
		
			

		} catch (Exception e)
		{
			System.out.println("Exception : RejectionTemplSummServlet.doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}
}
