package ibase.e12ria.e12widgets.collections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * This class is for maintain Tableform State
 *
 */
public class TableFormState implements Iterator< FeedData >, Iterable< FeedData > 
{
	protected static Map<String, TableFormState> map = new HashMap<String, TableFormState>();
	
	protected final String accessKey;	
	protected final String parentKey;
	protected final String formNo;

	protected boolean isDefault = false;
	protected LinkedHashMap< String, FeedData > currentFeedsState = new LinkedHashMap<String, FeedData>();
	protected LinkedHashMap< String, FeedData > baseFeedsState = new LinkedHashMap<String, FeedData>();
	
	private Iterator<FeedData> iterator;
	
	protected TableFormState( String parentKey, int formNo )
	{
		this.parentKey = parentKey;
		this.formNo = String.valueOf( formNo );
		this.accessKey = formNo + ":" + parentKey;
	}

	public static TableFormState get( String parentKey, int formNo  )
	{
		TableFormState tableFormState = map.get( String.valueOf( formNo ) + parentKey );
		if( tableFormState == null )
		{
			tableFormState = new TableFormState( parentKey, formNo );
			map.put( String.valueOf( formNo ) + parentKey, tableFormState );
		}
		return tableFormState;
	}
	
	public static boolean exists( String parentKey, int formNo )
	{
		return map.containsKey( String.valueOf( formNo ) + parentKey );
	}
	
	public boolean isDefault()
	{
		return this.isDefault;
	}

//	public void setDefault(boolean isDefault)
//	{
//		this.isDefault = isDefault;
//	}
	
	public void addRowDataMap( String pkValues, FeedData rowDataMap )
	{
		FeedData preRowDataMap = currentFeedsState.get( accessKey + pkValues );
		if( preRowDataMap == null )
		{
			preRowDataMap = new FeedData();
		}
		preRowDataMap.putAll(rowDataMap);
		currentFeedsState.put( accessKey + pkValues, preRowDataMap );
		baseFeedsState.put( accessKey + pkValues, preRowDataMap );
	}

	public void addRowDataMap( String pkValues, FeedData rowDataMap, boolean isDefault )
	{
		if(!this.isDefault)
		{
			clearRowDataMap();
		}
		currentFeedsState.put( accessKey + pkValues, rowDataMap );
		baseFeedsState.put( accessKey + pkValues, rowDataMap );
		this.isDefault = isDefault;
	}

	public void insertRowDataMap( String pkValues, FeedData rowDataMap )
	{
		FeedData preRowDataMap = currentFeedsState.get( accessKey + pkValues );
		preRowDataMap.putAll(rowDataMap);
		currentFeedsState.put( accessKey + pkValues, preRowDataMap );
	}
	
	protected void clearRowDataMap()
	{
		ArrayList< String > feedKeys = new ArrayList< String >();
		Iterator<String> iterator =  currentFeedsState.keySet().iterator();
		while( iterator.hasNext() )
		{
			String key = iterator.next();
			if( key.startsWith( accessKey ) )
			{
				feedKeys.add( key );
			}
		}
		if( !feedKeys.isEmpty() )
		{
			for( String key : feedKeys )
			{
				currentFeedsState.remove(key);
				baseFeedsState.remove(key);
			}
		}
	}

	public ArrayList< FeedData > getCurrentSelectedFeeds()
	{
		ArrayList< FeedData > feedDatas = new ArrayList< FeedData >();
		Iterator<String> iterator =  currentFeedsState.keySet().iterator();
		while( iterator.hasNext() )
		{
			String key = iterator.next();
			FeedData feedData  = currentFeedsState.get(key);
			
			//Checked for if Item Detail is deseleted 
			String attributeVal = feedData.get("ATTRIBUTE_NODE");
			boolean isDeleted = ( attributeVal != null && attributeVal.indexOf("\"D\"") != -1 );
			
			if( "true".equalsIgnoreCase( feedData.get("selectbox") ) && !isDeleted)
			{
				feedDatas.add( feedData );
			}
		}
		return feedDatas;
	}
	
	
	public Map<String, FeedData> getBaseFeeds()
	{
		return baseFeedsState;
	}
	
	public static void clear()
	{
		map.clear();
	}
	
	public void commit()
	{
		baseFeedsState.clear();
		baseFeedsState.putAll( currentFeedsState );
	}
	
	public void rollback()
	{
		currentFeedsState.clear();
		currentFeedsState.putAll( baseFeedsState );
	}
	
	
	@Override
	public boolean hasNext() {
		return iterator.hasNext();
	}

	@Override
	public FeedData next() {
		return iterator.next();
	}

	@Override
	public void remove() {
		iterator.remove();
	}

	@Override
	public Iterator<FeedData> iterator() {
		iterator = currentFeedsState.values().iterator();
		return this;
	}
	
	/**
	 * This method is remove the sub feed value when deselect the a doctor 
	 * 
	 *@param parentKey 
	 *@param formNo
	 *@return true if delete the value otherwise false
	 *   */
	public static boolean removeSubFeedValue( String parentKey, int formNo  )
	{
		if( map.containsKey( String.valueOf( formNo ) + parentKey ) )
		{
			map.remove( String.valueOf( formNo ) + parentKey );
			return true;
		}
		
		return false;
	}

}
