CREATE TABLE  MULTI_PICK_ISS (
TRAN_ID			CHAR(10) NOT NULL, 
TRAN_DATE		DATE NOT NULL, 
SITE_CODE		CHAR(5) NOT NULL, 
STATUS			CHAR(1), 
STATUS_DATE		DATE, 
CONFIRMED		CHAR(1), 
CONF_DATE		DATE, 
REMARKS			VARCHAR2(60), 
EMP_CODE__USER		CHAR(10),
CHG_DATE		DATE NOT NULL, 
CHG_USER		CHAR(10) NOT NULL, 
CHG_TERM		VARCHAR2(15) NOT NULL 
) TABLESPACE ITM_DIS_D2;
ALTER TABLE MULTI_PICK_ISS ADD  CONSTRAINT MPTCN_PICK_X PRIMARY KEY ( TRAN_ID ) USING INDEX TABLESPACE ITM_DIS_I1;
ALTER TABLE MULTI_PICK_ISS ADD CONSTRAINT FK_MPTCN_PICK_SITE_CODE FOREIGN KEY (SITE_CODE) REFERENCES site (SITE_CODE);


CREATE TABLE MULTI_PICK_ISS_HDR (
TRAN_ID			CHAR(10) NOT NULL, 
LINE_NO			NUMBER(14,3) NOT NULL, 
PTCN			CHAR(10), 
SALE_ORDER		CHAR(10), 
WAVE_ID			VARCHAR2(10) 
) TABLESPACE ITM_DIS_D2;
ALTER TABLE MULTI_PICK_ISS_HDR ADD  CONSTRAINT MPTCN_PICK_DET_X PRIMARY KEY ( TRAN_ID,LINE_NO ) USING 
INDEX TABLESPACE ITM_DIS_I1;

CREATE TABLE MULTI_PICK_ISS_DET (
TRAN_ID			CHAR(10) NOT NULL, 
LINE_NO			NUMBER(14,3) NOT NULL, 
SITE_CODE		CHAR(5) NOT NULL, 
PTCN			CHAR(10), 
SALE_ORDER		CHAR(10), 
LINE_NO__SORD		CHAR(3),
PICK_ORDER		CHAR(10),
LOC_CODE		CHAR(8), 
ITEM_CODE		CHAR(10), 
LOT_NO			CHAR(15), 
LOT_SL			CHAR(15), 
QUANTITY		NUMBER(14,3), 
NO_ART			NUMBER(6),
STATUS			CHAR(1),
CARTON_NO		VARCHAR2(20),
OUTER_CARTON_NO		VARCHAR2(20),
DEALLOC_QTY		NUMBER(14,3)
)TABLESPACE ITM_DIS_D2;
ALTER TABLE MULTI_PICK_ISS_DET ADD  CONSTRAINT MPTCN_PICK_ITEM_X PRIMARY KEY ( TRAN_ID,LINE_NO ) USING INDEX TABLESPACE ITM_DIS_I1;
ALTER TABLE MULTI_PICK_ISS_DET ADD CONSTRAINT FK_MPTCN_PICK_ITEM_SITE_CODE FOREIGN KEY (SITE_CODE) REFERENCES SITE (SITE_CODE);



Insert into itm2menu (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,ICON_PATH,CLOSE_ICON,OPEN_ICON,OBJ_TYPE,CHG_DATE,CHG_TERM,CHG_USER,MOB_DEPLOY) values 
('WMS',1,63,0,0,0,'w_multi_pick_iss','Multi Picking',null,'WMS.1.63.0.0.0','e12_logo.gif',null,null,'W',sysdate,'BASE','BASE','Y');


Insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,SCAN_FLAG,SCAN_METADATA,AUTO_ACCEPT_SCAN,PROPERTY_INFO,EXT_COM,EXT_METADATA,EXT_SETUP,AFTER_SAVE,COLUMN_ON_SAVE,SCAN_DELIMITER,AUTO_ACCEPT_WEIGHDATA,DEFAULT_VIEW,SELECTION_MODE,STORAGE_KEY_METADATA,ASSISTED_MODE,PARENT_KEY_COL,QTY_COL,FORM_TYPE,DISP_METADATA,RATE_COL,AUTO_ADDON_ENTRY)
values ('w_multi_pick_iss','Multi Picking',null,null,null,null,null,null,'1','F',null,null,null,null,null,null,null,null,null,null,null,null,null,null,'E',null,null,null,null,null,null);

Insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,SCAN_FLAG,SCAN_METADATA,AUTO_ACCEPT_SCAN,PROPERTY_INFO,EXT_COM,EXT_METADATA,EXT_SETUP,AFTER_SAVE,COLUMN_ON_SAVE,SCAN_DELIMITER,AUTO_ACCEPT_WEIGHDATA,DEFAULT_VIEW,SELECTION_MODE,STORAGE_KEY_METADATA,ASSISTED_MODE,PARENT_KEY_COL,QTY_COL,FORM_TYPE,DISP_METADATA,RATE_COL,AUTO_ADDON_ENTRY) 
values ('w_multi_pick_iss','Header',null,null,null,null,null,null,'2','T',null,'<SCAN_INFO><INPUT_SCAN ORDER="1"><SCAN_LABEL>PTCN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>ptcn</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>',null,null,null,null,null,null,null,null,null,null,null,null,'A',null,null,null,'checkedImage@img<ptcn>,<sale_order>,<wave_id>',null,null);

Insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,SCAN_FLAG,SCAN_METADATA,AUTO_ACCEPT_SCAN,PROPERTY_INFO,EXT_COM,EXT_METADATA,EXT_SETUP,AFTER_SAVE,COLUMN_ON_SAVE,SCAN_DELIMITER,AUTO_ACCEPT_WEIGHDATA,DEFAULT_VIEW,SELECTION_MODE,STORAGE_KEY_METADATA,ASSISTED_MODE,PARENT_KEY_COL,QTY_COL,FORM_TYPE,DISP_METADATA,RATE_COL,AUTO_ADDON_ENTRY) 
values ('w_multi_pick_iss','Detail',null,null,null,null,null,null,'3','T',null,'<SCAN_INFO><MAPPING_SCAN ORDER="1"><SCAN_LABEL>PTCN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>ptcn</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="2"><SCAN_LABEL>Pick Location:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>loc_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="3"><SCAN_LABEL>Item Code:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>item_code</FIELD></FIELDS></MAPPING_SCAN><INPUT_SCAN ORDER="1"><SCAN_LABEL>Quantity:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>quantity</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>',null,null,null,null,null,null,null,null,null,'U',null,null,'E',null,null,null,'checkedImage@img<ptcn>,<loc_code>,<item_descr> - <item_code>, <quantity>',null,null);


Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',1,'N',null,null,'Next','Next',null,'1',null,null,'U',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',2,'P','a','a','Prev','Prev',null,'2',null,null,'U',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',3,'N','a','a','Next','Next',null,'2',null,null,'U',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',4,'P','a','a','Prev','Prev',null,'3',null,null,'U',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',5,'A',null,null,'Add Record','Add',null,'2',null,null,'U',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',6,'S',null,null,'Saving','Finish',null,'3',null,null,'U',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',7,'A',null,null,'Add Record','Add',null,'3',null,null,'U',null,to_timestamp('29-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);


Insert into transetup (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,UDF_1,UDF_2,UDF_3,UDF_4,UDF_5,REPEATE_ADD,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,SITE_ACC_COL,CONFIRM_COL,CONFIRM_VAL,REPEAT_ADD_DET,LOAD_MODE,AUTO_CONFIRM,LEDG_POST_CONF,CHG_DATE_ON_CONF,TRAN_ID_COL,MAIL_OPTION,CONFIRM_MODE,GARBAGE_OPT,VAL_FLAG_EDI,VERIFY_PASSWORD,TABLE_NAME,APPLICATION,TABLE_DESC,TRAN_DATE_COL,SALES_PERS_ACC_COL,CUST_ACC_COL,SUPP_ACC_COL,ITEM_SER_ACC_COL,EMP_ACC_COL,WORKFLOW_OPT,TRAN_ID__FROM,TRAN_ID__TO,MULTITIRE_OPT,REF_SER,VIEW_MODE,TABLE_NAME_DET1,TABLE_NAME_DET2,TABLE_NAME_DET3,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CUSTOM_PREVIEW_OBJ,CHILDDATA_ARGOPT,IGNOREERRLIST_ONLOAD,EDIT_TMPLT,WRKFLW_INIT,FORMAL_ARGS,EDIT_OPT,AUDIT_TRAIL_OPT,EDITTAX,CACHE_OPT,OPTIMIZE_MODE,EDIT_EXPR,TRANSFER_MODE,RATE_COL,QTY_COL,RCP_CACHE_STATUS,PRINT_CONTROL,PROFILE_ID__RES,TRAN_COMPL_MSG,EXEC_TYPE,START_FORM,PERIOD_OPTION,HEADER_FORM_NO,WRKFLW_PRIORITY,EDIT_EXPR_INP,ISATTACHMENT,ITEM_SER_ACC_CODE,REPEATADDDET,ALLOW_ATTACH,DISP_META_DATA,MSG_ONSAVE,WF_STATUS,CONFIRM_BY_COL,CONFIRM_DATE_COL,RESTART_FORM) values ('w_multi_pick_iss','A','2','A','seq10','Y',null,null,null,null,'N',to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE           ','0',null,null,null,null,null,null,'Y','Y','TRAN_ID','0','0','N',null,null,'multi_pick_iss','WMS',null,null,null,null,null,null,null,null,null,null,null,'M-PTCN','F',null,null,null,null,null,null,null,'2',null,null,null,null,null,'0',null,null,null,null,null,null,null,null,null,null,null,null,null,'M','1',null,null,null,null,null,null,null,null,null,null,null,null);


Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_pick_iss','default_data_wiz','1','mpick_iss_default_data',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','2','0','EJB','MultiplePtcnWiz',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_pick_iss','post_item_change','1','poic_default_ejb',null,to_timestamp('09-10-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','2','0','EJB','MultiplePtcnWiz',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_pick_iss','post_save','1','mpick_iss_pos',null,to_timestamp('30-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','2','0','EJB','MultiplePtcnWizPos',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_pick_iss','pre_navigate_finish','1','pos_mpick_iss_finish',null,to_timestamp('30-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','2','0','EJB','MultiplePtcnWizPos',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_pick_iss','pre_navigate_next','1','prv_mpick_iss',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','2','0','EJB','MultiplePtcnWiz',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_pick_iss','pre_validate','1','prv_mpick_iss',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','2','0','EJB','MultiplePtcnWiz',null);


Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) values ('mpick_iss_default_data','Default Data','http://localhost:9090/axis/services/ValidatorService','BASE','itemChanged','String','S',null,null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE');
Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) values ('mpick_iss_pos','post save','http://localhost:9090/axis/services/ValidatorService','BASE','postSave','String','S',null,null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE');
Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) values ('poic_default_ejb',null,'http://localhost:9090/axis/services/ValidatorService',null,'itemChanged','String','S',null,null,to_timestamp('01-06-12','DD-MM-RR HH12:MI:SSXFF AM'),'Subrata   ','Subu');
Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) values ('prv_mpick_iss','Validation','http://localhost:9090/axis/services/ValidatorService','BASE','wfValData','String','S',null,null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'          ','BASE');



Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',1,'COMPONENT_TYPE','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',2,'COMPONENT_NAME','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','MultiplePtcnWiz');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',3,'XML_DATA','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',4,'XML_DATA_1','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',5,'XML_DATA_ALL','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',6,'OBJ_CONTEXT','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',7,'FOCUSED_COLUMN','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',8,'EDIT_FLAG','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',9,'XTRA_PARAMS','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',1,'COMPONENT_TYPE','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',2,'COMPONENT_NAME','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','MultiplePtcnWizPos');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',3,'XML_DATA_ALL','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',4,'<tran_id>','I',null,'B.String',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',5,'EDIT_FLAG','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',6,'XTRA_PARAMS','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',7,'DB_CONN','I',null,'S.Connection',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',1,'COMPONENT_TYPE','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',2,'COMPONENT_NAME','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',3,'XML_DATA','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',4,'XML_DATA_1','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',5,'XML_DATA_ALL','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',6,'OBJ_CONTEXT','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',7,'FOCUSED_COLUMN','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',8,'EDIT_FLAG','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',9,'XTRA_PARAMS','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',1,'COMPONENT_TYPE','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',2,'COMPONENT_NAME','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','MultiplePtcnWiz');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',3,'XML_DATA','l',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',4,'XML_DATA_1','l',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',5,'XML_DATA_ALL','l',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',6,'OBJ_CONTEXT','l',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',7,'EDIT_FLAG','l',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',8,'XTRA_PARAMS','l',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);


Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('multi_pick_iss','2','ptcn',null);

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNNN','Empty PTCN !!!','PTCN can not be blank.Please enter PTCN','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNNE','Invalid PTCN','Entered PTCN is not defined in wave_task_det master','E',sysdate,'BASE','BASE');


insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNAC','Confirmed PTCN','All task selected PTCN are confirmed','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNAS','PTCN already scanned','Entered PTCN already scanned','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNOH','PTCN on hold','Entered PTCN on hold please check','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNIC','Cancel PTCN','Entered PTCN is cancel please check','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNQG','Invalid Quantity !!!','Entered quantity cannot be greater picking quantity','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNTNC','Task incompleted','Dependent task not completed for this PTCN','E',sysdate,'BASE','BASE');

Insert into disparm (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','IMEDIATE_LOC','S','ISTAG   ','INTERMEDIATE LOCATION ACTIVE PICK',0,sysdate,'BASE','BASE');

Insert into location (LOC_CODE,DESCR,SH_DESCR,LOC_TYPE,INV_STAT,ONE_ITEM,CAPACITY,CAP_UOM,LOC_GROUP,TEMP,SITE_CODE,SITE_CODE__OWN,ITEM_CODE,EFF_FROM,VALID_UPTO,HIRE_CHARGE,USABLE,CHG_DATE,CHG_USER,CHG_TERM,ZONE,PALLET_BASED,SINGLE_LOT_SL,ITEM_LOT_OPT,CYCLE_COUNT_REQD,PHY_HAN_BASIS,FACILITY_CODE)
 values ('ISTAG   ','INTERMEDIATE LOCATION FOR ACTIVES','INTERMEDIATE LOC','N','STAG ','N',9999,null,'S    ','N',null,null,null,null,null,0,'Y',SYSDATE,'BASE      ','base-Lenovo    ',null,'N','N','2','N','L','          ');

update obj_forms set scan_metadata = '<SCAN_INFO><MAPPING_SCAN ORDER="1"><SCAN_LABEL>PTCN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>ptcn</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="2"><SCAN_LABEL>Pick Location:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>loc_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="3"><SCAN_LABEL>Lot No.:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_no</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="4"><SCAN_LABEL>Lot sl:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_sl</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="5"><SCAN_LABEL>Item Code:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>item_code</FIELD></FIELDS></MAPPING_SCAN><INPUT_SCAN ORDER="1"><SCAN_LABEL>Quantity:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>quantity</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>'
where win_name ='w_multi_pick_iss' and form_no = 3;

update obj_forms set disp_metadata = 'checkedImage@img<ptcn>,<loc_code>,<lot_no>,<lot_sl>,<item_descr> - <item_code>, <quantity>' 
where win_name ='w_multi_pick_iss' and form_no = 3;

INSERT INTO OBJ_ITEMCHANGE(OBJ_NAME,fORM_nO,FIELD_NAME,MANDATORY)VALUES('wavegen','1','batch_id','Y');

alter table wave_task add batch_id varchar2(10); 

INSERT INTO messages (    msg_no , 	msg_str, 	msg_descr , 	msg_type , 	msg_opt , 	msg_time , 	alarm , 	err_source , 	chg_date , 	chg_user , 	chg_term , 	override_input , 	mail_option ) VALUES ( 	'VTNOBATCH7', 	'No Pending orders!', 	'There is no pending orders for this batch id', 	'E', 	'Y', 	NULL, 	NULL, 	NULL, 	fn_sysdate(), 	'BASE      ', 	'BASE      ', 	NULL, 	NULL);
INSERT INTO messages ( 	msg_no , 	msg_str, 	msg_descr , 	msg_type , 	msg_opt , 	msg_time , 	alarm , 	err_source , 	chg_date , 	chg_user , 	chg_term , 	override_input , 	mail_option ) VALUES ( 	'VTINVBATCW', 	'Invalid Batch Id!', 	'Entered batch id is not valid, please enter valid batch id ', 	'E', 	'Y', 	NULL, 	NULL, 	NULL, 	fn_sysdate(), 	'BASE      ', 	'BASE      ', 	NULL, 	NULL);


--24/02/15

delete from system_events where obj_name ='multi_pick_iss' and event_code ='post_save';
delete from system_event_services where  service_code in (select service_code from system_events where obj_name ='multi_pick_iss' and event_code ='post_save');  
delete from system_service_args where  service_code in (select service_code from system_events where obj_name ='multi_pick_iss' and event_code ='post_save');  

Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM)
values ('pos_mpick_iss_finish','post save ','http://localhost:9090/axis/services/ValidatorService','BASE','postSave','String','S',null,null,sysdate,'BASE      ','BASE');

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',1,'COMPONENT_TYPE','I',null,'S',null,sysdate,'BASE      ','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',2,'COMPONENT_NAME','I',null,'S',null,sysdate,'BASE      ','BASE','MultiplePtcnWizPos');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',3,'XML_DATA_ALL','I',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',4,'<tran_id>','I',null,'B.String',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',5,'EDIT_FLAG','I',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',6,'XTRA_PARAMS','I',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',7,'DB_CONN','I',null,'S.Connection',null,sysdate,'BASE      ','BASE',null);

update obj_forms set scan_metadata ='<SCAN_INFO><MAPPING_SCAN ORDER="1"><SCAN_LABEL>Pick Location:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>loc_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="2"><SCAN_LABEL>Item Code:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>item_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="3"><SCAN_LABEL>Lot No.:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_no</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="4"><SCAN_LABEL>Lot sl:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_sl</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="5"><SCAN_LABEL>PTCN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>ptcn</FIELD></FIELDS></MAPPING_SCAN><INPUT_SCAN ORDER="1"><SCAN_LABEL>Quantity:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>quantity</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>'
where win_name ='w_multi_pick_iss' and form_no = 3;

update obj_forms set scan_metadata ='checkedImage@img<loc_code>, <item_code>, <lot_no>, <lot_sl>, <ptcn>, <quantity>'
where win_name ='w_multi_pick_iss' and form_no = 3;

--26/02/15
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) 
values ('multi_pick_iss',8,'Q',null,null,'Deselect Item','DESELECT',null,'2',null,null,'U',null,sysdate,null,null,null,null,null);


CREATE OR REPLACE
TRIGGER multi_PTCN_TRG
AFTER  DELETE ON multi_pick_iss_hdr
FOR EACH ROW
BEGIN
  delete from multi_pick_iss_det 
  where tran_id = :OLD.tran_id 
  and ptcn = :old.ptcn;
END ;



ALTER TABLE multi_pick_iss_det ADD PICK_ORD__LINE_NO  NUMBER(14,3);
update  obj_forms set scan_metadata= '<SCAN_INFO><INPUT_SCAN ORDER="1"><SCAN_LABEL>PTCN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>ptcn</FIELD></FIELDS></INPUT_SCAN><SCAN_CONDITION field="ptcn">ptcn =="null" ||ptcn == ""</SCAN_CONDITION></SCAN_INFO>'
 where win_name ='w_multi_pick_iss' and form_no =2;
 
 delete from obj_actions where obj_name ='multi_pick_iss' and form_no =3 and title like '%Add%';





