package ibase.dashboard.scm.servlet;

import ibase.dashboard.scm.ejb.SalesPerformanceRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

public class SalesPerfrmncExpncYTDGrphServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		SalesPerformanceRemote salesPerformance = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String month ="";
		try
		{
			response.setContentType("application/xml");
			dataSourceName = request.getParameter("dataSourceName");
			month = (request.getParameter("month"));
			context = new InitialContext(appConnectParm.getProperty());
			salesPerformance = (SalesPerformanceRemote) context.lookup("ibase/SalesPerformance/remote");
			JSONObject jsonObjData = (JSONObject) salesPerformance.getExpenseYTDGraphData(dataSourceName,month);
			OutputStream outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set in SalesPerfrmncExpncYTDGrphServlet  for build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : SalesPerfrmncExpncYTDGrphServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}