package ibase.e12ria.e12widgets.client;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Widget;

/**
 * This Command is used to ensure that a Widget will be on-screen, or at least
 * the title-bar scrolled offScreen.  It is used by {@link WallToWallPanel}.
 */
public class ScrollToCommand implements Command {
	final int yPos;

	public ScrollToCommand(Widget w) {
		if (w == null) {
			yPos = 1;
		} 
		else {
			yPos = DOM.getAbsoluteTop(w.getElement());
		}
	}
	
	public native void execute() /*-{
   $wnd.scrollTo(0, this.@ibase.e12ria.e12widgets.client.ScrollToCommand::yPos);
   }-*/;
}

