/*
 * Author:Wasim Ansari
 * Date:02-FEB-15
 * Request ID:D14IKAT004 (PO Wizard)
 */
package ibase.webitm.servlet.wms;

import ibase.utility.CommonConstants;
import ibase.webitm.bean.wms.PorderDetailBean;
import ibase.webitm.servlet.Messages;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;



public class PorderTableServlet extends HttpServlet 
{
	private static final long serialVersionUID = 1L;
	InitialContext ctx = null;
    
    public PorderTableServlet() 
    {
    	 super();
    }

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
	{
		doPost( request, response );
	}

	
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ ItemParentChange Started ]XXXXXXXXXXXXXXXXXXXX");

		ServletOutputStream outputStream = null;
		HttpSession sess = null;
		
		String sql = "";
		String htmlData = "",action = ""; 
		
		PorderDetailBean pordBeanObj = new PorderDetailBean();
		
		try 
		{
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )session.getAttribute( "USER_INFO" );
			
			if(userInfo != null)
			{
				action = checkNullAndTrim(request.getParameter("ACTION"));
				System.out.println("Action ["+action+"]");
				
				if("PRODUCT_SET".equalsIgnoreCase(action))
				{
					String itmcode = request.getParameter("ITEMCODE"); 
					String paraData = (request.getParameter("TRANTYPE")==null) ? "":request.getParameter("TRANTYPE").trim();
					String itemDLVDate = (request.getParameter("DLVDate")==null) ? "":request.getParameter("DLVDate").trim();
					String otherDetails = checkNullAndTrim(request.getParameter("OTHER_DETAILS"));
					
					System.out.println("Item Parent="+itmcode);
					
					String productSet = pordBeanObj.getSKUDetail(itmcode,itemDLVDate,paraData,otherDetails);
					sendResponse(response,productSet);
				}
				else if("GET_PURC_DET_1".equalsIgnoreCase(action))
				{
					String purcOrder = (request.getParameter("PURCHORDER")==null) ? "":request.getParameter("PURCHORDER").trim();
					String flag = (request.getParameter("FLAG")==null) ? "":request.getParameter("FLAG").trim();

					String retStr = pordBeanObj.getPurcDetail1(purcOrder, flag);
					sendResponse(response,retStr);
				}
				else if("GET_PURC_DET_2".equalsIgnoreCase(action))
				{
					String purcOrder = (request.getParameter("PURCHORDER")==null) ? "":request.getParameter("PURCHORDER").trim();
					String flag = (request.getParameter("FLAG")==null) ? "":request.getParameter("FLAG").trim();
					String siteCode = (request.getParameter("SITECODE")==null) ? "":request.getParameter("SITECODE").trim();	
					String empCodeFrmReq = (request.getParameter("EMPCODE")==null) ? "":request.getParameter("EMPCODE").trim();
					
					String retStr = pordBeanObj.getPorderDetail2(siteCode,empCodeFrmReq,purcOrder,flag);
					sendResponse(response,retStr);
				}
				else if("VALIDATE_PO".equalsIgnoreCase(action) || "VALIDATE_PO_NEXT".equalsIgnoreCase(action) )
				{
					String purcOrder = (request.getParameter("PURCHORDER")==null) ? "":request.getParameter("PURCHORDER").trim();
					
					String retStr = pordBeanObj.validatePorder(purcOrder);
					sendResponse(response,retStr);
				}
				else if("SAVE_PODtl1".equalsIgnoreCase(action))
				{
					String ordSiteCode = userInfo.getSiteCode();
					String str = (request.getParameter("STR")==null) ? "":request.getParameter("STR").trim();	
					
					String retStr = pordBeanObj.savePorderHeader(str,ordSiteCode);
					sendResponse(response,retStr);
				}
				else if("SAVE_PODtl2".equalsIgnoreCase(action))
				{
					String str = (request.getParameter("STR")==null) ? "":request.getParameter("STR").trim();	
					
					String retStr = pordBeanObj.savePorderDetail(str);
					sendResponse(response,retStr);
				}
				else if("RESET_PODtl".equalsIgnoreCase(action))
				{
					String str = (request.getParameter("STR")==null) ? "":request.getParameter("STR").trim();
					
					String retStr = pordBeanObj.resetPorderHeader(str);
					sendResponse(response,retStr);
				}
				else if("previous".equalsIgnoreCase(request.getParameter("action")))
				{
					String formNo 	= request.getParameter("FORM_NO");
					
					if ("2".equalsIgnoreCase(formNo)  ) 
					{
						request.getRequestDispatcher("/webitm/jsp/PorderPage.jsp").forward(request, response);
					}
					if ("3".equalsIgnoreCase(formNo)  )
					{
						request.getRequestDispatcher("/webitm/jsp/PorderPageII.jsp").forward(request, response); 
					}
				}
			}
			else
			{
				htmlData = Messages.getString("PorderTableServlet_UserNotLogin")+"\n"+Messages.getString("PorderTableServlet_pleaseReLogin"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
            
		}
		catch (Exception e)
		{
			e.printStackTrace();
	        System.out.println("Exception :PorderTableServlet: doPost :==>");
	        try 
	        {
				throw new ITMException(e);
			} 
	        catch (ITMException e1) 
	        {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			
		}
		finally 
		{
			try 
			{
				if( pordBeanObj!= null)
				{
					pordBeanObj = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :PorderTableServlet :==>\n"+ e.getMessage());
				try 
				{
					throw new ITMException(e);
				} 
				catch (ITMException e1) 
				{
					e1.printStackTrace();
				}
			}
		}

	}
	
	public void sendResponse(HttpServletResponse response,String retString)
	{
		try
		{
			response.setContentType("text/xml");
            
            if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
			{
				response.setHeader("Content-Encoding", "gzip");
				GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
				gzOutStream.write(retString.getBytes());
				gzOutStream.flush();
				gzOutStream.close();
			}
			else
			{
				response.setHeader("Content-Encoding", "");
				OutputStream outStream = response.getOutputStream();
				outStream.write(retString.getBytes());
				outStream.flush();
				outStream.close();
			}
		}
		catch(Exception e)
		{
			System.out.println("Inside catch sendResponse");
			e.printStackTrace();
		}
	}
	
	private String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
}
