package ibase.webitm.ejb.wms;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.bean.wms.Product;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.wms.CommonWmsUtil;
import ibase.webitm.utility.wms.MagentoProductSchedule;

import java.util.Iterator;

import java.io.BufferedReader;
import java.io.FileReader;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.ejb.Stateless;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import java.io.File;



/**
 * Session Bean implementation class DDProductWizPosEJB
 */
@Stateless
public class DDProductWizPosEJB extends ValidatorEJB implements DDProductWizPosRemote, DDProductWizPosLocal 
{
	//E12GenericUtility genericUtility = new E12GenericUtility();
	E12GenericUtility genericUtility = new E12GenericUtility(); // Added by Parikshit Kumbhar on 23/04/2015.
	private String tranId = "";
	
	//Changed by samadhan D15AKAT003 on 18/05/2015 for magento updation. start
	String apiSimpleUrl="",apiConfigUrl="",apiDelSkusUrl;
	String deleteSkus="";
	int simpleProductId = 0;
	List<Integer> simpleProductIdCollection = new ArrayList<Integer>();
	ArrayList<Double> parentMaxPrice = new ArrayList<Double>();
	Product objProductsChild = null;
	CommonWmsUtil commonutility = new CommonWmsUtil();
	double price = 0.0;
	String attributeSetId="";
	int siteCnt=0;
	HashMap maxPriceMap = new HashMap();
	//Changed by Samadhan on 26/12/2015 for price list to/from date integration Start
	HashMap<String, String> minFormDate = new HashMap<String, String>();
	HashMap<String, String> maxToDate = new HashMap<String, String>();
	//Changed by Samadhan on 26/12/2015 for price list to/from date integration Emd
	
	//Changed by samadhan D15AKAT003 on 08/06/2015 for store view magento updation
	String storeInfo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <store_info>	";
	//Changed by samadhan D15AKAT003 on 18/05/2015 for magento updation. End
	
	private String item_descr, item_parnt, item_ser, grp_code, item_type, phy_attrib_1, phy_attrib_2, phy_attrib_3,item_length, size_codes,
		item_width, item_height, price_list_dtl, item_gross_wt, item_parnt_desc, item_type_desc, itemser_descr, 
		descr, grp_code_desc, site_codes, color_codes, dimension_desc, supp_item_desc, item_barcode, item_category,
		img_path, item_sh_descr, long_desc, meta_desc, meta_keywords, meta_title, loc_code, 
		loginSiteCode , language_dtl, categoryId, tax, item_commodity, taxChapParent = "",taxChapChild = "", // Added By Parikshit on 23/02/2015[Added variable language_dtl ]
		tradeMarkChild = "", tradeMarkParent = "", phy_att1 = "";
	
	//Added by Chetan Mahajan on date:06/02/2015 [Added new fields] Start	
	private Double pur_lead_time ;  
	private String suppCode = "" ,loc_type = "",loc_type_child = "", pack_size_dtl = ""  ;  // Added By Parikshit on 20/02/2015[Added pack_size_dtl] 
	private String language = "";
	private Timestamp currDate;
	private String chg_user = "", chg_term = "";
	//Added by Chetan Mahajan on date:06/02/2015 [Added new fields] End
    //Changed by Samadhan on 21/12/2015 for Limited Edition and size grid Start
	String limitedEdition = "";
	HashMap<String, String> sizeMap = new HashMap<String, String>();
	String brandCode="",brandDescr="";
	DistCommon distComm = new DistCommon();
	//Changed by Samadhan on 21/12/2015 for Limited Edition and size grid End
	/**
     * Default constructor. 
     */
    public DDProductWizPosEJB() {
        // TODO Auto-generated constructor stub
    }

	@Override
	public String postSave(String xmlStringAll, String dcrId, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		String retString="";
		loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
		
		System.out.println("PostSave Action Called:::");
		System.out.println("loginSiteCode = ["+ loginSiteCode +"]");
		try 
		{
			//Changed by samadhan D15AKAT003 for magento updation. start
			CommonConstants.setIBASEHOME();	
			setDDSalesConfig();
			//Changed by samadhan D15AKAT003 for magento updation. End
			insertItemdetails(xmlStringAll, conn);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		// Changed by samadhan on 19/05/16 [start]
		finally
		{
			tradeMarkChild = "";
			tradeMarkParent = "";
			apiSimpleUrl="";
			apiConfigUrl="";
			apiDelSkusUrl="";
			deleteSkus="";
			simpleProductId = 0;
			simpleProductIdCollection.clear();
			parentMaxPrice.clear();
			objProductsChild = null;
			price = 0.0;
			attributeSetId="";
			siteCnt=0;
			maxPriceMap.clear();
			minFormDate.clear();
			maxToDate.clear();
		    storeInfo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <store_info>	";
		}
		// Changed by samadhan on 19/05/16 [end]
		return retString;
	}
	
	/**
	 * inserting records in tables
	 * @param xmlStringAll
	 * @throws ITMException
	 * @throws RemoteException
	 */
	public void insertItemdetails(String xmlStringAll, Connection conn) throws ITMException, RemoteException 
	{
		HashMap<String, String> itemAttrHashMap = new HashMap<String, String>(); //added by parikshit kumbhar on 13/05/2015.
		
		PreparedStatement pstmtIns = null;
		PreparedStatement pstmtSel = null;
		//Connection conn = null;
		boolean localConnection = false;
		boolean isError = false;
		String  custItemRefParent = "", custItemRefChild = "";
		DDProductWizEJB ddProductWizEJB = new DDProductWizEJB();
		System.out.println("@@@@@@@ inside insertItemdetails @@@@@@@");
		
		NodeList detail2dom = null;
		Document dom = null;
		int det2length = 0;
		
		System.out.println("xmlStringAll ========>>"+xmlStringAll);
		
		dom = genericUtility.parseString(xmlStringAll);
		
		detail2dom = dom.getElementsByTagName("Detail2");    
		det2length = detail2dom.getLength();
		
		System.out.println("det2length =["+det2length+"]");
		
		String objName = checkNull(getObjNameFromDom(dom, "objName","1"));
		
		System.out.println("objName =["+objName+"]");
		
		currDate = new Timestamp(System.currentTimeMillis());
		
		chg_user = checkNull(genericUtility.getColumnValue("chg_user",dom, "1"));
		chg_term = checkNull(genericUtility.getColumnValue("chg_term",dom, "1"));
		
		int currDetailListLength = 0;
		int	detailListLength = 0;
		
		Node currDetail1 = null;
		NodeList detail1List = null;
		NodeList currDetail1List = null;
		
		detail1List = dom.getElementsByTagName("Detail1");
		detailListLength = detail1List.getLength();
		
		for ( int ctr1 = 0; ctr1 < detailListLength; ctr1++ )
		{
			currDetail1 = detail1List.item(ctr1);
			currDetail1List = currDetail1.getChildNodes();
			currDetailListLength = currDetail1List.getLength();
			
			System.out.println("currDetailListLength =["+currDetailListLength+"]");
			
			for ( int i=0; i< currDetailListLength; i++ )
			{
				Node childNode = currDetail1List.item(i);
				String nodeName = childNode.getNodeName();
				
				if (nodeName.equalsIgnoreCase("item_parnt"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						item_parnt = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("item_parnt_desc"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						item_parnt_desc = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("item_type"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						item_type = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("item_type_desc"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						item_type_desc = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("item_ser"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						item_ser = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("itemser_descr"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						itemser_descr = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("descr"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						descr = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("grp_code"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						grp_code = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("grp_code_desc"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						grp_code_desc = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("site_codes"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						site_codes = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("color_codes"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						color_codes = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("dimension_desc"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						dimension_desc = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				//Added by Parikshit Kumbhar on date:24/04/2015 [Added language] Start
				else if (nodeName.equalsIgnoreCase("language"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						language  = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("language_dtl"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						language_dtl = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("tax"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						tax  = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				//Added by Parikshit Kumbhar on date:24/04/2015 [Added language] End
				else if (nodeName.equalsIgnoreCase("item_sh_descr"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						item_sh_descr = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("long_desc"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						long_desc = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("meta_title"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						meta_title = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("meta_keywords"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						meta_keywords = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("meta_desc"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						meta_desc = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("img_path"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						img_path = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("size_codes"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						size_codes = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("pur_lead_time"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						pur_lead_time = Double.parseDouble(checkNull(childNode.getFirstChild().getNodeValue()));
					}
				}
				//Added by Chetan Mahajan on date:05/02/2015 [Added loc_code , loc_type] Start
				else if (nodeName.equalsIgnoreCase("loc_code"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						loc_code = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("loc_type"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						loc_type = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				//Added by Chetan Mahajan on date:05/02/2015 [Added loc_code , loc_type] End
				 //Changed by Samadhan on 21/12/2015 for Limited Edition and size grid Start
				else if (nodeName.equalsIgnoreCase("item_usage_type"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						limitedEdition = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("item_phy_attrib_24"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						brandCode = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				else if (nodeName.equalsIgnoreCase("brand_descr"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						brandDescr = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				//Changed by Samadhan on 21/12/2015 for Limited Edition and size grid End
				
				//Changed by wasim on 27-07-2016 to add tax chapter for item parent [START]
				else if (nodeName.equalsIgnoreCase("tax_chap"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						taxChapParent = checkNull(childNode.getFirstChild().getNodeValue());
					}
				}
				//Changed by wasim on 27-07-2016 to add tax chapter for item parent [END]
				
				//Changed by Sneha on 26-09-2016, to add trade mark for item parent [Start]
				else if (nodeName.equalsIgnoreCase("trade_mark"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						tradeMarkParent = checkNull(childNode.getFirstChild().getNodeValue());
					}
					else
					{
						tradeMarkParent = "";
					}
				}
				//Changed by Sneha on 26-09-2016, to add trade mark for item parent [End]
				
				//Changed by Sneha on 24-10-2016, to add customer item references [Start]
				else if (nodeName.equalsIgnoreCase("phy_attrib_4"))
				{
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						custItemRefParent = checkNull(childNode.getFirstChild().getNodeValue());
					}
					else
					{
						custItemRefParent = "";
					}
				}
				//System.out.println("custItemRefParent=======>>"+custItemRefParent);
				//Changed by Sneha on 26-09-2019, to add trade mark for item parent [End]
				
		}
			
			
			/*System.out.println("item_parnt : "+ item_parnt +" grp_code : "+ grp_code +" item_parnt_desc : "+ item_parnt_desc + " item_type : "
					+ item_type +" descr : "+ descr +" dimension_desc : "+ dimension_desc);*/
		}
		
		 //Changed by Samadhan on 21/12/2015 for Limited Edition and size grid Start
		/*String sql = "insert into item (item_code, descr, item_ser, grp_code, item_type, unit, track_shelf_life, unit__rate,  " +
				" stk_opt, loc_type, loc_code, INTEGRAL_QTY, ISS_CRITERIA, UNIT__PUR, sh_descr, phy_attrib_17, phy_attrib_18, phy_attrib_19, " +
				" phy_attrib_20, phy_attrib_21, active, supp_sour, qc_reqd, pack_code, order_opt, item_usage, " +
				" auto_reqc, loc_type__parent, chg_date, chg_term, chg_user,pur_lead_time,udf__str1)" +
				" Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";//Added by Parikshit Kumbhar on 26/05/2015 [Added udf__str1 in query]*/
		
		//Changed by wasim on 27-07-2016 to add tax chapter [START]
		/*String sql = "insert into item (item_code, descr, item_ser, grp_code, item_type, unit, track_shelf_life, unit__rate,  " +
						" stk_opt, loc_type, loc_code, INTEGRAL_QTY, ISS_CRITERIA, UNIT__PUR, sh_descr, phy_attrib_17, phy_attrib_18, phy_attrib_19, " +
						" phy_attrib_20, phy_attrib_21, active, supp_sour, qc_reqd, pack_code, order_opt, item_usage, " +
						" auto_reqc, loc_type__parent, chg_date, chg_term, chg_user,pur_lead_time,udf__str1,usage_type,phy_attrib_24,po_rate_option)" +
						" Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";//Added by Parikshit Kumbhar on 26/05/2015 [Added udf__str1 in query]
		*/
		//Changed by Sneha on 26-09-2019, to add trade mark for item parent [Start]
		/*String sql = "insert into item (item_code, descr, item_ser, grp_code, item_type, unit, track_shelf_life, unit__rate,  " +
				" stk_opt, loc_type, loc_code, INTEGRAL_QTY, ISS_CRITERIA, UNIT__PUR, sh_descr, phy_attrib_17, phy_attrib_18, phy_attrib_19, " +
				" phy_attrib_20, phy_attrib_21, active, supp_sour, qc_reqd, pack_code, order_opt, item_usage, " +
				" auto_reqc, loc_type__parent, chg_date, chg_term, chg_user,pur_lead_time,udf__str1,usage_type,phy_attrib_24,po_rate_option,tax_chap)" +
				" Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";*/
		String sql = "insert into item (item_code, descr, item_ser, grp_code, item_type, unit, track_shelf_life, unit__rate,  " +
				" stk_opt, loc_type, loc_code, INTEGRAL_QTY, ISS_CRITERIA, UNIT__PUR, sh_descr, phy_attrib_17, phy_attrib_18, phy_attrib_19, " +
				" phy_attrib_20, phy_attrib_21, active, supp_sour, qc_reqd, pack_code, order_opt, item_usage, " +
				" auto_reqc, loc_type__parent, chg_date, chg_term, chg_user,pur_lead_time,udf__str1,usage_type," +
				" phy_attrib_24,po_rate_option,tax_chap, trade_mark, " +
				" phy_attrib_4) "+	//Changed by Sneha on 26-09-2019, to add customer item references
				" Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		//Changed by wasim on 27-07-2016 to add tax chapter [END]
		 //Changed by Samadhan on 21/12/2015 for Limited Edition and size grid End
		//Changed by Sneha on 26-09-2019, to add trade mark for item parent [End]
		
		try 
		{
			if (conn == null)
			{
				System.out.println("in conn");
				//Changed and Commented By Santosh on 14-06-2016 :[START]
				/*ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				connDriver = null;*/
				conn = getConnection();
				//Changed and Commented By Santosh on 14-06-2016 :[END]
				localConnection = true;
			}
			
			conn.setAutoCommit(false);
			
			/*tranId = getTransID( "w_dd_productWizard", conn);*/
			
			pstmtIns = conn.prepareStatement( sql );
			
			pstmtIns.setString(1, item_parnt);
			/*pstmtIns.setString(1, tranId);*/
			pstmtIns.setString(2, item_parnt_desc);
			pstmtIns.setString(3, item_ser);
			pstmtIns.setString(4, grp_code);
			pstmtIns.setString(5, item_type);
			pstmtIns.setString(6, "NO");
			pstmtIns.setString(7, "N");
			pstmtIns.setString(8, "NO");
			pstmtIns.setString(9, "1");
			pstmtIns.setString(10, loc_type);  //changed by Chetan Mahajan on date:05/02/2015 
			pstmtIns.setString(11, loc_code);  //changed by Chetan Mahajan on date:05/02/2015
			pstmtIns.setString(12, "1");
			pstmtIns.setString(13, "I"); 
			pstmtIns.setString(14, "NO");
			pstmtIns.setString(15, item_sh_descr);
			pstmtIns.setString(16, img_path);
			pstmtIns.setString(17, long_desc);
			pstmtIns.setString(18, meta_desc);
			pstmtIns.setString(19, meta_keywords); 
			pstmtIns.setString(20, meta_title);
			pstmtIns.setString(21, "Y");
			pstmtIns.setString(22, "P");
			pstmtIns.setString(23, "N"); 
			pstmtIns.setString(24, "NO");
			pstmtIns.setString(25, "C");
			pstmtIns.setString(26, "NA");
			pstmtIns.setString(27, "N");
			pstmtIns.setString(28, loc_type);  //changed by Chetan Mahajan on date:06/02/2015 
			pstmtIns.setTimestamp(29, currDate);
			pstmtIns.setString(30, chg_term); 
			pstmtIns.setString(31, chg_user);
			pstmtIns.setDouble(32, pur_lead_time);  //Added by Chetan Mahajan on date:04/02/2015 [Added for pur_lead_time]
			pstmtIns.setString(33, tax);     //Added by Parikshit Kumbhar on 26/05/2015 [Added udf__str1 in query for insert tax value ]
			pstmtIns.setString(34, limitedEdition);//Added by Samadhan on 21/12/2015 for Limited Edition .
			pstmtIns.setString(35, brandCode);//Added by Samadhan on 21/12/2015 for Brand code .
			pstmtIns.setString(36, "A");//Added by Samadhan on 23/05/2016
			pstmtIns.setString(37, taxChapParent);//Added by wasim on 27/07/2016
			pstmtIns.setString(38, tradeMarkParent);//Added by Sneha on 27-09-2016
			pstmtIns.setString(39, custItemRefParent);//Added by Sneha on 24-10-2016
			/*pstmtIns.addBatch();
			pstmtIns.clearParameters();*/
			
			pstmtIns.executeUpdate();
			pstmtIns.close(); pstmtIns = null;
			
			// Changed by Sneha on 25-10-2016, to insert values in brand master [Start]
			System.out.println("####### Inserting values into brand --------------- ");
			sql = "INSERT INTO BRAND (BRAND_CODE, DESCRIPTION, ITEM_SER, CHG_DATE, CHG_TERM, CHG_USER, ACTIVE_YN) "
				+ " VALUES(?,?,?,?,?,?,?)";
			try
			{
				pstmtIns = conn.prepareStatement(sql);
				pstmtIns.setString(1, item_parnt);
				pstmtIns.setString(2, item_parnt_desc);
				pstmtIns.setString(3, item_ser);
				pstmtIns.setTimestamp(4, currDate);
				pstmtIns.setString(5, chg_term);
				pstmtIns.setString(6, chg_user);
				pstmtIns.setString(7, "Y");
				pstmtIns.executeUpdate();
				if(pstmtIns != null)
				{
					pstmtIns.close();
					pstmtIns = null;
				}
				
			}
			catch (SQLException e) 
			{
				isError = true;
				System.out.println("SQLException ::" + e.getMessage() + ":");
				e.printStackTrace();
				throw new ITMException(e);
			}
			// Changed by Sneha on 25-10-2016, to insert values in brand master [End]
			
			// Added by Parikshit Kumbhar on date:13/05/2015 [to add insert query] start
			System.out.println("language_dtl :" + language_dtl);
			String sqllangForEN = "insert into OBJ_ATTRIBUTE (obj_name, item_attr_val, column_name, languages, attr_value, udf_str1, udf_str2, chg_date, chg_term, chg_user)"
					+ "values(?,?,?,?,?,?,?,?,?,?)";
			try
			{
				pstmtIns = conn.prepareStatement(sqllangForEN);
				pstmtIns.setString(1, "W_ITEM");
				pstmtIns.setString(2, "ITEM_CODE:" + item_parnt);
				pstmtIns.setString(3, "ITEM_CODE");
				pstmtIns.setString(4, "EN");
				pstmtIns.setString(5, descr);
				pstmtIns.setString(6, item_sh_descr);
				pstmtIns.setString(7, long_desc);
				pstmtIns.setTimestamp(8, currDate);
				pstmtIns.setString(9, chg_term);
				pstmtIns.setString(10, chg_user);
				
				pstmtIns.executeUpdate();
				pstmtIns.close(); pstmtIns = null;
			}
			catch (SQLException e) 
			{
				isError = true;
				System.out.println("SQLException ::" + e.getMessage() + ":");
				e.printStackTrace();
				throw new ITMException(e);
			}
			
				String[] languageDtl = language_dtl.split("\\|\\|");
			for (int k = 0; k < languageDtl.length; k++) 
			{
				String[] langDtl = languageDtl[k].split(":");
				//Changed by parikshit on 15/06/2015
				//if(Integer.parseInt(langDtl[5]) == 1)
				//{
				String sqllang = "insert into OBJ_ATTRIBUTE (obj_name, item_attr_val, column_name, languages, attr_value, udf_str1, udf_str2, chg_date, chg_term, chg_user)"
						+ "values(?,?,?,?,?,?,?,?,?,?)";
				
				try 
				{
					String langShDescr = "";
					String langLngDescr = "";
					for (int j = 0; j < langDtl.length; j++) 
					{
						if (j == 3)
							langShDescr = langDtl[3];
						if (j == 4)
							langLngDescr = langDtl[4];
					}
					pstmtIns = conn.prepareStatement(sqllang);
					pstmtIns.setString(1, "W_ITEM");
					pstmtIns.setString(2, "ITEM_CODE:" + item_parnt);
					pstmtIns.setString(3, "ITEM_CODE");
					pstmtIns.setString(4, langDtl[0]);
					pstmtIns.setString(5, langDtl[2]);
					pstmtIns.setString(6, checkNull(langShDescr));
					pstmtIns.setString(7, checkNull(langLngDescr));
					pstmtIns.setTimestamp(8, currDate);
					pstmtIns.setString(9, chg_term);
					pstmtIns.setString(10, chg_user);

					pstmtIns.executeUpdate();
					pstmtIns.close(); pstmtIns = null;
				}
				catch (SQLException e) 
				{
					isError = true;
					System.out.println("SQLException ::" + e.getMessage() + ":");
					e.printStackTrace();
					throw new ITMException(e);
				}
				
			//Changed by parikshit on 15/06/2015	
			//}
			
			}
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			String itmVal = "", attVal = "";
			
			try
	         {
				//changed by prasad on 29 05 2015 for retrieving language mapping start
				/*
				String sqlselt	= "SELECT (ITEM_ATTR_VAL||':'||LANGUAGES)As LANG_DET, TRIM(ATTR_VALUE) " +
						" FROM OBJ_ATTRIBUTE WHERE OBJ_NAME = 'W_ITM_ATTRIB_VAL'"+
						" AND ( ITEM_ATTR_VAL LIKE 'COLOR:%' OR ITEM_ATTR_VAL LIKE 'DIMENSION:%' OR ITEM_ATTR_VAL LIKE 'SIZE:%' ) " +
						" ORDER BY ITEM_ATTR_VAL, LANGUAGES";
				*/
				String sqlselt	= "SELECT (ITEM_ATTR_VAL||':'||LANGUAGES)As LANG_DET, ATTR_VALUE FROM OBJ_ATTRIBUTE WHERE OBJ_NAME = 'W_ITM_ATTRIB_VAL'"+
				"AND ( ITEM_ATTR_VAL LIKE 'COLOR:%' OR ITEM_ATTR_VAL LIKE 'DIMENSION:%' OR ITEM_ATTR_VAL LIKE 'SIZE:%' ) ORDER BY ITEM_ATTR_VAL, LANGUAGES";
				//changed by prasad on 29 05 2015 for retrieving language mapping end
				
				pstmt = conn.prepareStatement(sqlselt);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					itmVal = rs.getString(1);
					attVal = rs.getString(2);
					itemAttrHashMap.put(itmVal, attVal);
				}
				rs.close();rs = null;
				pstmt.close();pstmt = null;
				
	         }
			catch (Exception e)
			{
				isError = true;
				System.out.println("SQLException ::" + e.getMessage() + ":");
				e.printStackTrace();
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				catch(Exception e){}
			}
	
			System.out.println("itemAttrHashMap Size" +itemAttrHashMap.size());
			Set set = itemAttrHashMap.entrySet();
			Iterator it = set.iterator();
			
			while(it.hasNext()) {
				
				Map.Entry mp = (Map.Entry)it.next();
				String statusFeatures=(String) mp.getKey();
				String statusFeatures1=(String) mp.getValue();
				System.out.println("key = [" + statusFeatures +"] values = [" + statusFeatures1 + "]");
			}
			//Added by Parikshit Kumbhar on date:13/05/2015 [to add insert query] End
			
			Node currDetail = null;
			NodeList detail2List = null;
			NodeList currDetailList = null;
			detail2List = dom.getElementsByTagName("Detail2");
			detailListLength = detail2List.getLength();
			
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detail2List.item(ctr);
				currDetailList = currDetail.getChildNodes();
				currDetailListLength = currDetailList.getLength();
				
				System.out.println("currDetailListLength =["+currDetailListLength+"]");
				
				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					String nodeName = childNode.getNodeName();
					
					/*System.out.println("nodeName : "+ nodeName +" i : "+ i);*/
					
					if (nodeName.equalsIgnoreCase("item_descr"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_descr = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("item_length"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_length = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("item_width"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_width = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("item_height"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_height = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("price_list_dtl"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							price_list_dtl = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("item_gross_wt"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_gross_wt = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("phy_attrib_1"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							phy_attrib_1 = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("phy_attrib_2"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							phy_attrib_2 = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("phy_attrib_3"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							phy_attrib_3 = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("item_category"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_category = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("item_barcode"))
					{
						// Changed by Sneha on 06-12-2016, for Item barcode [Start]
						/*if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_barcode = checkNull(childNode.getFirstChild().getNodeValue());
						}*/
						
						
						// Changed by Sneha on 06-12-2016, for Item barcode [Start]
						
					}
					else if (nodeName.equalsIgnoreCase("supp_item_desc"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							supp_item_desc = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					//Added by Chetan Mahajan on date:05/02/2015 [Added for loc_code, loc_type] Starts
					else if (nodeName.equalsIgnoreCase("loc_code"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							loc_code = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("loc_type"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							loc_type_child = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					//Added by Chetan Mahajan on date:05/02/2015 [Added for loc_code, loc_type] End
					//Added by Parikshit Kumbhar on date:20/04/2015 [Added pack_size_dtl] start
					else if (nodeName.equalsIgnoreCase("pack_size_dtl"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							pack_size_dtl = checkNull(childNode.getFirstChild().getNodeValue());
							System.out.println("** pack_size_dtl **\n"+ pack_size_dtl);
						}
					}
					else if (nodeName.equalsIgnoreCase("language_dtl"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							language_dtl = checkNull(childNode.getFirstChild().getNodeValue());
							System.out.println("** language_dtl **\n"+ language_dtl);
						}
					}
					else if (nodeName.equalsIgnoreCase("tax"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							tax = checkNull(childNode.getFirstChild().getNodeValue());
							System.out.println("** tax **\n"+ tax);
						}
					}
					//Added by Parikshit Kumbhar on date:20/04/2015 [Added pack_size_dtl] end
					else if (nodeName.equalsIgnoreCase("category_descr"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							categoryId = checkNull(childNode.getFirstChild().getNodeValue());
							System.out.println("** category_descr **\n"+ categoryId);
						}
					}
					else if (nodeName.equalsIgnoreCase("item_commodity"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							 item_commodity = checkNull(childNode.getFirstChild().getNodeValue());
							
						}
					}
					//Changed by wasim on 27-07-2016 to add tax chapter for child items [START]
					else if (nodeName.equalsIgnoreCase("tax_chap"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							taxChapChild = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					//Changed by wasim on 27-07-2016 to add tax chapter for child items [END]
					
					//Changed by Sneha on 26-09-2016, to add trade mark for child item [Start]
					else if (nodeName.equalsIgnoreCase("trade_mark"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							tradeMarkChild = checkNull(childNode.getFirstChild().getNodeValue());
							//System.out.println("tradeMarkChild inside if =========>> ["+tradeMarkChild+"]");
						}
						else
						{
							tradeMarkChild = "";
						}
					}
					//Changed by Sneha on 26-09-2016, to add trade mark for child item [End]
					
					//Changed by Sneha on 24-10-2016 to add customer item ref [Start]
					else if (nodeName.equalsIgnoreCase("phy_attrib_4"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							custItemRefChild = checkNull(childNode.getFirstChild().getNodeValue());
							//System.out.println("custItemRefChild inside if =========>> ["+custItemRefChild+"]");
						}
						else
						{
							custItemRefChild = "";
						}
					}
					//System.out.println("custItemRefChild =========>> ["+custItemRefChild+"]");
					//Changed by Sneha on 24-10-2016 to add customer item ref [End]
					
					//Added by Parikshit Kumbhar on date:20/04/2015 [Added pack_size_dtl] end
					/*System.out.println("item_descr : "+ item_descr +" item_length : "+ item_length +" item_width : "+ item_width 
							+ " item_height : "+ item_height +" price_list_dtl : "+ price_list_dtl +" item_gross_wt : "+ item_gross_wt);*/
					
					/*pstmtIns.clearParameters();*/
					
				}
				
				// Changed by Sneha on 16-12-2016, for barcode auto generation [Start]
				String barcodeFlagVal = ddProductWizEJB.getDefaultBarcodeFlagVal();
				if(barcodeFlagVal.equalsIgnoreCase("Y"))
				{
					int paramName = 0;
					item_barcode = ddProductWizEJB.generateTranId( "w_barcode", loginSiteCode, conn);
					
					String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITEM WHERE TRIM(udf__str2) = ? ";
					PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
					pstmtParamName.setString(1, item_barcode);
					ResultSet rsCnt = pstmtParamName.executeQuery();
					if (rsCnt.next()) 
					{
						paramName = rsCnt.getInt("COUNT");
					}
					if( pstmtParamName != null )
					{
						pstmtParamName.close();
						pstmtParamName = null;
					}
					if ( rsCnt != null )
					{
						rsCnt.close();
						rsCnt = null;
					}
					
					if (paramName != 0) 
					{
						isError = true;
						String errMsg = "Invalid barcode generated. Generated Barcode already exists in item master.";
						throw new Exception(errMsg);
					}
		       
				}
				// Changed by Sneha on 16-12-2016, for barcode auto generation [End]
				
				// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [Start]
				//tranId = getTransID( "w_dd_productWiz", conn);
				sizeMap =  getSizeMap(phy_attrib_1,size_codes,conn);
				String phy_attrib_6 = sizeMap.get("DESCR");
				//System.out.println("phy_attrib_6======>>"+phy_attrib_6);
				
				tranId = getTransID( "w_dd_productWiz", item_parnt, phy_attrib_6, phy_attrib_2, conn);
				// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [End]
				
				// Changed by samadhan on 19/05/16 [start]
				String whiteSpace = "            ";
				tranId = tranId + whiteSpace.substring(0,10-tranId.length());
				System.out.println("tranId with whiteSpace is["+tranId+"]");
				// Changed by samadhan on 19/05/16 [end]
				
				//Changed by Samadhan on 21/15/2015 for size grid Start
				/*sql = "insert into item (item_code, descr, item_parnt, item_ser, grp_code, item_type, unit, track_shelf_life, unit__rate, " +
						" stk_opt, loc_type, loc_code, length, width, height, gross_weight, " +
						" phy_attrib_1, phy_attrib_2, phy_attrib_3, INTEGRAL_QTY, ISS_CRITERIA, UNIT__PUR, " +
						" phy_attrib_23, udf__str2, active, phy_attrib_22, supp_sour, qc_reqd, pack_code, " +
						" order_opt, item_usage, auto_reqc, loc_type__parent, chg_date, chg_term, chg_user,pur_lead_time,udf__str1,hsn_no)" +
						" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"; //Added by Parikshit Kumbhar on 26/05/2015 [Added udf__str1 in query]
*/				
				//Changed by wasim on 27-07-2016 to add tax chapter for child items [START]
				/*sql = "insert into item (item_code, descr, item_parnt, item_ser, grp_code, item_type, unit, track_shelf_life, unit__rate, " +
						" stk_opt, loc_type, loc_code, length, width, height, gross_weight, " +
						" phy_attrib_1, phy_attrib_2, phy_attrib_3, INTEGRAL_QTY, ISS_CRITERIA, UNIT__PUR, " +
						" phy_attrib_23, udf__str2, active, phy_attrib_22, supp_sour, qc_reqd, pack_code, " +
						" order_opt, item_usage, auto_reqc, loc_type__parent, chg_date, chg_term, chg_user,pur_lead_time,udf__str1,hsn_no,phy_attrib_6,usage_type,phy_attrib_24,phy_attrib_8,po_rate_option)" +
						" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";*/ 
				
				//Changed by Sneha on 26-09-2019, to add trade mark for child item [Start]
				/*sql = "insert into item (item_code, descr, item_parnt, item_ser, grp_code, item_type, unit, track_shelf_life, unit__rate, " +
						" stk_opt, loc_type, loc_code, length, width, height, gross_weight, " +
						" phy_attrib_1, phy_attrib_2, phy_attrib_3, INTEGRAL_QTY, ISS_CRITERIA, UNIT__PUR, " +
						" phy_attrib_23, udf__str2, active, phy_attrib_22, supp_sour, qc_reqd, pack_code, " +
						" order_opt, item_usage, auto_reqc, loc_type__parent, chg_date, chg_term, chg_user,pur_lead_time,udf__str1,hsn_no,phy_attrib_6,usage_type,phy_attrib_24,phy_attrib_8,po_rate_option,tax_chap)" +
						" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"; */
				sql = "insert into item (item_code, descr, item_parnt, item_ser, grp_code, item_type, unit, track_shelf_life, unit__rate, " +
						" stk_opt, loc_type, loc_code, length, width, height, gross_weight, " +
						" phy_attrib_1, phy_attrib_2, phy_attrib_3, INTEGRAL_QTY, ISS_CRITERIA, UNIT__PUR, " +
						" phy_attrib_23, udf__str2, active, phy_attrib_22, supp_sour, qc_reqd, pack_code, " +
						" order_opt, item_usage, auto_reqc, loc_type__parent, chg_date, chg_term," +
						" chg_user,pur_lead_time,udf__str1,hsn_no,phy_attrib_6,usage_type,phy_attrib_24," +
						" phy_attrib_8,po_rate_option,tax_chap, trade_mark," +
						" phy_attrib_4)" + //Changed by Sneha on 24-10-2016 to add customer item ref 
						" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"; 
				//Changed by wasim on 27-07-2016 to add tax chapter for child items [END]
				//Changed by Sneha on 26-09-2019, to add trade mark for child item [End]
				
				//sizeMap =  getSizeMap(phy_attrib_1,size_codes,conn);
                //Changed by Samadhan on 21/15/2015 for size grid End
				
				pstmtIns = conn.prepareStatement( sql );
				
				pstmtIns.setString(1, tranId);
				pstmtIns.setString(2, item_descr);
				pstmtIns.setString(3, item_parnt);
				pstmtIns.setString(4, item_ser);
				pstmtIns.setString(5, grp_code);
				pstmtIns.setString(6, item_type);
				pstmtIns.setString(7, "NO");
				pstmtIns.setString(8, "N");
				pstmtIns.setString(9, "NO");
				pstmtIns.setString(10, "1");
				pstmtIns.setString(11, loc_type_child);   //changed by Chetan Mahajan on date:05/02/2015
				pstmtIns.setString(12, loc_code);         //changed by Chetan Mahajan on date:05/02/2015 
				pstmtIns.setString(13, item_length);
				pstmtIns.setString(14, item_width);
				pstmtIns.setString(15, item_height);
				pstmtIns.setString(16, item_gross_wt);
				pstmtIns.setString(17, phy_attrib_1);
				pstmtIns.setString(18, phy_attrib_2);
				pstmtIns.setString(19, phy_attrib_3);
				pstmtIns.setString(20, "1");
				pstmtIns.setString(21, "I"); 
				pstmtIns.setString(22, "NO");
				pstmtIns.setString(23, item_category); 
				pstmtIns.setString(24, item_barcode);
				pstmtIns.setString(25, "Y");
				pstmtIns.setString(26, size_codes); 
				pstmtIns.setString(27, "P");
				pstmtIns.setString(28, "N"); 
				pstmtIns.setString(29, "NO");
				pstmtIns.setString(30, "C");
				pstmtIns.setString(31, "NA");
				pstmtIns.setString(32, "N");
				pstmtIns.setString(33, loc_type);        //changed by Chetan Mahajan on date:06/02/2015
				pstmtIns.setTimestamp(34, currDate);
				pstmtIns.setString(35, chg_term); 
				pstmtIns.setString(36, chg_user); 
				pstmtIns.setDouble(37, pur_lead_time);   //Added by Chetan Mahajan on date:04/02/2015 [Added for pur_lead_time]
				pstmtIns.setString(38, tax); //Added by Parikshit Kumbhar on 26/05/2015 [Added udf__str1 in query for insert tax value ]
				pstmtIns.setString(39, item_commodity);
				pstmtIns.setString(40, sizeMap.get("DESCR"));//Added By Samadhan on 21/12/2015 for Size Description
				pstmtIns.setString(41, limitedEdition);//Added By Samadhan on 21/12/2015 for Limited Edition
				pstmtIns.setString(42, brandCode);//Added By Samadhan on 21/12/2015 for brand
				pstmtIns.setString(43, sizeMap.get("SH_DESCR"));//Added By Samadhan on 21/12/2015 for Size Short Descr
				pstmtIns.setString(44, "A");//Added By Samadhan on 23/05/2016 
				pstmtIns.setString(45, taxChapChild);//Added By wasim on 27/07/2016 for adding tax chapter for child item 
				pstmtIns.setString(46, tradeMarkChild);//Changed By Sneha on 27-09-2016 for adding trade mark for child item 
				pstmtIns.setString(47, custItemRefChild);//Changed By Sneha on 24-10-2016 for adding cust item ref
				pstmtIns.executeUpdate();
				pstmtIns.close(); pstmtIns = null;
				
				// Added by Parikshit Kumbhar [for insert values in table] on 13/05/2015 start
                System.out.println("** pack_size_dtl **\n"+ pack_size_dtl);
				String pack_list[] = pack_size_dtl.split(":");
				String sqlpacksize = "insert into  item_lot_packsize (shipper_size, length, width, height, gross_weight, net_weight, Lot_no__from, Lot_no__to,unit__pack,unit__inner_label, site_code__own,item_code, chg_date, chg_term, chg_user)" + "values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
					
				pstmtIns = conn.prepareStatement(sqlpacksize);
				
				pstmtIns.setString(1, pack_list[0]);
				pstmtIns.setString(2, pack_list[1]);
				pstmtIns.setString(3, pack_list[2]);
				pstmtIns.setString(4, pack_list[3]);
				pstmtIns.setString(5, pack_list[4]);
				pstmtIns.setString(6, pack_list[5]);
				pstmtIns.setString(7, "00");
				pstmtIns.setString(8, "ZZ");
				pstmtIns.setString(9, "NO");
				pstmtIns.setString(10, "NO");
				pstmtIns.setString(11, loginSiteCode);
				pstmtIns.setString(12, tranId);
				pstmtIns.setTimestamp(13, currDate);
				pstmtIns.setString(14, chg_term);
				pstmtIns.setString(15, chg_user);
				
				pstmtIns.executeUpdate();
				pstmtIns.close(); pstmtIns = null;
				
				System.out.println("** language_dtl **\n" + language_dtl);
			
				String sqllangdtlItemInsEn = "insert into OBJ_ATTRIBUTE (obj_name, item_attr_val, column_name, languages, attr_value, Udf_Str1, Udf_Str2, chg_date, chg_user, chg_term)"
						+ " values(?,?,?,?,?,?,?,?,?,?)";

				String skuItemDescrs = "";
				String colors = checkNull(itemAttrHashMap.get("COLOR:"+ phy_attrib_2 + ":" + "EN"));
				String dimensions = checkNull(itemAttrHashMap.get("DIMENSION:"+ phy_attrib_3 + ":" + "EN"));
				String sizes = checkNull(itemAttrHashMap.get("SIZE:" + phy_attrib_1 + ":" + "EN"));

				skuItemDescrs = checkNull(descr + " " + colors.trim() + " " + dimensions.trim() + " " + sizes.trim());
				
				pstmtIns = conn.prepareStatement(sqllangdtlItemInsEn);
				pstmtIns.setString(1, "W_ITEM");
				pstmtIns.setString(2, "ITEM_CODE:" + tranId);
				pstmtIns.setString(3, "ITEM_CODE");
				pstmtIns.setString(4, "EN");
				pstmtIns.setString(5, skuItemDescrs);
				pstmtIns.setString(6, "");
				pstmtIns.setString(7, "");
				pstmtIns.setTimestamp(8, currDate);
				pstmtIns.setString(9, chg_user);
				pstmtIns.setString(10, chg_term);

				pstmtIns.executeUpdate();
				pstmtIns.close(); pstmtIns = null;
				
				String[] language_dtl_list = language_dtl.split("\\|\\|");
	
					for (int i = 0; i < language_dtl_list.length; i++) 
					{
						
						String[] lang = language_dtl_list[i].split(":");
						
						if(Integer.parseInt(lang[5]) == 1)
						{
						String skuItemDescr = "";
						String color = "";
						String dimension = "";
						String size = "";
	             		color = checkNull(itemAttrHashMap.get("COLOR:"+ phy_attrib_2 + ":" + lang[0]));
						dimension = checkNull(itemAttrHashMap.get("DIMENSION:"+ phy_attrib_3 + ":" + lang[0]));
						size = checkNull(itemAttrHashMap.get("SIZE:" + phy_attrib_1 + ":" + lang[0]));

						skuItemDescr = checkNull(lang[2]) + " " + color.trim() + " " + dimension.trim() + " " + size.trim();						
						
						String sqllangdtlItemIns = "insert into OBJ_ATTRIBUTE (obj_name, item_attr_val, column_name, languages, attr_value, Udf_Str1, Udf_Str2, chg_date, chg_user, chg_term)"
								+ " values(?,?,?,?,?,?,?,?,?,?)";
	
						pstmtIns = conn.prepareStatement(sqllangdtlItemIns);
	
						pstmtIns.setString(1, "W_ITEM");
						pstmtIns.setString(2, "ITEM_CODE:" + tranId);
						pstmtIns.setString(3, "ITEM_CODE");
						pstmtIns.setString(4, checkNull(lang[0]));
						pstmtIns.setString(5, skuItemDescr);
						pstmtIns.setString(6, "");
						pstmtIns.setString(7, "");
						pstmtIns.setTimestamp(8, currDate);
						pstmtIns.setString(9, chg_user);
						pstmtIns.setString(10, chg_term);
	
						pstmtIns.executeUpdate();
						pstmtIns.close(); pstmtIns = null;
					}
				}
				// Added by Parikshit Kumbhar [for insert values in table] on 13/05/2015 End
					
                System.out.println("** supp_item_desc **\n"+ supp_item_desc);
				String[] supp_item_list = supp_item_desc.split("\\|\\|");
				
				for (int i = 0; i < supp_item_list.length; i++)
				{
					String[] supp_item = supp_item_list[i].split(":");
					
					if (!supp_item[0].equals("0"))
					{
						System.out.println("** supp_item[1] **\n"+ supp_item[1]);
						
						String[] suppliers = supp_item[1].split(",");
						suppCode = suppliers[0];
						
						//Changed by samadhan D15AKAT003 for magento updation.						
						//price = Double.parseDouble((supp_item[3]==null||supp_item[3].equals(""))?"0":supp_item[3].trim());
						
						System.out.println("Supplier Code in for loop = "+suppCode);
						
						for (int j = 0; j < suppliers.length; j++)
						{
							String sqlSuppItemIns = "insert into supplieritem (supp_code, item_code, item_code__ref, unit, item_ser, pur_lead_time, " +
									" grp_code, chg_date, chg_user, chg_term" +
									" ,DESCR)" +//Changed by Samadhan on 23/05/2016 for insert SKU Description.
									" values(?,?,?,?,?,?,?,?,?,?,?)";
							
							pstmtIns = conn.prepareStatement(sqlSuppItemIns);
							
							pstmtIns.setString(1, checkNull(suppliers[j]));
							pstmtIns.setString(2, tranId);
							//Changed by Samadhan on 23/05/2016 for insert product id.
							//pstmtIns.setString(3, tranId);
							pstmtIns.setString(3, item_parnt);
							pstmtIns.setString(4, "NO");
							pstmtIns.setString(5, item_ser);
							pstmtIns.setDouble(6, pur_lead_time); //changed by Chetan Mahajan on date:06/02/2015
							pstmtIns.setString(7, grp_code);
							pstmtIns.setTimestamp(8, currDate);
							pstmtIns.setString(9, chg_user); 
							pstmtIns.setString(10, chg_term);
							pstmtIns.setString(11, item_descr);//Changed by Samadhan on 23/05/2016 for insert SKU Description.
							
							pstmtIns.executeUpdate();
							pstmtIns.close(); pstmtIns = null;
						}
						
						String sqlPricesIns = "insert into PRICELIST(PRICE_LIST, ITEM_CODE, UNIT, LIST_TYPE, SLAB_NO, RATE, " +
								" EFF_FROM, VALID_UPTO, LOT_NO__FROM, LOT_NO__TO, min_qty, max_qty, " +
								" rate_type, min_rate, max_rate, CHG_DATE, CHG_USER, CHG_TERM ) " +
								" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
						
						pstmtIns = conn.prepareStatement(sqlPricesIns);
						
						String dtFrom = genericUtility.getValidDateTimeString( checkNull(supp_item[4]), 
								genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
						
						String dtTo = genericUtility.getValidDateTimeString( checkNull(supp_item[5]), 
								genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
						
						pstmtIns.setString(1, supp_item[2]);
						pstmtIns.setString(2, tranId);
						pstmtIns.setString(3, "NO");
						pstmtIns.setString(4, "L");
						pstmtIns.setString(5, "1");
						pstmtIns.setString(6, supp_item[3]);
						pstmtIns.setTimestamp(7, java.sql.Timestamp.valueOf(dtFrom));
						pstmtIns.setTimestamp(8, java.sql.Timestamp.valueOf(dtTo));
						pstmtIns.setString(9, "00");
						pstmtIns.setString(10, "ZZ");
						pstmtIns.setString(11, "0");
						pstmtIns.setString(12, "999999");
						pstmtIns.setString(13, "F");
						pstmtIns.setString(14, supp_item[3]);
						pstmtIns.setString(15, supp_item[3]);
						pstmtIns.setTimestamp(16, currDate);
						pstmtIns.setString(17, chg_user); 
						pstmtIns.setString(18, chg_term); 
						
						pstmtIns.executeUpdate();
						pstmtIns.close(); pstmtIns = null;
					}
				}
				
				System.out.println("** price_list_dtl **\n" + price_list_dtl);
				String[] price_list = price_list_dtl.split("\\|\\|");
				ArrayList<String> siteList = new ArrayList<String>();
				for (int i = 0; i < price_list.length; i++) 
				{
					String[] site_list = price_list[i].split(":");
					siteList.add(site_list[1].trim());
				}
				System.out.println("******************siteList = "+ siteList);	
				String siteCode = "";
				String status = "";
				String sqlPriceSite = " SELECT SITE_CODE FROM SITE ";

				pstmtSel = conn.prepareStatement(sqlPriceSite);
				ResultSet rs1 = pstmtSel.executeQuery();
				//Changed by samadhan D15AKAT003 on 15/06/2015 for store view magento updation.
				siteCnt=0;
				storeInfo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <store_info>	";
				double adminPrice = 0.0;
				String adminSite = commonutility.getDDSalesConfig("PRODUCT_ADMIN_SITE");
				while (rs1.next()) 
				{
					siteCode = rs1.getString(1);

					String sqlSiteIns = "insert into SITEITEM (SITE_CODE, ITEM_CODE, MIN_QTY, MAX_QTY, REO_QTY, REO_LEV, "
							+ " PUR_LEAD_TIME, STK_OPT, ITEM_SER, ACTIVE, CHG_DATE, CHG_USER, CHG_TERM , loc_code__aprv, " 
							+ " SUPP_SOUR ) "	// Added by Sneha on 21-11-2016
							+ " values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

					pstmtIns = conn.prepareStatement(sqlSiteIns);

					if (siteList.contains(siteCode.trim())) 
					{
						status = "Y";
						priceListInsert(siteCode, price_list_dtl, conn);
					}
					else 
					{
						//Changed by samadhan on 27 may 2015 D15AKAT003 for magento updation. Start						
						//price = Double.parseDouble((site_list[3]==null||site_list[3].equals(""))?"0":site_list[3].trim());
						
						
						status = "N";
						
						//Changed by samadhan D15AKAT003 on 08/06/2015 for store view magento updation. start
						/*
						String operatingLang="";
						operatingLang = getOperatingLang(site_list[1],conn);
						
						for (int j = 0; j < language_dtl_list.length; j++) 
						{
							String[] lang = language_dtl_list[j].split(":");
							if(operatingLang.equalsIgnoreCase(lang[0]))
							{
								storeInfo = storeInfo +	"<store>		" ;
								storeInfo = storeInfo + "<code>"+operatingLang.toLowerCase()+"</code>		" ;
								storeInfo = storeInfo + "<product_id>"+item_parnt+"</product_id>		" ;
								storeInfo = storeInfo + "<name>"+lang[2]+"</name>		" ;
								storeInfo = storeInfo + "<short_desc>"+lang[3]+"</short_desc>		";
								storeInfo = storeInfo + "<long_desc>"+lang[4]+"</long_desc>		";
								storeInfo = storeInfo + "<price>"+price+"</price>	";
								storeInfo = storeInfo + "</store>";
								parentMaxPrice.add(price);
								break;
							}
						}
						*/
						//Changed by samadhan D15AKAT003 on 08/06/2015 for store view magento updation . end
					}
					
					//Changed by samadhan D15AKAT003 on 15/06/2015 for store view magento updation. start
					siteCnt++;
					String operatingLang="";
					boolean flag = false;
					operatingLang = getOperatingLang(siteCode.trim(),conn);
					price = 0.0;
					//Changed by Samadhan on 25/12/2015 for integrate price to/from with megento Start
					String dateFrom ="";
					String dateTo="";
					//Changed by Samadhan on 25/12/2015 for integrate price to/from with megento Start
										
					for (int i = 0; i < price_list.length; i++) 
					{
						String[] site_list = price_list[i].split(":");
						if(site_list[1].trim().equalsIgnoreCase(siteCode.trim()))
						{
							price = Double.parseDouble((site_list[3]==null||site_list[3].equals(""))?"0":site_list[3].trim());
							//Changed by Samadhan on 25/12/2015 for integrate price to/from with megento Start
							dateFrom = checkNull(site_list[5]);
							dateTo = checkNull(site_list[6]);
							System.out.println("date From:["+dateFrom+"] dateTo:["+dateTo+"]");
							//Changed by Samadhan on 25/12/2015 for integrate price to/from with megento End
						}
						
					}	
					for (int j = 0; j < language_dtl_list.length; j++) 
					{
						if(operatingLang.equalsIgnoreCase(adminSite))
						{
							adminPrice = price;
						}
						String[] lang = language_dtl_list[j].split(":");
						if(operatingLang.equalsIgnoreCase(lang[0]))
						{
							storeInfo = storeInfo +	"<store>		" ;
							storeInfo = storeInfo + "<code><![CDATA["+operatingLang.toLowerCase()+"]]></code>		" ;
							storeInfo = storeInfo + "<product_id><![CDATA["+tranId+"]]></product_id>		" ;
							storeInfo = storeInfo + "<name><![CDATA["+lang[2]+"]]></name>		" ;
							storeInfo = storeInfo + "<short_desc><![CDATA["+lang[3]+"]]></short_desc>		";
							storeInfo = storeInfo + "<long_desc><![CDATA["+lang[4]+"]]></long_desc>		";
							storeInfo = storeInfo + "<price><![CDATA["+price+"]]></price>	";
							//storeInfo = storeInfo + "<from_date><![CDATA["+dateFrom+"]]></from_date>	";
							//storeInfo = storeInfo + "<to_date><![CDATA["+dateTo+"]]></to_date>	";
							storeInfo = storeInfo + "</store>";
							//parentMaxPrice.add(price);
							flag=true;
							break;
						}
					}
					if(!flag)
					{
						storeInfo = storeInfo +	"<store>	 	" ;
						storeInfo = storeInfo + "<code><![CDATA["+operatingLang.toLowerCase()+"]]></code>		" ;
						storeInfo = storeInfo + "<product_id><![CDATA["+tranId+"]]></product_id>		" ;
						storeInfo = storeInfo + "<name><![CDATA["+descr+"]]></name>		" ;
						storeInfo = storeInfo + "<short_desc><![CDATA["+item_sh_descr+"]]></short_desc>		";
						storeInfo = storeInfo + "<long_desc><![CDATA["+long_desc+"]]></long_desc>		";
						storeInfo = storeInfo + "<price><![CDATA["+price+"]]></price>	";
						//storeInfo = storeInfo + "<from_date><![CDATA["+dateFrom+"]]></from_date>	";
						//storeInfo = storeInfo + "<to_date><![CDATA["+dateTo+"]]></to_date>	";
						storeInfo = storeInfo + "</store>";
						//parentMaxPrice.add(price);
					}
					if(maxPriceMap.containsKey(operatingLang.toLowerCase()))
					{
						if((Double)maxPriceMap.get(operatingLang.toLowerCase())<price)
						{
							maxPriceMap.put(operatingLang.toLowerCase(), price);
						}
					}
					else
					{
						maxPriceMap.put(operatingLang.toLowerCase(), price);
					}
					//Changed by samadhan D15AKAT003 on 15/06/2015 for store view magento updation . end
					//Changed by samadhan 25/12/2015 for price list to/from date integration with megento start
					System.out.println("minFormDate:"+minFormDate);
					if(!(dateFrom.length()==0))
					{
						if(minFormDate.containsKey(operatingLang.toLowerCase()))
						{
							if(genericUtility.getDateObject(minFormDate.get(operatingLang.toLowerCase())).compareTo(genericUtility.getDateObject(dateFrom)) > 0)
							{
								minFormDate.put(operatingLang.toLowerCase(), dateFrom);
							}
						}
						else
						{
							minFormDate.put(operatingLang.toLowerCase(), dateFrom);
						}
					}
					System.out.println("maxToDate:"+maxToDate);
					if(!(dateTo.length()==0))
					{
						if(maxToDate.containsKey(operatingLang.toLowerCase()))
						{
							if(genericUtility.getDateObject(maxToDate.get(operatingLang.toLowerCase())).compareTo(genericUtility.getDateObject(dateTo)) < 0)
							{
								maxToDate.put(operatingLang.toLowerCase(), dateTo);
							}
						}
						else
						{
							maxToDate.put(operatingLang.toLowerCase(), dateTo);
						}
					}
					//Changed by samadhan 25/12/2015 for price list to/from date integrate with megento start
					System.out.println(status +" ~~~~!!!!!!!!!! ~~~~ " + siteCode.trim());

					pstmtIns.setString(1, checkNull(siteCode));
					pstmtIns.setString(2, tranId);
					pstmtIns.setString(3, "0");
					pstmtIns.setString(4, "99999");
					pstmtIns.setString(5, "0");
					pstmtIns.setString(6, "0");
					pstmtIns.setDouble(7, pur_lead_time); // changed by Chetan Mahajan on date:06/02/2015
					pstmtIns.setString(8, "1");
					pstmtIns.setString(9, item_ser);
					pstmtIns.setString(10, status);
					pstmtIns.setTimestamp(11, currDate);
					pstmtIns.setString(12, chg_user);
					pstmtIns.setString(13, chg_term);
					pstmtIns.setString(14, loc_code); // Change by Parikshit Kumbhar on date 18/05/2015
					pstmtIns.setString(15, "P"); // Change by Sneha on date 21-11-2013

					pstmtIns.executeUpdate();
					pstmtIns.close();
					pstmtIns = null;
			}
			pstmtSel.close();
			pstmtSel = null;
			rs1.close();
			rs1 = null;
				/*pstmtIns.addBatch();
				pstmtIns.clearParameters();*/
				
				//Changed by samadhan D15AKAT003 on 08/06/2015 for store view magento updation.
				storeInfo = storeInfo + "</store_info> ";
				
				//Changed by samadhan D15AKAT003 on 18/05/2015 for magento updation. start
				String colorId="";
				objProductsChild = new Product();
				
				//Changed by wasim on 14-08-2015 to get th apiKey from DDSalesConfig.xml [START]
				String apiKey = commonutility.getDDSalesConfig("API_KEY");
				objProductsChild.setApiKey(apiKey);
				//Changed by wasim on 14-08-2015 to get th apiKey from DDSalesConfig.xml [END]
				
				//Changed by samadhan D15AKAT003 on 08/06/2015 for store view magento updation. start
				//parentMaxPrice.add(price);
				//objProductsChild.setCost(price);//-------------------------
				objProductsChild.setCost(0);
				//Changed by samadhan D15AKAT003 on 08/06/2015 for store view magento updation. end
				objProductsChild.setStoreId(0);
				
				colorId = checkNull(getItemAttribVal("UDF__STR1","COLOR",phy_attrib_2, conn));	
				
				System.out.println("colorId------>>["+colorId+"]");
				colorId = colorId.length() == 0 ? "0" : colorId;
				objProductsChild.setColorId(Integer.parseInt(colorId));	
				//Changed on 27 may 2015 start
				//objProductsChild.setTaxClass(2);
				System.out.println("Tax Class:"+tax);
				objProductsChild.setTaxClass(Integer.parseInt((tax.equals("")||tax==null)?"2":tax.trim()));
				//changed on 27 may 2015 end
				//Changed by Samadhan on 21/12/2015 for size short description integration
				//String sizeStrGen = checkNull(getItemAttribVal("UDF__STR1",size_codes,phy_attrib_1, conn));
				String sizeStrGen = checkNull(sizeMap.get("MEGETO_ID"));
				sizeStrGen = sizeStrGen.length() == 0 ? "0" : sizeStrGen;			 
				objProductsChild.setProductSizeId(Integer.parseInt(sizeStrGen)); 
				
				//Changed by Samadhan on 21/12/2015 for size short description and limited edition integration Start
				String sizeShortDescr = sizeMap.get("SH_DESCR");
				String sizeDescr = sizeMap.get("DESCR");
				String megetoBrandId = checkNull(getItemAttribVal("UDF__STR1","BRAND",brandCode, conn));
				String megetoBrandCatId = checkNull(getItemAttribVal("UDF__STR1","CATEGORY",brandCode, conn));
				
				System.out.println("MegentoSizeId:"+sizeStrGen);
				System.out.println("SizeDescr:"+sizeDescr);
				System.out.println("SizeShortDescr:"+sizeShortDescr);
				System.out.println("LimitedEdition:"+limitedEdition);
				System.out.println("MegentoBrandId:"+megetoBrandId);
				System.out.println("MegentoBrandCatId:"+megetoBrandCatId);
				//Changed by Samadhan on 21/12/2015 for size short description integration End
								
				String dimension1 = checkNull(getItemAttribVal("UDF__STR1","DIMENSION",phy_attrib_3, conn));
				
				dimension1 = dimension1.length() == 0 ? "0" : dimension1;
				int dimension = Integer.parseInt(dimension1);
				System.out.println("dimension@@------------>>["+dimension+"]");		
				objProductsChild.setProductDimensionId(dimension); //MEDIUM		
				
				objProductsChild.setImagePath(URLEncoder.encode(checkNull(img_path),"UTF-8"));//phy_attrib_17	
												
				objProductsChild.setLongDescription(URLEncoder.encode(checkNull(long_desc),"UTF-8"));
				
				String [] id = categoryId.split(",");
			 	String categoty ="";
				for(String str : id)
				{		
					String categoryId="";				
					categoryId = checkNull(getItemAttribVal("UDF__STR1","CATEGORY",checkNull(str), conn));
					categoty = categoty + categoryId+",";
				}
				categoty = categoty.substring(0 ,categoty.length() -1);
				System.out.println("categoty------>>["+categoty+"]");
				
				//Changed by Samadhan on 21/12/2015 for size short description and limited edition integration Start
				if(megetoBrandCatId.length()>0)
				{
					if((","+categoty+",").indexOf(","+megetoBrandCatId+",")==-1)
					{
						categoty = categoty+","+megetoBrandCatId;
					}
				}
				if(limitedEdition.equals("Y"))
				{
					String attribLtdEdiId = checkNull(distComm.getDisparams("999999", "LTDEDI_ATTRIB_ID", conn));
					String limitedEdiMegentoId = checkNull(getItemAttribVal("UDF__STR1","CATEGORY",attribLtdEdiId, conn));
					if((","+categoty+",").indexOf(","+limitedEdiMegentoId+",")==-1)
					{
						categoty = categoty+","+limitedEdiMegentoId;
					}
				}
				System.out.println("categoty after brand and limited edi------>>["+categoty+"]");
				//Changed by Samadhan on 21/12/2015 for size short description and limited edition integration End
				
				objProductsChild.setCategories(categoty);	
				
				//Changed by Samadhan on 21/12/2015 for brand integration Start
				/*String manufacturerId="";
				manufacturerId = getColumnDescr(conn,"udf_1","supplier","supp_code",suppCode);		        
				manufacturerId = manufacturerId.length() == 0 ? "0" :manufacturerId;
				objProductsChild.setManufacturerId(Integer.parseInt(manufacturerId));//supplier code
		
				sql = "SELECT SP.COUNT_CODE FROM ITEM I,SUPPLIERITEM S,SUPPLIER SP "
					+"WHERE I.ITEM_CODE = ? "
					+"AND I.ITEM_CODE = S.ITEM_CODE " 
					+"AND SP.SUPP_CODE = S.SUPP_CODE ";
				
				PreparedStatement pstmtsel=null;
				
				
				pstmtsel = conn.prepareStatement(sql);
				pstmtsel.setString(1, tranId);
				rs = pstmtsel.executeQuery();
				String countCodeMfg="";
				if(rs.next())
				{
					countCodeMfg = checkNull(rs.getString("COUNT_CODE"));	
				}
				if (rs != null)
				{
				rs.close();
				rs = null;
				}
				if (pstmtsel != null)
				{
				pstmtsel.close();
				pstmtsel = null;
				}
				System.out.println("countCodeMfg------->>["+countCodeMfg+"]");
				objProductsChild.setManufacturerCountryCode(countCodeMfg); //count_code__mfg
				 */
				megetoBrandId = megetoBrandId.length() == 0 ? "0" :megetoBrandId;
				objProductsChild.setManufacturerId(Integer.parseInt(megetoBrandId));
				//Changed by Samadhan on 21/12/2015 for brand integration End
				
				objProductsChild.setMetaDescription(URLEncoder.encode(checkNull(meta_desc),"UTF-8")); //.phy_attrib_19
				objProductsChild.setMetaKeywords(URLEncoder.encode(checkNull(meta_keywords),"UTF-8"));//phy_attrib_20
				objProductsChild.setMetaTitle(URLEncoder.encode(checkNull(meta_title),"UTF-8"));//phy_attrib_21
				//Changed by samadhan D15AKAT003 on 08/06/2015 for store view magento updation. start
				//objProductsChild.setPrice(price);	
				objProductsChild.setPrice(adminPrice);	
				//System.out.println("Price------------>>["+price+"]");
				//Changed by samadhan D15AKAT003 on 08/06/2015 for store view magento updation. end
				objProductsChild.setProductName(URLEncoder.encode(checkNull(item_descr),"UTF-8"));
				objProductsChild.setProductStatus(1);
				item_gross_wt=(item_gross_wt==null||item_gross_wt.equals(""))?"0":item_gross_wt.trim();
				
				objProductsChild.setProductWeight(Double.parseDouble(item_gross_wt));
				objProductsChild.setQty(0);
				objProductsChild.setShortDescription(URLEncoder.encode(checkNull(item_sh_descr),"UTF-8"));
				objProductsChild.setSku(tranId);	
				
				//delete skus
				deleteSkus = deleteSkus + tranId +",";
				
				attributeSetId = getColumnDescr(conn,"udf_str1","item_type","item_type",item_type);		
				objProductsChild.setAttributeSetId(Integer.parseInt((attributeSetId.equals("")||attributeSetId==null)?"0":attributeSetId.trim()));
				
				//Changed by samadhan D15AKAT003 on 15/06/2015 for store view magento updation. start
				//objProductsChild.setStoreInf(storeInfo);
				/*ArrayList<String> prIds = new ArrayList<String>();
				for(int k=0;k<siteCnt;k++)
				{
				prIds.add(tranId);
				}*/
				
				System.out.println("Store Info Child >>>>>>>>>:["+storeInfo+"]");
				
				//objProductsChild.setStoreInf(URLEncoder.encode(String.format(storeInfo,prIds.toArray(new String[prIds.size()])),"UTF-8"));
				objProductsChild.setStoreInf(URLEncoder.encode(checkNull(storeInfo),"UTF-8"));
				objProductsChild.setBarcode(URLEncoder.encode(checkNull(item_barcode),"UTF-8"));
				//Changed by samadhan D15AKAT003 on 15/06/2015 for store view magento updation. end
				int simpleId =  commonutility.Call(objProductsChild,this.apiSimpleUrl, null);
				System.out.println("simpleId child---->>["+simpleId+"]");					
				if(simpleId != 0)
				{
					simpleProductIdCollection.add(simpleId);
					updateItemUdfNum(tranId,simpleId,conn);
				}
								
				//Changed by samadhan D15AKAT003 on 18/05/2015 for magento updation. End
			}
			
			//Changed by samadhan D15AKAT003 on 18/05/2015 for magento updation. Start
			System.out.println("simpleProductId Parent@------>>["+simpleProductId+"]");
			System.out.println("simpleProductIdCollection Parent------>>["+simpleProductIdCollection+"]");
			if(simpleProductIdCollection !=null && ! simpleProductIdCollection.isEmpty())
			{
				System.out.println("itemCodec Parent@------>>["+item_parnt+"] itemCodeDescrP--->>"+item_parnt_desc);
				
				String sqlPriceSite = " SELECT SITE_CODE FROM SITE ";
				pstmtSel = conn.prepareStatement(sqlPriceSite);
				ResultSet rs1 = pstmtSel.executeQuery();
				siteCnt=0;
				storeInfo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <store_info>	";
				double adminPrice = 0.0;
				String adminSite = commonutility.getDDSalesConfig("PRODUCT_ADMIN_SITE");
				String[] language_dtl_list = language_dtl.split("\\|\\|");
				//Changed by samadhan on 25/12/2015 for price list to/from date
				String dateFrom="",dateTo="";
				while (rs1.next()) 
				{
					String	siteCode = rs1.getString(1);
					String operatingLang="";
					boolean flag = false;
					operatingLang = getOperatingLang(siteCode.trim(),conn);
					siteCnt++;
					
					price = (Double)maxPriceMap.get(operatingLang.toLowerCase());
					price = 0.0;
					System.out.println("Max Price of "+operatingLang+" is: "+price);
					//Changed by samadhan on 25/12/2015 for price list to/from date start
					dateFrom = checkNull(minFormDate.get(operatingLang.toLowerCase()));
					System.out.println("Min from date of "+operatingLang+" is: "+dateFrom);
					
					dateTo = checkNull(maxToDate.get(operatingLang.toLowerCase()));
					System.out.println("Max To date of "+operatingLang+" is: "+dateTo);
					//Changed by samadhan on 25/12/2015 for price list to/from date end
					for (int j = 0; j < language_dtl_list.length; j++) 
					{
						String[] lang = language_dtl_list[j].split(":");
						if(operatingLang.equalsIgnoreCase(adminSite))
						{
							adminPrice = price;
						}
						if(operatingLang.equalsIgnoreCase(lang[0]))
						{
							storeInfo = storeInfo +	"<store>		" ;
							storeInfo = storeInfo + "<code><![CDATA["+operatingLang.toLowerCase()+"]]></code>		" ;
							storeInfo = storeInfo + "<product_id><![CDATA["+item_parnt+"]]></product_id>		" ;
							storeInfo = storeInfo + "<name><![CDATA["+lang[2]+"]]></name>		" ;
							storeInfo = storeInfo + "<short_desc><![CDATA["+lang[3]+"]]></short_desc>		";
							storeInfo = storeInfo + "<long_desc><![CDATA["+lang[4]+"]]></long_desc>		";
							storeInfo = storeInfo + "<price><![CDATA["+price+"]]></price>	";
							//storeInfo = storeInfo + "<from_date><![CDATA["+dateFrom+"]]></from_date>	";
							//storeInfo = storeInfo + "<to_date><![CDATA["+dateTo+"]]></to_date>	";
							storeInfo = storeInfo + "</store>";
							flag=true;
							break;
						}
					}
					if(!flag)
					{
						storeInfo = storeInfo +	"<store>	 	" ;
						storeInfo = storeInfo + "<code><![CDATA["+operatingLang.toLowerCase()+"]]></code>		" ;
						storeInfo = storeInfo + "<product_id><![CDATA["+item_parnt+"]]></product_id>		" ;
						storeInfo = storeInfo + "<name><![CDATA["+descr+"]]></name>		" ;
						storeInfo = storeInfo + "<short_desc><![CDATA["+item_sh_descr+"]]></short_desc>		";
						storeInfo = storeInfo + "<long_desc><![CDATA["+long_desc+"]]></long_desc>		";
						storeInfo = storeInfo + "<price><![CDATA["+price+"]]></price>	";
						//storeInfo = storeInfo + "<from_date><![CDATA["+dateFrom+"]]></from_date>	";
						//storeInfo = storeInfo + "<to_date><![CDATA["+dateTo+"]]></to_date>	";
						storeInfo = storeInfo + "</store>";
					}
						
				}
				storeInfo = storeInfo + "</store_info> ";
				pstmtSel.close();
				rs1.close();
				//Changed by samadhan D15AKAT003 on 16/06/2015 for store view magento updation. 
				//objProductsChild.setProductName(item_parnt_desc);					
				
				objProductsChild.setSku(item_parnt);
				objProductsChild.setProductName(URLEncoder.encode(checkNull(item_parnt_desc),"UTF-8"));
				objProductsChild.setPrice(adminPrice);
				//Changed by samadhan D15AKAT003 on 15/06/2015 for store view magento updation. start
				//objProductsChild.setStoreInf(storeInfo);
				/*ArrayList<String> prIds = new ArrayList<String>();
				for(int k=0;k<siteCnt;k++)
				{
				prIds.add(item_parnt);
				}*/
				System.out.println("Store Info Parent >>>>>>>>>:["+storeInfo+"]");
				//objProductsChild.setStoreInf(URLEncoder.encode(String.format(storeInfo,prIds.toArray(new String[prIds.size()])),"UTF-8"));
				objProductsChild.setStoreInf(URLEncoder.encode(checkNull(storeInfo),"UTF-8"));
				//Changed by samadhan D15AKAT003 on 15/06/2015 for store view magento updation. end
				
				//delete skus
				deleteSkus = deleteSkus + item_parnt +",";
				
				//double objMaxPrice = Collections.max(parentMaxPrice);
				
				//Changed by samadhan D15AKAT003 on 16/06/2015 for store view magento updation. 
				//objProductsChild.setPrice(objMaxPrice);
				
				simpleProductId = commonutility.Call(objProductsChild,this.apiConfigUrl, simpleProductIdCollection);
				updateItemUdfNum(item_parnt,simpleProductId,conn);
			}
			//Changed by samadhan D15AKAT003 on 18/05/2015 for magento updation. End
			
			//Added by Chetan Mahajan on date:05/02/2015 [For inserting parent code in supplieritem table ] Start
			if(!suppCode.equals(""))
			{
				System.out.println("Supplier Code = "+suppCode);
				String sqlSuppItemIns = "insert into supplieritem (supp_code, item_code, item_code__ref, unit, item_ser, pur_lead_time, " +
						" grp_code, chg_date, chg_user, chg_term" +
						" ,DESCR)" +//Changed by Samadhan on 23/05/2016 for insert SKU Description.
						" values(?,?,?,?,?,?,?,?,?,?,?)";
				pstmtIns = conn.prepareStatement(sqlSuppItemIns);
				
				pstmtIns.setString(1, checkNull(suppCode));
				pstmtIns.setString(2, item_parnt);
				pstmtIns.setString(3, item_parnt);
				pstmtIns.setString(4, "NO");
				pstmtIns.setString(5, item_ser);
				pstmtIns.setDouble(6, pur_lead_time);
				pstmtIns.setString(7, grp_code);
				pstmtIns.setTimestamp(8, currDate);
				pstmtIns.setString(9, chg_user); 
				pstmtIns.setString(10, chg_term);
				pstmtIns.setString(11, item_parnt_desc);//Changed by Samadhan on 23/05/2016 for insert SKU Description.
				
				pstmtIns.executeUpdate();
				pstmtIns.close(); pstmtIns = null;
			}	
			//Added by Chetan Mahajan on date:05/02/2015 [For inserting parent code in supplieritem table ] End
		}
		catch (SQLException e)
		{
			isError = true;
			
			//delete skus start
			try
			{
				if(deleteSkus.length()>0)
				{
					deleteSkus = deleteSkus.substring(0, deleteSkus.length()-1);
					commonutility.CallDelete(deleteSkus, apiDelSkusUrl);
				}
			}catch (Exception e1) 
			{
				
			}
			//detete skus end
			
			System.out.println("SQLException ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
			
		} catch (Exception e) 
		{
			isError = true;
			
			//delete skus start
			try
			{
				if(deleteSkus.length()>0)
				{
					deleteSkus = deleteSkus.substring(0, deleteSkus.length()-1);
					commonutility.CallDelete(deleteSkus, apiDelSkusUrl);
				}
			}catch (Exception e1) 
			{
				
			}
			//detete skus end
			
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (pstmtIns != null)
				{
					pstmtIns.close();
					pstmtIns = null;
				}
				if (localConnection && conn != null && !conn.isClosed())
				{
					if ( !isError )
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e){}
		}
	}
	
	

	/**
	 * 
	 * @param siteCode
	 * @param price_list_dtl
	 * @param conn
	 * @throws Exception 
	 */
	private void priceListInsert(String siteCode, String price_list_dtl, Connection conn) throws Exception 
	{
		PreparedStatement pstmtIns = null;
		try 
		{
			System.out.println("in priceListInsert...");
			String[] price_list = price_list_dtl.split("\\|\\|");
			
			for (int i = 0; i < price_list.length; i++) 
			{
				String[] site_list = price_list[i].split(":");
				
				System.out.println(siteCode + " : " + site_list[1] + " priceListInsert...");
				if (site_list[1].trim().equals(siteCode.trim())) 
				{
					System.out.println("in if priceListInsert...");
					String sqlPricesIns = "insert into PRICELIST(PRICE_LIST, ITEM_CODE, UNIT, LIST_TYPE, SLAB_NO, RATE, "
							+ " EFF_FROM, VALID_UPTO, LOT_NO__FROM, LOT_NO__TO, min_qty, max_qty, "
							+ " rate_type, min_rate, max_rate, CHG_DATE, CHG_USER, CHG_TERM ) "
							+ " values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

					pstmtIns = conn.prepareStatement(sqlPricesIns);

					String dtFrom = genericUtility.getValidDateTimeString(
							checkNull(site_list[5]), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());

					String dtTo = genericUtility.getValidDateTimeString(
							checkNull(site_list[6]), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());

					pstmtIns.setString(1, checkNull(site_list[2]));
					pstmtIns.setString(2, tranId);
					pstmtIns.setString(3, "NO");
					pstmtIns.setString(4, "L");
					pstmtIns.setString(5, "1");
					pstmtIns.setString(6, checkNull(site_list[3]));
					pstmtIns.setTimestamp(7, java.sql.Timestamp.valueOf(dtFrom));
					pstmtIns.setTimestamp(8, java.sql.Timestamp.valueOf(dtTo));
					pstmtIns.setString(9, "00");
					pstmtIns.setString(10, "ZZ");
					pstmtIns.setString(11, "0");
					pstmtIns.setString(12, "999999");
					pstmtIns.setString(13, "F");
					pstmtIns.setString(14, checkNull(site_list[3]));
					pstmtIns.setString(15, checkNull(site_list[3]));
					pstmtIns.setTimestamp(16, currDate);
					pstmtIns.setString(17, chg_user);
					pstmtIns.setString(18, chg_term);

					pstmtIns.executeUpdate();
					pstmtIns.close();
					pstmtIns = null;
				}
			}
		}
		catch (ITMException e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		catch (SQLException e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			try
			{
				if (pstmtIns != null)
				{
					pstmtIns.close();
					pstmtIns = null;
				}
			}
			catch(Exception e){}
		}
	}
	
	/**
	 * get transaction id (parnt_code)
	 * @param conn
	 * @throws ITMException 
	 */
	// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [Start]
	//private String getTransID( String windowName, Connection conn ) throws ITMException
	private String getTransID( String windowName, String item_parnt, String phy_attrib_6, String phy_attrib_2, Connection conn ) throws ITMException
	// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [End]
	{
		//System.out.println("@@@@@@ Inside getTransID @@@@@@");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";

		 try
         {
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
					keyString = rs.getString("KEY_STRING");
					keyCol = rs.getString("TRAN_ID_COL");
					tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);
			
			// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [Start]
			String itemParntStr = "";
			if(item_parnt.length() < 5)
			{
				itemParntStr = "00000".substring(item_parnt.length()) + item_parnt;	
			}
			else
			{
				itemParntStr = item_parnt;
			}
			//System.out.println("itemParntStr========>>"+itemParntStr);
			// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [End]

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +        "<tran_id></tran_id>";
			
			// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [Start]
			xmlValues = xmlValues +		"<item_parnt>" + itemParntStr + "</item_parnt>";
			xmlValues = xmlValues +		"<phy_attrib_2>" + phy_attrib_2 + "</phy_attrib_2>";	// color
			xmlValues = xmlValues +		"<phy_attrib_6>" + phy_attrib_6 + "</phy_attrib_6>"; 	// size
			// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [End]
			
			xmlValues = xmlValues + "</Detail1></Root>";
			
			System.out.println("xmlValues  :["+xmlValues+"]");
			
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId =======>> " + tranId);
         }
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e){}
		}
        return tranId;
	}
	
	/**
	 * 
	 * @param dom
	 * @param attribute
	 * @param objContext
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null;
		String objName = "";
		int detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		System.out.println("objName =["+objName+"]");
		
		return objName;
	}
	
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	
	@Override
	public String updateStatus(Document dom, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		// TODO Auto-generated method stub
		return null;
	}
	
	//Changed by samadhan D15AKAT003 on 18/05/2015 for magento updation. Start
	private double getPriceListRate(String suppCode,String itemCode,Connection conn) throws Exception
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql = "",supplierPriceList = "",pricelist = "";
		double rate = 0;
		String loginSite="";
		loginSite = loginSite == null ? "" : loginSite.trim();
		boolean isError = false;
		suppCode = suppCode == null ? "" : suppCode.trim();
		System.out.println("getPriceListRate loginSite------>["+loginSite+"]");
		try
		{	
			supplierPriceList=checkNull(getColumnDescr(conn, "price_list", "supplier", "supp_code", suppCode));
			System.out.println("getPriceListRate supplierPriceList------>["+supplierPriceList+"]");
			
			sql ="SELECT DESCR FROM GENCODES WHERE MOD_NAME = ? AND FLD_NAME = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "W_DD_PRODUCTWIZ");
			pstmt.setString(2, "SITE_PRICE");
			//pstmt.setString(3, loginSite);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{				
				pricelist = checkNull(rs.getString(1));
				System.out.println("pricelist while------>>["+pricelist+"]");				
				if(!(supplierPriceList.equalsIgnoreCase(pricelist)) )
				{
					break;
				}
			}
			rs.close();
			rs= null;
			pstmt.close();
			pstmt = null;
			System.out.println("getPriceListRate pricelist------>["+pricelist+"]");
			
			
			sql = "SELECT RATE FROM PRICELIST WHERE PRICE_LIST = ? AND ITEM_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, pricelist);
			pstmt.setString(2, itemCode);
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				rate = rs.getDouble(1);
			}
			rs.close();
			rs= null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			isError = true;
			throw new Exception(e);
		}
		System.out.println("getPriceListRate rate------>["+rate+"]");
		return rate;
	}
	
	public String getColumnDescr(Connection conn, String columnName ,String tableName, String columnName2, String value)throws Exception 
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";

		sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1,value);
		rs = pstmt.executeQuery();
		if(rs.next())
		{					
			findValue = rs.getString(1);					
		}
		rs.close();
		rs = null;
		pstmt.close();
		pstmt = null;        


		System.out.println("returning String from getColumnDescr " + findValue);
		return checkNull(findValue);
	}
	
	private String getGencodesValue(String selectColumn,String descr,String fldName,Connection conn) throws Exception
	{	
		//("UDF_STR1",sizeStr,"", conn));
		boolean isError = false;
		ResultSet rs = null;
		PreparedStatement pstmt =null;
		String sql = "",udfStr1 = "";

		try
		{
			fldName = fldName == null ? "" :fldName.trim();
			if(fldName.length() > 0)
			{
				sql ="select "+selectColumn+" from gencodes where mod_name = ? and fld_name = ? and descr = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "W_DD_PRODUCTWIZ");
				pstmt.setString(2, fldName);
				pstmt.setString(3, descr);
			}
			else
			{
				sql ="select "+selectColumn+" from gencodes where mod_name = ? and  descr = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "W_DD_PRODUCTWIZ");				
				pstmt.setString(2, descr);
			}
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				udfStr1 = rs.getString(1);			
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			isError = true;
			throw new Exception(e);
		}
		return udfStr1;

	}
	//Changed by wasim 16-07-2015 to make function as public for Edit pos save 
	public String getItemAttribVal(String selectColumn,String attibCode,String attribId,Connection conn) throws Exception
	{	
		//("UDF_STR1",sizeStr,"", conn));
		boolean isError = false;
		ResultSet rs = null;
		PreparedStatement pstmt =null;
		String sql = "",udfStr1 = "";

		try
		{
			
			sql ="select "+selectColumn+" from itm_attrib_val where attrib_code = ? and attrib_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, attibCode);
			pstmt.setString(2, attribId);
			
		
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				udfStr1 = rs.getString(1);			
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			isError = true;
			throw new Exception(e);
		}
		return udfStr1;

	}
	//Changed by wasim 16-07-2015 to make function as public for Edit pos save 
	public void updateItemUdfNum(String itemCode,int simpleProductId,Connection conn) throws Exception
	{
		String sql = "";
		int count = 0;
		PreparedStatement pstmt = null;
		try
		{
			sql = "update item set udf_num = ? where item_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setInt(1, simpleProductId);
			pstmt.setString(2, itemCode);
			count = pstmt.executeUpdate();
			
			// Changed by Sneha on 02-09-2016, for Closing the Open Cursor [Start]
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			// Changed by Sneha on 02-09-2016, for Closing the Open Cursor [End]
		}
		catch(Exception e)
		{
			//isError = true;
			throw new Exception(e);
		}

	}
	
	private void setDDSalesConfig()
	{
		CommonConstants objCommon =new CommonConstants();
		E12GenericUtility genericUtility=new E12GenericUtility();
		String fileName = null,xmlString = "",xmlFileName = "";
		Document dom=null;
		String sCurrentLine = "";
		String xmlFile="DDSalesConfig";
		System.out.println("  in setDDSalesConfig -------------------------");
		System.out.println("CommonConstants.APPLICATION_CONTEXT-->>["+CommonConstants.APPLICATION_CONTEXT+"]");   
		System.out.println("CommonConstants.JBOSSHOME-->>["+CommonConstants.JBOSSHOME+"]");   
		if(CommonConstants.APPLICATION_CONTEXT != null)
		{
			xmlFileName = CommonConstants.APPLICATION_CONTEXT + "setting" + File.separator + "DDSalesConfig.xml";
		}
		else
		{
			xmlFileName = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator +"setting" + File.separator +"DDSalesConfig.xml";
		}
		
		//fileName = ".." + File.separator + "setting" + File.separator + xmlFile + ".xml";
		StringBuilder sb = new StringBuilder();
		System.out.println("xmlFileName-->>["+xmlFileName+"]");          
		try 
		{ 
			BufferedReader br = new BufferedReader(new FileReader(xmlFileName));
			while (( sCurrentLine = br.readLine()) != null)
			{
				sb.append(sCurrentLine);
			}
			xmlString =sb.toString();
			System.out.println("DDSalesConfig xmlString---->>["+xmlString+"]");            	 
			dom = genericUtility.parseString(xmlString);                 
			if(dom != null)
			{                	
				this.apiSimpleUrl = genericUtility.getColumnValue("PROD_SIMPLE_API_URL",dom);               	 
				this.apiConfigUrl = genericUtility.getColumnValue("PROD_CONFIG_API_URL",dom);		
				//detete skus
				this.apiDelSkusUrl = genericUtility.getColumnValue("PROD_DELETE_API_URL",dom);
			}                 
		}
		catch(Exception e)
		{
			e.printStackTrace();
		} 
	}
		//Changed by samadhan D15AKAT003 on 18/05/2015 for magento updation. End
		
	//Changed by samadhan on 08/06/2015 for store view magento updation.start
	//Changed by wasim 16-07-2015 to make function as public for Edit pos save 
	public String getOperatingLang(String siteCode , Connection conn) throws Exception 
	{
		String sql="";
		PreparedStatement pstmt = null;
		ResultSet rs= null;
		
		String langCode = "";
		try
		{
			sql = "select operating_language from site where site_code = ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,siteCode);
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				langCode = rs.getString("operating_language");
				//Added by sarita 09-03-2017
				langCode = langCode==null?"":langCode;
			
			}
			pstmt.close();
			rs.close();			
		}
		catch(Exception e)
		{
			throw new Exception(e);
		}
		System.out.println("Language Code = "+langCode);
		return langCode;
	}
	//Changed by samadhan on 08/06/2015 for store view magento updation.end
	//Changed by Samadhan on 21/12/2015 for size Grid Start.
	public HashMap<String, String> getSizeMap(String sizeCode,String sizeGroup,Connection conn) throws Exception 
	{
	HashMap<String, String> sizeMap = new HashMap<String, String>();
	String sql="";
	PreparedStatement pstmt = null;
	ResultSet rs= null;
	
		try
	{
		sql = "SELECT Attrib_Id, trim(Descr),trim(sh_descr),udf__str1 FROM itm_attrib_val " +
				"WHERE Attrib_Code = ? and attrib_id = ?";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1,sizeGroup);
		pstmt.setString(2,sizeCode);
		rs = pstmt.executeQuery();
		
		if(rs.next())
		{
			sizeMap.put("CODE", checkNull(rs.getString(1)));
			sizeMap.put("DESCR", checkNull(rs.getString(2)));
			sizeMap.put("SH_DESCR", checkNull(rs.getString(3)));
			sizeMap.put("MEGETO_ID", checkNull(rs.getString(4)));
		}
		pstmt.close();
		rs.close();			
	}
	catch(Exception e)
	{
		throw new Exception(e);
	}
	System.out.println("Size Map = "+sizeMap);
		return sizeMap;
	}
	//Changed by Samadhan on 21/12/2015 for size Grid End.
	
	

}
