package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.NilInwardSupplies;

public class NilInwardSerializer extends JsonSerializer<NilInwardSupplies> 
{
	@Override
	public void serialize(NilInwardSupplies nilInwardSupplies, JsonGenerator json, SerializerProvider serializerProvider)throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		
		if(nilInwardSupplies.interNilSupplies != null)
		{
			json.writeFieldName("inter");
			
			json.writeStartObject();
			json.writeNumberField("cpddr", nilInwardSupplies.interNilSupplies.compoundSuppliesAmt);
			json.writeNumberField("exptdsply", nilInwardSupplies.interNilSupplies.exempetedSuppliesAmt);
			json.writeNumberField("ngsply", nilInwardSupplies.interNilSupplies.nonGSTSuppliesAmt);
			json.writeNumberField("nilsply", nilInwardSupplies.interNilSupplies.nilSuppliesAmt);
			json.writeEndObject();
		}
		
		if(nilInwardSupplies.intraNilSupplies != null)
		{
			json.writeFieldName("intra");
			
			json.writeStartObject();
			json.writeNumberField("cpddr", nilInwardSupplies.intraNilSupplies.compoundSuppliesAmt);
			json.writeNumberField("exptdsply", nilInwardSupplies.intraNilSupplies.exempetedSuppliesAmt);
			json.writeNumberField("ngsply", nilInwardSupplies.intraNilSupplies.nonGSTSuppliesAmt);
			json.writeNumberField("nilsply", nilInwardSupplies.intraNilSupplies.nilSuppliesAmt);
			json.writeEndObject();
		}
        
        json.writeEndObject();
	}
}
