

//Author : Suraj C
//Component : Employee Master
//Date: 26/MAY/15


package ibase.webitm.ejb.adm;

import ibase.system.config.*;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.ejb.*;

//import org.dom4j.util.IndexedElement;
import org.w3c.dom.*;

//import com.sun.org.apache.xalan.internal.xsltc.compiler.Pattern;

@Stateless

public class EmployeeEJB extends ValidatorEJB implements EmployeeEJBLocal,EmployeeEJBRemote
{

	// Code for Validation
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}


	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("EmployeeEJB:wfValData value of xmlString ["+xmlString+"]");
			System.out.println("EmployeeEJB:wfValData value of xmlString ["+xmlString1+"]");
			System.out.println("EmployeeEJB:wfValData value of xmlString ["+xmlString2+"]");
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println ("ErrString: " + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception: EmployeeEJB: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println ("Returning from EmployeeEJB wfValData");
		return (errString);  
	}



	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0,currentFormNo =0,childNodeListLength =0,cnt =0;
		String cctrCodeSal="";
		String childNodeName = null,childNodeValue = null;
		String errString = "";
		String errCode = "",workLocCode="",parentDept="";
		Connection conn = null;
		String userId = ""; 		
		String stanCode="";
		String loginSite = "";
		String bankCode="",bankAcct="",funcGroup="";
		String payableBank="" , year="",duration="";
		String acctCodeSal="",amount="",handCtgr="";
		String nationality="",empCodeHOD="" , trainCode="",empMname="";
		String payMode="",graDate="" ,printSeq="",empCodeLink="";
		String projCode="",startDate="",siteCodePay="",perState="";
		String isTemp="",workShift="",patternCode="",curState="";
		String contactCode="",empLname = "",empFname = "",sex = "";
		String relieveDateStr ="",deptCode ="",cadreCode ="",gradeCode ="";
		String designCode ="",empSite ="",workSite ="",conState="",currCode="";
		String empCode ="",paySite ="",reportTo ="", stanCodeHq ="",reportToAdmin ="";
		String dateJoinStr ="",status ="",emailIdOff = "",language="",keyFlag="";
		String gratPerc="", pfPerc="", penPerc="",qlfCode="",grossAmt="",phyHand="",suppCode="";
		String editFlg="";
		String fromDate = "";
		String errFldName="";		
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		java.util.Date joinDate = null;
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		String msgType = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			GenericUtility genericUtility = GenericUtility.getInstance(); 			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());	
			SimpleDateFormat dbsdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			if(editFlag == null || editFlag.trim().length() == 0)
			{	
				editFlg="A";
				System.out.println("editFlg:::::::::"+editFlg);
			} 
			else
			{
				editFlg = editFlag;
				System.out.println("editFlg:::::::::"+editFlg);
			}
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println(" ***********Validation for Employee Detail  "+currentFormNo);
			switch(currentFormNo)
			{
			case 1 :
			{
				System.out.println("Validation for Detail 1 Employee..........");
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("child Node List Length::::::"+childNodeListLength);
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{	

					childNode = childNodeList.item(ctr);
					System.out.println("childNode"+childNode);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					childNodeName = childNode.getNodeName();
					if(childNode.getFirstChild()!= null)
					{
						childNodeValue = childNode.getFirstChild().getNodeValue();
					}


					if(childNodeName.equalsIgnoreCase("emp_code"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						empCode = genericUtility.getColumnValue("emp_code", dom);
						System.out.println("EMPcode::::::["+empCode+"]");
						String sqlKey="SELECT KEY_FLAG FROM TRANSETUP WHERE TRAN_WINDOW='w_emp_master'";
						pstmt=conn.prepareStatement(sqlKey);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							keyFlag=rs.getString("KEY_FLAG");
							System.out.println("KEY FLAG VALUE:::::::::"+keyFlag);
							System.out.println("editFlg:::::::::"+editFlg);
							if(editFlg.equalsIgnoreCase("A"))
							{
								if(keyFlag.equals("M"))
								{
									System.out.println("inside if if if empcode ["+empCode+"]");
									if(empCode == null || empCode.trim().length() == 0)
									{
										errList.add("VEEMP2");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "VEEMP2"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									else
									{
										cnt =  isValueExist("employee","emp_code",empCode, conn);
										if(cnt > 0)
										{
											errList.add("VMDUPL1");
											errFields.add(childNodeName.toLowerCase());
											msgType = errorType(conn, "VMDUPL1"); 					
											if (msgType.equalsIgnoreCase("E"))
											{
												break;
											}
										}
									}
								}
							}
						}	
						close(pstmt, rs);
					}

					else if(childNodeName.equalsIgnoreCase("emp_fname"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						empFname = genericUtility.getColumnValue("emp_fname", dom);

						if(empFname == null || empFname.trim().length() == 0)
						{

							errList.add("VEEMP4");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VEEMP4"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("emp_mname"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						empMname = genericUtility.getColumnValue("emp_mname", dom);

						if(empMname == null)
						{
							errList.add("VEEMP5");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VEEMP5"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}

					else if(childNodeName.equalsIgnoreCase("emp_lname"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						empLname = genericUtility.getColumnValue("emp_lname", dom);

						if(empLname == null || empLname.trim().length() == 0)
						{
							errList.add("VEEMP3");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VEEMP3"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}

					else if(childNodeName.equalsIgnoreCase("contact_code"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						contactCode = genericUtility.getColumnValue("contact_code", dom);
						if(contactCode == null || contactCode.trim().length() == 0)
						{
							errList.add("VMCCD1");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMCCD1"); 
							System.out.println("msgType in cont code::::::::::::::"+msgType);
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
						else
						{
							cnt =  isValueExist("contact","contact_code",contactCode, conn);
							if(cnt == 0)
							{
								errList.add("VMCCD2");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMCCD2"); 	
								System.out.println("msgType2 in cont code::::::::::::::"+msgType);
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("emp_code__link"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						empCodeLink = genericUtility.getColumnValue("emp_code__link", dom);
						if(empCodeLink != null && empCodeLink.trim().length() > 0)
						{
							cnt = isValueExist("employee","emp_code",empCodeLink, conn);
							if(cnt == 0)
							{
								errList.add("VMEMP1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMP1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								relieveDateStr =  getFieldValue("relieve_date", "employee", "emp_code", empCodeLink, conn);
								if(relieveDateStr == null || relieveDateStr.trim().length() == 0)
								{
									errList.add("VTEMPRLVDT");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTEMPRLVDT"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
					}



					else if(childNodeName.equalsIgnoreCase("dept_code"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						deptCode = genericUtility.getColumnValue("dept_code", dom);

						cnt =  isValueExist("department","dept_code",deptCode, conn);
						if(cnt == 0)
						{
							errList.add("VMDEP1");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMDEP1"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}	
						else
						{
							status  = getFieldValue("status", "department", "dept_code", deptCode, conn);	
							if(status.trim().equals("I"))
							{
								errList.add("VTDPINAC");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTDPINAC"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}


					}
					//Modified by Ahmed on 22/AUG/2016 [A16ESUN005] [To validate func_group from busi_functions table, emp_code__funchead from employee table and bu_code from business_units table][start]
					else if(childNodeName.equalsIgnoreCase("func_group"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						funcGroup = genericUtility.getColumnValue("func_group", dom);
						if(funcGroup != null && funcGroup.length() > 0)
						{	
							String sql = "select count(*) as cnt from busi_functions where func_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, funcGroup);
							rs = pstmt.executeQuery();
							cnt = 0;
							if(rs.next())
							{
								cnt = rs.getInt("cnt");
							}
							close(pstmt,rs);
							if(cnt == 0)
							{
								errList.add("VMEMPFGRP1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPFGRP1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("emp_code__funchead"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						String empCodeFuncHead = genericUtility.getColumnValue("emp_code__funchead", dom);
						String empCodeDom = genericUtility.getColumnValue("emp_code", dom);
						if(empCodeFuncHead != null && empCodeFuncHead.length() > 0)
						{	
							String sql = "select count(*) as cnt from employee where emp_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, empCodeFuncHead);
							rs = pstmt.executeQuery();
							cnt = 0;
							if(rs.next())
							{
								cnt = rs.getInt("cnt");
							}
							close(pstmt,rs);
							if(cnt == 0)
							{
								errList.add("VMEMPFUHD1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPFUHD1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else if(empCodeDom.equalsIgnoreCase(empCodeFuncHead))
							{
								errList.add("VMEMPFUHD2");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPFUHD2"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								sql = "";
								sql = "select relieve_date from employee where emp_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, empCodeFuncHead);
								rs = pstmt.executeQuery();
								cnt = 0;
								Timestamp relieveDateTS = null;
								if(rs.next())
								{
									relieveDateTS = rs.getTimestamp("relieve_date");
								}
								close(pstmt,rs);
								if(relieveDateTS != null)
								{
									errList.add("VMEMPFUHD3");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMPFUHD3"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("bu_code"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						String buCode = genericUtility.getColumnValue("bu_code", dom);
						if(buCode != null && buCode.length() > 0)
						{	
							String sql = "select count(*) as cnt from business_units where bu_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, buCode);
							rs = pstmt.executeQuery();
							cnt = 0;
							if(rs.next())
							{
								cnt = rs.getInt("cnt");
							}
							close(pstmt,rs);
							if(cnt == 0)
							{
								errList.add("VMEMPBUCD1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPBUCD1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					//Modified by Ahmed on 22/AUG/2016 [A16ESUN005] [To validate func_group from busi_functions table, emp_code__funchead from employee table and bu_code from business_units table][end]
					else if(childNodeName.equalsIgnoreCase("grade_code"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						gradeCode = genericUtility.getColumnValue("grade_code", dom);
						if(gradeCode != null && gradeCode.trim().length() > 0)
						{
							cnt =  isValueExist("grade","grade_code",gradeCode, conn);
							if(cnt == 0)
							{
								errList.add("VMGRA1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMGRA1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("cadre_code"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						cadreCode = genericUtility.getColumnValue("cadre_code", dom);
						cnt =  isValueExist("cadre","cadre_code",cadreCode, conn);
						if(cnt == 0)
						{
							errList.add("VMCAD1");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMCAD1"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}

					}

					else if(childNodeName.equalsIgnoreCase("design_code"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						designCode = genericUtility.getColumnValue("design_code", dom);
						if(designCode != null && designCode.trim().length() > 0)
						{
							cnt =  isValueExist("designation","design_code",designCode, conn);
							if(cnt == 0)
							{
								errList.add("VMDESIGN");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMDESIGN"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								status  = getFieldValue("status", "designation", "design_code", designCode, conn);	
								if(status.equalsIgnoreCase("I"))
								{
									errList.add("VTDGINAC");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTDGINAC"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						else if (designCode == null || designCode.trim().length() == 0)
						{

							errList.add("VMDESIGN2");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMDESIGN2"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("report_to"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						reportTo = genericUtility.getColumnValue("report_to", dom);
						empCode = genericUtility.getColumnValue("emp_code", dom);
						if(reportTo != null && reportTo.trim().length() > 0)
						{
							cnt =  isValueExist("employee","emp_code",reportTo, conn);
							if(cnt == 0)
							{
								errList.add("VMEMP1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMP1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								status  = getFieldValue("status", "employee", "emp_code", reportTo, conn);	
								if(status.trim().equalsIgnoreCase("S"))
								{
									errList.add("VMEMP2");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMP2"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									if(empCode.equalsIgnoreCase(reportTo))
									{
										errList.add("VMEMP4");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "VMEMP4"); 					
										if (msgType.trim().equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
							}
						}
					}


					else if(childNodeName.equalsIgnoreCase("report_to__admin"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						reportToAdmin = genericUtility.getColumnValue("report_to__admin", dom);
						empCode = genericUtility.getColumnValue("emp_code", dom);
						if(reportToAdmin != null && reportToAdmin.trim().length() > 0)
						{
							cnt =  isValueExist("employee","emp_code",reportToAdmin, conn);
							if(cnt == 0)
							{
								errList.add("VMEMP1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMP1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else if(empCode.trim().equalsIgnoreCase(reportToAdmin))
							{
								errList.add("VMEMPACD");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPACD"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								relieveDateStr = getFieldValue("relieve_date", "employee", "emp_code", reportToAdmin, conn);	
								if(relieveDateStr != null && relieveDateStr.trim().length() > 0)
								{
									errList.add("VMEMPREL");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMPREL"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("emp_site"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						empSite = genericUtility.getColumnValue("emp_site", dom);
						if(empSite != null && empSite.trim().length() > 0)
						{
							cnt =  isValueExist("site","site_code",empSite, conn);
							if(cnt == 0)
							{
								errList.add("VTSITECD1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTSITECD1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("work_site"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						workSite = genericUtility.getColumnValue("work_site", dom);
						if(workSite != null && workSite.trim().length() > 0)
						{
							cnt =  isValueExist("site","site_code",workSite, conn);
							if(cnt == 0)
							{
								errList.add("VMWKRSITE");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMWKRSITE"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("pay_site"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						paySite = genericUtility.getColumnValue("pay_site", dom);
						if(paySite != null && paySite.trim().length() > 0)
						{
							cnt =  isValueExist("site","site_code",paySite, conn);
							if(cnt == 0)
							{
								errList.add("VMPAYSITE");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMPAYSITE"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}					



					else if(childNodeName.equalsIgnoreCase("date_join"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						dateJoinStr = genericUtility.getColumnValue("date_join", dom);
						System.out.println(" dateJoinStr................ "+dateJoinStr);							
						if( dateJoinStr == null )
						{
							errList.add("VMJOIN");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMJOIN"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}

					else if(childNodeName.equalsIgnoreCase("stan_code__hq"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						stanCodeHq = genericUtility.getColumnValue("stan_code__hq", dom);
						if(stanCodeHq != null && stanCodeHq.trim().length() > 0)
						{
							cnt =  isValueExist("station","stan_code",stanCodeHq, conn);
							if(cnt == 0)
							{
								errList.add("VESTACD1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VESTACD1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}



					else if(childNodeName.equalsIgnoreCase("bank_code"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						bankCode=genericUtility.getColumnValue("bank_code", dom);
						if(bankCode != null && bankCode.trim().length() > 0)
						{
							String sql="Select count(*) as cnt from bank where bank_code =?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1, bankCode);
							rs=pstmt.executeQuery();
							while(rs.next())
							{
								cnt=rs.getInt("cnt");
							}
							close(pstmt,rs);
							if(cnt==0)
							{
								errList.add("VMBANK1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMBANK1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								stanCode=genericUtility.getColumnValue("stan_code", dom);
								empCode=genericUtility.getColumnValue("emp_code", dom);
								if(stanCode !=null && stanCode.trim().length() > 0)
								{
									String sqlsc="select count(*) as cnt from bank_stan_serv where bank_code = ? and stan_code = ?";
									pstmt=conn.prepareStatement(sqlsc);
									pstmt.setString(1, bankCode);
									pstmt.setString(2, stanCode);
									rs=pstmt.executeQuery();
									cnt = 0;
									while(rs.next())
									{
										cnt=rs.getInt("cnt");
									}
									close(pstmt,rs);
									if(cnt==0)
									{
										errList.add("VTBKSTAN");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "VTBKSTAN"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									else
									{
										paySite=genericUtility.getColumnValue("pay_site", dom);
										if(paySite != null && paySite.trim().length() > 0)
										{
											String sqlPs="select count(*) as cnt from bank where bank_code = ? "
													+ "and site_code = (select site_code__acct from site where site_code = ?) ";
											pstmt=conn.prepareStatement(sqlPs);
											pstmt.setString(1, bankCode);
											pstmt.setString(2, paySite);
											rs=pstmt.executeQuery();
											cnt = 0;
											while(rs.next())
											{
												cnt=rs.getInt("cnt");
											}
											close(pstmt,rs);
											if(cnt==0)
											{
												errList.add("VTBKPAY");
												errFields.add(childNodeName.toLowerCase());
												msgType = errorType(conn, "VTBKPAY"); 					
												if (msgType.equalsIgnoreCase("E"))
												{
													break;
												}
											}
										}
									}
								}
							}
						}
					}

					else if(childNodeName.equalsIgnoreCase("dd_payable_bank"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						payableBank=genericUtility.getColumnValue("dd_payable_bank", dom);
						if(payableBank != null)
						{
							cnt=isValueExist("bank","bank_code",payableBank, conn);									
							if(cnt==0)
							{
								errList.add("VTBANK1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTBANK1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("stan_code"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						stanCode=genericUtility.getColumnValue("stan_code", dom);

						if(stanCode != null && stanCode.trim().length() > 0)
						{
							cnt=isValueExist("station","stan_code",stanCode, conn);
							if(cnt == 0)
							{
								errList.add("VESTACD1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VESTACD1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else
						{
							payMode=genericUtility.getColumnValue("pay_mode", dom);
							if(payMode != null && payMode.trim().length() > 0)
							{
								if(payMode.equals("D") || payMode.equals("T"))
								{
									if(stanCode == null || stanCode.trim().length() == 0)//Modified By suraj [11/06/2015][To fix the bug]
									{
										errList.add("VESTACD2");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "VESTACD2"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("proj_code"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						projCode = genericUtility.getColumnValue("proj_code", dom);
						if(projCode != null)
						{
							cnt = isValueExist("project","proj_code",projCode, conn);
							if(cnt==0)
							{
								errList.add("VTPROJCD1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTPROJCD1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("acct_code__sal"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						acctCodeSal = genericUtility.getColumnValue("acct_code__sal", dom);
						if(acctCodeSal != null && acctCodeSal.trim().length() > 0)
						{
							cnt=isValueExist("accounts","acct_code",acctCodeSal, conn);								
							if(cnt==0)
							{
								errList.add("VMACCT1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMACCT1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("cctr_code__sal"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						cctrCodeSal = genericUtility.getColumnValue("cctr_code__sal", dom);
						isTemp = getEnv("999999","CCTR_YESNO",conn);
						if(isTemp == null)
						{
							errList.add("VSENVAR1");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VSENVAR1"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
						else if(cctrCodeSal != null && cctrCodeSal.trim().length() > 0)
						{
							cnt=isValueExist("costctr","cctr_code",cctrCodeSal, conn);
							if(cnt==0)
							{
								errList.add("VMCCTR1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMCCTR1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else if(isTemp.equals("N"))
							{
								errList.add("VMCCTR1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMCCTR1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("nationality"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						//Modified by Suraj [03/06/2015][To handle null nationality value] [Start]
						cnt=0;
						nationality=genericUtility.getColumnValue("nationality", dom);	
						if(nationality != null && nationality.trim().length() > 0)
						{							
							cnt=isValueExist("country","count_code",nationality, conn);
						}
						if(cnt==0)
						{
							errList.add("VMCONT");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMCONT"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
						//Modified by Suraj [03/06/2015][To handle null nationality value] [End]
					}
					else if(childNodeName.equalsIgnoreCase("contact_state"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						conState=genericUtility.getColumnValue("contact_state", dom);
						if(conState != null && conState.trim().length() > 0)
						{
							cnt=isValueExist("state","state_code",conState, conn);
							if(cnt==0)
							{
								errList.add("VESTATCD2");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VESTATCD2"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("cur_state"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						curState=genericUtility.getColumnValue("cur_state", dom);
						if(curState != null && curState.trim().length() > 0)
						{
							cnt=isValueExist("state","state_code",curState, conn);
							if(cnt==0)
							{
								errList.add("VESTATCD2");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VESTATCD2"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else
						{
							errList.add("VESTATCD2");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VESTATCD2"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("per_state"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						perState=genericUtility.getColumnValue("per_state", dom);
						if(perState != null && perState.trim().length() > 0)
						{
							cnt=isValueExist("state","state_code",perState, conn);
							if(cnt==0)
							{
								errList.add("VESTATCD2");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VESTATCD2"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else
						{
							errList.add("VESTATCD2");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VESTATCD2"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}

					else if(childNodeName.equalsIgnoreCase("site_code__payment"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						siteCodePay=genericUtility.getColumnValue("site_code__payment", dom);
						empSite=genericUtility.getColumnValue("emp_site", dom);
						if(siteCodePay != null && siteCodePay.trim().length() > 0)
						{
							cnt=isValueExist("site","site_code",siteCodePay, conn);							
							if(cnt==0)
							{
								errList.add("VMSITE");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMSITE"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								String sqlScp=  "select count(*) as cnt from site where site_code = ?"
										+"and fin_entity = (select fin_entity from site	where site_code = ?)";
								pstmt=conn.prepareStatement(sqlScp);
								pstmt.setString(1, siteCodePay);
								pstmt.setString(2, empSite);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("cnt");
								}
								close(pstmt,rs);
								if(cnt==0)
								{
									errList.add("VMSITE2");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMSITE2"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
					}

					else if(childNodeName.equalsIgnoreCase("pay_mode"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						payMode=genericUtility.getColumnValue("pay_mode", dom);
						if(payMode != null && payMode.trim().length() > 0)
						{
							if(payMode.equals("T"))
							{
								bankCode=genericUtility.getColumnValue("bank_code", dom);
								bankAcct=genericUtility.getColumnValue("bank_acct", dom);
								if(bankCode == null || bankCode.trim().length() == 0)
								{
									errList.add("VMBANK1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMBANK1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else if(bankAcct == null || bankAcct.trim().length() == 0) 
								{
									errList.add("VTBANKACC");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTBANKACC"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							else if (payMode.equals("D"))
							{
								bankCode=genericUtility.getColumnValue("bank_code", dom);
								if(bankCode == null || bankCode.trim().length() == 0)
								{
									errList.add("VMBANK1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMBANK1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("pattern_code"))
					{
						java.util.Date startDt=null;
						System.out.println("In Validation of : ["+childNodeName+"]");
						patternCode=genericUtility.getColumnValue("pattern_code", dom);
						if(patternCode != null && patternCode.trim().length() > 0)
						{
							cnt = 0;
							empCode=genericUtility.getColumnValue("emp_code", dom);
							workSite=genericUtility.getColumnValue("work_site", dom);
							String sqlPc="select start_date as startdate from shift_pattern "
									+ "where site_code = ? and pattern_code = ?";
							pstmt=conn.prepareStatement(sqlPc);
							pstmt.setString(1, workSite);
							pstmt.setString(2, patternCode);
							rs=pstmt.executeQuery();
							while(rs.next())
							{
								startDate=rs.getString("startdate");
								cnt = 1;
							}
							close(pstmt,rs);
							if (cnt == 0)
							{
								errList.add("VTPNOTM");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTPNOTM"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							java.util.Date currDate = new java.util.Date();
							if(startDate == null || startDate.trim().length() == 0)
							{
								errList.add("VTPNOTM");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTPNOTM"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								startDt =dbsdf.parse(startDate)	;						
								if(startDt.after(currDate))
								{
									errList.add("VTDTGTST");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTDTGTST"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("work_shift"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						workShift=genericUtility.getColumnValue("work_shift", dom);
						if(workShift != null && workShift.trim().length() > 0)
						{
							empCode=genericUtility.getColumnValue("emp_code", dom);
							workSite=genericUtility.getColumnValue("work_site", dom);
							String sqlWs=" select count(*) as cnt from workshft where site_code = ? and shift = ?";
							pstmt=conn.prepareStatement(sqlWs);
							pstmt.setString(1, workSite);
							pstmt.setString(2, workShift);
							rs=pstmt.executeQuery();
							while(rs.next())
							{
								cnt=rs.getInt("cnt");
							}
							close(pstmt, rs);
							if(cnt==0)
							{
								errList.add("VTWSNOT");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTWSNOT"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								String sqlws="select count(*) as ctr from workshft where "
										+ "site_code = ? and shift = ? and status = 'I'";
								cnt=0;
								pstmt=conn.prepareStatement(sqlws);
								pstmt.setString(1, workSite);
								pstmt.setString(2, workShift);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("ctr");										
								}
								close(pstmt, rs);
								if(cnt > 0)
								{
									errList.add("VTSHINAC");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTSHINAC"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("gratuity_date"))
					{
						java.util.Date graDt=null;
						System.out.println("In Validation of : ["+childNodeName+"]");
						graDate = genericUtility.getColumnValue("gratuity_date", dom);
						if(graDate != null)
						{
							graDt = sdf.parse(graDate);
						}
						dateJoinStr = genericUtility.getColumnValue("date_join", dom);
						if(dateJoinStr != null)
						{
							joinDate = sdf.parse(dateJoinStr);
						}
						if(graDt.before(joinDate))
						{
							errList.add("VTGRADATE");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VTGRADATE"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("emp_code__hod"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						empCodeHOD = genericUtility.getColumnValue("emp_code__hod", dom);
						if(empCodeHOD != null && empCodeHOD.trim().length() > 0)
						{
							cnt = isValueExist("employee","emp_code",empCodeHOD, conn);
							if(cnt == 0)
							{
								errList.add("VMEMP1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMP1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								String relieveDate =getFieldValue("relieve_date","employee","emp_code",empCodeHOD,conn);
								//if(relieveDate != null)
								if(relieveDate != null && relieveDate.trim().length() > 0) // Modified By Suraj [16/06/2015] [To fix the logical bug related to space]
								{
									errList.add("VMEMPREL");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMPREL"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
					}
					//Commented by Ahmed on 11/12/2015[AD3DSUN001][START]
					/*else if(childNodeName.equalsIgnoreCase("func_group"))
						{
							System.out.println("In Validation of : ["+childNodeName+"]");
							funcGroup = genericUtility.getColumnValue("func_group", dom);
							if(funcGroup == null || funcGroup.trim().length() == 0)
							{

								errList.add("VMEMPFGRP2");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPFGRP2"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								cnt = isValueExist("department","dept_code",funcGroup, conn);
								if(cnt == 0)
								{
									errList.add("VMEMPFGRP1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMPFGRP1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("parent_dept"))
						{
							System.out.println("In Validation of : ["+childNodeName+"]");
							parentDept = genericUtility.getColumnValue("parent_dept", dom);
							if(parentDept == null || parentDept.trim().length() == 0)
							{
								errList.add("VMEMPPDPT2");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPPDPT2"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								cnt = isValueExist("department","dept_code",parentDept, conn);
								if(cnt == 0)
								{
									errList.add("VMEMPPDPT1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMPPDPT1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}*/
					//Commented by Ahmed on 11/12/2015[AD3DSUN001][END]
					else if(childNodeName.equalsIgnoreCase("work_loc_code"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						workLocCode = genericUtility.getColumnValue("work_loc_code", dom);
						if(workLocCode != null && workLocCode.trim().length() > 0)
						{
							cnt = isValueExist("WORK_LOCATIONS","work_loc_code",workLocCode, conn);
							if(cnt == 0)
							{
								errList.add("VMEMPWLOC1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPWLOC1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								cnt=0;
								String sqlWlc = "select count(1) as cnt from WORK_LOCATIONS where "
										+ "work_loc_code = ? and case when active is null then 'Y' else active end = 'Y'";
								pstmt = conn.prepareStatement(sqlWlc);
								pstmt.setString(1, workLocCode);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMEMPWLOC1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMPWLOC1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("handicap_category"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						handCtgr = genericUtility.getColumnValue("handicap_category", dom);
						phyHand = genericUtility.getColumnValue("physical_handicap", dom);
						if(phyHand != null && phyHand.trim().equals("Y"))
						{
							if(handCtgr != null &&  handCtgr.trim().length() > 0)
							{
								String sqlHc="select count(1) as cnt from GENCODES where"
										+ " MOD_NAME IN ('X') AND FLD_NAME = 'HANDICAP_CATEGORY' "
										+ "AND trim(FLD_VALUE) = trim(?)";
								cnt=0;
								pstmt=conn.prepareStatement(sqlHc);
								pstmt.setString(1, handCtgr);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMEMPHCTG1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMPHCTG1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							else
							{
								errList.add("VMEMPHCTG1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPHCTG1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						/*if(handCtgr != null &&  handCtgr.length() > 0)
							{
								if(handCtgr.trim().length() == 0)
								{
									errList.add("VMEMPHCTG1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMPHCTG1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							else 
							{
								String sqlHc="select count(1) as cnt from GENCODES where"
										+ " MOD_NAME IN ('X') AND FLD_NAME = 'HANDICAP_CATEGORY' "
										+ "AND trim(FLD_VALUE) = trim(?)";
								cnt=0;
								pstmt=conn.prepareStatement(sqlHc);
								pstmt.setString(1, handCtgr);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMEMPHCTG1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMPHCTG1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}*/
					}
					else if(childNodeName.equalsIgnoreCase("notice_prd"))
					{
						System.out.println("In Validation of : ["+childNodeName+"]");
						String notPrd = genericUtility.getColumnValue("notice_prd", dom);
						//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To validate negative values][START]
						/*if(notPrd != null && notPrd.trim().length()> 0)
							{
								float notPrdnum=Float.parseFloat(notPrd);
								if(notPrdnum < 0)
								{
									errList.add("VMEMPNOTP1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMPNOTP1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}*/

						float notPrdFloat = 0f;
						try
						{
							notPrdFloat = Float.parseFloat(notPrd);
						}
						catch(Exception e)
						{
							errList.add("VMEMPNPRD1");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPNPRD1"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
						if(notPrdFloat < 0)
						{
							errList.add("VMEMPNPRD2");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPNPRD2"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
						//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To validate negative values][END]
					}
					//Added by Suraj [03/06/2015] [To validate position code][Start]
					else if(childNodeName.equalsIgnoreCase("pos_code"))
					{
						String dateJoin="";
						String posCode="";
						posCode = genericUtility.getColumnValue("pos_code",dom);
						empCode = checkNull(getColumnValue("emp_code",dom));
						deptCode = checkNull(getColumnValue("dept_code",dom));
						dateJoin= checkNull(getColumnValue("date_join",dom));
						if(dateJoin != null && dateJoin.trim().length() > 0)
						{
							joinDate=sdf.parse(dateJoin);
							errString = validatePosition(empCode , posCode , deptCode , joinDate, conn);
							if (errString.length() > 0)
							{
								errList.add(errString);
								errFields.add( childNodeName.toLowerCase() );

								msgType =  errorType( conn ,errString );

								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					//Added by Suraj [03/06/2015] [To validate position code][End]	

					//Added by Suraj [11/06/2015] [To validate supplier contract code][Start]	
					else if(childNodeName.equalsIgnoreCase("supp_code__con"))
					{
						suppCode = genericUtility.getColumnValue("supp_code__con",dom);
						cnt=0;
						if(suppCode != null && suppCode.trim().length() > 0)
						{
							cnt=isValueExist("supplier","supp_code",suppCode, conn);
							if(cnt==0)
							{
								errList.add("VTSUPP1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTSUPP1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}

							}
						}
						else if (suppCode != null)
						{
							errList.add("VMSUPPCD");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMSUPPCD"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}

					}
					//Added by Suraj [11/06/2015] [To validate supplier contract code][Start]
					//Modified by Ahmed on 22/AUG/2016 [A16ESUN005][To validate when negative value is entered in below fields][start]
					else if(childNodeName.equalsIgnoreCase("tot_exp"))
					{
						String totExp = genericUtility.getColumnValue("tot_exp",dom);
						/*Modified by Anjali Rawankar on[10/04/2017][Start]
						 *[Purpose : system should allow tot_exp as null]
						 */
						//if(totExp != null && totExp.trim().length() > 0)
						if(totExp != null && totExp.length() > 0)
						{
						/*[Purpose : system should allow tot_exp as null]
						 *Modified by Anjali Rawankar on[10/04/2017][End]
						 */
							float totExpFloat = 0f;
							try
							{
								totExpFloat = Float.parseFloat(totExp);
							}
							catch(Exception e)
							{
								errList.add("VMEMPTEXP1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPTEXP1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							if(totExpFloat < 0)
							{
								errList.add("VMEMPTEXP1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPTEXP1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}//Modified by Anjali Rawankar on[10/04/2017]
					}
					else if(childNodeName.equalsIgnoreCase("training_prd"))
					{
						String trainingPrd = genericUtility.getColumnValue("training_prd",dom);
						float trainingPrdFloat = 0f;
						try
						{
							trainingPrdFloat = Float.parseFloat(trainingPrd);
						}
						catch(Exception e)
						{
							errList.add("VMEMPTPRD1");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPTPRD1"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
						if(trainingPrdFloat < 0)
						{
							errList.add("VMEMPTPRD2");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPTPRD2"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("probation_prd"))
					{
						String probationPrd = genericUtility.getColumnValue("probation_prd",dom);
						float probationPrdFloat = 0f;
						try
						{
							probationPrdFloat = Float.parseFloat(probationPrd);
						}
						catch(Exception e)
						{
							errList.add("VMEMPPPRD1");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPPPRD1"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
						if(probationPrdFloat < 0)
						{
							errList.add("VMEMPPPRD2");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPPPRD2"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("basic"))
					{
						String basic = genericUtility.getColumnValue("basic",dom);
						float basicFloat = 0f;
						try
						{
							basicFloat = Float.parseFloat(basic);
						}
						catch(Exception e)
						{
							errList.add("VMEMPBASI1");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPBASI1"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
						if(basicFloat < 0)
						{
							errList.add("VMEMPBASI1");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPBASI1"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("gross"))
					{
						String gross = genericUtility.getColumnValue("gross",dom);
						float grossFloat = 0f;
						try
						{
							grossFloat = Float.parseFloat(gross);
						}
						catch(Exception e)
						{
							errList.add("VMEMPGROS1");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPGROS1"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
						if(grossFloat < 0)
						{
							errList.add("VMEMPGROS1");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPGROS1"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("normal_rate"))
					{
						String normalRate = genericUtility.getColumnValue("normal_rate",dom);
						if(normalRate != null && normalRate.trim().length() > 0)//Modified by Ahmed on 30/AUG/2016 to validate normalRate when not null[A16ESUN005]
						{
							float normalRateFloat = 0f;
							try
							{
								normalRateFloat = Float.parseFloat(normalRate);
							}
							catch(Exception e)
							{
								errList.add("VMEMPNRAT1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPNRAT1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							if(normalRateFloat < 0)
							{
								errList.add("VMEMPNRAT1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPNRAT1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("ot_rate"))
					{
						String otRate = genericUtility.getColumnValue("ot_rate",dom);
						if(otRate != null && otRate.trim().length() > 0)//Modified by Ahmed on 30/AUG/2016 to validate otRate when not null[A16ESUN005]
						{
							float otRateFloat = 0f;
							try
							{
								otRateFloat = Float.parseFloat(otRate);
							}
							catch(Exception e)
							{
								errList.add("VMEMPORAT1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPORAT1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							if(otRateFloat < 0)
							{
								errList.add("VMEMPORAT1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPORAT1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("shift_index"))
					{
						String shiftIndex = genericUtility.getColumnValue("shift_index",dom);
						if(shiftIndex != null && shiftIndex.trim().length() > 0)//Modified by Ahmed on 30/AUG/2016 to validate shift index when not null[A16ESUN005]
						{
							float shiftIndexFloat = 0f;
							try
							{
								shiftIndexFloat = Float.parseFloat(shiftIndex);
							}
							catch(Exception e)
							{
								errList.add("VMEMPSIND1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPSIND1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							if(shiftIndexFloat < 0)
							{
								errList.add("VMEMPSIND1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPSIND1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					//Modified by Ahmed on 22/AUG/2016 [A16ESUN005][To validate when negative value is entered in below fields][end]
				}
				break;
			}
			case 2 :
				System.out.println("Validation for Detail 2 Employee..........");
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);

					System.out.println("childNode"+childNode);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("pf_perc"))
					{
						pfPerc = genericUtility.getColumnValue("pf_perc", dom);					
						if(pfPerc == null || Integer.parseInt(pfPerc) < 0 || Integer.parseInt(pfPerc) >100)
						{
							errList.add("VMEMPFML01");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPFML01"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("member_name"))
					{
						String memberName ="" ;
						memberName = genericUtility.getColumnValue("member_name", dom);					
						if(memberName == null || memberName.trim().length() == 0)
						{
							errList.add("VMEMPFML04");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPFML04"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("grat_perc"))
					{
						gratPerc = genericUtility.getColumnValue("grat_perc", dom);						
						if(gratPerc == null || Integer.parseInt(gratPerc) < 0 || Integer.parseInt(gratPerc) >100)
						{
							errList.add("VMEMPFML02");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPFML02"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("pen_perc"))
					{
						penPerc = genericUtility.getColumnValue("pen_perc", dom);						
						if(penPerc == null || Integer.parseInt(penPerc) < 0 || Integer.parseInt(penPerc) >100)
						{
							errList.add("VMEMPFML03");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPFML03"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
				} break;
			case 3 :
				System.out.println("Validation for Detail 3 Employee..........");
				parentNodeList = dom.getElementsByTagName("Detail3");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);

					System.out.println("childNode"+childNode);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("emp_code"))
					{

					}
					if(childNodeName.equalsIgnoreCase("language"))
					{
						language = genericUtility.getColumnValue("language", dom);
						if(language == null || language.trim().length() == 0)
						{
							errList.add("VMEMPLNG01");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPLNG01"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
				}
				break;
			case 4 :
				System.out.println("Validation for Detail 4 Employee..........");
				parentNodeList = dom.getElementsByTagName("Detail4");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{	

					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNode.getFirstChild()!= null)
					{
						childNodeValue = childNode.getFirstChild().getNodeValue();
					}
					if(childNodeName.equalsIgnoreCase("qlf_code"))
					{
						qlfCode = genericUtility.getColumnValue("qlf_code", dom);
						cnt=isValueExist("qualification","qlf_code",qlfCode, conn);		
						if(cnt == 0)
						{
							errList.add("VMQLF1");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMQLF1"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("print_seq"))
					{
						printSeq = genericUtility.getColumnValue("print_seq", dom);						
						if(printSeq == null || Integer.parseInt(printSeq) < 0)
						{
							errList.add("VMEMPQLF01");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPQLF01"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}

					}
					if(childNodeName.equalsIgnoreCase("perc"))
					{
						String percent=genericUtility.getColumnValue("perc", dom);
						if(percent!=null && percent.trim().length() > 0)
						{
							float percnum=Float.parseFloat(percent);
							if(percnum < 0 || percnum > 100 )
							{
								errList.add("VMEMPQLF02");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPQLF02"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else
						{
							errList.add("VMEMPQLF03");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPQLF03"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}						
					}
				}
				break;
			case 5 :
				System.out.println("Validation for Detail 5 Employee..........");
				parentNodeList = dom.getElementsByTagName("Detail5");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{	

					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNode.getFirstChild()!= null)
					{
						childNodeValue = childNode.getFirstChild().getNodeValue();
					}
					if(childNodeName.equalsIgnoreCase("train_code"))
					{
						trainCode = genericUtility.getColumnValue("train_code", dom);
						cnt=isValueExist("training","train_code",trainCode, conn);	
						if(cnt == 0)
						{

							errList.add("VMTRG1");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMTRG1"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("train_type"))
					{
						String trainType="";
						trainType = genericUtility.getColumnValue("train_type", dom);
						if(trainType == null || trainType.trim().length() == 0)
						{
							errList.add("VMEMPTRN03");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPTRN03"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}

					}
					if(childNodeName.equalsIgnoreCase("duration"))
					{
						duration = genericUtility.getColumnValue("duration", dom);
						try{							

							if(duration == null || Integer.parseInt(duration) < 0)
							{
								errList.add("VMEMPTRN01");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPTRN01"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						catch(Exception e)
						{
							errList.add("VMEMPTRN01");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPTRN01"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("year"))
					{
						year = genericUtility.getColumnValue("year", dom);
						try
						{
							if(year != null && (year.trim().length() < 4 || Integer.parseInt(year) < 0 || year.indexOf(".") == 1 ))
							{
								errList.add("VMEMPTRN02");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPTRN02"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						catch(Exception e)
						{
							errList.add("VMEMPTRN02");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPTRN02"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
				}
				break;
			case 6 :
				System.out.println("Validation for Detail 6 Employee..........");
				parentNodeList = dom.getElementsByTagName("Detail6");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{	

					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNode.getFirstChild()!= null)
					{
						childNodeValue = childNode.getFirstChild().getNodeValue();
					}
					if(childNodeName.equalsIgnoreCase("emp_code"))
					{

					}
					if(childNodeName.equalsIgnoreCase("gross_amt"))
					{
						grossAmt = genericUtility.getColumnValue("gross_amt", dom);
						//Added by Ahmed on 11/12/2015[AD3DSUN001][START]
						double grossAmtNum = 0d;//Added by Ahmed on 11/12/2015[AD3DSUN001]
						/*if(grossAmt == null || Integer.parseInt(grossAmt) < 0)
						{
							errList.add("VMEMPEXP01");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPEXP01"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}*/
						if(grossAmt != null)
						{
							try
							{
								grossAmtNum = Double.parseDouble(grossAmt);
								if(grossAmtNum < 0)
								{
									errList.add("VMEMPEXP09");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMPEXP09"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								if(grossAmt.trim().length() > 8)
								{
									errList.add("VMEMPEXP07");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMPEXP07"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							catch(Exception e)
							{
								errList.add("VMEMPEXP08");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPEXP08"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else
						{
							errList.add("VMEMPEXP01");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPEXP01"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}


						//Added by Ahmed on 11/12/2015[AD3DSUN001][END]
					}
					if(childNodeName.equalsIgnoreCase("organisation"))
					{
						String organisation= "" ;
						organisation = genericUtility.getColumnValue("organisation", dom);
						if(organisation == null || organisation.trim().length() == 0)
						{
							errList.add("VMEMPEXP04");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPEXP04"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("designation"))
					{
						String designation= "" ;
						designation = genericUtility.getColumnValue("designation", dom);
						if(designation == null || designation.trim().length() == 0)
						{
							errList.add("VMEMPEXP05");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPEXP05"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("from_date"))
					{

						fromDate = genericUtility.getColumnValue("from_date", dom);
						if(fromDate == null || fromDate.trim().length() == 0)
						{
							errList.add("VMEMPEXP06");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPEXP06"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("print_seq"))
					{
						printSeq = genericUtility.getColumnValue("print_seq", dom);
						if(printSeq == null || Integer.parseInt(printSeq) < 0)
						{
							errList.add("VMEMPEXP02");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPEXP02"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("curr_code"))
					{
						currCode = genericUtility.getColumnValue("curr_code", dom);
						//if(currCode != null || currCode.trim().length() > 0) 
						if(currCode != null && currCode.trim().length() > 0) //Modified by Suraj [16/06/2015] [To fix the logical bug]
						{
							cnt=isValueExist("currency","curr_code",currCode, conn);
							if(cnt == 0)
							{
								errList.add("VMEMPEXP03");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPEXP03"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
				}
				break;
			case 7 :
				System.out.println("Validation for Detail 7 Employee..........");
				parentNodeList = dom.getElementsByTagName("Detail7");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{	

					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNode.getFirstChild()!= null)
					{
						childNodeValue = childNode.getFirstChild().getNodeValue();
					}
					if(childNodeName.equalsIgnoreCase("bank_code"))
					{
						bankCode = genericUtility.getColumnValue("bank_code", dom);
						if(bankCode != null && bankCode.trim().length() > 0)
						{
							cnt=isValueExist("bank","bank_code",bankCode, conn);
							if(cnt == 0)
							{
								errList.add("VMEMPBNK01");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPBNK01"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								stanCode = genericUtility.getColumnValue("stan_code", dom);
								empCode = genericUtility.getColumnValue("emp_code", dom);
								if(stanCode != null && stanCode.trim().length() > 0)
								{
									String sqlBc="select count(*) as cnt from bank_stan_serv where bank_code "
											+ "= ? and stan_code = ?";
									pstmt = conn.prepareStatement(sqlBc);
									pstmt.setString(1, bankCode);
									pstmt.setString(2, stanCode);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										cnt=rs.getInt("cnt");
									}
									close(pstmt, rs);
									if(cnt == 0)
									{
										errList.add("VMEMPBNK02");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "VMEMPBNK02"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									else
									{
										paySite = genericUtility.getColumnValue("pay_site", dom1);

										//paySite = getFieldValue("pay_site","employee","emp_code",empCode,conn);
										if(paySite != null && paySite.trim().length() > 0)
										{
											String sqlPs="select count(*) as cnt from bank where bank_code = ? and"
													+ " site_code = (select site_code__acct from site where site_code = ?) ";
											pstmt=conn.prepareStatement(sqlPs);
											pstmt.setString(1, bankCode);
											pstmt.setString(2, paySite);
											rs = pstmt.executeQuery();
											while(rs.next())
											{
												cnt = rs.getInt("cnt");
											}
											close(pstmt, rs);
											if(cnt == 0)
											{
												errList.add("VMEMPBNK03");
												errFields.add(childNodeName.toLowerCase());
												msgType = errorType(conn, "VMEMPBNK03"); 					
												if (msgType.equalsIgnoreCase("E"))
												{
													break;
												}
											}
										}
									}
								}
							}
						}
						else
						{
							errList.add("VMEMPBNK05");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPBNK05"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("amount"))
					{
						amount = genericUtility.getColumnValue("amount", dom);
						if(amount == null || Float.parseFloat(amount) < 0 || amount.trim().length() == 0)
						{
							errList.add("VMEMPBNK04");
							errFields.add(childNodeName.toLowerCase());
							msgType = errorType(conn, "VMEMPBNK04"); 					
							if (msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
						else 
						{
							float amtflt=Float.parseFloat(amount);
							if(amtflt < 0)
							{
								errList.add("VMEMPBNK06");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMEMPBNK06"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
				}
				break;
			}		
			//END SWITCH
			int errListSize = errList.size();
			System.out.println("errListSize:::::::["+errListSize+"]");
			if ( errList != null && errListSize > 0 )
			{
				System.out.println("in error::::::::::");
				for (int i = 0; i < errListSize; i++ )
				{
					System.out.println("in error For:::::::::::::::"); 
					errCode = (String)errList.get(i);
					errFldName = (String)errFields.get(i);
					System.out.println("errCode .........."+errCode);					
					errString = getErrorString( errFldName, errCode, userId );
					System.out.println("errString is : ::::>>>> " + errString);
					msgType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( msgType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;				
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			errString = errStringXml.toString();

		}//END TRY

		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
			errString=e.getMessage();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
			System.out.println(" Employee Validation End and Connection is Closed");
		}
		System.out.println("ErrString ::"+errString);
		return errString;
	}//END OF VALIDATION 




	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("EmployeeEJB:itemChanged value of xmlString ["+xmlString+"]");
			System.out.println("EmployeeEJB:itemChanged value of xmlString ["+xmlString1+"]");
			System.out.println("EmployeeEJB:itemChanged value of xmlString ["+xmlString2+"]");
			System.out.println("objContext ..:: ["+objContext+"]");
			System.out.println("currentColumn ..:: ["+currentColumn+"]");
			System.out.println("editFlag ..:: ["+editFlag+"]");

			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception : Employee :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from contact itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{

		int currentFormNo = 0;
		StringBuffer valueXmlString =null;
		GenericUtility genericUtility = GenericUtility.getInstance();

		String code="";		
		String addDate="";
		String addUser="";
		String addTerm="";
		String chgDate = "";
		String chgUser = "";
		String chgTerm = "";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String columnValue = "";
		String childNodeName = null,childNodeValue = null;
		int ctr=0,childNodeListLength =0,cnt =0;
		String reportToAdmin = "",empLname = "",empFname = "",noticePrd="";
		String contactCode = "",contactName = "",desgnCode="",curAdd2="",conCity="",perTel="",curAdd3="";
		String deptName ="",deptCode ="",cadreCode ="",cadreName ="",gradeCode ="",gradeName ="",lname="",fname="";
		String empSite ="",empSiteName ="",workSiteName ="",workSite ="",designation="",sex="",reportTo="";
		String paySite ="",paySiteName ="",stanCodeHq ="",perState="",probationFlag="",curTel1="",confirmedFlag="";
		String stanCodeHqName ="",curAdd1="",perAdd1="",empCode="",joinedAs="",curCity="",curState="",curPin="";
		String probation="",confirmed="",trainPrd="",probPrd="",joinDate="",probDate="",payMode="",empClass="";
		String empCodeHOD="",occuCode="",posCode="",drivLicNo="",phyHandicap="",funcGroup="",parentDept="";
		String gratNominee="",seqNo="",pfNominee="",penNominee="",gratPerc="",pfPerc="",qlfCode="",penPerc="",bankCode="";
		String gs_runmode = "I",mName="";
		String sql = "",editFlg="",loginSite="";

		ResultSet rs = null;

		PreparedStatement pstmt = null;

		Connection connection = null;
		ConnDriver connDriver = null;

		try
		{
			System.out.println("CURRENT COLUMN:::::"+currentColumn);	
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			addDate = sdf.format(new java.util.Date());
			addUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "logincode");
			addTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			java.util.Date currDate = new java.util.Date();
			chgDate = sdf.format(currDate);	
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			String objNameDefault = checkNull(getObjName(dom ,objContext));
			empCode = genericUtility.getColumnValue("report_to__admin", dom);
			if(editFlag == null || editFlag.trim().length() == 0)
			{	
				editFlg="A";
			} 
			if (objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch (currentFormNo)
			{
			case 1:	
			{
				valueXmlString.append("<Detail1 domID='1' dbID='' objContext='1' objName='"+objNameDefault+"' selected='Y'>\r\n");
				if (currentColumn.equalsIgnoreCase("itm_default"))
				{	
					System.out.println("ItemChange of:::::"+currentColumn);						
					valueXmlString.append("<citizen>").append("<![CDATA[Y]]>").append("</citizen>");
					valueXmlString.append("<training_prd>").append("<![CDATA[0]]>").append("</training_prd>");
					valueXmlString.append("<probation_prd>").append("<![CDATA[0]]>").append("</probation_prd>");
					valueXmlString.append("<notice_prd>").append("<![CDATA[0]]>").append("</notice_prd>");
					//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To set confirmed column as N and non-editable in add mode][start]
					//valueXmlString.append("<confirmed>").append("<![CDATA[Y]]>").append("</confirmed>");
					valueXmlString.append("<confirmed protect=\"1\">").append("<![CDATA[N]]>").append("</confirmed>");
					//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To set confirmed column as N and non-editable in add mode][end]
					//Added by Sana to set name_prefix , basic , gross , salary with_held on itm_default][Start]
					valueXmlString.append("<nationality>").append("<![CDATA[IND]]>").append("</nationality>");
					valueXmlString.append("<pay_mode>").append("<![CDATA[C]]>").append("</pay_mode>");
					valueXmlString.append("<name_prefix>").append("<![CDATA[" ).append("Mr").append( "]]>").append("</name_prefix>"); 
					valueXmlString.append("<basic>").append("<![CDATA[0.00]]>").append("</basic>"); 
					valueXmlString.append("<gross>").append("<![CDATA[0.00]]>").append("</gross>"); 
					valueXmlString.append("<with_held>").append("<![CDATA[N]]>").append("</with_held>");
					//Added by Sana to set name_prefix , basic , gross , salary with_held on itm_default][End]
					//Modified by Ahmed on 30/AUG/2016[A16ESUN005][To set total experience, normal rate and extra working hour column as 0 in add mode][start]
					valueXmlString.append("<tot_exp>").append("<![CDATA[0]]>").append("</tot_exp>");
					valueXmlString.append("<normal_rate>").append("<![CDATA[0]]>").append("</normal_rate>");
					valueXmlString.append("<ot_rate>").append("<![CDATA[0]]>").append("</ot_rate>");
					//Modified by Ahmed on 30/AUG/2016[A16ESUN005][To set total experience, normal rate and extra working hour column as 0 in add mode][end]
				}


				else if(currentColumn.equalsIgnoreCase("itm_defaultedit"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					reportToAdmin = genericUtility.getColumnValue("report_to__admin", dom);
					empClass = genericUtility.getColumnValue("emp_class", dom);
					occuCode = genericUtility.getColumnValue("occupation_code", dom);
					//Added by Anjali Rawankar on[04/04/2017][Start]
					lname="";
					fname="";
					//Added by Anjali Rawankar on[04/04/2017][End]

					if(reportToAdmin != null && reportToAdmin.trim().length() > 0)
					{

						/*Modified by Anjali Rawankar on [04/04/2017][Start]
						 * [Purpose : To Resolve the issue of employee master reported by aditi]

						String sqldefEdit="SELECT EMP_LNAME,EMP_FNAME,TRAINING_PRD,"
							 		+ "PROBATION_PRD,NOTICE_PRD FROM EMPLOYEE WHERE EMP_CODE=?";
						String sqldefEdit="SELECT EMP_LNAME,EMP_FNAME FROM EMPLOYEE WHERE EMP_CODE=?";
						pstmt = connection.prepareStatement(sqldefEdit);
						pstmt.setString(1, reportToAdmin);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							lname=rs.getString("EMP_LNAME");
							fname=rs.getString("EMP_FNAME");
							trainPrd=rs.getString("TRAINING_PRD");
							probPrd=rs.getString("PROBATION_PRD");
							noticePrd=rs.getString("NOTICE_PRD");
						}*/

						String sqldefEdit="SELECT EMP_LNAME,EMP_FNAME FROM EMPLOYEE WHERE EMP_CODE=?";
						pstmt = connection.prepareStatement(sqldefEdit);
						pstmt.setString(1, reportToAdmin);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							lname=rs.getString("EMP_LNAME");
							fname=rs.getString("EMP_FNAME");
						}
						/*Modified by Anjali Rawankar on [04/04/2017][End]
						 * [Purpose : To Resolve the issue of employee master reported by aditi]
						 */
						close(pstmt, rs);
						valueXmlString.append("<admin_fname>").append("<![CDATA[" + fname + "]]>").append("</admin_fname>");
						valueXmlString.append("<admin_lname>").append("<![CDATA[" + lname + "]]>").append("</admin_lname>");
					}
					/*Added by Anjali Rawankar on [04/04/2017][Start]
					 * [Purpose : To Resolve the issue of employee master reported by aditi]
					 */
					empCode = genericUtility.getColumnValue("emp_code", dom);
					String totExp = "0";
					sql = "SELECT TRAINING_PRD,PROBATION_PRD,NOTICE_PRD,GRADE,TOT_EXP FROM EMPLOYEE WHERE EMP_CODE = ?";
					pstmt = connection.prepareStatement(sql);
					pstmt.setString(1, empCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						trainPrd = rs.getString("TRAINING_PRD");
						probPrd = rs.getString("PROBATION_PRD");
						noticePrd = rs.getString("NOTICE_PRD");
						gradeCode = rs.getString("GRADE");
						totExp = rs.getString("TOT_EXP");
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					sql = "";

					if(totExp == null || totExp.trim().length() == 0)
					{
						totExp="0";
						valueXmlString.append("<tot_exp>").append("<![CDATA[" + totExp + "]]>").append("</tot_exp>");
					}
					/*Added by Anjali Rawankar on [04/04/2017][End]
					 * [Purpose : To Resolve the issue of employee master reported by aditi]
					 */
					if(trainPrd == null)
					{
						trainPrd=Integer.toString(0);
						valueXmlString.append("<training_prd>").append("<![CDATA[" + trainPrd + "]]>").append("</training_prd>");
					}
					if(probPrd == null)
					{
						probPrd=Integer.toString(0);
						valueXmlString.append("<probation_prd>").append("<![CDATA[" + probPrd + "]]>").append("</probation_prd>");
					}
					if(noticePrd == null || noticePrd.trim().length() == 0)
					{
						/*Added by Anjali Rawankar on [04/04/2017][Start]
						 * [Purpose : To Resolve the issue of employee master reported by aditi]
						 */
						// noticePrd=Integer.toString(0);
						noticePrd="0";
						/*
						if(gradeCode != null)
						{
							sql = "SELECT NOTICE_PRD FROM GRADE WHERE GRADE_CODE = ?";
							pstmt = connection.prepareStatement(sql);
							pstmt.setString(1, gradeCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								noticePrd = rs.getString("NOTICE_PRD");	
								if(noticePrd == null || noticePrd.trim().length() == 0)
								{
									noticePrd = "0";
								}

							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
						*/
						valueXmlString.append("<notice_prd>").append("<![CDATA[" + noticePrd + "]]>").append("</notice_prd>");
						/*Added by Anjali Rawankar on [04/04/2017][End]
						 * [Purpose : To Resolve the issue of employee master reported by aditi]
						 */
					}					

					/*Commented by anjali Rawankar on[04/04/2017][Start]
					 * [Purpose : To Resolve the issue of employee master reported by aditi]

					valueXmlString.append("<admin_fname>").append("<![CDATA[" + fname + "]]>").append("</admin_fname>");
					valueXmlString.append("<admin_lname>").append("<![CDATA[" + lname + "]]>").append("</admin_lname>");
					valueXmlString.append("<training_prd>").append("<![CDATA[" + trainPrd + "]]>").append("</training_prd>");
					valueXmlString.append("<probation_prd>").append("<![CDATA[" + probPrd + "]]>").append("</probation_prd>");
					valueXmlString.append("<notice_prd>").append("<![CDATA[" + noticePrd + "]]>").append("</notice_prd>");
					}
					Commented by anjali Rawankar on[04/04/2017][End]
					 * [Purpose : To Resolve the issue of employee master reported by aditi]
					 */


					if(empClass != null && empClass.trim().length() > 0)
					{
						String sqlEc="SELECT DESCR FROM GENCODES WHERE FLD_NAME='EMP_CLASS' AND FLD_VALUE =?";
						pstmt = connection.prepareStatement(sqlEc);
						pstmt.setString(1, empClass);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							valueXmlString.append("<class_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</class_descr>");
						}
						else
						{
							valueXmlString.append("<class_descr>").append("<![CDATA[]]>").append("</class_descr>");
						}
						close(pstmt, rs);
					}
					if(occuCode != null && occuCode.trim().length() > 0)
					{
						String sqlEc="SELECT DESCR FROM GENCODES WHERE FLD_NAME='OCCUPATION_CODE' AND FLD_VALUE =?";
						pstmt = connection.prepareStatement(sqlEc);
						pstmt.setString(1, occuCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							valueXmlString.append("<occ_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</occ_descr>");
						}
						else
						{
							valueXmlString.append("<occ_descr>").append("<![CDATA[]]>").append("</occ_descr>");
						}
						close(pstmt, rs);
					}
					//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To set emp_site field as non-editable in edit mode][START]
					empSite = genericUtility.getColumnValue("emp_site", dom);
					confirmed = genericUtility.getColumnValue("confirmed", dom);
					valueXmlString.append("<emp_site protect=\"1\">").append("<![CDATA[" + empSite + "]]>").append("</emp_site>");
					valueXmlString.append("<confirmed protect=\"1\">").append("<![CDATA[" + confirmed + "]]>").append("</confirmed>");
					//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To set emp_site field as non-editable in edit mode][END]
					//Modified by Ahmed on 30/AUG/2016[A16ESUN005][To set contact_state and present state field as non-editable in edit mode][start]
					String contactState = genericUtility.getColumnValue("contact_state", dom);
					String presentState = genericUtility.getColumnValue("cur_state", dom);
					if(contactState != null && contactState.trim().length() > 0)
					{
						valueXmlString.append("<contact_state protect=\"1\">").append("<![CDATA[" + contactState + "]]>").append("</contact_state>");
					}
					if(presentState != null && presentState.trim().length() > 0)
					{
						valueXmlString.append("<cur_state protect=\"1\">").append("<![CDATA[" + presentState + "]]>").append("</cur_state>");
					}
					//Modified by Ahmed on 30/AUG/2016[A16ESUN005][To set contact_state and present state field as non-editable in edit mode][ENd]
				}


				else if(currentColumn.trim().equalsIgnoreCase("contact_code"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);
					lname="";
					fname="";
					mName="";
					contactCode = genericUtility.getColumnValue("contact_code", dom);
					if(editFlg.trim().equals("A"))
					{
						sql = " SELECT NAME FROM CONTACT WHERE CONTACT_CODE = ? " ;	
						pstmt = connection.prepareStatement(sql);
						pstmt.setString(1, contactCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							// To divide the name in parts
							String name=rs.getString("NAME");	
							String[] parts = name.split(" ");
							for(int i=0;i<parts.length;i++)
							{
								if(i == 0)
								{	
									fname=parts[i];									
								}
								if(i> 0 && i < parts.length-1)
								{
									mName=parts[i];									
								}
								if(i== parts.length-1)
								{
									lname=parts[i];									
								}

							}
							valueXmlString.append("<emp_fname>").append("<![CDATA[" + fname + "]]>").append("</emp_fname>");
							valueXmlString.append("<emp_mname>").append("<![CDATA[" + mName + "]]>").append("</emp_mname>");
							valueXmlString.append("<emp_lname>").append("<![CDATA[" + lname +"]]>").append("</emp_lname>");

							empCode=genericUtility.getColumnValue("emp_code", dom);
							if(empCode == null || empCode.trim().length() == 0)
							{
								valueXmlString.append("<emp_code>").append("<![CDATA[" + contactCode +"]]>").append("</emp_code>");
							}
						}
						else
						{
							valueXmlString.append("<emp_fname>").append("<![CDATA[]]>").append("</emp_fname>");
							valueXmlString.append("<emp_mname>").append("<![CDATA[]]>").append("</emp_mname>");
							valueXmlString.append("<emp_lname>").append("<![CDATA[]]>").append("</emp_lname>");
						}
						close(pstmt, rs);

						//Added by Sana [10-12-2015][To populate shortname , contact person, address , city , pin , statecode , telephone on itemchange of contact_code][Start]

						sql = "SELECT SH_NAME , CONT_PERS, ADDR1 , ADDR2, ADDR3 , CITY , PIN , STATE_CODE ,TELE1 , TELE2, TELE3 FROM CONTACT WHERE CONTACT_CODE = ?";
						pstmt = connection.prepareStatement(sql);
						pstmt.setString(1,contactCode);
						rs= pstmt.executeQuery();
						if(rs.next())
						{
							valueXmlString.append("<short_name>").append("<![CDATA[" + rs.getString("SH_NAME") + "]]>").append("</short_name>");
							valueXmlString.append("<contact_pers>").append("<![CDATA[" + rs.getString("CONT_PERS") + "]]>").append("</contact_pers>");
							valueXmlString.append("<cur_add1>").append("<![CDATA[" + rs.getString("ADDR1") + "]]>").append("</cur_add1>");
							valueXmlString.append("<cur_add2>").append("<![CDATA[" + rs.getString("ADDR2") + "]]>").append("</cur_add2>");
							valueXmlString.append("<cur_add3>").append("<![CDATA[" + rs.getString("ADDR3") + "]]>").append("</cur_add3>");
							valueXmlString.append("<cur_city>").append("<![CDATA[" + rs.getString("CITY") + "]]>").append("</cur_city>");
							valueXmlString.append("<cur_pin>").append("<![CDATA[" + rs.getString("PIN") + "]]>").append("</cur_pin>");
							valueXmlString.append("<cur_state>").append("<![CDATA[" + rs.getString("STATE_CODE") + "]]>").append("</cur_state>");
							valueXmlString.append("<cur_tel1>").append("<![CDATA[" + rs.getString("TELE1") + "]]>").append("</cur_tel1>");
							valueXmlString.append("<cur_tel2>").append("<![CDATA[" + rs.getString("TELE2") + "]]>").append("</cur_tel2>");
							valueXmlString.append("<cur_tel3>").append("<![CDATA[" + rs.getString("TELE3") + "]]>").append("</cur_tel3>");
							valueXmlString.append("<per_add1>").append("<![CDATA[" + rs.getString("ADDR1") + "]]>").append("</per_add1>");
							valueXmlString.append("<per_add2>").append("<![CDATA[" + rs.getString("ADDR2") + "]]>").append("</per_add2>");
							valueXmlString.append("<per_add3>").append("<![CDATA[" + rs.getString("ADDR3") + "]]>").append("</per_add3>");
							valueXmlString.append("<per_city>").append("<![CDATA[" + rs.getString("CITY") + "]]>").append("</per_city>");
							valueXmlString.append("<per_pin>").append("<![CDATA[" + rs.getString("PIN") + "]]>").append("</per_pin>");
							valueXmlString.append("<per_state>").append("<![CDATA[" + rs.getString("STATE_CODE") + "]]>").append("</per_state>");
							valueXmlString.append("<per_tel>").append("<![CDATA[" + rs.getString("TELE1") + "]]>").append("</per_tel>");

						}
						close(pstmt,rs);


						sql = "SELECT SEX , NATIONALITY FROM EMPLOYEE WHERE CONTACT_CODE = ?";
						pstmt = connection.prepareStatement(sql);
						pstmt.setString(1, contactCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							valueXmlString.append("<sex>").append("<![CDATA[" + rs.getString("SEX") + "]]>").append("</sex>");
							valueXmlString.append("<nationality>").append("<![CDATA[" + rs.getString("NATIONALITY") + "]]>").append("</nationality>");
						}
						close(pstmt,rs);

						//Added by Sana [10-12-2015][To populate shortname , contact person, address , city , pin , statecode , telephone on itemchange of contact_code][End]

					}
				}



				else if(currentColumn.trim().equalsIgnoreCase("design_code"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					desgnCode = genericUtility.getColumnValue("design_code", dom);
					sql = " SELECT DESIGNATION FROM DESIGNATION WHERE DESIGN_CODE = ? " ;	
					pstmt = connection.prepareStatement(sql);
					pstmt.setString(1, desgnCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						valueXmlString.append("<designation>").append("<![CDATA[" + rs.getString("DESIGNATION") + "]]>").append("</designation>");
					}
					else
					{
						valueXmlString.append("<designation>").append("<![CDATA[]]>").append("</designation>");
					}
					close(pstmt, rs);
				}


				else if(currentColumn.trim().equalsIgnoreCase("dept_code"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					deptCode = genericUtility.getColumnValue("dept_code", dom);
					funcGroup = genericUtility.getColumnValue("func_group", dom);
					parentDept = genericUtility.getColumnValue("parent_dept", dom);

					sql = " SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE = ? " ;
					pstmt = connection.prepareStatement(sql);

					pstmt.setString(1, deptCode);

					rs = pstmt.executeQuery();

					if(rs.next())
					{
						valueXmlString.append("<department_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</department_descr>");

						// if(funcGroup==null || funcGroup.trim().length() == 0) Commented by Sana [Request ID : A15HSUN001][Start]
						//  valueXmlString.append("<func_group>").append("<![CDATA[" + deptCode + "]]>").append("</func_group>");
						//  valueXmlString.append("<func_group_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</func_group_descr>");

						/* else
							 {
								 valueXmlString.append("<func_group>").append("<![CDATA[]]>").append("</func_group>");
								 valueXmlString.append("<func_group_descr>").append("<![CDATA[]]>").append("</func_group_descr>");
							 }*/ // Modified by Suraj [03/06/2015] [To fix the bug]

						// if(parentDept==null || parentDept.trim().length() == 0) 
						// valueXmlString.append("<parent_dept>").append("<![CDATA[" + deptCode + "]]>").append("</parent_dept>");
						// valueXmlString.append("<parent_dept_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</parent_dept_descr>");

						//Commented by Sana [Request ID : A15HSUN001][End]


						/* else
							 {
								 valueXmlString.append("<parent_dept>").append("<![CDATA[]]>").append("</parent_dept>");
								 valueXmlString.append("<parent_dept_descr>").append("<![CDATA[]]>").append("</parent_dept_descr>");
							 }*/// Modified by Suraj [03/06/2015] [To fix the bug]
					}
					else
					{
						valueXmlString.append("<department_descr>").append("<![CDATA[]]>").append("</department_descr>");
					}

					close(pstmt, rs);

					//Added by Sana [Request ID : A15HSUN001][To add DEPT_HIERARCHY ,EMP_CODE__FUNCHEAD,funchead_name,bu_code,bu_descr,emp_code__buhead,buhead_name][Start]

					sql = "SELECT D.DEPT_CODE__PARENT AS PARENT_DEPT,  FN_GET_DEPT_DESCR( D.DEPT_CODE__PARENT ) AS PARENT_DESCR FROM DEPARTMENT D WHERE D.DEPT_CODE = ?  AND D.DEPT_CODE__PARENT IS NOT NULL AND D.DEPT_CODE <> D.DEPT_CODE__PARENT";
					pstmt = connection.prepareStatement(sql);
					pstmt.setString(1,deptCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{	
						valueXmlString.append("<parent_dept>").append("<![CDATA[" + rs.getString("PARENT_DEPT") +"]]>").append("</parent_dept>");
						valueXmlString.append("<parent_dept_descr>").append("<![CDATA[" + rs.getString("PARENT_DESCR") + "]]>").append("</parent_dept_descr>");

					}
					//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To remove value from parent dept and descr if dept code is not valid][START]
					else
					{
						valueXmlString.append("<parent_dept>").append("<![CDATA[]]>").append("</parent_dept>");
						valueXmlString.append("<parent_dept_descr>").append("<![CDATA[]]>").append("</parent_dept_descr>");
					}
					//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To remove value from parent dept and descr if dept code is not valid][END]
					close(pstmt , rs);

					sql="SELECT FN_DEPT_HIER_DESC(?) AS DEPT_HIERARCHY FROM DUAL";
					pstmt= connection.prepareStatement(sql);
					pstmt.setString(1,deptCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						valueXmlString.append("<dept_hierarchy>").append("<![CDATA[" + rs.getString("DEPT_HIERARCHY") + "]]>").append("</dept_hierarchy>");
					}
					//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To remove value from department hierarchy  if dept code is not valid][START]
					else
					{
						valueXmlString.append("<dept_hierarchy>").append("<![CDATA[]]>").append("</dept_hierarchy>");
					}
					//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To remove value from department hierarchy if dept code is not valid][END]
					close(pstmt,rs);

					//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To not set function code, function head, business unit code and business unit head on itemchange of department code][start]
					/*sql = "SELECT D.FUNC_CODE AS FUNC_CODE, FN_GET_BUFUNC_DESCR(D.FUNC_CODE) AS FUNC_DESCR FROM DEPARTMENT D WHERE D.DEPT_CODE = ? ";
						pstmt = connection.prepareStatement(sql);
						pstmt.setString(1,deptCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{	
							valueXmlString.append("<func_group>").append("<![CDATA[" + rs.getString("FUNC_CODE") +"]]>").append("</func_group>");
							valueXmlString.append("<func_group_descr>").append("<![CDATA[" + rs.getString("FUNC_DESCR") + "]]>").append("</func_group_descr>");
						}
						close(pstmt,rs);

			            String funcHead="";
			            sql="SELECT EMP_CODE__FUNCHEAD FROM DEPARTMENT  WHERE DEPT_CODE = ? ";
			            pstmt = connection.prepareStatement(sql);
			            pstmt.setString(1, deptCode);
			            rs=pstmt.executeQuery();
			            if(rs.next()){
			            	funcHead = checkNull(rs.getString("EMP_CODE__FUNCHEAD"));
			            }


			            close(pstmt,rs);

			            String headName="";
			            sql="SELECT FN_GET_EMP_NAME(?,'X') AS HEAD_NAME FROM DUAL";
			            pstmt= connection.prepareStatement(sql);
			            pstmt.setString(1,funcHead);
			            rs=pstmt.executeQuery();
			            if(rs.next()){
			              	headName = checkNull(rs.getString("HEAD_NAME"));
			            }
			            valueXmlString.append("<emp_code__funchead><![CDATA[").append(funcHead).append("]]></emp_code__funchead>\r\n");
						valueXmlString.append("<funchead_name><![CDATA[").append(headName).append("]]></funchead_name>\r\n");

			            close(pstmt,rs);


			            String bu_code="";
			            String bu_descr="";
			            sql="SELECT D.BU_CODE AS BU_CODE, B.DESCR AS BU_DESCR FROM DEPARTMENT D, BUSINESS_UNITS B WHERE D.DEPT_CODE = ?  AND B.BU_CODE = D.BU_CODE";
			            pstmt = connection.prepareStatement(sql);
			            pstmt.setString(1,deptCode);
			            rs=pstmt.executeQuery();
			            if(rs.next()){
			            	bu_code= checkNull(rs.getString("BU_CODE"));
			            	bu_descr= checkNull(rs.getString("BU_DESCR"));
			            }
			            valueXmlString.append("<bu_code><![CDATA[").append(bu_code).append("]]></bu_code>\r\n");
						valueXmlString.append("<bu_descr><![CDATA[").append(bu_descr).append("]]></bu_descr>\r\n");

						close(pstmt,rs);

						String bu_head="";
						String bu_headName= "";
						sql="SELECT EMP_CODE__HEAD FROM BUSINESS_UNITS WHERE BU_CODE = ? ";
						pstmt = connection.prepareStatement(sql);
						pstmt.setString(1, bu_code);
						rs=pstmt.executeQuery();
						if(rs.next()){
							bu_head=checkNull(rs.getString("EMP_CODE__HEAD"));
						}

						close(pstmt,rs);

						sql="SELECT FN_GET_EMP_NAME(?,'X') AS BU_HEAD_NAME FROM DUAL";
						pstmt = connection.prepareStatement(sql);
						pstmt.setString(1, bu_head);
						rs=pstmt.executeQuery();
						if(rs.next()){
							bu_headName=checkNull(rs.getString("BU_HEAD_NAME"));
						}

						 valueXmlString.append("<emp_code__buhead><![CDATA[").append(bu_head).append("]]></emp_code__buhead>\r\n");
						 valueXmlString.append("<buhead_name><![CDATA[").append(bu_headName).append("]]></buhead_name>\r\n");

							close(pstmt,rs);*/
					//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To not set function code, function head, business unit code and business unit head on itemchange of department code][end]
					//Added by Sana [Request ID : A15HSUN001][To add DEPT_HIERARCHY ,EMP_CODE__FUNCHEAD,funchead_name,bu_code,bu_descr,emp_code__buhead,buhead_name][End]
				}
				//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To set description of function code, function head, business unit and business unit head][START]
				else if(currentColumn.trim().equalsIgnoreCase("func_group"))
				{
					funcGroup = genericUtility.getColumnValue("func_group", dom);
					sql = "SELECT FN_GET_BUFUNC_DESCR(?) AS FUNC_DESCR FROM DUAL";
					pstmt = connection.prepareStatement(sql);
					pstmt.setString(1, funcGroup);
					rs = pstmt.executeQuery();
					String funcDescr = "";
					if(rs.next())
					{	
						funcDescr = checkNull(rs.getString("FUNC_DESCR"));
					}
					close(pstmt,rs);
					valueXmlString.append("<func_group_descr>").append("<![CDATA[" + funcDescr + "]]>").append("</func_group_descr>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("emp_code__funchead"))
				{
					String empCodeFuncHead = genericUtility.getColumnValue("emp_code__funchead", dom);
					sql = "SELECT FN_GET_EMP_NAME(?, 'X') AS FUNCHEAD_NAME FROM DUAL";
					pstmt = connection.prepareStatement(sql);
					pstmt.setString(1, empCodeFuncHead);
					rs = pstmt.executeQuery();
					String funcHeadName = "";
					if(rs.next())
					{	
						funcHeadName = checkNull(rs.getString("FUNCHEAD_NAME"));
					}
					close(pstmt,rs);
					valueXmlString.append("<funchead_name>").append("<![CDATA[" + funcHeadName + "]]>").append("</funchead_name>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("bu_code"))
				{
					String buCode = genericUtility.getColumnValue("bu_code", dom);
					sql = "SELECT DESCR, EMP_CODE__HEAD, FN_GET_EMP_NAME(EMP_CODE__HEAD, 'X') AS BUHEAD_NAME FROM BUSINESS_UNITS WHERE BU_CODE = ?";
					pstmt = connection.prepareStatement(sql);
					pstmt.setString(1, buCode);
					rs = pstmt.executeQuery();
					String buHeadName = "", buDescr = "", empCodeBuHead = "";
					if(rs.next())
					{	
						buDescr = checkNull(rs.getString("DESCR"));
						empCodeBuHead = checkNull(rs.getString("EMP_CODE__HEAD"));
						buHeadName = checkNull(rs.getString("BUHEAD_NAME"));
					}
					close(pstmt,rs);
					valueXmlString.append("<bu_descr>").append("<![CDATA[" + buDescr + "]]>").append("</bu_descr>");
					valueXmlString.append("<emp_code__buhead>").append("<![CDATA[" + empCodeBuHead + "]]>").append("</emp_code__buhead>\r\n");
					valueXmlString.append("<buhead_name>").append("<![CDATA[" + buHeadName + "]]>").append("</buhead_name>\r\n");
				}
				//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To set description of function code, function head, business unit and business unit head][END]
				else if(currentColumn.trim().equalsIgnoreCase("grade_code"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					gradeCode = genericUtility.getColumnValue("grade_code", dom);
					String gradeCodedoc = genericUtility.getColumnValue("cadre_code", dom);
					sql = " SELECT DESCR,CADRE_CODE FROM GRADE WHERE GRADE_CODE = ? " ;	
					pstmt = connection.prepareStatement(sql);
					pstmt.setString(1, gradeCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						cadreCode=rs.getString("CADRE_CODE");
						valueXmlString.append("<grade_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</grade_descr>");

						if(gradeCodedoc == null || editFlg.equals("A"))
						{
							valueXmlString.append("<cadre_code>").append("<![CDATA[" + cadreCode + "]]>").append("</cadre_code>");								 	
							sql = " SELECT DESCR FROM CADRE WHERE CADRE_CODE = ? " ;
							pstmt = connection.prepareStatement(sql);
							pstmt.setString(1, cadreCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								valueXmlString.append("<cadre_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</cadre_descr>");
							}
						}
					}
					else
					{
						valueXmlString.append("<grade_descr>").append("<![CDATA[]]>").append("</grade_descr>");
					}
					close(pstmt, rs);

				}

				else if(currentColumn.trim().equalsIgnoreCase("cadre_code"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					cadreCode = genericUtility.getColumnValue("cadre_code", dom);
					sql = " SELECT DESCR FROM CADRE WHERE CADRE_CODE = ? " ;	
					pstmt = connection.prepareStatement(sql);
					pstmt.setString(1, cadreCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						valueXmlString.append("<cadre_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</cadre_descr>");
					}
					else
					{
						valueXmlString.append("<cadre_descr>").append("<![CDATA[]]>").append("</cadre_descr>");
					}
					close(pstmt, rs);
				}


				else if(currentColumn.trim().equalsIgnoreCase("emp_site"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					empSite = genericUtility.getColumnValue("emp_site", dom);
					paySite = genericUtility.getColumnValue("pay_site", dom);
					if(paySite == null || paySite.trim().length() == 0)
					{
						valueXmlString.append("<pay_site>").append("<![CDATA[" + empSite + "]]>").append("</pay_site>");
					}
					workSite = genericUtility.getColumnValue("work_site", dom);
					if(workSite == null || workSite.trim().length() == 0)
					{
						valueXmlString.append("<work_site>").append("<![CDATA[" + empSite + "]]>").append("</work_site>");
					}
				}


				else if(currentColumn.trim().equalsIgnoreCase("report_to__admin"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					reportToAdmin = genericUtility.getColumnValue("report_to__admin", dom);
					sql = " SELECT EMP_FNAME,EMP_LNAME,EMP_MNAME FROM EMPLOYEE WHERE EMP_CODE = ? " ;	
					pstmt = connection.prepareStatement(sql);
					pstmt.setString(1, reportToAdmin);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						valueXmlString.append("<admin_fname>").append("<![CDATA[" + rs.getString("EMP_FNAME") + "]]>").append("</admin_fname>");
						valueXmlString.append("<admin_lname>").append("<![CDATA[" + rs.getString("EMP_LNAME") + "]]>").append("</admin_lname>");
						valueXmlString.append("<admin_mname>").append("<![CDATA[" + rs.getString("EMP_MNAME") + "]]>").append("</admin_mname>");
					}
					else
					{
						valueXmlString.append("<admin_fname>").append("<![CDATA[]]>").append("</admin_fname>");
						valueXmlString.append("<admin_mname>").append("<![CDATA[]]>").append("</admin_mname>");
						valueXmlString.append("<admin_lname>").append("<![CDATA[]]>").append("</admin_lname>");
					}
					close(pstmt, rs);
				}
				else if(currentColumn.trim().equalsIgnoreCase("report_to"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					reportTo = genericUtility.getColumnValue("report_to", dom);
					sql = " SELECT EMP_FNAME,EMP_LNAME,EMP_MNAME FROM EMPLOYEE WHERE EMP_CODE = ? " ;
					pstmt = connection.prepareStatement(sql);
					pstmt.setString(1, reportTo);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						valueXmlString.append("<report_fname>").append("<![CDATA[" + rs.getString("EMP_FNAME") + "]]>").append("</report_fname>");
						valueXmlString.append("<report_lname>").append("<![CDATA[" + rs.getString("EMP_LNAME") + "]]>").append("</report_lname>");
						valueXmlString.append("<report_mname>").append("<![CDATA[" + rs.getString("EMP_MNAME") + "]]>").append("</report_mname>");
					}
					else
					{
						valueXmlString.append("<report_fname>").append("<![CDATA[]]>").append("</report_fname>");
						valueXmlString.append("<report_mname>").append("<![CDATA[]]>").append("</report_mname>");
						valueXmlString.append("<report_lname>").append("<![CDATA[]]>").append("</report_lname>");
					}
					close(pstmt, rs);
				}
				else if(currentColumn.trim().equalsIgnoreCase("designation"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					designation = genericUtility.getColumnValue("designation", dom);
					joinedAs = genericUtility.getColumnValue("joined_as", dom); 
					if(joinedAs == null || joinedAs.trim().length() == 0)
					{
						valueXmlString.append("<joined_as>").append("<![CDATA["+designation+"]]>").append("</joined_as>");
					}
					else
					{
						valueXmlString.append("<joined_as>").append("<![CDATA[]]>").append("</joined_as>");
					}
					designation="";
					joinedAs="";
				}
				else if(currentColumn.trim().equalsIgnoreCase("sex"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);


					sex = genericUtility.getColumnValue("sex", dom);
					System.out.println("Sex is"+sex);
					if(sex.equals("M"))
					{
						valueXmlString.append("<name_prefix>").append("<![CDATA[" ).append("Mr").append( "]]>").append("</name_prefix>");
					}
					else
					{
						valueXmlString.append("<name_prefix>").append("<![CDATA[" ).append("Ms").append( "]]>").append("</name_prefix>");
					}

				}
				else if(currentColumn.trim().equalsIgnoreCase("cur_add1"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);
					if(!gs_runmode.equals("B"))
					{
						curAdd1 = genericUtility.getColumnValue("cur_add1", dom);
						perAdd1 = genericUtility.getColumnValue("per_add1", dom);
						if(editFlg.trim().equals("A"))
						{
							perAdd1="";
						}
						else
						{		
							perAdd1 ="";
							empCode = genericUtility.getColumnValue("emp_code", dom);
							String sqlCa = "SELECT PER_ADD1 FROM EMPLOYEE WHERE EMP_CODE=?";
							pstmt = connection.prepareStatement(sqlCa);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								perAdd1 = rs.getString("PER_ADD1");
							}
							close(pstmt, rs);
						}
						if(perAdd1 == null || perAdd1.trim().length() == 0)
						{
							valueXmlString.append("<per_add1>").append("<![CDATA[" ).append(curAdd1).append( "]]>").append("</per_add1>");
						}
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("cur_add2"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);
					if(!gs_runmode.equals("B"))
					{
						curAdd2 = genericUtility.getColumnValue("cur_add2", dom);
						perAdd1 = genericUtility.getColumnValue("per_add1", dom);
						if(editFlg.trim().equals("A"))
						{
							perAdd1="";
						}
						else
						{	
							perAdd1="";
							empCode = genericUtility.getColumnValue("emp_code", dom);
							String sqlCa = "SELECT PER_ADD1 FROM EMPLOYEE WHERE EMP_CODE=?";
							pstmt = connection.prepareStatement(sqlCa);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								perAdd1 = rs.getString("PER_ADD1");
							}
							close(pstmt, rs);
						}
						if(perAdd1 == null || perAdd1.trim().length() == 0)
						{
							valueXmlString.append("<per_add2>").append("<![CDATA[" ).append(curAdd2).append( "]]>").append("</per_add2>");
						}
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("cur_add3"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);
					if(!gs_runmode.equals("B"))
					{
						curAdd3 = genericUtility.getColumnValue("cur_add3", dom);
						perAdd1 = genericUtility.getColumnValue("per_add1", dom);
						if(editFlg.trim().equals("A"))
						{
							perAdd1="";
						}
						else
						{		
							perAdd1="";
							empCode = genericUtility.getColumnValue("emp_code", dom);
							String sqlCa = "SELECT PER_ADD1 FROM EMPLOYEE WHERE EMP_CODE=?";
							pstmt = connection.prepareStatement(sqlCa);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								perAdd1 = rs.getString("PER_ADD1");
							}
							close(pstmt, rs);
						}
						if(perAdd1 == null || perAdd1.trim().length() == 0)
						{
							valueXmlString.append("<per_add3>").append("<![CDATA[" ).append(curAdd3).append( "]]>").append("</per_add3>");
						}
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("cur_city"))
				{

					System.out.println("ItemChange of:::::"+currentColumn);
					if(!gs_runmode.equals("B"))
					{
						curCity = genericUtility.getColumnValue("cur_city", dom);
						perAdd1 = genericUtility.getColumnValue("per_add1", dom);
						if(editFlg.trim().equals("A"))
						{
							perAdd1="";
						}
						else
						{							
							empCode = genericUtility.getColumnValue("emp_code", dom);
							String sqlCa = "SELECT PER_ADD1 FROM EMPLOYEE WHERE EMP_CODE=?";
							pstmt = connection.prepareStatement(sqlCa);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								perAdd1 = rs.getString("PER_ADD1");
							}
							close(pstmt, rs);
						}
						String sqlSt="SELECT STATE_CODE FROM STATION WHERE DESCR=TRIM(?)";
						pstmt = connection.prepareStatement(sqlSt);
						pstmt.setString(1, curCity);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							perState = rs.getString("STATE_CODE");
						}
						close(pstmt, rs);
						if(perAdd1 == null || perAdd1.trim().length() == 0)
						{
							valueXmlString.append("<per_city>").append("<![CDATA[" ).append(curCity).append( "]]>").append("</per_city>");
							valueXmlString.append("<per_state>").append("<![CDATA[" ).append(perState).append( "]]>").append("</per_state>");
						}
						valueXmlString.append("<cur_state>").append("<![CDATA[" ).append(perState).append( "]]>").append("</cur_state>");
						if(perState.trim().length() > 0)
						{
							valueXmlString.append("<cur_state protect=\"1\"><![CDATA["+perState+"]]></cur_state>\r\n");
						}
						else
						{
							valueXmlString.append("<cur_state protect=\"0\"><![CDATA[]]></cur_state>\r\n");
						}
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("cur_state"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);
					if(!gs_runmode.equals("B"))
					{
						curState = genericUtility.getColumnValue("cur_state", dom);
						System.out.println("Current State::::::::" + curState);
						perAdd1 = genericUtility.getColumnValue("per_add1", dom);							  
						if(editFlg.trim().equals("A"))
						{
							perAdd1="";
						}
						else
						{		
							perAdd1="";
							empCode = genericUtility.getColumnValue("emp_code", dom);
							System.out.println("Employee code::::::::"+empCode);								 
							String sqlCa = "SELECT PER_ADD1 FROM EMPLOYEE WHERE EMP_CODE=?";
							pstmt = connection.prepareStatement(sqlCa);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								perAdd1 = rs.getString("PER_ADD1");
							}
							close(pstmt, rs);								  
						}
						if(perAdd1 == null || perAdd1.trim().length() == 0)
						{
							valueXmlString.append("<per_state>").append("<![CDATA[" ).append(curState).append( "]]>").append("</per_state>");
						}
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("cur_pin"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);
					if(!gs_runmode.equals("B"))
					{
						curPin = genericUtility.getColumnValue("cur_pin", dom);
						perAdd1 = genericUtility.getColumnValue("per_add1", dom);
						if(editFlg.trim().equals("A"))
						{
							perAdd1="";
						}
						else
						{							
							empCode = genericUtility.getColumnValue("emp_code", dom);
							String sqlCa = "SELECT PER_ADD1 FROM EMPLOYEE WHERE EMP_CODE=?";
							pstmt = connection.prepareStatement(sqlCa);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								perAdd1 = rs.getString("PER_ADD1");
							}
							close(pstmt, rs);
						}
						if(perAdd1 == null || perAdd1.trim().length() == 0)
						{
							valueXmlString.append("<per_pin>").append("<![CDATA[" ).append(curPin).append( "]]>").append("</per_pin>");
						}
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("cur_tel1"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);
					if(!gs_runmode.equals("B"))
					{
						curTel1 = genericUtility.getColumnValue("cur_tel1", dom);
						perTel = genericUtility.getColumnValue("per_tel", dom);
						if(editFlg.trim().equals("A"))
						{
							perTel="";
						}
						else
						{							
							empCode = genericUtility.getColumnValue("emp_code", dom);
							String sqlCa = "SELECT PER_TEL FROM EMPLOYEE WHERE EMP_CODE=?";
							pstmt = connection.prepareStatement(sqlCa);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								perTel = rs.getString("PER_ADD1");
							}
							close(pstmt, rs);
						}
						if(perTel == null || perTel.trim().length() == 0)
						{
							valueXmlString.append("<per_tel>").append("<![CDATA[" ).append(curTel1).append( "]]>").append("</per_tel>");
						}
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("per_city"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);
					if(!gs_runmode.equals("B"))
					{
						conCity = genericUtility.getColumnValue("contact_city", dom);
						String sqlConCity="SELECT STATE_CODE FROM STATION WHERE DESCR=TRIM(?)";
						pstmt = connection.prepareStatement(sqlConCity);
						pstmt.setString(1, conCity);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							perState = rs.getString("STATE_CODE");
							valueXmlString.append("<per_state>").append("<![CDATA[" ).append(perState).append( "]]>").append("</per_state>");

						}
						close(pstmt, rs);
					}
				}

				else if(currentColumn.trim().equalsIgnoreCase("contact_city"))
				{
					if(!gs_runmode.equals("B"))
					{
						System.out.println("ItemChange of:::::"+currentColumn);

						conCity = genericUtility.getColumnValue("contact_city", dom);
						String sqlConCity="SELECT STATE_CODE FROM STATION WHERE DESCR=TRIM(?)";
						pstmt = connection.prepareStatement(sqlConCity);
						pstmt.setString(1, conCity);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							perState = rs.getString("STATE_CODE");
							//valueXmlString.append("<contact_state>").append("<![CDATA[" ).append(perState).append( "]]>").append("</contact_state>");//Modified by Ahmed on 30/AUG/2016 to disable contact state field on item change of contact city[A16ESUN005]
						}
						close(pstmt, rs);
						//Modified by Ahmed on 30/AUG/2016 to disable contact state field on item change of contact city when contact STATE is not null[A16ESUN005][START]
						if(perState != null && perState.trim().length() > 0)
						{
							valueXmlString.append("<contact_state protect=\"1\">").append("<![CDATA[" ).append(perState).append( "]]>").append("</contact_state>");
						}
						else
						{
							valueXmlString.append("<contact_state protect=\"0\">").append("<![CDATA[" ).append(perState).append( "]]>").append("</contact_state>");
						}
						//Modified by Ahmed on 30/AUG/2016 to disable contact state field on item change of contact city when contact STATE is not null[A16ESUN005][END]
					}
				}

				else if(currentColumn.trim().equalsIgnoreCase("probation_prd"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					if(gs_runmode.equals("I"))
					{
						String date="";
						Date probDt = null;
						Date probDt1=null;
						float trainPrdint=0;
						float probPrdint=0;
						empCode = genericUtility.getColumnValue("emp_code", dom);
						probation = genericUtility.getColumnValue("probation", dom);
						confirmed = genericUtility.getColumnValue("confirmed", dom);
						trainPrd = genericUtility.getColumnValue("training_prd", dom);
						probPrd = genericUtility.getColumnValue("probation_prd", dom);
						joinDate = genericUtility.getColumnValue("date_join", dom);
						probDate = genericUtility.getColumnValue("probation_date", dom);							 
						if(trainPrd != null)
						{
							trainPrdint = Float.parseFloat(trainPrd);
						}
						if(probPrd != null)
						{
							probPrdint = Float.parseFloat(probPrd);
						}
						if(probDate != null)
						{
							probDt = sdf.parse(probDate);
						}

						if(probPrdint == 0)
						{
							if(probDt != null)
							{
								probDt1 = probDt;  								
								date=sdf.format(probDt1);
								valueXmlString.append("<date_conf>").append("<![CDATA[" ).append(date).append( "]]>").append("</date_conf>");
							}
							else
							{
								valueXmlString.append("<date_conf>").append("<![CDATA[]]>").append("</date_conf>");  
							}
						}
						else
						{
							if(probDt != null)
							{
								probDt1 = addMonths(probDt,probPrdint);
								date=sdf.format(probDt1);
								valueXmlString.append("<date_conf>").append("<![CDATA[" ).append(date).append( "]]>").append("</date_conf>");
							}
							else
							{
								valueXmlString.append("<date_conf>").append("<![CDATA[]]>").append("</date_conf>");	
							}
						}

						if(probPrdint == 0 && (trainPrdint == 0 || probationFlag.equals("Y")))
						{								 
							valueXmlString.append("<confirmed>").append("<![CDATA[Y]]>").append("</confirmed>");
						}
						else
						{
							valueXmlString.append("<confirmed>").append("<![CDATA[N]]>").append("</confirmed>");
						}
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("training_prd"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					if(gs_runmode.equals("I"))
					{

						String date="";
						Date joinDt=null;
						Date joinDt1=null;
						float trainPrdint=0;
						float probPrdint=0;
						empCode = genericUtility.getColumnValue("emp_code", dom);
						probation = genericUtility.getColumnValue("probation", dom);							 
						trainPrd = genericUtility.getColumnValue("training_prd", dom);
						probPrd = genericUtility.getColumnValue("probation_prd", dom);
						joinDate = genericUtility.getColumnValue("date_join", dom);
						probDate = genericUtility.getColumnValue("probation_date", dom);
						if(trainPrd != null)
						{
							trainPrdint = Float.parseFloat(trainPrd);
						}
						if(probPrd != null)
						{
							probPrdint = Float.parseFloat(probPrd);
						}
						if(joinDate != null)
						{
							joinDt = sdf.parse(joinDate);
						}
						if(joinDt != null)
						{
							joinDt1 = joinDt;  


							if(trainPrd== null || trainPrdint == 0)
							{

								date=sdf.format(joinDt1);
								valueXmlString.append("<probation_date>").append("<![CDATA[" ).append(date).append( "]]>").append("</probation_date>");
							}
							else
							{
								joinDt1 = addMonths(joinDt,trainPrdint);
								date=sdf.format(joinDt1);
								valueXmlString.append("<probation_date>").append("<![CDATA[" ).append(date).append( "]]>").append("</probation_date>");

							}
							if(probPrd != null)
							{
								joinDt1 = addMonths(joinDt1,probPrdint); 
								date=sdf.format(joinDt1);
								valueXmlString.append("<date_conf>").append("<![CDATA[" ).append(date).append( "]]>").append("</date_conf>");
							}
						}
						else
						{
							valueXmlString.append("<probation_date>").append("<![CDATA[]]>").append("</probation_date>");
							valueXmlString.append("<date_conf>").append("<![CDATA[]]>").append("</date_conf>");
						}
						if(trainPrdint == 0)
						{
							probationFlag = "Y";
							valueXmlString.append("<probation>").append("<![CDATA["+ probationFlag +"]]>").append("</probation>");
						}
						else
						{
							probationFlag = "N";
							valueXmlString.append("<probation>").append("<![CDATA["+ probationFlag +"]]>").append("</probation>");
						}
						if(probPrdint == 0 && (trainPrdint == 0 || probationFlag.equals("Y")))
						{
							confirmedFlag = "Y";
							valueXmlString.append("<probation>").append("<![CDATA[" ).append(probationFlag).append( "]]>").append("</probation>");
							valueXmlString.append("<confirmed>").append("<![CDATA[" ).append(confirmedFlag).append( "]]>").append("</confirmed>");
						}
						else
						{
							confirmedFlag = "N";
							valueXmlString.append("<probation>").append("<![CDATA[" ).append(probationFlag).append( "]]>").append("</probation>");
							valueXmlString.append("<confirmed>").append("<![CDATA[" ).append(confirmedFlag).append( "]]>").append("</confirmed>");
						}
					}

				}
				else if(currentColumn.trim().equalsIgnoreCase("date_join"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					if(gs_runmode.equals("I"))
					{
						String date="";
						Date joinDt1=null;
						Date probDt1=null;
						Date probDt = null;
						Date joinDt = null;
						float trainPrdint=0,probPrdint=0;							  
						joinDate = genericUtility.getColumnValue("date_join", dom); 
						System.out.println("joinDt::::::::"+joinDt);
						probDate = genericUtility.getColumnValue("probation_date", dom);
						probPrd = genericUtility.getColumnValue("probation_prd", dom);
						if(joinDate != null)
						{
							System.out.println("joinDate::::::::"+joinDate);
							joinDt = sdf.parse(joinDate);

							if(probDate != null)
							{								  
								probDt = sdf.parse(probDate);  
							}
							valueXmlString.append("<gratuity_date>").append("<![CDATA[" + joinDate + "]]>").append("</gratuity_date>");

							trainPrd = genericUtility.getColumnValue("training_prd", dom);
							if(trainPrd != null)
							{
								trainPrdint = Float.parseFloat(trainPrd);
							}
							if(probPrd != null)
							{
								probPrdint = Float.parseFloat(probPrd);
							}
							String probDateNew = "";//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To get probation date after calculation]
							System.out.println("trainPrdint::::::::"+trainPrdint);
							if(trainPrd == null || trainPrdint == 0)
							{
								joinDt1 = joinDt;
								date=sdf.format(joinDt1);
								probDateNew = date;//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To get probation date after calculation]
								valueXmlString.append("<probation_date>").append("<![CDATA[" ).append(date).append( "]]>").append("</probation_date>");

							}
							else
							{
								joinDt1 = addMonths(joinDt,trainPrdint);
								date=sdf.format(joinDt1);
								probDateNew = date;//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To get probation date after calculation]
								valueXmlString.append("<probation_date>").append("<![CDATA["+ date + "]]>").append("</probation_date>");

							}
							//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To set probation date based on new calculation][START]
							System.out.println("probDateNew :: " + probDateNew);
							if(probDateNew != null && probDateNew.trim().length() > 0)
							{								  
								probDt = sdf.parse(probDateNew);  
							}
							//Modified by Ahmed on 23/AUG/2016[A16ESUN005][To set probation date based on new calculation][END]
							if(probPrd == null || probPrdint == 0)
							{
								probDt1 = probDt;
								if(probDt1 != null)
								{
									date=sdf.format(probDt1);
									valueXmlString.append("<date_conf>").append("<![CDATA[" + date + "]]>").append("</date_conf>");
								}
								else
								{
									valueXmlString.append("<date_conf>").append("<![CDATA[]]>").append("</date_conf>");
								}

							}
							else
							{
								probDt1 = addMonths(probDt,trainPrdint);
								if(probDt1 != null)
								{
									date=sdf.format(probDt1);
									valueXmlString.append("<date_conf>").append("<![CDATA[" ).append(date).append( "]]>").append("</date_conf>");
								}
								else
								{
									valueXmlString.append("<date_conf>").append("<![CDATA[]]>").append("</date_conf>");
								}

							}
							if(probPrdint == 0)
							{
								probationFlag = "Y";
								valueXmlString.append("<probation>").append("<![CDATA[" ).append(probationFlag).append( "]]>").append("</probation>");
							}
							else
							{
								probationFlag = "N";
								valueXmlString.append("<probation>").append("<![CDATA[" ).append(probationFlag).append( "]]>").append("</probation>");
							}
							if(probPrdint == 0 && trainPrdint == 0)
							{
								confirmedFlag = "Y";
								valueXmlString.append("<confirmed>").append("<![CDATA[" ).append(confirmedFlag).append( "]]>").append("</confirmed>");
							}
							else
							{
								confirmedFlag = "N";
								valueXmlString.append("<confirmed>").append("<![CDATA[" ).append(confirmedFlag).append( "]]>").append("</confirmed>");
							}
						}
					}
					else
					{
						valueXmlString.append("<date_join>").append("<![CDATA[]]>").append("</date_join>");
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("pay_mode"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					payMode = genericUtility.getColumnValue("pay_mode", dom);
					if(payMode.trim().equals("C"))
					{
						valueXmlString.append("<bank_code>").append("<![CDATA[]]>").append("</bank_code>");
						valueXmlString.append("<bank_acct>").append("<![CDATA[]]>").append("</bank_acct>");
					}
					if(!payMode.trim().equals("D"))
					{
						valueXmlString.append("<dd_payable_bank>").append("<![CDATA[]]>").append("</dd_payable_bank>");
					}
					if(!gs_runmode.equals("B"))
					{
						if(!payMode.trim().equals("T"))
						{
							valueXmlString.append("<bank_acct protect=\"1\"><![CDATA[]]></bank_acct>\r\n");
						}
						else
						{
							valueXmlString.append("<bank_acct protect=\"0\"><![CDATA[]]></bank_acct>\r\n");
						}
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("emp_class"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);
					String descr="";
					empClass = genericUtility.getColumnValue("emp_class", dom);
					if(empClass != null && empClass.trim().length() > 0)
					{
						String sqlEc="SELECT DESCR FROM GENCODES WHERE FLD_NAME='EMP_CLASS' AND FLD_VALUE=?";
						pstmt = connection.prepareStatement(sqlEc);
						pstmt.setString(1, empClass);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							descr = rs.getString("DESCR");
						}
						close(pstmt, rs);
						if(descr != null && descr.trim().length() > 0)
						{
							valueXmlString.append("<class_descr>").append("<![CDATA[" ).append(descr).append( "]]>").append("</class_descr>");
						}
						else
						{
							valueXmlString.append("<class_descr>").append("<![CDATA[]]>").append("</class_descr>");
						}
					}
					else
					{
						valueXmlString.append("<class_descr>").append("<![CDATA[]]>").append("</class_descr>"); 
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("occupation_code"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);
					String descr="";
					occuCode = genericUtility.getColumnValue("occupation_code", dom);
					if(occuCode != null && occuCode.trim().length() > 0)
					{
						String sqlOc="SELECT DESCR FROM GENCODES WHERE FLD_NAME='OCCUPATION_CODE' AND FLD_VALUE=?";
						pstmt = connection.prepareStatement(sqlOc);
						pstmt.setString(1, occuCode);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							descr = rs.getString("DESCR");
						}
						close(pstmt, rs); 
						if(descr != null && descr.trim().length() > 0)
						{
							valueXmlString.append("<occ_descr>").append("<![CDATA[" ).append(descr).append( "]]>").append("</occ_descr>");
						}
						else
						{
							valueXmlString.append("<occ_descr>").append("<![CDATA[]]>").append("</occ_descr>");
						}							 
					}
					else
					{
						valueXmlString.append("<occ_descr>").append("<![CDATA[]]>").append("</occ_descr>");
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("emp_code__hod"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					empCodeHOD = genericUtility.getColumnValue("emp_code__hod", dom);						  
					String sqlEch="SELECT EMP_FNAME,EMP_MNAME,EMP_LNAME FROM EMPLOYEE WHERE EMP_CODE=?";
					pstmt = connection.prepareStatement(sqlEch);
					pstmt.setString(1, empCodeHOD);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						valueXmlString.append("<emp_code_hod__fname>").append("<![CDATA[" + rs.getString("EMP_FNAME") + "]]>").append("</emp_code_hod__fname>");
						valueXmlString.append("<emp_code_hod__lname>").append("<![CDATA[" + rs.getString("EMP_LNAME") + "]]>").append("</emp_code_hod__lname>");
						valueXmlString.append("<emp_code_hod__mname>").append("<![CDATA[" + rs.getString("EMP_MNAME") + "]]>").append("</emp_code_hod__mname>");
					}
					else
					{
						valueXmlString.append("<emp_code_hod__fname>").append("<![CDATA[]]>").append("</emp_code_hod__fname>");
						valueXmlString.append("<emp_code_hod__lname>").append("<![CDATA[]]>").append("</emp_code_hod__lname>");
						valueXmlString.append("<emp_code_hod__mname>").append("<![CDATA[]]>").append("</emp_code_hod__mname>");

					}
					close(pstmt, rs);
				}
				else if(currentColumn.trim().equalsIgnoreCase("pos_code"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);
					String descr="";
					empCode = genericUtility.getColumnValue("emp_code", dom);	
					deptCode = genericUtility.getColumnValue("dept_code", dom);	
					posCode = genericUtility.getColumnValue("pos_code", dom);	
					if(posCode != null && posCode.trim().length() > 0)
					{
						String sqlPc = "SELECT fn_get_pos_descr(?,?,?) AS POS_DESCR FROM DUAL";
						pstmt = connection.prepareStatement(sqlPc);
						pstmt.setString(1, empCode);
						pstmt.setString(2, deptCode);
						pstmt.setString(3, posCode);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							descr = rs.getString("POS_DESCR");
						}
						close(pstmt, rs);
						if(descr != null && descr.trim().length() > 0)
						{
							valueXmlString.append("<pos_code_descr>").append("<![CDATA[").append(descr).append( "]]>").append("</pos_code_descr>");
						}
						else
						{
							valueXmlString.append("<pos_code_descr>").append("<![CDATA[]]>").append("</pos_code_descr>");  
						}
					}
					else
					{
						valueXmlString.append("<pos_code_descr>").append("<![CDATA[]]>").append("</pos_code_descr>");
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("driv_lic_no"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					drivLicNo = genericUtility.getColumnValue("driv_lic_no", dom);	
					if(drivLicNo == null || drivLicNo.trim().length() == 0)
					{
						Date date = null;
						valueXmlString.append("<driv_lic_valid_upto protect=\"1\"><![CDATA[]]></driv_lic_valid_upto>\r\n");
					}
					else
					{
						valueXmlString.append("<driv_lic_valid_upto protect=\"0\"><![CDATA[]]></driv_lic_valid_upto>\r\n");
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("physical_handicap"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					phyHandicap = genericUtility.getColumnValue("physical_handicap", dom);
					if(phyHandicap == null || phyHandicap.trim().length() == 0 || phyHandicap.equals("N"))
					{
						valueXmlString.append("<physical_handicap>").append("<![CDATA[N]]>").append("</physical_handicap>");
						valueXmlString.append("<handicap_category protect=\"1\"><![CDATA[]]></handicap_category>\r\n");
					}
					else
					{
						valueXmlString.append("<handicap_category protect=\"0\"><![CDATA[]]></handicap_category>\r\n"); 
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("func_group"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					funcGroup = genericUtility.getColumnValue("func_group", dom);						  
					String sqlFg="SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE=?";
					pstmt = connection.prepareStatement(sqlFg);
					pstmt.setString(1, funcGroup);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						valueXmlString.append("<func_group_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</func_group_descr>"); 
					}
					else
					{
						valueXmlString.append("<func_group_descr>").append("<![CDATA[]]>").append("</func_group_descr>");  
					}
					close(pstmt, rs);
				}
				else if(currentColumn.trim().equalsIgnoreCase("parent_dept"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);

					parentDept = genericUtility.getColumnValue("parent_dept", dom);						  
					String sqlPd="SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE=?";
					pstmt = connection.prepareStatement(sqlPd);
					pstmt.setString(1, parentDept);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						valueXmlString.append("<parent_dept_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</parent_dept_descr>"); 
					}
					else
					{
						valueXmlString.append("<parent_dept_descr>").append("<![CDATA[]]>").append("</parent_dept_descr>");  
					}
					close(pstmt, rs);
				}
				else if(currentColumn.trim().equalsIgnoreCase("notice_prd"))
				{
					String notPrd= genericUtility.getColumnValue("notice_prd", dom);
					System.out.println("Notice period 1:::::"+notPrd);
					if(notPrd != null && notPrd.trim().length() > 0)
					{
						float notPrdnum = Float.parseFloat(notPrd);
						System.out.println("Notice period 2:::::"+notPrdnum);
						if(notPrdnum < 0)
						{
							valueXmlString.append("<notice_prd>").append("<![CDATA[0]]>").append("</notice_prd>");  
						}
						else
						{

							float notPrdInt = Math.round(notPrdnum);
							int roundup=(int)notPrdInt;
							String noticePeriod = Integer.toString(roundup);
							System.out.println("Notice period 3:::::"+noticePeriod);
							valueXmlString.append("<notice_prd>").append("<![CDATA["+ noticePeriod +"]]>").append("</notice_prd>");
						}
					}						
					else
					{
						valueXmlString.append("<notice_prd>").append("<![CDATA[]]>").append("</notice_prd>");
					}
				}
				valueXmlString.append ("</Detail1>\r\n");	
			}
			break;

			case 2:
			{
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				childNodeListLength = childNodeList.getLength();

				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}
				while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
				valueXmlString.append("<Detail2>\r\n");	
				if (currentColumn.equalsIgnoreCase("itm_default"))
				{	
					System.out.println("ItemChange2 of:::::"+currentColumn);	
					valueXmlString.append("<chg_term>").append("<![CDATA[" + addTerm + "]]>").append("</chg_term>\r\n");
					valueXmlString.append("<chg_user>").append("<![CDATA[" + chgUser + "]]>").append("</chg_user>\r\n");
					valueXmlString.append("<chg_date>").append("<![CDATA[" + chgDate + "]]>").append("</chg_date>\r\n");
					empCode = genericUtility.getColumnValue("emp_code", dom);
					valueXmlString.append("<emp_code>").append("<![CDATA[" + (empCode) + "]]>").append("</emp_code>\r\n");
					seqNo = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "seq_no");
					if(seqNo.trim().length() > 0)
					{
						valueXmlString.append("<seq_no protect=\"1\"><![CDATA["+ seqNo +"]]></seq_no>\r\n");
					}						
					valueXmlString.append("<grat_nominee protect=\"1\"><![CDATA[N]]></grat_nominee>\r\n");
					valueXmlString.append("<pf_nominee protect=\"1\"><![CDATA[N]]></pf_nominee	>\r\n");
					valueXmlString.append("<pen_nominee protect=\"1\"><![CDATA[N]]></pen_nominee>\r\n");

				}
				if (currentColumn.equalsIgnoreCase("itm_defaultedit"))
				{
					System.out.println("ItemChange2 of:::::"+currentColumn);

					gratNominee = genericUtility.getColumnValue("grat_nominee", dom);
					pfNominee = genericUtility.getColumnValue("pf_nominee", dom);
					penNominee = genericUtility.getColumnValue("pen_nominee", dom);

					if(gratNominee == null || gratNominee.trim().length() == 0 || gratNominee.trim().equals("N"))
					{
						valueXmlString.append("<grat_perc protect=\"1\"><![CDATA[]]></grat_perc>\r\n");
					}
					else
					{
						valueXmlString.append("<grat_perc protect=\"0\"><![CDATA[]]></grat_perc>\r\n");
					}
					if(pfNominee == null || pfNominee.trim().length() == 0 || pfNominee.trim().equals("N"))
					{
						valueXmlString.append("<pf_perc protect=\"1\"><![CDATA[]]></pf_perc>\r\n");
					}
					else
					{
						valueXmlString.append("<pf_perc protect=\"0\"><![CDATA[]]></pf_perc>\r\n");
					}
					if(penNominee == null || penNominee.trim().length() == 0 || penNominee.trim().equals("N"))
					{
						valueXmlString.append("<pen_perc protect=\"1\"><![CDATA[]]></pen_perc>\r\n");
					}
					else
					{
						valueXmlString.append("<pen_perc protect=\"0\"><![CDATA[]]></pen_perc>\r\n");
					}

				}
				if (currentColumn.equalsIgnoreCase("grat_nominee"))
				{
					System.out.println("ItemChange2 of:::::"+currentColumn);
					float gratpercent=0;
					gratNominee = genericUtility.getColumnValue("grat_nominee", dom);
					System.out.println("gratNominee :::::"+gratNominee);
					gratPerc = genericUtility.getColumnValue("grat_perc", dom);
					if(gratPerc != null)
					{
						gratpercent=Float.parseFloat(gratPerc);
					}
					if(gratNominee.equals("Y") && (gratPerc == null || gratpercent == 0))
					{
						valueXmlString.append("<grat_perc protect=\"0\"><![CDATA[100]]></grat_perc>\r\n");
					}
					else if(gratNominee.equals("N"))
					{
						valueXmlString.append("<grat_perc protect=\"1\"><![CDATA[0]]></grat_perc>\r\n");
					}
				}
				if (currentColumn.equalsIgnoreCase("grat_perc"))
				{
					System.out.println("ItemChange2 of:::::"+currentColumn);

					gratNominee = genericUtility.getColumnValue("grat_nominee", dom);
					gratPerc = genericUtility.getColumnValue("grat_perc", dom);
					if(gratNominee == null || gratNominee.trim().length() == 0 || gratNominee.equals("N"))
					{
						valueXmlString.append("<grat_perc protect=\"1\"><![CDATA[0]]></grat_perc>\r\n");
					}
				}
				if (currentColumn.equalsIgnoreCase("pf_nominee"))
				{
					System.out.println("ItemChange2 of:::::"+currentColumn);
					float pfpercent=0;
					pfNominee = genericUtility.getColumnValue("pf_nominee", dom);
					System.out.println("pfNominee :::::"+pfNominee);
					pfPerc = genericUtility.getColumnValue("pf_perc", dom);
					if(pfPerc != null)
					{
						pfpercent=Float.parseFloat(pfPerc);
					}
					if(pfNominee.equals("Y") && (pfPerc == null || pfpercent == 0))
					{
						valueXmlString.append("<pf_perc protect=\"0\"><![CDATA[]]></pf_perc>\r\n");
					}
					else if(pfNominee.equals("N"))
					{
						valueXmlString.append("<pf_perc protect=\"1\"><![CDATA[0]]></pf_perc>\r\n");
					}
				}
				if (currentColumn.equalsIgnoreCase("pf_perc"))
				{
					System.out.println("ItemChange2 of:::::"+currentColumn);

					pfNominee = genericUtility.getColumnValue("pf_nominee", dom);
					pfPerc = genericUtility.getColumnValue("pf_perc", dom);
					if(pfNominee == null || pfNominee.trim().length() == 0 || pfNominee.equals("N"))
					{
						valueXmlString.append("<pf_perc protect=\"1\"><![CDATA[0]]></pf_perc>\r\n");
					}
				}
				if (currentColumn.equalsIgnoreCase("pen_nominee"))
				{
					System.out.println("ItemChange2 of:::::"+currentColumn);
					float penpercent=0;
					penNominee = genericUtility.getColumnValue("pen_nominee", dom);
					penPerc = genericUtility.getColumnValue("pen_perc", dom);
					System.out.println("penPerc::::::::::::::"+penPerc);
					if(penPerc != null)
					{
						penpercent=Float.parseFloat(penPerc);
					}
					if(penNominee.equals("Y") && (penPerc == null || penpercent == 0))
					{
						valueXmlString.append("<pen_perc protect=\"0\"><![CDATA[]]></pen_perc>\r\n");
					}
					else if(penNominee.equals("N"))
					{
						valueXmlString.append("<pen_perc protect=\"1\"><![CDATA[0]]></pen_perc>\r\n");
					}
				}
				if (currentColumn.equalsIgnoreCase("pen_perc"))
				{
					System.out.println("ItemChange2 of:::::"+currentColumn);

					penNominee = genericUtility.getColumnValue("pen_nominee", dom);
					pfPerc = genericUtility.getColumnValue("pen_perc", dom);
					if(penNominee == null || penNominee.trim().length() == 0 || penNominee.equals("N"))
					{
						valueXmlString.append("<pen_perc protect=\"1\"><![CDATA[0]]></pen_perc>\r\n");
					}
				}
				valueXmlString.append ("</Detail2>\r\n");
			}
			break;

			case 3:
			{
				parentNodeList = dom.getElementsByTagName("Detail3");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				childNodeListLength = childNodeList.getLength();

				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}
				while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
				valueXmlString.append("<Detail3>\r\n");		
				if (currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("ItemChange3 of:::::"+currentColumn);

					empCode = genericUtility.getColumnValue("emp_code", dom);
					valueXmlString.append("<emp_code>").append("<![CDATA[" + (empCode) + "]]>").append("</emp_code>\r\n");
					valueXmlString.append("<read>").append("<![CDATA[Y]]>").append("</read>\r\n");
					valueXmlString.append("<write>").append("<![CDATA[Y]]>").append("</write>\r\n");
					valueXmlString.append("<speak>").append("<![CDATA[Y]]>").append("</speak>\r\n");
				}
				valueXmlString.append ("</Detail3>\r\n");
			}
			break;

			case 4:
			{
				//valueXmlString.append("<Detail4 domID='1' dbID='' objContext='4' objName='"+objNameDefault+"' selected='Y'>\r\n");
				System.out.println("Start of Case 4");
				/* Searching the dom for the incoming column value start*/

				parentNodeList = dom.getElementsByTagName("Detail4");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				childNodeListLength = childNodeList.getLength();

				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					System.out.println("childNodeName::::::::::::"+childNodeName);

					if(childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}
				while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));

				valueXmlString.append("<Detail4>\r\n");					
				if (currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("ItemChange4 of:::::"+currentColumn);

					empCode = genericUtility.getColumnValue("emp_code", dom);
					valueXmlString.append("<emp_code>").append("<![CDATA[" + (empCode) + "]]>").append("</emp_code>\r\n");
					seqNo = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "seq_no");
					if(seqNo.trim().length() > 0)
					{
						valueXmlString.append("<seq_no>").append("<![CDATA[" + (seqNo) + "]]>").append("</seq_no>\r\n");
					}
					valueXmlString.append("<seq_no protect=\"1\"><![CDATA[0]]></seq_no>\r\n");
				}
				else if(currentColumn.equalsIgnoreCase("qlf_code"))
				{
					System.out.println("ItemChange4 of:::::"+currentColumn);
					String qlfDescr = "";
					qlfCode = genericUtility.getColumnValue("qlf_code", dom);
					System.out.println("qlfCode:::::"+qlfCode);
					if(qlfCode != null && qlfCode.trim().length() > 0)
					{

						String sqlQc = "SELECT DESCR FROM QUALIFICATION WHERE QLF_CODE=?";
						pstmt = connection.prepareStatement(sqlQc);
						pstmt.setString(1, qlfCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							qlfDescr=rs.getString("DESCR");								
						}
						close(pstmt, rs);
						valueXmlString.append("<qualification_descr>").append("<![CDATA[" + qlfDescr + "]]>").append("</qualification_descr>\r\n");
						System.out.println(" NEW QUALIFICATION");
					}
					else
					{
						valueXmlString.append("<qualification_descr>").append("<![CDATA[]]>").append("</qualification_descr>\r\n");
					}
				}
				else if(currentColumn.equalsIgnoreCase("perc"))
				{
					System.out.println("ItemChange4 of:::::"+currentColumn);
					String percent = genericUtility.getColumnValue("perc", dom);
					System.out.println("percentage1:::::::::::::::" +percent );
					if(percent != null && percent.trim().length() > 0)
					{
						float percnum = Float.parseFloat(percent);
						System.out.println("percentage2:::::::::::::::" +percnum );
						if(percnum < 0)
						{
							valueXmlString.append("<perc>").append("<![CDATA[0.00]]>").append("</perc>\r\n");
						}
						else
						{
							DecimalFormat decf = new DecimalFormat("##.00");// to convert number in '00.00' format
							String perc=decf.format(percnum);
							System.out.println("percentage3:::::::::::::::" +perc );
							valueXmlString.append("<perc>").append("<![CDATA["+ perc +"]]>").append("</perc>\r\n");								
						}
					}
					else
					{
						valueXmlString.append("<perc>").append("<![CDATA[0]]>").append("</perc>\r\n");
					}
				}
				valueXmlString.append ("</Detail4>\r\n");					
			}
			break;

			case 5:
			{
				parentNodeList = dom.getElementsByTagName("Detail5");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				childNodeListLength = childNodeList.getLength();

				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}
				while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
				valueXmlString.append("<Detail5>\r\n");	
				if (currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("ItemChange 5 of:::::"+currentColumn);
					valueXmlString.append("<chg_term>").append("<![CDATA[" + addTerm + "]]>").append("</chg_term>\r\n");
					valueXmlString.append("<chg_user>").append("<![CDATA[" + chgUser + "]]>").append("</chg_user>\r\n");
					valueXmlString.append("<chg_date>").append("<![CDATA[" + chgDate + "]]>").append("</chg_date>\r\n");
					empCode = genericUtility.getColumnValue("emp_code", dom);
					valueXmlString.append("<emp_code>").append("<![CDATA[" + (empCode) + "]]>").append("</emp_code>\r\n");
					seqNo = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "seq_no");
					if(seqNo.trim().length() > 0)
					{
						valueXmlString.append("<seq_no>").append("<![CDATA[" + (seqNo) + "]]>").append("</seq_no>\r\n");
					}
					valueXmlString.append("<seq_no protect=\"1\"><![CDATA[0]]></seq_no>\r\n");
				}
				valueXmlString.append ("</Detail5>\r\n");
			}
			break;

			case 6:
			{
				parentNodeList = dom.getElementsByTagName("Detail6");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				childNodeListLength = childNodeList.getLength();

				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}
				while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
				valueXmlString.append("<Detail6>\r\n");	
				if (currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("ItemChange 6 of:::::"+currentColumn);
					valueXmlString.append("<chg_term>").append("<![CDATA[" + addTerm + "]]>").append("</chg_term>\r\n");
					valueXmlString.append("<chg_user>").append("<![CDATA[" + chgUser + "]]>").append("</chg_user>\r\n");
					valueXmlString.append("<chg_date>").append("<![CDATA[" + chgDate + "]]>").append("</chg_date>\r\n");	
					empCode = genericUtility.getColumnValue("emp_code", dom);
					valueXmlString.append("<emp_code>").append("<![CDATA[" + (empCode) + "]]>").append("</emp_code>\r\n");
				}
				//Added by Ahmed on 11/12/2015[AD3DSUN001][START]
				if(currentColumn.equalsIgnoreCase("gross_amt"))
				{
					String grossAmt = checkNull(genericUtility.getColumnValue("gross_amt", dom));
					double grossAmtNum = 0d;
					long grossAmtInt = 0;
					if(grossAmt.length() > 0)
					{
						try
						{
							grossAmtNum = Double.parseDouble(grossAmt);
							grossAmtInt = Math.round(grossAmtNum);
						}
						catch(Exception e)
						{
							String errString =  getErrorString("gross_amt", "VMEMPAXP07", chgUser);
							return errString;
						}
						valueXmlString.append("<gross_amt>").append("<![CDATA[" + (grossAmtInt) + "]]>").append("</gross_amt>\r\n");
					}
				}
				//Added by Ahmed on 11/12/2015[AD3DSUN001][END]
				valueXmlString.append ("</Detail6>\r\n");
			}
			break;

			case 7:
			{
				parentNodeList = dom.getElementsByTagName("Detail7");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				childNodeListLength = childNodeList.getLength();

				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}
				while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
				valueXmlString.append("<Detail7>\r\n");	
				if (currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("ItemChange 7 of:::::"+currentColumn);						
					empCode = genericUtility.getColumnValue("emp_code", dom);
					valueXmlString.append("<emp_code>").append("<![CDATA[" + (empCode) + "]]>").append("</emp_code>\r\n");
					valueXmlString.append("<amount>").append("<![CDATA[0]]>").append("</amount>\r\n");						
				}
				else if(currentColumn.equalsIgnoreCase("bank_code"))
				{
					bankCode = genericUtility.getColumnValue("bank_code", dom);						
					String sqlbc="SELECT BANK_NAME FROM BANK WHERE BANK_CODE = ?";
					pstmt = connection.prepareStatement(sqlbc);
					pstmt.setString(1, bankCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						valueXmlString.append("<bank_name>").append("<![CDATA["+ rs.getString("BANK_NAME") +"]]>").append("</bank_name>"); 
					} 
					close(pstmt, rs);
				}
				valueXmlString.append ("</Detail7>\r\n");
			}
			break;					
			}
		}
		catch (Exception e)
		{
			System.out.println ("Exception :EmployeeMAster :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally
		{     
			try
			{
				close(pstmt, rs);
				if(connection != null)
				{
					connection.close();
					connection = null;
				}	
			}
			catch(Exception e)
			{
				System.out.println(e.getMessage());
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("EmployeeMAster :itemChanged(Document,String):return valueXmlString"+valueXmlString);
		return valueXmlString.toString();

	}

	private String checkNull(String input)
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input =input.trim();
		}
		return input;
	}


	private String getFieldValue(String column,String tableName, String columnName, String columnValue,Connection conn)
	{	
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String value = null;
		String sql = null;

		sql = " select "+column+" from "+tableName+" where "+columnName+" = '" + columnValue + "' ";
		try
		{
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
			if(rs.next())
			{
				value = rs.getString(1) != null ? rs.getString(1) : "";            	
			}
			else
			{
				value = " ";
			}   
			rs.close();
			pstmt.close();
		}
		catch(Exception exception)
		{
			exception.printStackTrace();
			System.out.println("Exception ::" + exception.getMessage());
		}
		return value;
	}



	private int isValueExist(String tableName, String columnName, String columnValue,Connection conn)
	{	
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = null;
		int cnt = 0 ; 	
		sql = " select count(1) as count from "+tableName+" where "+columnName+" = '" + columnValue + "' ";
		try
		{
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
			if(rs.next())
			{
				cnt = rs.getInt("count");            	
			}
			rs.close();
			pstmt.close();
			System.out.println("cnt--------------"+cnt);
		}
		catch(Exception exception)
		{
			exception.printStackTrace();
			System.out.println("Exception ::" + exception.getMessage());
		}
		return cnt;
	}

	public void close(PreparedStatement pstmt,ResultSet rs)
	{
		try
		{
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
	public String getEnv(String prdCode, String varName,Connection conn)
	{
		String retValue = "";
		String sql = "";
		Statement stmt = null;
		ResultSet rs = null;
		try
		{
			sql = "SELECT VAR_VALUE FROM PAYRPARM WHERE PRD_CODE = '" + prdCode + "' AND VAR_NAME = '" + varName + "'";

			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);

			if (rs.next())
			{
				retValue = rs.getString(1);
			}
			else
			{
				retValue = "NULLFOUND";
			}
			rs.close();
			stmt.close();
		}
		catch (SQLException se)
		{
			System.out.println("Exception :ITMDBAccessEJB :getEnvFin:" + se.getMessage() + ":");
			se.printStackTrace();
		}
		catch (Exception e)
		{
			System.out.println("Exception :ITMDBAccessEJB :getEnvFin:" + e.getMessage() + ":");
			e.printStackTrace();
		}
		System.out.println("Returning Value From getEnv() :: "+retValue);  
		return retValue;
	}
	// To calculate Date
	public Date addMonths(Date date, float months) 	
	{
		java.util.Date caldate=new java.util.Date();

		try
		{
			int mon=(int)months;
			SimpleDateFormat fmt = new SimpleDateFormat("dd-MMM-yyyy");
			GregorianCalendar cal = new GregorianCalendar();
			fmt.setCalendar(cal);
			cal.setTime(date);
			cal.add(Calendar.MONTH, mon);			 		
			caldate=cal.getTime();			
			System.out.println("caldate:::::::::::::::::::::" +caldate);		       
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return caldate;
	}
	private String getObjName(Document dom2,String objContext)
	{	
		Node elementName = null;
		NodeList elementList = null;
		String objName = "";
		elementList = dom2.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}
	private String errorType(Connection conn, String errorCode)	throws ITMException 
	{
		String msgType = "E";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
			String sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		} catch (Exception ex) 
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		finally 
		{
			try 
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
	//Added by Suraj [03/06/2015] [Method to validate pssition code][Start] 
	private String validatePosition(String empCode , String posCode , String deptCode , Date joinDate , Connection conn) throws ITMException
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String dbPosCode  =  "";
		java.util.Date dbJoinDate = null ;	
		String dbDeptCode = "";
		String tableno = "";
		String errString = "";
		String versionId = "";		
		E12GenericUtility genericUtility = new E12GenericUtility();	
		try
		{
			if(posCode == null || posCode.length() == 0)
			{
				return "";
			}
			Date currentDate = new Date();
			SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
			String curDate = sdf.format(currentDate);
			curDate = genericUtility.getValidDateTimeString(curDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			sql = "SELECT POS_CODE  AS  POS_CODE_OLD , DATE_JOIN  AS  JOIN_DATE_OLD ,  DEPT_CODE  AS  DEPT_CODE_OLD  FROM  EMPLOYEE  WHERE  EMP_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				dbPosCode = checkNull(rs.getString("POS_CODE_OLD"));
				dbJoinDate = rs.getDate("JOIN_DATE_OLD");
				dbDeptCode = checkNull(rs.getString("DEPT_CODE_OLD"));
			}
			else
			{
				dbPosCode = null;
				dbJoinDate = null;
				dbDeptCode = null;
			}
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("posCodeOld:::::::::"+dbPosCode);
			System.out.println("joinDateOld:::::::::"+dbJoinDate);
			System.out.println("deptCodeOld:::::::::"+dbDeptCode);
			if(dbJoinDate == null)
			{
				dbJoinDate = currentDate;
			}
			if(joinDate == null)
			{
				joinDate = dbJoinDate ;
			}
			if(dbPosCode == null || dbPosCode.trim().length() == 0 )
			{
				dbPosCode = "!";
			}
			if(dbDeptCode == null || dbDeptCode.trim().length() == 0 )
			{
				dbDeptCode = "!";
			}
			if(deptCode == null || deptCode.trim().length() == 0)
			{
				deptCode = dbDeptCode ;
			}
			if(!(dbPosCode.equalsIgnoreCase(posCode)) || dbJoinDate.compareTo(joinDate) > 0 || !(dbDeptCode.equalsIgnoreCase(deptCode)))
			{
				sql = "SELECT ITEM_SER AS TABLENO FROM DEPARTMENT WHERE DEPT_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,deptCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					tableno = checkNull(rs.getString("TABLENO"));
				}
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("tableno:::::::::"+tableno);
				if(tableno == null || tableno.length() == 0)
				{
					errString = "VMTBLNO";
					return errString;
				}
				sql = "SELECT VERSION_ID  FROM VERSION WHERE ? BETWEEN EFF_FROM AND VALID_UPTO ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(curDate));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					versionId = checkNull(rs.getString("VERSION_ID"));
				}
				else
				{
					errString ="VERID";
				}
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(errString != null && errString.length() > 0)
				{
					return errString;
				}
				System.out.println("versionId:::::::::"+versionId);

				sql = "SELECT EMP_CODE AS EMP_CODE_ORG FROM ORG_STRUCTURE WHERE VERSION_ID = ? AND TABLE_NO = ? AND POS_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,versionId);
				pstmt.setString(2,tableno);
				pstmt.setString(3,posCode);
				rs = pstmt.executeQuery();
				String empCodeOrg = "";
				if(rs.next())
				{
					empCodeOrg = checkNull(rs.getString("EMP_CODE_ORG"));
				}
				else
				{
					errString = "NOPOS";
				}
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(errString != null && errString.length() > 0)
				{
					return errString;
				}
				System.out.println("empCodeOrg:::::::::"+empCodeOrg);
				if(( empCodeOrg != null && empCodeOrg.trim().length() > 0 ) && !(empCodeOrg.trim().equalsIgnoreCase(empCode.trim())))
				{
					errString = "POSNA";
					return errString;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = "DS000";
			throw new ITMException(e);
		}
		return errString ;
	}
	//Added by Suraj [03/06/2015] [Method to validate pssition code][End]
}

