/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.bean.ConnParams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CommonUtil {
    Logger logger = Logger.getLogger(CommonUtil.class);

    public void message(String magStr) {
        JOptionPane.showMessageDialog(null, magStr);
    }

    public Connection getConnection() throws Exception {
        this.logger.info((Object)"Inside Getting Connection............");
        Connection connection = null;
        ConnParams connParams = this.setConnParams();
        try {
            Class.forName(connParams.getDriverName());
            String encodedPass = CommonUtil.decrypt(this.readPasswordFromFile(connParams.getDatabasePassword()));
            connection = DriverManager.getConnection(connParams.getDriverUrl(), connParams.getDatabaseUsername(), encodedPass);
            this.logger.debug((Object)("Connection:" + connection));
        }
        catch (Exception e) {
            System.out.println("Connection Not Established([" + connParams.getDriverName() + "][" + connParams.getDriverUrl() + "][" + connParams.getDriverUrl() + "] ?????????");
            this.logger.error((Object)("Connection Not Established([" + connParams.getDriverName() + "][" + connParams.getDriverUrl() + "][" + connParams.getDriverUrl() + "] ?????????"));
            this.logger.error((Object)("Exception: CommonUtil: getConnection: Generic Exception==>\n" + e));
            throw e;
        }
        this.logger.info((Object)"Connection Established");
        return connection;
    }

    private ConnParams setConnParams() throws ParserConfigurationException, SAXException, IOException {
        this.logger.info((Object)"Inside set connection params...........");
        ConnParams connParams = new ConnParams();
        String current = System.getProperty("user.dir");
        this.logger.info((Object)("working directory in Java : " + current));
        File fXmlFile = new File(String.valueOf(current) + "/Driver.xml");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document document = dBuilder.parse(fXmlFile);
        NodeList parentNodeList = document.getElementsByTagName("dbconfig");
        Node parentNode = parentNodeList.item(0);
        NodeList childNodeList = parentNode.getChildNodes();
        int i = 0;
        while (i < childNodeList.getLength()) {
            Node node = childNodeList.item(i);
            if (node.getNodeName().equals("driverURL")) {
                connParams.setDriverUrl(node.getFirstChild().getNodeValue());
            }
            if (node.getNodeName().equals("username")) {
                connParams.setDatabaseUsername(node.getFirstChild().getNodeValue());
            }
            if (node.getNodeName().equals("passwordFile")) {
                connParams.setDatabasePassword(node.getFirstChild().getNodeValue());
            }
            if (node.getNodeName().equals("drivername")) {
                connParams.setDriverName(node.getFirstChild().getNodeValue());
            }
            ++i;
        }
        return connParams;
    }

    private String readPasswordFromFile(String ipwFile) {
        String pass = "";
        try {
            String fileName = String.valueOf(System.getProperty("user.dir")) + "/" + ipwFile;
            this.logger.info((Object)("ReadPasswordFromFile:" + fileName));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileInputStream isr = new FileInputStream(fileName);
            StringBuffer passStrBuff = new StringBuffer();
            int i = -1;
            while ((i = isr.read()) != -1) {
                baos.write(i);
            }
            pass = baos.toString("ISO-8859-1");
            baos.close();
            isr.close();
        }
        catch (Exception e) {
            System.out.println("Exception: CommonUtil: readPasswordFromFile(String):==>\n" + e.getMessage());
        }
        return pass;
    }

    private static String decrypt(String as_passwd) {
        String ls_return = "";
        try {
            int li_len = as_passwd.length();
            int li_seedcount = 1;
            int li_count = 0;
            while (li_count < li_len) {
                int li_Seed = as_passwd.charAt(li_count + 1) - li_seedcount;
                int li_passAsc = as_passwd.charAt(li_count) - li_seedcount;
                ls_return = String.valueOf(ls_return) + (char)(li_passAsc -= li_Seed);
                ++li_seedcount;
                li_count += 2;
            }
        }
        catch (Exception e) {
            System.out.println("Exception: ConnDriver: decrypt(String):==>\n" + e.getMessage());
        }
        return ls_return;
    }

    public static Logger getLogger(Class clazz, String myLogFile) {
        Logger log = Logger.getLogger((Class)clazz);
        Properties props = new Properties();
        props.setProperty("log4j.rootLogger", "debug,ERROR,INFO,CONSOLE,R");
        props.setProperty("log4j.appender.CONSOLE", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.CONSOLE.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("log4j.appender.CONSOLE.layout.ConversionPattern", "%5p [%t] (%F:%L) - %m%n");
        props.setProperty("log4j.appender.R", "org.apache.log4j.RollingFileAppender");
        props.setProperty("log4j.appender.R.File", myLogFile);
        props.setProperty("log4j.appender.R.Target", "System.out");
        props.setProperty("log4j.appender.file", "org.apache.log4j.RollingFileAppender");
        props.setProperty("log4j.appender.R.MaxFileSize", "2");
        props.setProperty("log4j.appender.R.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("log4j.appender.R.layout.ConversionPattern", "%d - %c - %p - %m%n");
        PropertyConfigurator.configure((Properties)props);
        return log;
    }

    public FileAppender getLogAppender(String ptcn) {
        FileAppender appender = new FileAppender();
        appender.setName("ptcnLog");
        appender.setLayout((Layout)new PatternLayout("%d %-5p [%c{1}] %m%n"));
        appender.setFile("logs/" + ptcn + ".log");
        appender.setAppend(true);
        appender.setThreshold((Priority)Level.ERROR);
        appender.setThreshold((Priority)Level.INFO);
        appender.setThreshold((Priority)Level.DEBUG);
        appender.activateOptions();
        return appender;
    }
}

