------------------------------------------------------------------------------
/* create MISC_VCH_EMP */
------------------------------------------------------------------------------

CREATE TABLE  MISC_VCH_EMP
(
	TRAN_ID    		CHAR(10)   		NOT NULL,
	TRAN_DATE  		DATE       		NOT NULL,
	VOUCH_TYPE		CHAR(1)			NOT NULL,
	TRAN_TYPE		CHAR(5),
	PAY_MODE        CHAR(1) 		NOT NULL, 
	SUNDRY_TYPE		CHAR(1) 		NOT NULL,
	SITE_CODE		CHAR(5)			NOT NULL,
	ANAL_CODE		CHAR(5),
	REMARKS			VARCHAR2(60),
	ACCT_CODE__AP	CHAR(10)		NOT NULL,
	CCTR_CODE__AP	CHAR(4),
	ACCT_CODE__ADV	CHAR(10),		
	CCTR_CODE__ADV	CHAR(4),
	CURR_CODE		CHAR(5)		NOT NULL,
	EXCH_RATE		NUMBER(17,6)	NOT NULL,
	BANK_CODE		CHAR(10),
	PROJ_CODE		CHAR(10),
	AUTO_PAY		CHAR(1)			NOT NULL,
	TAX_CLASS       CHAR(5),
	TAX_CHAP        CHAR(10),
	TAX_ENV         CHAR(10),
	TAX_DATE        DATE,
	DUE_DATE        DATE			NOT NULL,
	CONFIRMED       CHAR(1),
	CONF_DATE       DATE,
	EMP_CODE__APRV  CHAR(10),
	LOGIN_EMP__CODE CHAR(10),
	TOTAL_AMOUNT	NUMBER(14,3,
	CHG_DATE		DATE			NOT NULL,
	CHG_USER        CHAR(10)		NOT NULL,
	CHG_TERM        CHAR(15)		NOT NULL
)TABLESPACE ITM_FIN_D1;

------------------------------------------------------------------------------
/* set primary key and reference key for MISC_VCH_EMP_HDR */
------------------------------------------------------------------------------
ALTER TABLE MISC_VCH_EMP ADD CONSTRAINT MISC_VCH_EMP_X PRIMARY KEY (TRAN_ID) USING INDEX TABLESPACE ITM_FIN_I1;

ALTER TABLE MISC_VCH_EMP ADD CONSTRAINT FK_MISCVCHEMP_SITE FOREIGN KEY ( SITE_CODE ) REFERENCES SITE( SITE_CODE ) ON DELETE CASCADE;
ALTER TABLE MISC_VCH_EMP ADD CONSTRAINT FK_MISCVCHEMP_ANAL FOREIGN KEY ( ANAL_CODE ) REFERENCES ANALYSIS( ANAL_CODE ) ON DELETE CASCADE;
ALTER TABLE MISC_VCH_EMP ADD CONSTRAINT FK_MISCVCHEMP_ACCT FOREIGN KEY ( ACCT_CODE__AP ) REFERENCES ACCOUNTS( ACCT_CODE ) ON DELETE CASCADE;
ALTER TABLE MISC_VCH_EMP ADD CONSTRAINT FK_MISCVCHEMP_CCTR FOREIGN KEY ( CCTR_CODE__AP ) REFERENCES COSTCTR( CCTR_CODE ) ON DELETE CASCADE;
ALTER TABLE MISC_VCH_EMP ADD CONSTRAINT FK_MISCVCHEMP_CURR FOREIGN KEY ( CURR_CODE ) REFERENCES CURRENCY( CURR_CODE ) ON DELETE CASCADE;
ALTER TABLE MISC_VCH_EMP ADD CONSTRAINT FK_MISCVCHEMP_ADV FOREIGN KEY ( ACCT_CODE__ADV ) REFERENCES ACCOUNTS( ACCT_CODE ) ON DELETE CASCADE;
ALTER TABLE MISC_VCH_EMP ADD CONSTRAINT FK_MISCVCHEMP_CADV FOREIGN KEY ( CCTR_CODE__ADV ) REFERENCES COSTCTR( CCTR_CODE ) ON DELETE CASCADE;



------------------------------------------------------------------------------
/* create MISC_VCH_EMP_det */
------------------------------------------------------------------------------

CREATE TABLE  MISC_VCH_EMPDET
(
	TRAN_ID    		CHAR(10)   		NOT NULL,
	LINE_NO         NUMBER(3)		NOT NULL,
	SUNDRY_TYPE		CHAR(1),
	SUNDRY_CODE		CHAR(10)		NOT NULL,
	EMP_CODE        CHAR(10),
	ACCT_CODE       CHAR(10)		NOT NULL,
	CCTR_CODE       CHAR(4),
	ACCT_CODE__ADV	CHAR(10)		NOT NULL,
	CCTR_CODE__ADV	CHAR(4),
	ANAL_CODE       CHAR(5),
	AMOUNT          NUMBER(14,3)	NOT NULL,
	APPLY_TAX       CHAR(1),
	DEPT_CODE       CHAR(5),
	REMARKS         VARCHAR2(60),
	TAX_CLASS       CHAR(5),
	TAX_CHAP        CHAR(10),
	TAX_ENV         CHAR(10)
)TABLESPACE ITM_FIN_D1;

------------------------------------------------------------------------------
/* set primary key and reference key for MISC_VCH_EMP_DET */
------------------------------------------------------------------------------

ALTER TABLE MISC_VCH_EMPDET ADD CONSTRAINT MISC_VCH_EMP_DET_X PRIMARY KEY (TRAN_ID,LINE_NO) USING INDEX TABLESPACE ITM_FIN_I1;

ALTER TABLE MISC_VCH_EMPDET ADD CONSTRAINT FK_MISCVCHEMPDET_TRAN_ID FOREIGN KEY ( TRAN_ID ) REFERENCES MISC_VCH_EMP( TRAN_ID ) ON DELETE CASCADE;	
ALTER TABLE MISC_VCH_EMPDET ADD CONSTRAINT FK_MISCVCHEMPDET_EMP FOREIGN KEY (EMP_CODE ) REFERENCES EMPLOYEE( EMP_CODE ) ON DELETE CASCADE;
ALTER TABLE MISC_VCH_EMPDET ADD CONSTRAINT FK_MISCVCHEMPDET_CCTR FOREIGN KEY (CCTR_CODE ) REFERENCES COSTCTR( CCTR_CODE ) ON DELETE CASCADE;	
ALTER TABLE MISC_VCH_EMPDET ADD CONSTRAINT FK_MISCVCHEMPDET_ACCT FOREIGN KEY (ACCT_CODE ) REFERENCES ACCOUNTS( ACCT_CODE ) ON DELETE CASCADE;	
ALTER TABLE MISC_VCH_EMPDET ADD CONSTRAINT FK_MISCVCHEMPDET_DEPT FOREIGN KEY (DEPT_CODE ) REFERENCES DEPARTMENT( DEPT_CODE ) ON DELETE CASCADE;	
ALTER TABLE MISC_VCH_EMPDET ADD CONSTRAINT FK_MISCVCHEMPDET_CADV FOREIGN KEY (CCTR_CODE__ADV ) REFERENCES COSTCTR( CCTR_CODE ) ON DELETE CASCADE;	
ALTER TABLE MISC_VCH_EMPDET ADD CONSTRAINT FK_MISCVCHEMPDET_ADV FOREIGN KEY (ACCT_CODE__ADV ) REFERENCES ACCOUNTS( ACCT_CODE ) ON DELETE CASCADE;


-----------------------------------------------------------
/* System tables Entries */
------------------------------------------------------------
INSERT INTO ITM2MENU 
(
	APPLICATION,
	LEVEL_1,
	LEVEL_2,
	LEVEL_3,
	LEVEL_4,
	LEVEL_5,
	WIN_NAME,
	DESCR,
	COMMENTS,
	MENU_PATH,
	ICON_PATH,
	OBJ_TYPE,
	CHG_USER,
	CHG_TERM,
	CHG_DATE,
	OPEN_ICON,
	CLOSE_ICON
)VALUES (
	'FIN',
	5,29,13,0,0,
	'w_misc_vch_emp',
	'P. Multi Sundry Misc. Voucher Creation',
	null,
	'FIN.5.29.13.0.0',
	'itm_logo.ico',
	null,
	null,
	null,
	null,
	null,
	null
);



--------------------------Object Forms-------------------------------------------------------------------------------------------------------------------

insert into obj_forms (WIN_NAME,TITLE,
OBJ_BROW_NAME,OBJ_EDIT_NAME,FORM_NO)
values('w_misc_vch_emp','Header',
'misc_vch_emp11','misc_vch_emp21','1');

insert into obj_forms (WIN_NAME,TITLE,
OBJ_BROW_NAME,OBJ_EDIT_NAME,FORM_NO)
values('w_misc_vch_emp','Detail',
'misc_vch_emp12','misc_vch_emp22','2');


----------------------------Object Actions------------------------------------------------------------------------------------------------------


insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,
CHG_DATE,CHG_TERM,CHG_USER)
values ('misc_vch_emp',1,'add.gif','Adding new','a','a','A','Add','1','S',sysdate,'BASE','BASE');
	
insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER)
values ('misc_vch_emp',2,'edit.gif','Editing Existing Record','a','a','E','Add','1','S',sysdate,'BASE','BASE');

	
INSERT INTO OBJ_ACTIONS 
(OBJ_NAME,LINE_NO ,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE)
 VALUES ('misc_vch_emp','3','D','a','a','Deleting','Delete','delete.gif','1',NULL,NULL,'S',NULL);
	

------------------------------------------------------Transetup------------------------------------------------------------------------
 
 insert into transetup(TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,CONFIRM_COL,CONFIRM_VAL,REPEAT_ADD_DET,LEDG_POST_CONF,
CHG_DATE_ON_CONF,TRAN_ID_COL,REF_SER,CONFIRM_MODE,WORKFLOW_OPT,TABLE_NAME,APPLICATION,TABLE_DESC,VIEW_MODE,CHILDDATA_ARGOPT,EDIT_OPT,PERIOD_OPTION)
values('w_misc_vch_emp','2','2','A','seq10',sysdate,'BASE','BASE','0','confirmed','Y','Y','N','N','TRAN_ID',
'EMPTRE','0','0','misc_vch_emp','FIN','','F','2','0','M');

 
 ------------------------------------------------System_events--------------------------------------------------------------------

INSERT INTO SYSTEM_EVENTS   (
	obj_name ,event_code ,event_context ,service_code ,method_rule ,chg_date ,chg_user ,chg_term ,
	result_handle ,overwrite_core ,	comp_type ,comp_name ,comm_format )
 VALUES ('misc_vch_emp','pre_validate','1','prv_default_ejb',NULL,
	sysdate,
	'BASE','BASE','1','0','EJB','MiscVchEmpIC',NULL);
	
INSERT INTO SYSTEM_EVENTS (
	obj_name ,event_code ,event_context ,service_code ,method_rule ,chg_date ,chg_user ,chg_term ,
	result_handle ,overwrite_core ,	comp_type ,comp_name ,comm_format )
 VALUES ('misc_vch_emp','post_item_change','1','poic_default_ejb',NULL,
	sysdate,
	'BASE','BASE','1','0','EJB','MiscVchEmpIC',NULL);
	
 
insert into finparm(
PRD_CODE,
 VAR_NAME,       
 VAR_TYPE,       
 VAR_VALUE,      
 CHG_DATE,       
 CHG_USER,       
 CHG_TERM,       
 DESCR
)
values(
'999999',
'ACCT_CODE_PAY',
'S',
'0',
fn_sysdate(),
'BASE22',
'BASE22',
'account code payble'
); 

update finparm set var_value='0064' where var_name='ACCT_CODE_PAY';
update finparm set var_name='ACCT_CODE_PE' where var_name='ACCT_CODE_PAY';
update finparm set DESCR='account code payble for prepaide expense' where var_name='ACCT_CODE_PE';


insert into finparm(
PRD_CODE,
 VAR_NAME,       
 VAR_TYPE,       
 VAR_VALUE,      
 CHG_DATE,       
 CHG_USER,       
 CHG_TERM,       
 DESCR
)
values(
'999999',
'ACCT_CODE_EMP',
'S',
'0',
fn_sysdate(),
'BASE22',
'BASE22',
'account code payable for employee'
);

update finparm set var_value='NEW0012' where var_name='ACCT_CODE_EMP';

insert into finparm(
PRD_CODE,
 VAR_NAME,       
 VAR_TYPE,       
 VAR_VALUE,      
 CHG_DATE,       
 CHG_USER,       
 CHG_TERM,       
 DESCR
)
values(
'999999',
'MVOUCH_TRAN_TYPE',
'S',
'DR',
fn_sysdate(),
'BASE22',
'BASE22',
'tran type for employee'
);

insert into obj_itemchange(
	OBJ_NAME,       
	FORM_NO,        
	FIELD_NAME
)
values
(
	'misc_vch_emp',
	1,
	'tran_date'
);

--Confirmed sql start

insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,
SERVICE_HANDLER,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER)
values ('misc_vch_emp',4,NULL,'Confirm','miscvch_conf','N','C','Confirm','1',
'2','U',sysdate,'BASE','BASE');   

INSERT INTO SYSTEM_EVENTS   (
	obj_name ,event_code ,event_context ,service_code ,method_rule ,chg_date ,chg_user ,chg_term ,
	result_handle ,overwrite_core ,	comp_type ,comp_name ,comm_format )
 VALUES (
	'misc_vch_emp','miscvch_conf','1','miscVchEmp_conf',NULL,
	sysdate,
	'Dadaso','BASE','1','0','EJB','MiscVchEmpIConf',NULL);
	
insert into system_event_services(SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
values ('miscVchEmp_conf','Action for confirmation of Misc Vch Emp','http://localhost:8080/axis/services/ActionHandlerService','BASE Information','confirm','String',
'S',sysdate,'BASE','BASE');

	
insert into system_service_args(SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
values ('miscVchEmp_conf',1,'COMPONENT_TYPE','I','Component Type','S',sysdate,'BASE','BASE','EJB');

insert into system_service_args(SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
values ('miscVchEmp_conf',2,'COMPONENT_NAME','I','Component name','S',sysdate,'BASE','BASE','MiscVchEmpIConf');


insert into system_service_args(SERVICE_CODE,LINE_NO,ARG_NAME,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
values ('miscVchEmp_conf',3,'<tran_id>','B.String',sysdate,'BASE','BASE');


insert into system_service_args(SERVICE_CODE,LINE_NO,ARG_NAME ,DESCR,ARG_TYPE,CHG_DATE, CHG_USER,CHG_TERM)                                       
values ('miscVchEmp_conf',4,'XTRA_PARAMS','params','S',sysdate,'BASE','BASE');

insert into system_service_args(SERVICE_CODE,LINE_NO,ARG_NAME ,DESCR,ARG_TYPE,CHG_DATE, CHG_USER,CHG_TERM)                                           
values ('miscVchEmp_conf',5,'FORCED_FLAG','flag','S',sysdate,'BASE','BASE');

--confirmed sql end


--Post save Misc_vch_emp [Start]

INSERT INTO SYSTEM_EVENTS (
	obj_name ,event_code ,event_context ,service_code ,method_rule ,chg_date ,chg_user ,chg_term ,
	result_handle ,overwrite_core ,	comp_type ,comp_name ,comm_format )
 VALUES ('misc_vch_emp','post_save','1','miscVchEmp_post_save',NULL,
	sysdate,
	'BASE','BASE','2','0','EJB','MiscVchEmpPostSave',NULL);
	
	
insert into system_event_services(
SERVICE_CODE,                                                                                                                                                                                                  
SERVICE_DESCR  ,                                                                                                                                                                                                         
SERVICE_URI,                                                                                                                                                                                                            
SERVICE_PROVIDER,                                                                                                                                                                                                   
METHOD_NAME,   
                                                                                                                                                                                          
RETURN_VALUE,                                                                                                                                                                                                   
RETURN_TYPE,                                                                                                                                                                                                   
                                                                                                                                                                                                    
CHG_DATE,                                                                                                                                                                                                               
CHG_USER,                                                                                                                                                                                                           
CHG_TERM                                                                                                                                                                                                       
)

values (
'miscVchEmp_post_save',
'Action To update totalamount in Header',
'http://localhost:8080/axis/services/ActionHandlerService',
'BASE Information',
'postSave',
'String',
'S',
sysdate,
'BASE',
'BASE'
);

insert into system_service_args(SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
values ('miscVchEmp_post_save',1,'COMPONENT_TYPE','I','Component Type','S',sysdate,'BASE','BASE','EJB');

insert into system_service_args(SERVICE_CODE,LINE_NO,ARG_NAME ,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE, CHG_USER,CHG_TERM,ARG_VALUE)                                           
values ('miscVchEmp_post_save',2,'COMPONENT_NAME','I','Component name','S',sysdate,'BASE','BASE','MiscVchEmpPostSave');


insert into system_service_args(SERVICE_CODE,LINE_NO,ARG_NAME ,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE, CHG_USER,CHG_TERM) 
                                          
values ('miscVchEmp_post_save',3,'XML_DATA_ALL','I','XML data','S',sysdate,'BASE','BASE');

insert into system_service_args(SERVICE_CODE,LINE_NO,ARG_NAME ,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE, CHG_USER,CHG_TERM) 
                                          
values ('miscVchEmp_post_save',4,'<tran_id>','I','tran id','S',sysdate,'BASE','BASE');

insert into system_service_args(SERVICE_CODE,LINE_NO,ARG_NAME ,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE, CHG_USER,CHG_TERM) 
                                          
values ('miscVchEmp_post_save',5,'EDIT_FLAG','I','edit flag','S',sysdate,'BASE','BASE');

insert into system_service_args(SERVICE_CODE,LINE_NO,ARG_NAME ,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE, CHG_USER,CHG_TERM) 
                                          
values ('miscVchEmp_post_save',6,'XTRA_PARAMS','I','Xtra params','S',sysdate,'BASE','BASE');

insert into system_service_args(SERVICE_CODE,LINE_NO,ARG_NAME ,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE, CHG_USER,CHG_TERM) 
                                          
values ('miscVchEmp_post_save',7,'DB_CONN','I','db conn','S.Connection',sysdate,'BASE','BASE');

--End post save

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMTRNDNN','Mandatory field','Transaction Date cannot be blank.Please enter Transaction Date','E',sysdate,'BASE','BASE');

insert into messages 
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMVCHTNN','Mandatory Selection','Please select Voucher Type','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMSUNYCNN','Mandatory field','Sundry Code cannot be blank.Please enter Sundry Code','E',sysdate,'BASE','BASE');


insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMSUNYCND','Invalid Sundry Code','Entered Sundry Code is not associated with sundry type','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMANALNF','Invalid Analysis Code','Entered Analysis Code is not defined in Analysis master','E',sysdate,'BASE','BASE');



insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMPAYACNN','Mandatory field','Please enter payable A/c','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMPAYACNF','payable A/c Not Found!','The payable A/c you have entered is not found in the accounts master.','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMACTADNF','Acct Code Adv. Not Found!','The Acct Code Adv. you have entered is not found in the accounts master.','E',sysdate,'BASE','BASE');


Insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMCTRADNF','Cctr Code Adv. Not Found!','The Cctr Code Adv. you have entered is not found in the costctr master.','E',sysdate,'BASE','BASE');



insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMACTCNN','Mandatory field','Please enter acct code','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMACTCNF','payable acct Not Found!','The payable acct code you have entered is not found in the accounts master.','E',sysdate,'BASE','BASE');


insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMCCTRNF','payable Cctr Not Found!','The payable Cctr code you have entered is not found in the costctr master.','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMCURRCNN','Mandatory field','Currency Code cannot be blank.Please enter Currency Code','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMCURRCND','Invalid Currency Code','Entered Currency Code is not defined in Currency master','E',sysdate,'BASE','BASE');


insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMBNKND','Invalid Bank Code','Entered Bank Code is not defined in Bank master','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMPROJCND','Invalid Project Code','Entered Project Code is not defined in Project master','E',sysdate,'BASE','BASE');




insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTSITENN','Mandatory field','SIte Code cannot be blank.Please enter Site Code','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTSITEND','Invalid Site Code','Entered Site Code is not defined in Site master','E',sysdate,'BASE','BASE');



insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMTAXCLND','Invalid tax class','Entered tax class is not defined in taxclass master','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMTAXCPND','Invalid tax Chapter','Entered tax Chapter is not defined in taxchap master','E',sysdate,'BASE','BASE');


insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMTAXENND','Invalid tax environment','Entered tax environment is not defined in taxenv master','E',sysdate,'BASE','BASE');    

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMAMTNN','Mandatory field','Amount cannot be blank.Please enter Amount','E',sysdate,'BASE','BASE');


insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMPAYMNN','Mandatory field','Please select Payment Mode','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMTRNCONN','Confirmation Error','Voucher not generated.Please check server log','E',sysdate,'BASE','BASE');


insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMTRNCONS','Transaction confirmed','Selected Transaction confirmed successfully','P',sysdate,'BASE','BASE');


insert into obj_itemchange (obj_name,form_no,field_name,mandatory) 
values('misc_vch_emp','1','itm_default',null); 

insert into obj_itemchange (obj_name,form_no,field_name,mandatory) 
values('misc_vch_emp','2','itm_default',null); 

insert into obj_itemchange (obj_name,form_no,field_name,mandatory)
values('misc_vch_emp','1','site_code','Y');

insert into obj_itemchange (obj_name,form_no,field_name,mandatory)
values('misc_vch_emp','1','acct_code__ap','Y');

insert into obj_itemchange (obj_name,form_no,field_name,mandatory)
values('misc_vch_emp','1','cctr_code__ap','Y');

insert into obj_itemchange (obj_name,form_no,field_name,mandatory)
values('misc_vch_emp','2','acct_code','Y');

insert into obj_itemchange (obj_name,form_no,field_name,mandatory)
values('misc_vch_emp','2','cctr_code','Y');

insert into obj_itemchange (obj_name,form_no,field_name,mandatory)
values('misc_vch_emp','2','sundry_code','Y');

--pophelp       

insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'ACCT_CODE__AP','W_MISC_VCH_EMP','SELECT ACCT_CODE, DESCR FROM ACCOUNTS','Account Code',0,0,sysdate,'BASE','BASE');

insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'CCTR_CODE__AP','W_MISC_VCH_EMP','SELECT CCTR_CODE,DESCR FROM COSTCTR','Cost Center Code',0,0,sysdate,'BASE','BASE');


insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'ACCT_CODE__ADV','W_MISC_VCH_EMP','SELECT ACCT_CODE, DESCR FROM ACCOUNTS','Account Code',0,0,sysdate,'BASE','BASE');

insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'CCTR_CODE__ADV','W_MISC_VCH_EMP','SELECT CCTR_CODE,DESCR FROM COSTCTR','Cost Center Code',0,0,sysdate,'BASE','BASE');


insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'SITE_CODE','W_MISC_VCH_EMP','SELECT SITE_CODE,DESCR FROM SITE','Site Code',0,0,sysdate,'BASE','BASE');

insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'CURR_CODE','W_MISC_VCH_EMP','SELECT CURR_CODE,DESCR FROM CURRENCY','Currency Code',0,0,sysdate,'BASE','BASE');

insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'PROJ_CODE','W_MISC_VCH_EMP','SELECT PROJ_CODE, DESCR FROM PROJECT ','Project Code',0,0,sysdate,'BASE','BASE');


insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'TAX_CLASS','W_MISC_VCH_EMP','SELECT TAX_CLASS,DESCR FROM TAXCLASS','Tax Class',0,0,sysdate,'BASE','BASE');


insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'TAX_CHAP','W_MISC_VCH_EMP','SELECT TAX_CHAP,DESCR FROM TAXCHAP','Tax Chapter',0,0,sysdate,'BASE','BASE');

insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'TAX_ENV','W_MISC_VCH_EMP','SELECT TAX_ENV,DESCR FROM TAXENV','Tax Environment',0,0,sysdate,'BASE','BASE');

insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'ANAL_CODE','W_MISC_VCH_EMP','SELECT ANAL_CODE, DESCR FROM ANALYSIS','Analysis Code',0,0,sysdate,'BASE','BASE');

insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'SUNDRY_CODE','W_MISC_VCH_EMP','SELECT EMP_CODE, EMP_LNAME, EMP_FNAME, DEPT_CODE FROM EMPLOYEE','Employee Code',0,0,sysdate,'BASE','BASE');

insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'ACCT_CODE','W_MISC_VCH_EMP','SELECT ACCT_CODE, DESCR FROM ACCOUNTS','Account Code',0,0,sysdate,'BASE','BASE');

insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'CCTR_CODE','W_MISC_VCH_EMP','SELECT CCTR_CODE,DESCR FROM COSTCTR','Cost Center Code',0,0,sysdate,'BASE','BASE');

--added on 2-AUG-2014

insert into obj_itemchange (obj_name,form_no,field_name,mandatory)
values('misc_vch_emp','1','curr_code','Y');

Insert into GENCODES (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3) 
values ('TRAN_TYPE','W_MISC_VCH_EMP','ADV','ADVANCE','ADVANCE',sysdate,'SUN','BASE','Y',null,null,null);

insert into pophelp(FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM)
values(	'TRAN_TYPE','W_MISC_VCH_EMP','select rtrim(fld_value),descr from gencodes where fld_name=''TRAN_TYPE'' AND MOD_NAME = ''W_MISC_VCH_EMP''','Transaction Type',0,0,sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VMCCTRND','Cctr code Not Found!','The Cctr code you have entered is not found in the costctr master.','E',sysdate,'BASE','BASE');

alter table misc_vch_emp add last_chq varchar2(20); 
alter table misc_vch_emp add chq_upto varchar2(20);
alter table misc_vch_emp add net_amt number(14,3);
alter table misc_vch_emp add net_amt__bc number(14,3);
alter table misc_vch_emp add total_amount__bc number(14,3);
alter table misc_vch_empdet add tax_amt number(14,3);




