/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import ibase.e12ria.client.E12ActionWrapper;

public class E12WizardFooter {
    private FooterType footerType;
    private Grid navigationFooter;

    public Widget createFooter(E12ActionWrapper actionWrapper, FooterType footerType) {
        try {
            if (footerType == null) {
                int noOfActions = actionWrapper.getRightsCharList().size();
                if (noOfActions <= 0) {
                    return this.navigationFooter;
                }
                if (noOfActions == 1) {
                    this.footerType = FooterType.FOOTERTYPE_ONE;
                    this.setNumberOfColumnForWidget();
                } else if (noOfActions == 2) {
                    this.footerType = FooterType.FOOTERTYPE_TWO;
                    this.setNumberOfColumnForWidget();
                } else if (noOfActions > 2) {
                    this.footerType = FooterType.FOOTERTYPE_THREE;
                    this.setNumberOfColumnForWidget();
                }
            } else {
                this.footerType = footerType;
                this.setNumberOfColumnForWidget();
            }
        }
        catch (Exception ee) {
            Window.alert((String)("Exception createFooter :" + ee.toString()));
        }
        return this.navigationFooter;
    }

    protected FooterType getFooterType() {
        return this.footerType;
    }

    private void setNumberOfColumnForWidget() {
        try {
            if (this.footerType == FooterType.FOOTERTYPE_ONE) {
                this.navigationFooter = new Grid(1, 2);
                this.navigationFooter.setWidth("100%");
                this.navigationFooter.getCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER);
                this.navigationFooter.getCellFormatter().setHorizontalAlignment(0, 1, HasHorizontalAlignment.ALIGN_RIGHT);
                this.navigationFooter.getCellFormatter().setWidth(0, 0, "80%");
                this.navigationFooter.getCellFormatter().setWidth(0, 1, "20%");
            } else if (this.footerType == FooterType.FOOTERTYPE_TWO) {
                this.navigationFooter = new Grid(1, 3);
                this.navigationFooter.setWidth("100%");
                this.navigationFooter.getCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT);
                this.navigationFooter.getCellFormatter().setHorizontalAlignment(0, 1, HasHorizontalAlignment.ALIGN_CENTER);
                this.navigationFooter.getCellFormatter().setHorizontalAlignment(0, 2, HasHorizontalAlignment.ALIGN_RIGHT);
                this.navigationFooter.getCellFormatter().setWidth(0, 0, "20%");
                this.navigationFooter.getCellFormatter().setWidth(0, 1, "60%");
                this.navigationFooter.getCellFormatter().setWidth(0, 2, "20%");
            } else if (this.footerType == FooterType.FOOTERTYPE_THREE) {
                this.navigationFooter = new Grid(1, 5);
                this.navigationFooter.setStyleName("navigationFooter");
                this.navigationFooter.setWidth("100%");
                this.navigationFooter.getCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT);
                this.navigationFooter.getCellFormatter().setHorizontalAlignment(0, 4, HasHorizontalAlignment.ALIGN_RIGHT);
                this.navigationFooter.getCellFormatter().setWidth(0, 0, "20%");
                this.navigationFooter.getCellFormatter().setWidth(0, 1, "20%");
                this.navigationFooter.getCellFormatter().setWidth(0, 2, "20%");
                this.navigationFooter.getCellFormatter().setWidth(0, 3, "20%");
                this.navigationFooter.getCellFormatter().setWidth(0, 4, "20%");
            }
        }
        catch (Exception ee) {
            Window.alert((String)("Exception setNumberOfColumnForWidget :" + ee.toString()));
        }
    }

    public void addWidgetInFooter(Widget widget, int positionWidget) {
        try {
            if (widget == null || this.navigationFooter == null) {
                return;
            }
            int row = 0;
            int column = this.getColumnPosition(positionWidget);
            if (column == -1) {
                Window.alert((String)this.getExceptionMessage());
                return;
            }
            this.navigationFooter.setWidget(row, column, widget);
        }
        catch (Exception ee) {
            Window.alert((String)("Exception addWidgetInFooter :" + ee.toString()));
        }
    }

    private int getColumnPosition(int positionWidget) {
        int returnValue = -1;
        try {
            block1 : switch (this.footerType) {
                case FOOTERTYPE_ONE: {
                    switch (positionWidget) {
                        case 1: {
                            returnValue = positionWidget;
                            break block1;
                        }
                        case 2: {
                            returnValue = positionWidget - 2;
                        }
                    }
                    break;
                }
                case FOOTERTYPE_TWO: {
                    switch (positionWidget) {
                        case 1: {
                            returnValue = positionWidget + 1;
                            break block1;
                        }
                        case 2: {
                            returnValue = positionWidget - 2;
                            break block1;
                        }
                        case 3: {
                            returnValue = positionWidget - 2;
                        }
                    }
                    break;
                }
                case FOOTERTYPE_THREE: {
                    switch (positionWidget) {
                        case 1: {
                            returnValue = positionWidget + 3;
                            break block1;
                        }
                        case 2: {
                            returnValue = positionWidget - 2;
                            break block1;
                        }
                        case 3: {
                            returnValue = positionWidget - 1;
                            break block1;
                        }
                        case 4: {
                            returnValue = positionWidget - 1;
                            break block1;
                        }
                        case 5: {
                            returnValue = positionWidget - 4;
                        }
                    }
                    break;
                }
                default: {
                    returnValue = -1;
                    break;
                }
            }
        }
        catch (Exception ee) {
            Window.alert((String)("Exception getColumnPosition :" + ee.toString()));
        }
        return returnValue;
    }

    private String getExceptionMessage() {
        String returnString = "";
        switch (this.footerType) {
            case FOOTERTYPE_ONE: {
                returnString = "Cannot insert more than two widget.";
                break;
            }
            case FOOTERTYPE_TWO: {
                returnString = "Cannot insert more than three widget.";
                break;
            }
            case FOOTERTYPE_THREE: {
                returnString = "Cannot insert more than five widget.";
                break;
            }
        }
        return returnString;
    }

    public static enum FooterType {
        FOOTERTYPE_ONE,
        FOOTERTYPE_TWO,
        FOOTERTYPE_THREE;

    }
}

