package ibase.webitm.servlet.wms;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.bean.wms.ItemDetailsBean;
import ibase.webitm.bean.wms.PorderDetailBean;
import ibase.webitm.ejb.wms.ConsignmentDetailsRemote;
import ibase.webitm.ejb.wms.DDPorderWizEJB;
import ibase.webitm.ejb.wms.DDPorderWizPosEJB;
import ibase.webitm.ejb.wms.DDPorderWizPosEJBRemote;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.GZIPOutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;


public class ProdWizItemChangeServlet extends HttpServlet 
{
	private static final long serialVersionUID = 1L;
	InitialContext ctx = null;

	/**
     * @see HttpServlet#HttpServlet()
     */
    public ProdWizItemChangeServlet() {
        super();
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		doPost( request, response );
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ ProdWizItemChangeServlet ]XXXXXXXXXXXXXXXXXXXX");

		ServletOutputStream outputStream = null;
		HttpSession sess = null;
		
		String sql = "", sqlSel = "";
		
		Connection conn = null;
		PreparedStatement pstmt = null, pstmtSel = null;
		ResultSet rs = null, rsSel = null;
		String finalItmQtyStr = "";
		
		// Changed By Sneha on 31-05-2016, for PO details [Start]
		String phyAttribute1 = "", phyAttribute2 = "", phyAttribute3 = "", itemCode = "", phyAttribute1DB = "", phyAttribute2DB = "", 
				phyAttribute3DB = "", purcOrder = "", itemParent = "", quantity = "", flag = "", xtraParams = "",
				xmlString1 = "", xmlString2 = "", xmlStringAll = "", detail3Str = "", ordSiteCode = "", dlvDate = "",
				userId = "", empCode = "", xmlString1New = "", str = "", empCodeFrmReq = "", siteCode = "", purcOrderTemp = "";
		int count = 0;
		StringBuffer valueXmlString = new StringBuffer();
		Document dom1 = null, dom2 = null;
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();  
	    DocumentBuilder builder;  
	    boolean isError = false;
	    Date dlvDateDt = null;
	    
	    // Changed By Sneha on 31-05-2016, for PO details [End]
	    
		try 
		{
			//StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
			String sizeCode = request.getParameter("SIZECODE");
			String objName = (request.getParameter("OBJ_NAME")==null) ? "":request.getParameter("OBJ_NAME").trim();
			//Added by Prasad on 08/06/15 [for multiple action] START
			String action = request.getParameter("ACTION");
			System.out.println("ACTION from request ====>> ["+action+"]");
			//Added by Prasad on 08/06/15 [for multiple action] END
			
			// Changed by Sneha on 07-04-2016, for item description [Start]
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			
			E12GenericUtility genericUtility = new E12GenericUtility();
		    SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			itemCode = request.getParameter("ITEMCODE"); 
			phyAttribute1 = request.getParameter("PHYATTRIBUTE1"); 
			phyAttribute2 = request.getParameter("PHYATTRIBUTE2"); 
			phyAttribute3 = request.getParameter("PHYATTRIBUTE3"); 
			
			//System.out.println("PHYATTRIBUTE1 from request = ["+ phyAttribute1 +"] PHYATTRIBUTE2 = ["+ phyAttribute2 +"] PHYATTRIBUTE3 = ["+ phyAttribute3 +"]");
			// Changed by Sneha on 07-04-2016, for item description [End]
			
			// Changed By Sneha on 31-05-2016, for PO details [Start]
			PorderDetailBean porderDetailBean = new PorderDetailBean();
			DDPorderWizEJB ddPorderWizEJB = new DDPorderWizEJB();
			DDPorderWizPosEJB ddPorderWizPosEJB = new DDPorderWizPosEJB();
			
			purcOrder = (request.getParameter("PURCHORDER")==null) ? "":request.getParameter("PURCHORDER").trim();
			flag = (request.getParameter("FLAG")==null) ? "":request.getParameter("FLAG").trim();
			xmlString1 = (request.getParameter("XMLSTRING1")==null) ? "":request.getParameter("XMLSTRING1").trim();
			xmlString2 = (request.getParameter("XMLSTRING2")==null) ? "":request.getParameter("XMLSTRING2").trim();
			xmlStringAll = (request.getParameter("XMLSTRINGALL")==null) ? "":request.getParameter("XMLSTRINGALL").trim();	
			str = (request.getParameter("STR")==null) ? "":request.getParameter("STR").trim();	
			siteCode = (request.getParameter("SITECODE")==null) ? "":request.getParameter("SITECODE").trim();	
			empCodeFrmReq = (request.getParameter("EMPCODE")==null) ? "":request.getParameter("EMPCODE").trim();	
			// Changed By Sneha on 31-05-2016, for PO details [End]
			
			// Changed By Sneha on 29-06-2016, for PO Save [Start]
			HttpSession session = null;
			session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			userId = userInfo.getLoginCode();
			ordSiteCode = userInfo.getSiteCode();
			empCode = userInfo.getEmpCode();
			
		/*	System.out.println("ordSiteCode========>>" + ordSiteCode);
			System.out.println("userId========>>" + userId);
			System.out.println("empCode========>>" + empCode);*/
			// Changed By Sneha on 29-06-2016, for PO Save [End]
			
			/*sess = request.getSession();
			System.out.println( "sess.getId() :["+sess.getId()+"]" );
			
			if(ctx == null)
			{
				ctx = getInitialContext();  
			}*/
			
			ItemDetailsBean itemDetailsBean = new ItemDetailsBean();
			//changed by Prasad on 08/06/15 [for multiple action] START
			//String sizeDetails = itemDetailsBean.getSizeDetails(sizeCode);
			//E12GenericUtility genericUtility = new E12GenericUtility();
			String retStr = "";
			if ( action.equalsIgnoreCase( "GET_SIZE_DTL" ) )
			{
				System.out.println("SIZECODE = ["+ sizeCode +"] OBJ_NAME = ["+ objName +"]");
				retStr = itemDetailsBean.getSizeDetails(sizeCode);
			}
			else if ( action.equalsIgnoreCase( "GET_APPL_DATEFORMAT" ) )
			{
				retStr = genericUtility.getApplDateFormat();
			}
			
			// Changed by Sneha on 25-10-2016, for customer item reference flag [Start]
			else if ( action.equalsIgnoreCase( "CUST_ITEM_REF" ) )
			{
				retStr = itemDetailsBean.getCustItemRefFlag();
			}
			// Changed by Sneha on 25-10-2016, for customer item reference flag [End]
			
			// Changed by Sneha on 23-11-2016, to default values flag and autogenerate barcode flag [Start]
			else if ( action.equalsIgnoreCase( "SET_DEFAULT_VALUES" ))
			{
				retStr = itemDetailsBean.getDefaultValuesFlag();
			}
			else if ( action.equalsIgnoreCase( "SET_DEFAULT_BARCODE_FLAG" ))
			{
				retStr = itemDetailsBean.getDefaultBarcodeFlag();
			}
			/*else if ( action.equalsIgnoreCase( "GET_DEFAULT_BARCODE_VAL" ))
			{
				retStr = itemDetailsBean.defaultBarcodeVal(userId);
			}*/
			// Changed by Sneha on 23-11-2016, to default values flag and autogenerate barcode flag [End]
			
			// Changed by Sneha on 07-04-2016, for item description [Start]
			else if(action.equalsIgnoreCase( "GET_ITEM_DESCR" ))
			{
				System.out.println("itemCode inside GET_ITEM_DESCR ---------->>" + itemCode);
				sql = " SELECT ITEM_PARNT FROM ITEM WHERE ITEM_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					sqlSel = " SELECT ATTR_VALUE FROM OBJ_ATTRIBUTE WHERE ITEM_ATTR_VAL = 'ITEM_CODE:"+checkNullAndTrim(rs.getString("ITEM_PARNT"))+"' AND LANGUAGES = 'EN' ";
					pstmtSel = conn.prepareStatement(sqlSel);
					rsSel = pstmtSel.executeQuery();
					if (rsSel.next())
					{
						retStr = checkNullAndTrim(rsSel.getString("ATTR_VALUE"));
					}
					if (rsSel != null) 
					{					
						rsSel.close();
						rsSel = null;
					}
					if (pstmtSel != null ) 
					{					
						pstmtSel.close();
						pstmtSel = null;
					}
				}

				if (rs != null) 
				{					
					rs.close();
					rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();
					pstmt = null;
				}
			}
			else if(action.equalsIgnoreCase( "GET_ITEM_ATTRIBUTE" ))
			{
				System.out.println("itemCode inside GET_ITEM_ATTRIBUTE ---------->>" + itemCode);
				sql = " SELECT ITEM_PARNT FROM ITEM WHERE ITEM_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					sqlSel = "SELECT PHY_ATTRIB_1, PHY_ATTRIB_2, PHY_ATTRIB_3 FROM ITEM WHERE ITEM_PARNT = '"+checkNullAndTrim(rs.getString("ITEM_PARNT"))+"'  ";
					pstmtSel = conn.prepareStatement(sqlSel);
					rsSel = pstmtSel.executeQuery();
					while(rsSel.next())
					{
						phyAttribute1DB = checkNullAndTrim(rsSel.getString("PHY_ATTRIB_1"));
						phyAttribute2DB = checkNullAndTrim(rsSel.getString("PHY_ATTRIB_2"));
						phyAttribute3DB = checkNullAndTrim(rsSel.getString("PHY_ATTRIB_3"));
						
						//System.out.println("PHYATTRIBUTE1 from Database = ["+ phyAttribute1DB +"] PHYATTRIBUTE2 = ["+ phyAttribute2DB +"] PHYATTRIBUTE3 = ["+ phyAttribute3DB +"]");

						if(phyAttribute1DB.equalsIgnoreCase(phyAttribute1) && phyAttribute2DB.equalsIgnoreCase(phyAttribute2) && phyAttribute3DB.equalsIgnoreCase(phyAttribute3))
						{
							//System.out.println("----------- phyAttributes found same ------------------");
							retStr = "Y";
						}
						else
						{
							retStr = "N";
						}
					}
					if (rsSel != null) 
					{					
						rsSel.close();
						rsSel = null;
					}
					if (pstmtSel != null ) 
					{					
						pstmtSel.close();
						pstmtSel = null;
					}
				}
				if (rs != null) 
				{					
					rs.close();
					rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();
					pstmt = null;
				}
			}
			// Changed by Sneha on 07-04-2016, for item description [End]
			
			// Changed By Sneha on 31-05-2016, for PO details [Start]
			else if(action.equalsIgnoreCase( "GET_PURC_DET_1" ))
			{
				System.out.println("purcOrder Inside if GET_PURC_DET_1 = ["+ purcOrder +"]");
				retStr = porderDetailBean.getPurcDetail1(purcOrder, flag);
			}
			else if(action.equalsIgnoreCase( "GET_PURC_DET_2" ))
			{
				System.out.println("purcOrder Inside if GET_PURC_DET_2 = ["+ purcOrder +"]");
			    HashMap<String, String> hm = new HashMap<String, String>();
				

			    if(flag.equalsIgnoreCase("A") && purcOrder.length() <= 0)	// Add mode, Purchase order blank
			    {
			    	//System.out.println("Inside 111111 ["+ purcOrder +"]");
			    	
			    	sqlSel = " SELECT PURC_ORDER FROM PORDER_TEMP WHERE STATUS = ? AND EMP_CODE = ? AND SITE_CODE__ORD = ?   ";
					pstmtSel = conn.prepareStatement(sqlSel);
					pstmtSel.setString(1, "A");
					pstmtSel.setString(2, empCodeFrmReq);
					pstmtSel.setString(3, siteCode);		
					rsSel = pstmtSel.executeQuery();
					if(rsSel.next())
					{
						purcOrderTemp = checkNullAndTrim(rsSel.getString("PURC_ORDER"));
						
						sql = " SELECT I.ITEM_PARNT, P.ITEM_CODE, P.DLV_DATE, P.QUANTITY FROM PORDDET_TEMP P, ITEM I WHERE PURC_ORDER = ? " 
							+ " AND I.ITEM_CODE = P.ITEM_CODE ORDER BY I.ITEM_PARNT,  P.ITEM_CODE ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, purcOrderTemp);
					}
					if(rsSel != null)
					{
						rsSel.close();
						rsSel = null;
					}
					if(pstmtSel != null)
					{
						pstmtSel.close();
						pstmtSel = null;
					}
			    }
				else if(flag.equalsIgnoreCase("E") && purcOrder.length() > 0)	// Edit mode, Purchase order found
			    {
					//System.out.println("Inside 333333333 ["+ purcOrder +"]");
					
					sql = "SELECT  I.ITEM_PARNT, P.ITEM_CODE, P.DLV_DATE, P.QUANTITY  FROM PORDDET P, ITEM I WHERE PURC_ORDER = ? AND " 
						+ "I.ITEM_CODE = P.ITEM_CODE AND P.Item_code not in (SELECT  PT.ITEM_CODE FROM PORDDET_TEMP PT WHERE PURC_ORDER = ? ) " 
						+ "UNION  " 
						+ "SELECT  I.ITEM_PARNT, PT.ITEM_CODE, PT.DLV_DATE, PT.QUANTITY FROM PORDDET_TEMP PT, ITEM I WHERE PURC_ORDER = ? " 
						+ "AND I.ITEM_CODE = PT.ITEM_CODE ORDER BY 1, 2 ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, purcOrder);
					pstmt.setString(2, purcOrder);
					pstmt.setString(3, purcOrder);
			    }
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					itemParent = checkNullAndTrim(rs.getString("ITEM_PARNT"));
					itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
					dlvDateDt = rs.getDate("DLV_DATE");
					quantity = checkNullAndTrim(rs.getString("QUANTITY"));

					dlvDate = sdf.format(dlvDateDt).toString();
					if(hm.containsKey(itemParent))
					{	
						String itemQtyStr = hm.get(itemParent); 
						hm.put(itemParent, itemQtyStr + itemCode + "::" + quantity + "~");
					}
					else
					{
						//10115C****301761~02/06/16****301761::1||||10****301738~02/06/16****301738::2~301736::3
						hm.put(itemParent, (itemParent + "****" + itemCode + "~" + dlvDate + "****" +itemCode + "::" + quantity + "~"));
					}
					itemParent = "";
					itemCode = "";
					dlvDateDt = null;
					quantity = "";
				}
				if (rs != null) 
				{					
					rs.close();
					rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();
					pstmt = null;
				}
				
				 Set<String> setOfKeys = hm.keySet();
				 Iterator<String> iterator = setOfKeys.iterator();
				 finalItmQtyStr = "";
				 while (iterator.hasNext()) 
				 {
					 String key = (String) iterator.next();
					 String value = hm.get(key);
					 //System.out.println("Key =========>> "+ key+", Value =============>> "+ value);
					 finalItmQtyStr = finalItmQtyStr+value.substring(0,value.length()-1)+"||||";
				 }
				 retStr = finalItmQtyStr;
			}
			else if(action.equalsIgnoreCase( "VALIDATE_PO" ) || action.equalsIgnoreCase( "VALIDATE_PO_NEXT" ) )
			{
				sql = " SELECT COUNT(*) FROM PORDER WHERE PURC_ORDER = ? AND CONFIRMED = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, purcOrder);
					pstmt.setString(2, "N");
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						count = rs.getInt(1);
					}
					if (rs != null) 
					{					
						rs.close();
						rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();
						pstmt = null;
					}
					retStr = String.valueOf(count);
			}
			// Changed By Sneha on 31-05-2016, for PO details [End]
			
			// Changed By Sneha on 29-06-2016, for PO Save [Start]
			else if(action.equalsIgnoreCase( "SAVE_PODtl1" ))
			{
				System.out.println("------Inside SAVE_PODtl1 ---------");

				java.sql.Timestamp currdate = new java.sql.Timestamp( System.currentTimeMillis() );
				
				String[] detail = str.split("~");
				
				/*for(int i = 0; i<= detail.length -1; i++ )
				{
					System.out.println("detail value of ["+i+"]======>>" + detail[i]);
				}*/

				//System.out.println("detail value of [29]======>>" + detail[29]);
				if(detail[29].equalsIgnoreCase("A"))
				{
					sqlSel = " SELECT PURC_ORDER FROM PORDER_TEMP WHERE STATUS = ? AND EMP_CODE = ? AND SITE_CODE__ORD = ? ";
					pstmtSel = conn.prepareStatement(sqlSel);
					pstmtSel.setString(1, detail[29]);
					pstmtSel.setString(2, detail[26]);
					pstmtSel.setString(3, detail[2]);		
				}
				else if(detail[29].equalsIgnoreCase("E"))
				{
					sqlSel = " SELECT PURC_ORDER FROM PORDER_TEMP WHERE STATUS in (?,?) AND EMP_CODE = ? AND SITE_CODE__ORD = ? AND PURC_ORDER = ? ";
					pstmtSel = conn.prepareStatement(sqlSel);
					pstmtSel.setString(1, detail[29]);
					pstmtSel.setString(2, "O");
					pstmtSel.setString(3, detail[26]);
					pstmtSel.setString(4, detail[2]);
					pstmtSel.setString(5, detail[0]);
				}
				rsSel = pstmtSel.executeQuery();
				if( rsSel.next() )
				{	
					purcOrderTemp = checkNullAndTrim(rsSel.getString("PURC_ORDER"));
				}
				if(rsSel != null)
				{
					rsSel.close();
					rsSel = null;
				}
				if(pstmtSel != null)
				{
					pstmtSel.close();
					pstmtSel = null;
				}
				
				if(detail[0].length() <= 0 && purcOrderTemp.length() > 0)	// Add mode old record
				{
					detail[0] = purcOrderTemp;
				}
				else if(detail[0].length() <= 0 && purcOrderTemp.length() <= 0)	// Add mode new record
				{
					detail[0] = generateTranId( "w_porderWiz_temp", ordSiteCode, conn );
					System.out.println("purchase order after generateTranId ======>>" + detail[0]);
				}
				System.out.println("------- purchase order after ----- " + detail[0]);
				
				if(purcOrderTemp.length() > 0)		// purchase order found blank and Status = "A"  ADD 
				{
					System.out.println("UPDATE PORDER_TEMP ======>>"+detail[0]);

					sql = "UPDATE PORDER_TEMP SET TRAN_DATE = ?, PORD_TYPE = ?, ITEM_SER = ?, TASK_DESC = ?, SUPP_CODE = ?, SUPP_NAME = ?, " 
					+ "CR_TERM = ?, CRTERM_DESCR = ?, REMARKS = ?, DLV_TERM = ?, TRAN_CODE = ?, TRAN_NAME = ?, PRICE_LIST = ?, " 
					+ "EXCH_RATE = ?, DEPT_CODE = ?, DEPT_DESCR = ?, TRANS_MODE = ?, SITE_ADD1 = ?, CURR_CODE = ?, TERM_TABLE = ?, " 
					+ "UDF_STR__1 = ?, CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ?, STATUS = ? " 
					+ "WHERE PURC_ORDER = ? AND EMP_CODE = ? AND SITE_CODE__ORD = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1, currdate);	// TRAN_DATE
					pstmt.setString(2, detail[3]);		// pord_type
					pstmt.setString(3, detail[4]);		// itmser
					pstmt.setString(4, detail[5]);		// itmdescr/TASK_DESC
					pstmt.setString(5, detail[6]);		// supcode
					pstmt.setString(6, detail[7]);		// supname
					pstmt.setString(7, detail[8]);		// crterm
					pstmt.setString(8, detail[9]);		// crdescr
					pstmt.setString(9, detail[10]);		// remarks
					pstmt.setString(10, detail[12]);	// dlvterm
					pstmt.setString(11, detail[13]);	// trcode
					pstmt.setString(12, detail[14]);	// trdescr
					pstmt.setString(13, detail[17]);	// prlist
					pstmt.setString(14, detail[19]);	// exch_rate
					pstmt.setString(15, detail[20]);	// dcode
					pstmt.setString(16, detail[21]);	// ddescr
					pstmt.setString(17, detail[15]);	// trmode
					pstmt.setString(18, detail[24]);	// site_add1
					pstmt.setString(19, detail[18]);	// curr_code
					pstmt.setString(20, detail[22]);	// term_table
					pstmt.setString(21, detail[23]);	// udf_str__1
					pstmt.setTimestamp(22, currdate);	// CHG_DATE
					pstmt.setString(23, detail[27]);	// CHG_USER
					pstmt.setString(24, detail[28]);	// CHG_TERM
					pstmt.setString(25, detail[29]);	// STATUS
					
					pstmt.setString(26, detail[0]);		// purc_order
					pstmt.setString(27, detail[26]);	// EMP_CODE
					pstmt.setString(28, detail[2]);		// SITE_CODE__ORD
					pstmt.executeUpdate();
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
				else if(purcOrderTemp.length() <= 0)	
				{
					System.out.println("INSERT into PORDER_TEMP ======>>"+detail[0]);					
					
					String orddate = genericUtility.getValidDateTimeString(
						checkNullAndTrim(detail[1]), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());

					sql = "INSERT INTO PORDER_TEMP(PURC_ORDER, ORD_DATE, TRAN_DATE, PORD_TYPE, ITEM_SER, TASK_DESC, SUPP_CODE, SUPP_NAME, " 
						+ "CR_TERM, CRTERM_DESCR, REMARKS, DLV_TERM, TRAN_CODE, TRAN_NAME, PRICE_LIST, EXCH_RATE, DEPT_CODE, DEPT_DESCR, " 
						+ "TRANS_MODE, SITE_CODE__DLV, SITE_CODE__ORD, SITE_ADD1, CURR_CODE, TERM_TABLE, UDF_STR__1, " 
						+ "UDF_STR__2, EMP_CODE, CHG_DATE, CHG_USER, CHG_TERM, STATUS) " 
						+ " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, detail[0]);		// purc_order
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(orddate));		// orddate
					pstmt.setTimestamp(3, currdate);	// TRAN_DATE
					pstmt.setString(4, detail[3]);		// pord_type
					pstmt.setString(5, detail[4]);		// itmser
					pstmt.setString(6, detail[5]);		// itmdescr/TASK_DESC
					pstmt.setString(7, detail[6]);		// supcode
					pstmt.setString(8, detail[7]);		// supname
					pstmt.setString(9, detail[8]);		// crterm
					pstmt.setString(10, detail[9]);		// crdescr
					pstmt.setString(11, detail[10]);	// remarks
					pstmt.setString(12, detail[12]);	// dlvterm
					pstmt.setString(13, detail[13]);	// trcode
					pstmt.setString(14, detail[14]);	// trdescr
					pstmt.setString(15, detail[17]);	// prlist
					pstmt.setString(16, detail[19]);	// exch_rate
					pstmt.setString(17, detail[20]);	// dcode
					pstmt.setString(18, detail[21]);	// ddescr
					pstmt.setString(19, detail[15]);	// trmode
					pstmt.setString(20, detail[11]);	// site_code__dlv
					pstmt.setString(21, detail[2]);		// order_site/SITE_CODE__ORD
					pstmt.setString(22, detail[24]);	// site_add1
					pstmt.setString(23, detail[18]);	// curr_code
					pstmt.setString(24, detail[22]);	// term_table
					pstmt.setString(25, detail[23]);	// udf_str__1
					pstmt.setString(26, detail[25]);	// udf_str__2
					pstmt.setString(27, detail[26]);	// EMP_CODE
					pstmt.setTimestamp(28, currdate);	// CHG_DATE
					pstmt.setString(29, detail[27]);	// CHG_USER
					pstmt.setString(30, detail[28]);	// CHG_TERM
					pstmt.setString(31, detail[29]);			// STATUS
					//pstmt.setString(28, detail[17]);	// delivery_term_descr
					pstmt.executeUpdate();
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				//retStr = detail[0];
			}
			else if(action.equalsIgnoreCase( "SAVE_PODtl2" ))
			{
				//System.out.println("------------- Inside SAVE_PODtl2 -----------" + str);

				String[] detail = str.split("~");
				
				/*for(int i = 0; i<= detail.length -1; i++ )
				{
					System.out.println("detail value of ["+i+"]======>>" + detail[i]);
				}*/
				String purcOrderFrmHdr = "";	
				if(detail[6].equalsIgnoreCase("A"))		// Status
				{
					sqlSel = " SELECT PURC_ORDER FROM PORDER_TEMP WHERE STATUS = ? AND EMP_CODE = ? AND SITE_CODE__ORD = ? ";
					pstmtSel = conn.prepareStatement(sqlSel);
					pstmtSel.setString(1, detail[6]);		 //Status
					pstmtSel.setString(2, detail[4]);		 // Emp_Code
					pstmtSel.setString(3, detail[5]);		// order_site/SITE_CODE__ORD
					rsSel = pstmtSel.executeQuery();
					if(rsSel.next())
					{
						purcOrderFrmHdr = rsSel.getString("PURC_ORDER");
					}
					if(rsSel != null)
					{
						rsSel.close();
						rsSel = null;
					}
					if(pstmtSel != null)
					{
						pstmtSel.close();
						pstmtSel = null;
					}
				}
				else
				{
					purcOrderFrmHdr = detail[7];
				}
				//System.out.println("purcOrderFrmHdr after ======>>" + purcOrderFrmHdr);
				
				if(!detail[2].trim().equalsIgnoreCase("") && Integer.parseInt(detail[2]) > 0)			
				{
					sqlSel = "SELECT ITEM_CODE FROM PORDDET_TEMP PD WHERE PURC_ORDER = ? AND ITEM_CODE = ? ";
					pstmtSel = conn.prepareStatement(sqlSel);
					pstmtSel.setString(1, purcOrderFrmHdr);			// PURC_ORDER
					pstmtSel.setString(2, detail[1]);				// ITEM_CODE
					rsSel = pstmtSel.executeQuery();
					if( rsSel.next() )
					{
						sql = "UPDATE PORDDET_TEMP SET QUANTITY = ? WHERE PURC_ORDER = ? AND ITEM_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, detail[2]);				// QUANTITY	
						pstmt.setString(2, purcOrderFrmHdr);		// PURC_ORDER
						pstmt.setString(3, detail[1]);				// ITEM_CODE
						pstmt.executeUpdate();
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					else
					{
						dlvDate = genericUtility.getValidDateTimeString(
								checkNullAndTrim(detail[3]), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());

						sql = "INSERT INTO PORDDET_TEMP(PURC_ORDER, SITE_CODE, ITEM_CODE, QUANTITY, DLV_DATE) " 
								+ " VALUES(?,?,?,?,?)";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, purcOrderFrmHdr);	// PURC_ORDER
						pstmt.setString(2, detail[0]);			// SITE_CODE
						pstmt.setString(3, detail[1]);			// ITEM_CODE
						pstmt.setString(4, detail[2]);			// QUANTITY	
						pstmt.setTimestamp(5, java.sql.Timestamp.valueOf(dlvDate));		// DLV_DATE
						pstmt.executeUpdate();
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					if(rsSel != null)
					{
						rsSel.close();
						rsSel = null;
					}
					if(pstmtSel != null)
					{
						pstmtSel.close();
						pstmtSel = null;
					}
				}
				else if(detail[2].trim().equalsIgnoreCase("") || Integer.parseInt(detail[2]) <= 0)	// if Quantity is zero
				{
					sql = "DELETE FROM PORDDET_TEMP WHERE PURC_ORDER = ? AND ITEM_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, purcOrderFrmHdr);		// PURC_ORDER
					pstmt.setString(2, detail[1]);				// ITEM_CODE
					pstmt.executeUpdate();
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			else if(action.equalsIgnoreCase( "RESET_PODtl" ))
			{
				System.out.println("------Inside RESET_PODtl ---------");
				
				String[] detail = str.split("~");
				
				/*for(int i = 0; i<= detail.length -1; i++ )
				{
					System.out.println("detail value of ["+i+"]======>>" + detail[i]);
				}*/
				
				sql = "UPDATE PORDER_TEMP SET STATUS = ? WHERE  STATUS = ? AND EMP_CODE = ? AND SITE_CODE__ORD = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "C");				
				pstmt.setString(2, detail[2]);		
				pstmt.setString(3, detail[0]);	
				pstmt.setString(4, detail[1]);	
				pstmt.executeUpdate();
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			
			// Changed By Sneha on 29-06-2016, for PO Save [End]
			
			System.out.println("retStr ====>> ["+retStr+"]");
			//changed by Prasad on 08/06/15 [for multiple action] START
            
            response.setContentType("text/xml");
            
            if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
			{
				response.setHeader("Content-Encoding", "gzip");
				GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
				gzOutStream.write(retStr.toString().getBytes());
				gzOutStream.flush();
				gzOutStream.close();
			}
			else
			{
				response.setHeader("Content-Encoding", "");
				OutputStream outStream = response.getOutputStream();
				outStream.write(retStr.toString().getBytes());
				outStream.flush();
				outStream.close();
			}
			System.out.println("****** ProdWizItemChangeServlet call end successfully ***********");
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
	        System.out.println("Exception :ProdWizItemChangeServlet: doPost :==>");
	        try 
	        {
				throw new ITMException(e);
			} 
	        catch (ITMException e1) 
	        {
	        	isError = true;
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			
		}
		// Changed by Sneha on 07-04-2016 [Start]
		finally 
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();
					rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();
					pstmt = null;
				}
				if (rsSel != null) 
				{					
					rsSel.close();
					rsSel = null;
				}
				if (pstmtSel != null ) 
				{					
					pstmtSel.close();
					pstmtSel = null;
				}
				// Changed by Sneha [Start]
				if( !isError  )
				{
					System.out.println("------- commmited succesfully --------");
					conn.commit();  
				}
				else if ( isError )
				{
					System.out.println("------- rollback succesfully --------");
					conn.rollback();
				}	
				// Changed by Sneha [End]
				
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();
					conn = null;
				}
			} 
			// Changed by Sneha on 07-04-2016 [End]
			catch (Exception e) 
			{
				System.out.println("Exception :ProdWizItemChangeServlet :==>\n"+ e.getMessage());
				try {
					throw new ITMException(e);
				} catch (ITMException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			}
		}
	}
	
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[ProdWizItemChangeServlet] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[ProdWizItemChangeServlet] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}
	
	private String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	// Changed by Sneha, on 28-07-2016 for generating tran_id [Start]
	private String generateTranId( String windowName, String siteCode, Connection conn )throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";
		String paySiteCode = "";
		String effectiveDate = "";
		java.sql.Timestamp currDate = null;
		java.sql.Date effDate = null;
		E12GenericUtility genericUtility = new E12GenericUtility();

		try
		{

			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());

			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			String currDateStr = sdfAppl.format(currDate);

			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";

			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +        "<tran_id></tran_id>";
			xmlValues = xmlValues +        "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +        "<tran_date>" + currDateStr + "</tran_date>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);
		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e){}
		}
		return checkNullAndTrim(tranId);
	}
	// Changed by Sneha, on 28-07-2016 for generating tran_id [End]
	
}
