package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.AT;
import ibase.webitm.bean.gst.InvLineItem;

public class ATSearializer extends BaseSerializer<AT>
{
	@Override
	public void serialize(AT at, JsonGenerator json, SerializerProvider serializeProvider) throws IOException, JsonProcessingException
	{
		json.writeStartObject();
		
		json.writeStringField("typ", at.typ);
		json.writeStringField("cpty", at.cpty);
		json.writeStringField("state_cd", at.stateCode);
		json.writeStringField("doc_num", at.docNum);
		json.writeStringField("doc_dt", gstFmt.format(at.docDt));
		
		writeLineItems(at, json);
		
		json.writeEndObject();
	}
	
	 private void writeLineItems(AT at, JsonGenerator json) throws IOException 
	    {
	        json.writeFieldName("itms");
	        
	        json.writeStartArray();
	        
	        for(InvLineItem li : at.itms)
	        {
	        	writeLineItem(json, li);
	        }

	        json.writeEndArray();
	    }

	    private void writeLineItem(JsonGenerator json, InvLineItem li) 
	    {
	        try 
	        {
	            json.writeStartObject();
	            
	            //json.writeStringField("ty", li.ty);
	            //json.writeStringField("hsn_sc", li.hsn_sc);
	            json.writeNumberField("ad_amt", li.taxval);

	            //json.writeNumberField("irt", li.irt);
	            json.writeNumberField("iamt", li.iamt);
	            
	        	//json.writeNumberField("crt", li.crt);
	        	json.writeNumberField("camt", li.camt);
	        	
	        	//json.writeNumberField("srt", li.srt);
	        	json.writeNumberField("samt", li.samt);
	            
	            //json.writeNumberField("csrt", li.csrt);
	            json.writeNumberField("csamt", li.csamt);
	            
	            json.writeEndObject();
	        }
	        catch (Exception e) 
	        {
	        	System.out.println("ATSearializer.writeLineItem()["+e.getMessage()+"]");
	            e.printStackTrace();
	        }
	    }
}
