/*
 * Author:Manish Singh
 * Date:28-Apr-15
 * Request ID:D15AKAT017 (Item Attribute)
 */

package ibase.webitm.ejb.wms;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

@Stateless
public class ItemAttributeIC extends ValidatorEJB implements ItemAttributeICLocal, ItemAttributeICRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();	

	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = null;
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("Val xmlString :: " + xmlString );
			System.out.println("Val xmlString1 :: " + xmlString1 );
			System.out.println("Val xmlString2 :: " + xmlString2 );
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);

			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException( e );
		}
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("wfValData.....called..");
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0,currentFormNo =0,childNodeListLength =0;
		String loginSite="",userId="";
		String childNodeName = null,childNodeValue = null;
		String errString = "";
		Connection conn = null;
		SimpleDateFormat simpleDateFormat = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String attribCode = "";
		String sql = "";
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]

			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
				case 1 :
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{	
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						System.out.println("itmAttr_codechildNodeName.editFlag." + childNodeName+".." + editFlag);
						if(childNode.getFirstChild()!= null)
						{
							childNodeValue = childNode.getFirstChild().getNodeValue();
						}
		
						if(childNodeName.equalsIgnoreCase("ATTRIB_CODE") )
						{
							if (childNode.getFirstChild() == null)
							{
								errString = getErrorString("ATTRIB_CODE","VMATTCOD",userId);
								break ;
							}
		
						}
						else if(childNodeName.equalsIgnoreCase("DESCR"))
						{
							if (childNode.getFirstChild() == null)
							{
								errString = getErrorString("DESCR","VMDESCR",userId);
								break ;
							}
						}
						
					}
					break;
				
			}//END SWITCH
			System.out.println("EditFlag : "+editFlag);
			if(!"E".equalsIgnoreCase(editFlag))
			{
				attribCode = checkNull(genericUtility.getColumnValue("attrib_code", dom));
				sql =" SELECT count(1) FROM ITEM_ATTRIBUTE WHERE attrib_code=? " ;	
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, attribCode);
				rs = pstmt.executeQuery();
				int count=0;
				if(rs.next())
				{
					count = rs.getInt(1);
				}
				pstmt.close();
				rs.close();
				if(count != 0 )
				{	 
					errString = getErrorString("attrib_id","VTEXIST",userId);
					return errString;
				}	
			}
			
		}//END TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
			errString=e.getMessage();
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		System.out.println("ErrString ::"+errString);
		return errString;
	}
	private String checkNull( String input )
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}  


}
