package ibase.webitm.ejb.fin.adv;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.utility.ITMException;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import javax.ejb.Stateless;
import javax.imageio.ImageIO;
import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Element;
/**
 * Session Bean implementation class GstRegNoIC
 */
@Stateless
public class CostCtrAllocIC extends ValidatorEJB implements CostCtrAllocICRemote, CostCtrAllocICLocal 
{
	public String globalXtraParams = "";
	E12GenericUtility genericUtility = new E12GenericUtility();
	DecimalFormat deciFormater = new DecimalFormat("0.00");
   	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException 
    {
   	   Document dom = null; 
   	   Document dom1 = null; 
   	   Document dom2 = null;
   	   String retString = "";	
       try
       {
    	    System.out.println("*************** Inside wfValData *******************");  	   		
	   		if(xmlString != null && xmlString.trim().length()>0)
	   		{
	   			dom = genericUtility.parseString(xmlString);		
	   		}
	   		if(xmlString1 != null && xmlString1.trim().length()>0)
	   		{
	   			dom1 = genericUtility.parseString(xmlString1);
	   		}
	   		if(xmlString2 != null && xmlString2.trim().length()>0)
	   		{
	   			dom2 = genericUtility.parseString(xmlString2);
	   		}
	   		retString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
	   		System.out.println("errorString::::::::::"+retString);
		}
        catch(Exception e)
        {
	        System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 
        }
        return retString;	    
	}
   	
	public String wfValData(Document dom, Document dom1, Document dom2,String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
		System.out.println("********************** Inside CostCtrAllocIC class ******************");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String sql="";
		String errorType = "",errString="";
		String errCode = "",userId = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		int currentFormNo = 0;
		NodeList parentNodeList = null;
		Node parentNode = null;
		NodeList childNodeList = null;
		Node childNode = null;
		int childNodeLength = 0;
	    int ctr = 0, cnt = 0;
		String childNodeName = "",siteCode="",prdCode="";
		double totalPer=0 ,crntPer=0;
		String allocation = "",CurrentLineNo="";
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{
			conn = getConnection();
			
			if(objContext != null && objContext.trim().length()>0)
			{
			    currentFormNo = Integer.parseInt(objContext);
			    System.out.println("currentFormNo::: in Validation"+currentFormNo);
		        switch(currentFormNo)
		    	{
		    		case 1:
		    		{	
		    			parentNodeList = dom.getElementsByTagName("Detail1");
		    			parentNode = parentNodeList.item(0);
		    			childNodeList = parentNode.getChildNodes();
		    			childNodeLength = childNodeList.getLength();
		    			
		    			for(ctr = 0; ctr < childNodeLength; ctr++)
		    			{
		    				childNode =  childNodeList.item(ctr);
		    				childNodeName = childNode.getNodeName();
		    				System.out.println("childNodeName:::"+childNodeName);
		    						    					    				
		    				if("site_code".equalsIgnoreCase(childNodeName))
		    				{
		    					siteCode = checkNull(genericUtility.getColumnValue("site_code",dom)).trim();
		    					System.out.println("site_code******"+siteCode);	    					        
		    			    }//end of if block for site_code	
		    				else if("prd_code".equalsIgnoreCase(childNodeName))
		    				{
		    				   prdCode = checkNull(genericUtility.getColumnValue("prd_code",dom)).trim();
		    				   System.out.println("Period Code is :::"+prdCode);
		    				  
		    				}//end of if block for prd_code
		    		     }//end of for loop	
		    			 if(siteCode == null || siteCode.trim().length() ==0)
		    			 {
		    				 errCode = "VMPSITECD";
		    				 errList.add(errCode);
		    				 errFields.add(childNodeName.toLowerCase());
		    			 }
		    			 else
		    			 {
		    				 sql = "select count(*) as cnt from site where site_code=?";
		    				 pstmt = conn.prepareStatement(sql);
		    				 pstmt.setString(1,siteCode);
		    				 rs = pstmt.executeQuery();
		    				 if(rs.next())
		    				 {
		    					 cnt = rs.getInt("cnt");
		    				 }
		    				 if(pstmt != null)
		    				 {
		    					 pstmt.close(); 
		    					 pstmt = null;
		    				 }
		    				 if(rs != null)
		    				 {
		    					 rs.close();
		    					 rs = null;
		    				 }		 
		    				 if(cnt==0)
		    				 {
		    					 errCode = "VTSITEXT";
		    					 errList.add(errCode);
		    					 errFields.add(childNodeName.toLowerCase());
		    				 }
		    			 }
		    			 if(prdCode == null || prdCode.trim().length() == 0)
		    			 {
		    				 	errCode = "VPATDPRC01";
  								errList.add(errCode);
  								errFields.add(childNodeName.toLowerCase());
		    			 }
		    			 else 
		    			 {
		    				 prdCode = checkNull(genericUtility.getColumnValue("prd_code", dom)).trim();
		    				 sql = "select count(*) as cnt from period where code=?";
		    				 pstmt = conn.prepareStatement(sql);
		    				 pstmt.setString(1,prdCode);
		    				 rs = pstmt.executeQuery();
		    				 if(rs.next())
		    				 {
		    					 cnt = rs.getInt("cnt");
		    				 }
		    				 if(pstmt != null)
		    				 {
		    					 pstmt.close(); 
		    					 pstmt = null;
		    				 }
		    				 if(rs != null)
		    				 {
		    					 rs.close();
		    					 rs = null;
		    				 } 
		    				 if(cnt==0)
		    				 {
		    					 errCode = "VTMONATD10";
		    					 errList.add(errCode);
		    					 errFields.add(childNodeName.toLowerCase());	
		    				 }
		    			 }				
		    			 System.out.println("Site Code is ==="+siteCode +"----- AND -----"+"Period Code is ===="+prdCode);
		    			 
		    			 sql = "select count(*) as count from resource_cons where site_code=? and prd_code=?";
		    			 pstmt = conn.prepareStatement(sql);
		    			 pstmt.setString(1,siteCode);
		    			 pstmt.setString(2,prdCode);
		    			 rs = pstmt.executeQuery();
		    			 if(rs.next())
		    			 {
		    				 cnt = rs.getInt("count");
		    				 System.out.println("Count is :::::"+cnt);
		    			 }
		    			 if(pstmt != null)
		    			 {
		    				 pstmt.close(); 
		    				 pstmt = null;
		    			 }
		    			 if(rs != null)
		    			 {
		    				 rs.close();
		    				 rs = null;
		    			 }		    
						
						if(cnt > 0)
						{
							errCode = "INVPRDSTCD";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						  	
		    		}//end of case1
		    		break;
		    		
		    		case 2:
		    		{ 
		    			System.out.println("Inside Case3 Validation:::");	
		    		    parentNodeList = dom.getElementsByTagName("Detail2");
		    			parentNode = parentNodeList.item(0);
		    			childNodeList = parentNode.getChildNodes();
		    			childNodeLength = childNodeList.getLength();
		    			for(ctr = 0; ctr < childNodeLength; ctr++)
		    			{
		    				childNode =  childNodeList.item(ctr);
		    				childNodeName = childNode.getNodeName();
		    				System.out.println("childNodeName::: for Case3"+childNodeName);
		    			}	
		    		}
		    		break;
		    		
		    		case 3:
		    		{
		    			System.out.println("Inside Case3 Validation:::");	
		    		    parentNodeList = dom.getElementsByTagName("Detail3");
		    			parentNode = parentNodeList.item(0);
		    			childNodeList = parentNode.getChildNodes();
		    			childNodeLength = childNodeList.getLength();
		    			for(ctr = 0; ctr < childNodeLength; ctr++)
		    			{
		    				childNode =  childNodeList.item(ctr);
		    				childNodeName = childNode.getNodeName();
		    				System.out.println("childNodeName::: for Case3"+childNodeName);
		    				if("allocation".equalsIgnoreCase(childNodeName))
		    				{
		    					allocation = checkNull(genericUtility.getColumnValue("allocation",dom)).trim();
		    					CurrentLineNo= checkNull(genericUtility.getColumnValue("line_no",dom)).trim();
		    					System.out.println("Allocation Percentage Value is :::::["+allocation+"]");
		    					
		    					if(allocation.trim().length()==0 || allocation == null)
		    					{
		    						System.out.println("inside alloc_perc LENGTH..");
		    						errCode = "VMEMPQLF03";
		  							errList.add(errCode);
		  							errFields.add(childNodeName.toLowerCase());
		    					}
		    					else
		    					{
		    						System.out.println("inside alloc_perc ");
		    						crntPer = Double.parseDouble(allocation);
		    						System.out.println("crntPer :::::["+crntPer+"]");
		    						//Added by sarita on 06NOV2017
		    						System.out.println("detailString value is =="+genericUtility.serializeDom(dom));
									NodeList detailNoteList = dom2.getElementsByTagName("Detail3");
									//updateFlag = getAttributeVal(childNode,"updateFlag");
									//System.out.println("updateFlag is :::::::::::::::"+updateFlag);
									//int detlCnt = detailNoteList.getLength();
									int detlCnt = getNumOfNonDelDetail(dom2,3);
									System.out.println("DETAIL COUNT" +detlCnt);
									totalPer = getNumOftotalallocPercentage( dom2 ,CurrentLineNo);
									System.out.println("TOTAL AMOUNT..." +totalPer);
									//Added by sarita on 06NOV2017
									 if(detlCnt != 0)
									 {
										   if(totalPer > 100)
											{
												System.out.println("AMOUNT..." +crntPer);
												errCode = "OVERALLINV";
												errList.add(errCode);
												errFields.add(childNodeName.toLowerCase());
											}
											else if(totalPer < 100)
											{
												System.out.println("AMOUNT..." +crntPer);
												errCode = "VTRCONT2";
												errList.add(errCode);
												errFields.add(childNodeName.toLowerCase());
											}		 
									 }
												
								/*	if(detlCnt >=2)
									{	
										totalPer = getNumOftotalallocPercentage( dom2 ,CurrentLineNo);
										System.out.println("TOTAL AMOUNT..." +totalPer);
										double remAmt = 100 - totalPer; // 5
										if(crntPer > remAmt) //
										{
											System.out.println("EXCEED AMOUNT..." +remAmt);
											errCode = "OVERALLINV";
											errList.add(errCode);
											errFields.add(childNodeName.toLowerCase());

										}
									}
									else
									{
										if(crntPer > 100)
										{
											System.out.println("AMOUNT..." +crntPer);
											errCode = "OVERALLINV";
											errList.add(errCode);
											errFields.add(childNodeName.toLowerCase());
										}
									}*/
		    					}
		    				}
		    			}//end of for loop	
		    	}//end of case3
		    	break;  		    		
		    }//end of switch statement		    	
		    int errListSize = errList.size();
		    System.out.println("errListSize::::::::::"+errListSize);
		    int count = 0;
		    String errFldName = null;
		    if (errList != null && errListSize > 0)
		    {
		    	for (count = 0; count < errListSize; count++)
		    	{
		    		errCode = errList.get(count);
		    		errFldName = errFields.get(count);
		    		System.out.println(" testing :errCode .:" + errCode);
		    		errString = getErrorString(errFldName, errCode, userId);
		    		System.out.println("errString>>>>>>>>>"+errString);
		    		errorType = errorType(conn, errCode);
		    		if (errString.length() > 0)
		    		{
		    			String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
		    			bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
		    			errStringXml.append(bifurErrString);
		    			errString = "";
		    		}
		    		if (errorType.equalsIgnoreCase("E"))
		    		{
		    			break;
		    		}
		    	}//end of for loop
		    	errList.clear();
		    	errList = null;
		    	errFields.clear();
		    	errFields = null;
		    	errStringXml.append("</Errors> </Root> \r\n");
		    } 
		    else
		    {
		    	errStringXml = new StringBuffer("");
		    }
		}//end of if for obj_context	
	}//end of try block			
	catch(Exception e)
	{
		System.out.println("Exception ::"+e);
		e.printStackTrace();
	}
	finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
					conn.close();
				}
				conn = null;
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
	}//end of finally block
	errString = errStringXml.toString();
	System.out.println("testing : final errString : " + errString);
	return errString;
}// end of wfvalData method
	
private String checkNull(String input) 
{
	return input == null ? "" : input;
}
	
public String defaultDataWiz() throws RemoteException, ITMException
{
	return "";
}

	//private String defaultDataWiz( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName ) throws RemoteException,ITMException
	/*public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn,String editFlag, String xtraParams) throws RemoteException,ITMException 
	{
		Document dom=null;
		Document domhr=null;
		Document domAll=null;
		String retString="";
		try
		{
			System.out.println("**************  Inside itemChanged method ****************");
			if(xmlString != null && xmlString.trim().length()>0)
	   		{
				dom = genericUtility.parseString(xmlString);		
	   		}
			if(xmlString1 != null && xmlString1.trim().length()>0)
	   		{
				domhr = genericUtility.parseString(xmlString1);		
	   		}
			if(xmlString2 != null && xmlString2.trim().length()>0)
	   		{
				domAll = genericUtility.parseString(xmlString2);		
	   		}
			retString = itemChanged(dom,domhr,domAll,objContext,currentColumn,editFlag,xtraParams);	
			//retString = "<?xml version='"+1.0+"'?><Root><header><editFlag>null</editFlag></header><Detail1 domID='1'><site_code><![CDATA[TA821]]></site_code><site_descr><![CDATA[TARO PHARMACEUTICALS, USA, HAWTHORNE, NY]]></site_descr><period_descr><![CDATA[]]></period_descr></Detail1></Root>";
			System.out.println("retString123::::::::::"+retString);
		}
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 	
		}
		return retString;
	}*/
	
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn,String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			System.out.println ( "**********************itemChanged Called********");
			System.out.println ( "xmlString :" + xmlString);
			System.out.println ( "xmlString1 :" + xmlString1);
			System.out.println ( "xmlString2 :" + xmlString2);

			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			//System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			String errString1 = "";
			StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
			errString1 = genericUtility.createErrorString( e ) ;
			
			if ( errString.length() > 0)
			{
				String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
				bifurErrString =bifurErrString;//+"<trace>"+errMsg+"</trace>";
				bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
				errStringXml.append(bifurErrString);
				System.out.println("errStringXml .........."+errStringXml);
				errString1 = "";
			}
			errStringXml.append("</Errors></Root>\r\n");  
                           

		}
		return errString;
	}

	//Code for Default Data
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String returnStr="";
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0,k=0,childNodeListLength=0;
		String columnValue = null;
		String childNodeName = null;
		Connection conn = null;
		int currentFormNo = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",descr ="";
		String userId = "",loginSite = "" ,empFname = "",empLname = "",query =""; 
		String deptHead="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try{

			returnStr = defaultDataWiz(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			if(objContext != null && objContext.trim().length() > 0)
				k = Integer.parseInt(objContext);
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return returnStr;
	}

	//public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag,String xtraParams) throws RemoteException, ITMException
	private String defaultDataWiz( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
    {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		int currentFormNo=0,ctr = 0;	
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		NodeList childNodeList = null;
		int childNodeLength = 0;
		String childNodeName = "";
		String columnValue="",loginSite="",sql="",siteCode="",siteDescr="",prdCode="",prdCodeDescr="";
		String sSQL ="",sSQL1 ="", sSQL2 ="",sSQL3 ="";
		String fromDate = "", toDate ="",acctPeriod = "",finEntity ="";
		ArrayList cosAllocationList =  new ArrayList();
		HashMap dataMap = null;
		String 	cctrCodeFrm = "", acctCode = "",subGroupCode = "",groupCode = "",accCatGrp = "", allocBasis = "",resBasis = "",tranIDMst = "";
		int childNodeListLength = 0;
		Timestamp fromDateTimestamp = null;
		Timestamp toDateTimestamp = null;
		int domID=0,domIDDet =0;
		String drcrFlagVal = "", allocdescr = "";
		double allocation_perc=0,unitAllocation = 0;;
		int cnt=0;
		double allocPercent=0;
		try
		{
			conn = getConnection();
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			System.out.println("loginSiteCode is>>>>>>>>>>>"+loginSite);
			System.out.println("[CostCtrAllocIC] [itemChanged] :currentFormNo ....." +currentFormNo);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>\r\n");
			valueXmlString.append(editFlag).append("</editFlag></header>\r\n");
			
			switch(currentFormNo)
			{
				case 1 :
				{
					domID++;
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					valueXmlString.append("<Detail1 domID='" + domID + "'>\r\n");
					childNodeListLength = childNodeList.getLength();
					ArrayList gstList = new ArrayList();
					System.out.println("currentColumn-------->>[" + currentColumn + "]");
					
					if("itm_default".equalsIgnoreCase(currentColumn.trim()))
					{
						valueXmlString.append("<site_code><![CDATA[").append(loginSite).append( "]]></site_code>");
						sql = "select descr from site where site_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,loginSite);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							siteDescr = rs.getString("descr");	
							System.out.println("SiteDescr>>>>>>>>>"+siteDescr);
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}	
						valueXmlString.append("<site_descr><![CDATA[").append(siteDescr).append( "]]></site_descr>");
						
						sql = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
					   	pstmt = conn.prepareStatement(sql);
					   	pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateString(new Date(), genericUtility.getDBDateFormat()+" 00:00:00.0")));
					   	
					   	rs = pstmt.executeQuery();
					   	
					   	if(rs.next())
					   	{
					   	 prdCode = rs.getString("CODE") == null ? "" : rs.getString("CODE");
					   	}
					   	if(pstmt != null)
					   	{
					   	 pstmt.close();
					   	 pstmt = null;
					   	}
					   	if(rs != null)
					   	{
					   	 rs.close();
					   	 rs = null;
					   	}
					   	valueXmlString.append("<prd_code>").append("<![CDATA["+prdCode+"]]>").append("</prd_code>");
					   	
					   	sql = "select descr from period where code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,prdCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							prdCodeDescr = rs.getString("descr");
						}
						if(pstmt != null)
					    {
						  pstmt.close(); 
						  pstmt = null;
						}
						if(rs != null)
						{
						 rs.close();
						 rs = null;
						}		    
						valueXmlString.append("<period_descr>").append("<![CDATA["+prdCodeDescr+"]]>").append("</period_descr>\r\n");
					}
					else if("site_code".equalsIgnoreCase(currentColumn.trim()))
					{
						siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));
						System.out.println("Site Code is ===="+siteCode);
						sql = "select descr from site where site_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							siteDescr = rs.getString("descr");	
							System.out.println("SiteDescr>>>>>>>>>"+siteDescr);
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}	
						valueXmlString.append("<site_descr><![CDATA[").append(siteDescr).append( "]]></site_descr>\r\n");
					}
					else if("prd_code".equalsIgnoreCase(currentColumn.trim()))
					{
						prdCode = checkNull(genericUtility.getColumnValue("prd_code", dom));
						System.out.println("prdCode :::["+prdCode+"]");
						 
						sql = "select descr from period where code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,prdCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							prdCodeDescr = rs.getString("descr");
							System.out.println("Description is ::::===="+prdCodeDescr);
						}
						if(pstmt != null)
					    {
						  pstmt.close(); 
						  pstmt = null;
						}
						if(rs != null)
						{
						 rs.close();
						 rs = null;
						}		    
						valueXmlString.append("<period_descr>").append("<![CDATA["+prdCodeDescr+"]]>").append("</period_descr>\r\n");
					}		
					valueXmlString.append("</Detail1>\r\n");
					break;
				}
				
				case 2 :
				{
					parentNodeList = dom.getElementsByTagName("Detail2");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					childNodeListLength = childNodeList.getLength();
					ArrayList gstList = new ArrayList();
					ArrayList<HashMap> cctrDataList = null;
					System.out.println("currentColumn-------->>[" + currentColumn + "]");
					
					prdCode = checkNull(genericUtility.getColumnValue("prd_code", dom1));
					siteCode = checkNull(genericUtility.getColumnValue("site_code", dom1));
					System.out.println("prdCode ::::["+prdCode+"]" + "siteCode ::::["+siteCode+"]");
					
					if("itm_default".equalsIgnoreCase(currentColumn.trim()))
					{
						/*valueXmlString.append("<acct_code><![CDATA[").append("acct01").append( "]]></acct_code>");
						valueXmlString.append("<accounts_descr><![CDATA[").append("Trave Expense").append( "]]></accounts_descr>");
						valueXmlString.append("<costalloc_bas_alloc_basis><![CDATA[").append("Percentage(%) Basis").append( "]]></costalloc_bas_alloc_basis>");*/				 
						
						sSQL = "select fr_date, to_date, acct_prd from period where code = ?";
						pstmt = conn.prepareStatement(sSQL);
						pstmt.setString(1,prdCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							fromDate = rs.getString("fr_date");
							toDate = rs.getString("to_date");
							acctPeriod = rs.getString("acct_prd");
						}				
						
						if(pstmt != null)
					    {
						  pstmt.close(); 
						  pstmt = null;
						}
						if(rs != null)
						{
						 rs.close();
						 rs = null;
						}
						
						
						sSQL = "select fin_entity  from site where site_code = ?";
						pstmt = conn.prepareStatement(sSQL);
						pstmt.setString(1,siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							finEntity = rs.getString("fin_entity");
						}				
						
						if(pstmt != null)
					    {
						  pstmt.close(); 
						  pstmt = null;
						}
						if(rs != null)
						{
						 rs.close();
						 rs = null;
						}
						System.out.println("fromDate ::"+fromDate + "toDate ::"+toDate);
						if(fromDate != null && fromDate.length() > 0)
						{
							fromDateTimestamp = Timestamp.valueOf(fromDate);
						}
						
						if(toDate != null && toDate.length() > 0)
						{
							toDateTimestamp = Timestamp.valueOf(toDate);
							//toDateTimestamp = Timestamp.valueOf(genericUtility.getValidDateTimeString(toDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat()));
						}
						
						
						/*sSQL = "select tran_id,cctr_code__from, sgroup_code,group_code, acct_code, alloc_basis, res_basis,  from costalloc_bas " 
								+ " where site_code = ? " 
								+" and eff_date <= ?  " 
								+" and exp_date >= ? "
								+" group by cctr_code__from, sgroup_code, group_code,  acct_code";*/
						
						sSQL = "select tran_id,cctr_code__from, sgroup_code,group_code,acct_cat, acct_code, alloc_basis, res_basis from costalloc_bas " 
								+ " where site_code = ? " 
								+" and eff_from >= ?  " 
								+" and valid_upto <= ? ";
								
					 
						pstmt = conn.prepareStatement(sSQL);
						pstmt.setString(1,siteCode);
						pstmt.setTimestamp(2,fromDateTimestamp);
						pstmt.setTimestamp(3,toDateTimestamp);
						rs = pstmt.executeQuery();
						
						while(rs.next())
						{
							
							dataMap = new HashMap();
							dataMap.put("tran_id", rs.getString("tran_id"));
							dataMap.put("cctr_code__from", rs.getString("cctr_code__from"));
							dataMap.put("acct_code", rs.getString("acct_code"));
							dataMap.put("sgroup_code", rs.getString("sgroup_code"));
							dataMap.put("group_code", rs.getString("group_code"));
							dataMap.put("alloc_basis", rs.getString("alloc_basis"));
							dataMap.put("res_basis", rs.getString("res_basis"));
							//changes by sarita to put acct_cat in dataMap on 03-NOV-2017
							dataMap.put("acct_cat", rs.getString("acct_cat"));
							System.out.println("siteCode::["+siteCode+"]"+"traidMst::["+rs.getString("tran_id")+"]"+"resBas::["+rs.getString("res_basis")+"]"+"allocBas::["+rs.getString("alloc_basis")+"]"+"Account Category ::["+rs.getString("acct_cat")+"]");
							cctrDataList = getCostCenterList(siteCode, rs.getString("tran_id"), rs.getString("res_basis"), rs.getString("alloc_basis"), conn);
							dataMap.put("cctr_list", cctrDataList);
							cosAllocationList.add(dataMap);
					
						}
						
						if(pstmt != null)
					    {
						  pstmt.close(); 
						  pstmt = null;
						}
						
						if(rs != null)
						{
						 rs.close();
						 rs = null;
						}		    
						
						int listLength = cosAllocationList.size();
						
						System.out.println("cosAllocationList ++++++++++++["+listLength+"]");
						
						if(listLength> 0)
						{
							
							for (int cCtr = 0; cCtr < listLength; cCtr++)
							{
								HashMap tempMap = (HashMap)cosAllocationList.get(cCtr);
																
								cctrCodeFrm = (String)tempMap.get("cctr_code__from");
								acctCode = (String)tempMap.get("acct_code");
								subGroupCode = (String)tempMap.get("sgroup_code");
								accCatGrp = (String)tempMap.get("acct_cat");
								groupCode = (String)tempMap.get("group_code");
								allocBasis = (String)tempMap.get("alloc_basis");
								resBasis = (String)tempMap.get("res_basis");
								tranIDMst = (String)tempMap.get("tran_id");
								/*ArrayList cctrList = (ArrayList)tempMap.get("cctr_list");
								
								System.out.println("cctrList :::------------------"+cctrList+"]")*/;
								
								ArrayList<HashMap> accountDataList = getAllocationAmt(siteCode ,groupCode,subGroupCode ,accCatGrp,acctCode,acctPeriod,finEntity,cctrCodeFrm,prdCode ,conn);
								System.out.println("accountList :::////////////////////////"+accountDataList.toString());
								
								int accountListLength = accountDataList.size();
								System.out.println("accountListLength ++++++++++++"+accountListLength);
								
								if("1".equalsIgnoreCase(allocBasis))
								{
									allocdescr = "Percentage";
								}
								else
								{
									allocdescr = "Resource";
								}
								System.out.println("allocdescr ::::: ["+allocdescr+"]");
								
								double totUnit = 0.0;
								String acctCodeGet = "",acctCodeGetDescr = " ",detail3 ="";
								
								if(accountListLength > 0)
								{
									HashMap acctDataMap = null;
									for(int acctCtr =0;acctCtr <accountListLength;acctCtr++)
									{
										acctDataMap = accountDataList.get(acctCtr);
										
										acctCodeGet = (String)acctDataMap.get("acct_code");
										acctCodeGetDescr = (String)acctDataMap.get("acct_descr");
										totUnit = (Double)acctDataMap.get("alloc_amt");
										acctCodeGet = acctCodeGet.trim();
										drcrFlagVal = (String)acctDataMap.get("drcr_flag");
										/*tempMap.put("acct_code", acountCode);
										tempMap.put("acct_descr", acctDescr);
										tempMap.put("alloc_amt", allocAmt);*/
										System.out.println("Value of drcr_flag is ======="+drcrFlagVal);
										domID++;
										valueXmlString.append("<Detail2 domID='" + domID + "' selected=\"Y\">\r\n");
										valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\"/>\r\n");
										//valueXmlString.append("<tran_id><![CDATA[" ).append(checkNull("1")).append( "]]></tran_id>\r\n" );
										valueXmlString.append("<tran_id_mst><![CDATA[" ).append(checkNull(tranIDMst)).append( "]]></tran_id_mst>\r\n" );
										valueXmlString.append("<prd_code><![CDATA[" ).append(checkNull(prdCode)).append( "]]></prd_code>\r\n" );
										valueXmlString.append("<site_code><![CDATA[" ).append(checkNull(siteCode)).append( "]]></site_code>\r\n" );
										valueXmlString.append("<from_date><![CDATA[" ).append(checkNull("")).append( "]]></from_date>\r\n" );
										valueXmlString.append("<to_date><![CDATA[" ).append(checkNull("")).append( "]]></to_date>\r\n" );
										valueXmlString.append("<acct_code><![CDATA[" ).append(checkNull(acctCodeGet)).append( "]]></acct_code>\r\n" );
										valueXmlString.append("<cctr_code><![CDATA[" ).append(checkNull(cctrCodeFrm)).append( "]]></cctr_code>\r\n" );
										valueXmlString.append("<exp_head><![CDATA[" ).append(checkNull(acctCodeGetDescr)).append( "]]></exp_head>\r\n" );
										valueXmlString.append("<alloc_basis><![CDATA[" ).append(checkNull(allocBasis)).append( "]]></alloc_basis>\r\n" );
										valueXmlString.append("<res_basis><![CDATA[" ).append(checkNull(resBasis)).append( "]]></res_basis>\r\n" );
										valueXmlString.append("<tot_units><![CDATA[" ).append(deciFormater.format(totUnit)).append( "]]></tot_units>\r\n" );
										valueXmlString.append("<current_form_subform><![CDATA[" ).append("3").append( "]]></current_form_subform>\r\n" );
										valueXmlString.append("<drcr_flag><![CDATA[" ).append(drcrFlagVal).append( "]]></drcr_flag>\r\n" );
										valueXmlString.append("<allocpercdescr><![CDATA[" ).append(checkNull(allocdescr)).append( "]]></allocpercdescr>\r\n" );
										valueXmlString.append("</Detail2>\r\n");
										
										detail3 = getCostCenetrAllocationDetail(siteCode, acctCodeGet, tranIDMst, totUnit, resBasis, allocBasis, conn);
										valueXmlString.append(detail3 + "\r\n");

									}//for(int acctCtr =0;acctCtr <accountListLength;acctCtr++)
									
									
								}							
								
							}//for (int cCtr = 0; cCtr < listLength; cCtr++) 
						}

					}
					
					
					break;
				}				
				case 3 :
				{					
					parentNodeList = dom2.getElementsByTagName("Detail2");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					System.out.println("childNodeName ::::: for Detail3"+childNodeName);
					childNodeListLength = childNodeList.getLength();
					String detailData3 = "",tranIdMaster = "",acctCodeGet = "",
							resBas ="",allocBas = "";
					double totUnit = 0.0;
					System.out.println("currentColumn-------->>[" + currentColumn + "]");
					
					prdCode = checkNull(genericUtility.getColumnValue("prd_code", dom2));
					siteCode = checkNull(genericUtility.getColumnValue("site_code", dom2));
					tranIdMaster = checkNull(genericUtility.getColumnValue("tran_id_mst", dom2));
					acctCodeGet = checkNull(genericUtility.getColumnValue("acct_code", dom2));
					resBas = checkNull(genericUtility.getColumnValue("res_basis", dom2));
					allocBas = checkNull(genericUtility.getColumnValue("alloc_basis", dom2));
					totUnit = Double.parseDouble(genericUtility.getColumnValue("tot_units", dom2));
					//allocation_perc = checkNull(genericUtility.getColumnValue("allocation", dom2));
					System.out.println("prdCode :::111:["+prdCode+"]" + "siteCode ::::["+siteCode+"]Master tranId["+tranIdMaster+"]Acct Code["+acctCodeGet+"]Res Bas["+resBas+"]allocBas["+allocBas+"] Tot Units["+totUnit+"]"+"allocPercent["+allocPercent+"]");
				
					if("itm_default".equalsIgnoreCase(currentColumn.trim()))
					{
						detailData3 = getCostCenetrAllocationDetail(siteCode, acctCodeGet, tranIdMaster, totUnit, resBas, allocBas, conn);
						valueXmlString.append(detailData3 + "\r\n");
					}
					else if("allocation".equalsIgnoreCase(currentColumn))
					{
						String accountCode="";
						
						Node curDetail = dom.getChildNodes().item(0);
						
						System.out.println("detailString value is DOM=="+genericUtility.serializeDom(dom));
						domIDDet = Integer.parseInt(curDetail.getAttributes().getNamedItem("domID").getNodeValue());
						
						System.out.println("domIDDet ["+domIDDet+"]");
						totUnit = Double.parseDouble(genericUtility.getColumnValue("tot_units", dom));
						allocation_perc = Double.parseDouble(genericUtility.getColumnValue("allocation", dom));
						System.out.println("Value of totUnit :::: ["+totUnit+"]" + "allocation_perc :::: ["+allocation_perc+"]");
						unitAllocation =  setUnitAllocationValue(totUnit,allocation_perc);				
						accountCode = checkNull(genericUtility.getColumnValue("acct_code", dom));
						System.out.println("allocation_perc ::::["+allocation_perc+"]" + "unitAllocation ::::["+unitAllocation+"]" + "accountCode ::::["+accountCode+"]" + "totUnit ::::: ["+totUnit+"]");	
						valueXmlString.append("<Detail3 domID='" + domIDDet + "' selected=\"Y\">\r\n");
						valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\"/>\r\n");
						valueXmlString.append("<selectbox>true</selectbox>\r\n");
						valueXmlString.append("<unit_alloc><![CDATA[" ).append(unitAllocation).append( "]]></unit_alloc>\r\n" );
						valueXmlString.append("</Detail3>\r\n");	
						
					}
					
										
					break;
				}
			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}//end of finally block
		return valueXmlString.toString();
    }//end of defaultDataWiz
		
	private ArrayList<HashMap> getAllocationAmt(String siteCode ,String groupCode,String subGroupCode ,String catGroupCode,String acctCode,String acctPeriod,String finEntity,String cctrCodeFrm,String periodCode ,Connection conn) throws ITMException
	{	
		ArrayList<HashMap> accontsList = new ArrayList<HashMap>();
		HashMap tempMap = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String sSql = "";
		String acountCode = "",acctDescr= "";
		double allocAmt = 0.0;
		//Added by sarita for acctGroup on 03NOV2017
		boolean isAcctGroup = false;
		boolean isGroup = false;
		boolean isSubGroup = false;
		boolean isCatGroup = false;
		System.out.println("siteCode>>"+siteCode +"groupCode>>"+groupCode+"subGroupCode>>"+subGroupCode+"acctCode>>"+catGroupCode+"catGroupCode>>"+acctCode+"acctPeriod>>"+acctPeriod+"finEntity>>"+finEntity+"cctrCodeFrm>>"+cctrCodeFrm+"periodCode>>"+periodCode);
		try 
		{
			tempMap = new HashMap();
			if( acctCode != null && acctCode.length() > 0)
			{
				/*sSql = " select sum(dr_amt - cr_amt) as amt,b.acct_code,b.descr " 
						+" from acctbal, accounts b  where acct_prd = ? "
						+" and prd_code = ? "
						+" and fin_entity = ? "
						+" and acct_code = ? " 
						+" and a.acct_code = b.acct_code " 
						+" and cctr_code = ? " 
						+" and site_code = ? group by  b.acct_code,b.descr";*/
				sSql = " select sum(dr_amt - cr_amt) as amt,b.acct_code,b.descr " 
						+" from acctbal a, accounts b  " 
						+" where a.acct_prd = ? "
						+" and a.prd_code = ? "
						+" and a.fin_entity = ? "
						+" and a.acct_code = b.acct_code " 
						+" and a.cctr_code = ? " 
						+" and a.site_code = ?  " 
						+" and a.acct_code = ? group by  b.acct_code,b.descr";
				//Added by sarita on 03NOV2017
				isAcctGroup = true;
			}
			else if(subGroupCode != null && subGroupCode.length() > 0)
			{
				sSql =  " select sum(dr_amt - cr_amt) as amt,b.acct_code,b.descr "
						+" from acctbal a, accounts b   "
						+" where a.acct_prd = ? "
						+" and a.prd_code = ? "
						+" and a.fin_entity = ? "
						+" and a.acct_code = b.acct_code " 
						+" and a.cctr_code = ? " 
						+" and a.site_code = ?"
						+" and b.sgroup_code = ? group by  b.acct_code,b.descr ";
				
				//isGroup = true;
				isSubGroup = true;
			}
			else if(groupCode != null && groupCode.length() > 0)
			{
				sSql =  " select sum(dr_amt - cr_amt) as amt,b.acct_code,b.descr "
						+" from acctbal a, accounts b, acctsgrp s   "
						+" where a.acct_prd = ? "
						+" and a.prd_code = ? "
						+" and a.fin_entity = ? "
						+" and a.acct_code = b.acct_code " 
						+" and b.sgroup_code = s.sgroup_code "
						+" and a.cctr_code = ? " 
						+" and a.site_code = ?"
						+" and s.group_code = ?  group by  b.acct_code,b.descr ";
				isGroup = true;
			}
			else if(catGroupCode != null && catGroupCode.length() > 0)
			{
			/*	sSql =  " select sum(dr_amt - cr_amt),b.acct_code,b.descr "
						+" from acctbal a, accounts b,acctsgrp s , acctgrp g   "
						+" where a.acct_prd = ? "
						+" and a.prd_code = ? "
						+" and a.fin_entity = ? "
						+" and a.acct_code = b.acct_code " 
						+" and b.sgroup_code = s.sgroup_code "
						+" and g.group_code = s.group_code "
						+" and a.cctr_code = ? " 
						+" and a.site_code = ?"
						+" and s.acct_cat = ?  group by  b.acct_code,b.descr ";*/
				//change by sarita showing SQLSyntaxError on 03NOV2017
				sSql =  " select sum(dr_amt - cr_amt)as amt,b.acct_code,b.descr "
						+" from acctbal a, accounts b,acctsgrp s , acctgrp g   "
						+" where a.acct_prd = ? "
						+" and a.prd_code = ? "
						+" and a.fin_entity = ? "
						+" and a.acct_code = b.acct_code " 
						+" and b.sgroup_code = s.sgroup_code "
						+" and s.group_code = g.group_code "
						+" and a.cctr_code = ? " 
						+" and a.site_code = ?"
						+" and g.acct_cat = ?  group by  b.acct_code,b.descr";
				isCatGroup = true;
			}
			
			System.out.println("isAcctGroup["+isAcctGroup+"]"+"isSubGroup["+isSubGroup+"]"+ "isGroup["+isGroup+"]"+"isCatGroup["+isCatGroup+"]");
			pstmt = conn.prepareStatement(sSql);
			pstmt.setString(1,acctPeriod);
			pstmt.setString(2,periodCode);
			pstmt.setString(3,finEntity);
			pstmt.setString(4,cctrCodeFrm);
			pstmt.setString(5,siteCode);
			
			//if(!isSubGroup && !isGroup)//changes by sarita on 06NOV2017
			if(isAcctGroup)
			{
				pstmt.setString(6,acctCode);
			}
			else if(isSubGroup)
			{
				pstmt.setString(6,subGroupCode);
			}
			else if(isGroup)
			{
				pstmt.setString(6,groupCode);
			}	
			else if(isCatGroup)
			{
				System.out.println("Category group code");
				pstmt.setString(6,catGroupCode);
			}	
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				allocAmt = rs.getDouble("amt");
				acountCode = rs.getString("acct_code");
				acctDescr = rs.getString("descr");
				
				if(allocAmt == 0)
				{
					continue;
				}
				else if(allocAmt < 0)
				{
					allocAmt =0 -allocAmt;
					tempMap.put("drcr_flag", "C");
				}
				else
				{
					tempMap.put("drcr_flag", "D");
				}							
				tempMap.put("acct_code", acountCode);
				tempMap.put("acct_descr", acctDescr);
				tempMap.put("alloc_amt", allocAmt);				
				accontsList.add(tempMap);				
			}			
		} 
		catch (Exception e) 
		{
			// TODO: handle exception			
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("accontsList :::::--------------------------"+accontsList);
		return accontsList;	
	}
	
	private ArrayList<HashMap> getCostCenterList(String siteCode,String traidMst,String resBas,String allocBas,Connection conn) throws ITMException
	{
		System.out.println("Inside getCostCenterList method");
	    System.out.println("siteCode4545::["+siteCode+"]"+"traidMst::["+traidMst+"]"+"resBas::["+resBas+"]"+"allocBas::123["+allocBas+"]");	
		ArrayList<HashMap> cctrList = new ArrayList<HashMap>();
		ArrayList<HashMap> tempList = new ArrayList<HashMap>();
		HashMap tempMap = null;
		HashMap tempMap1 = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String sSql = "";
		String cctrCode = "",cctrDescr = "",allocPerc = "",acctCodeAlloc = "";
		double allocAmt = 0.0;
		boolean isGroup = false;
		boolean isSubGroup = false;
		String itemSer = "",techSpec = "",utilSQL = "";
		double invAmt = 0;	
		double totSalesAmt = 0.0;
		
		try 
		{
			//if("1".equalsIgnoreCase(allocBas.trim()))
			if("1".equalsIgnoreCase(allocBas))
			{
				System.out.println("Inside if block of getCostCenterList method");
				
				/*sSql = "select b.acct_code__alloc, b.cctr_code__to, b.alloc_perc,c.descr " 
						+" from costalloc_bas_det b,costctr c " 
						+" where b.tran_id = ? "
						+" where b.cctr_code__to = c.cctr_code " ;*/
				sSql = "select b.acct_code__alloc, b.cctr_code__to, b.alloc_perc,c.descr " 
						+" from costalloc_bas_det b,costctr c " 
						+" where b.tran_id = ? "
						+" and b.cctr_code__to = c.cctr_code " ;
				
				pstmt = conn.prepareStatement(sSql);
				pstmt.setString(1,traidMst);
				rs = pstmt.executeQuery();
				
				while(rs.next())
				{
					cctrCode = rs.getString("cctr_code__to");
					acctCodeAlloc = rs.getString("acct_code__alloc");
					cctrDescr = rs.getString("descr");
					allocPerc = rs.getString("alloc_perc");
								
					tempMap = new HashMap();
					tempMap.put("cctr_code", cctrCode);
					tempMap.put("acct_code__alloc", acctCodeAlloc);
					tempMap.put("cctr_descr", cctrDescr);
					tempMap.put("alloc_perc", allocPerc);
					
					cctrList.add(tempMap);				
				}
				
				if(pstmt != null)
				{
				    pstmt.close(); 
				    pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
				    rs = null;
				}
			}//end of if block for alloc_basis is 1
			else if("2".equalsIgnoreCase(allocBas.trim()))
			{
				System.out.println("Inside Else Block of getCostCenterList method");
				String resBasis = getResourceBasVal(conn);
				sSql = "select util_sql from resource_basis where res_bas = ?";
				pstmt = conn.prepareStatement(sSql);
				pstmt.setString(1,resBasis);
				rs = pstmt.executeQuery();
				
				while(rs.next())
				{
					utilSQL = rs.getString("util_sql");
					System.out.println("utilSQL ::::: ["+utilSQL+"]");
				}
				
				if(pstmt != null)
				{
				    pstmt.close(); 
				    pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
				    rs = null;
				}
				
				if(utilSQL != null)
				{
					pstmt = conn.prepareStatement(utilSQL);
					rs = pstmt.executeQuery();
					while(rs.next())
					{						
						itemSer = rs.getString("item_ser");
						techSpec = rs.getString("tech_spec");
						invAmt = rs.getDouble("inv_amt");
						totSalesAmt = totSalesAmt + invAmt;
						System.out.println("Value of itemSer::["+itemSer+"]" + "Value of techSpec:: ["+techSpec+"]" + "Value of invAmt::["+invAmt+"]");

						tempMap1 = new HashMap();
						tempMap1.put("item_ser", itemSer);
						tempMap1.put("tech_spec", techSpec);
						tempMap1.put("inv_amt", invAmt);
						tempList.add(tempMap1);	
					}
					if(pstmt != null)
					{
					    pstmt.close(); 
					    pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
					    rs = null;
					}
					int temListlen = tempList.size();
					
					if(temListlen > 0 && totSalesAmt >0)
					{
						HashMap dataMap = null;
						double calcAlloc = 0.0;
						for (int iCtr = 0; iCtr < temListlen; iCtr++) 
						{
							dataMap = tempList.get(iCtr);
							cctrCode = (String)dataMap.get("tech_spec");
							itemSer = (String)dataMap.get("item_ser");
							invAmt = (double)dataMap.get("inv_amt");
							
							calcAlloc = (invAmt / totSalesAmt) * 100;
							System.out.println("calcAlloc Amt::[" +calcAlloc+"]");
							
							calcAlloc = Math.round(calcAlloc);
							System.out.println("calcAlloc Amt after Round::[" +calcAlloc+"]");
							
							tempMap = new HashMap();
							tempMap.put("cctr_code", cctrCode);
							tempMap.put("acct_code__alloc", itemSer);
							tempMap.put("cctr_descr", cctrCode);
							tempMap.put("alloc_perc",String.valueOf(calcAlloc));
							cctrList.add(tempMap);		
						}	
					}//end of if block
				}//end of if block for utilSQL
			}//end of else for alloc basis 2	
		}//end of try block....
		catch (Exception e)
		{
			// TODO: handle exception
			System.out.println(e);
			e.printStackTrace();
			throw new ITMException(e);		
		}
		System.out.println("accontsList :::::"+cctrList);
		return cctrList;	
	}//end of method getCostCenterList
	
	private String getCostCenetrAllocationDetail(String siteCode,String acctCodeFor,String traidMst,double totUnit,String resBas,String allocBas,Connection conn) throws ITMException
	{
		System.out.println("Inside getCostCenetrAllocationDetail method");
		ArrayList cctrDataList = null;
	    StringBuffer valueXmlString = new StringBuffer("");
	    int  domIDDet =0;
	    FinCommon finCommon = new FinCommon();
		
		try 
		{
			cctrDataList = getCostCenterList(siteCode, traidMst, resBas, allocBas, conn);
			System.out.println("cctrDataList Value ::::::::::["+cctrDataList+"]");
			
			int costCtrtListLength = cctrDataList.size();
			System.out.println("costCtrtListLength ["+costCtrtListLength+"]");
			System.out.println("Value of siteCode ::["+siteCode+"]" + "Value of traidMst ::["+traidMst+"]" + "Value of resBas ::["+resBas+"]" + "Value of allocBas ::["+allocBas+"]");
			
			if(costCtrtListLength > 0)
			{
				HashMap cctrDataMap = null;
				double percentage = 0.0,allocPerc = 0.0;
				double allocUnit = 0.0;
				String ccctrCode = "";
				String cctrsDescription = "";
				
				for(int cctrCnt = 0;cctrCnt < costCtrtListLength; cctrCnt++)
				{
					domIDDet++;
					cctrDataMap = (HashMap)cctrDataList.get(cctrCnt);	
					ccctrCode = (String)cctrDataMap.get("cctr_code");
					cctrsDescription = (String)cctrDataMap.get("cctr_descr");
					valueXmlString.append("<Detail3 domID='" + domIDDet + "' selected=\"Y\">\r\n");
					//valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\"/>\r\n");
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\"/>\r\n");
					valueXmlString.append("<selectbox>true</selectbox>\r\n");
					valueXmlString.append("<tran_id><![CDATA[" ).append(checkNull("")).append( "]]></tran_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA[" ).append(domIDDet).append( "]]></line_no>\r\n" );
					
					if("1".equalsIgnoreCase(allocBas))
					{
						percentage = Double.parseDouble((String)cctrDataMap.get("alloc_perc"));
						System.out.println("Allocation Percentage ::::"+percentage);
						System.out.println("Current Allocation % ["+percentage+"totUnit["+totUnit+"]["+(totUnit*percentage)/100+"]");
						allocUnit = Math.round(((totUnit*percentage)/100)); //Round function should be taken from finCommon
						System.out.println("allocUnit:::"+allocUnit);
						//allocUnit = finCommon.getRequiredDecimal(allocUnit,2);
						System.out.println("allocUnit:::123"+allocUnit);
						//valueXmlString.append("<allocation><![CDATA[" ).append(percentage + "%").append( "]]></allocation>\r\n" );
						valueXmlString.append("<allocation><![CDATA[" ).append(percentage).append( "]]></allocation>\r\n" );
					}
					else if("2".equalsIgnoreCase(allocBas))
					{
						//development pending
						System.out.println("cctrDataMap :::::::["+cctrDataMap+"]");
						System.out.println("cctrDataMap.get(alloc_perc) ::"+cctrDataMap.get("alloc_perc"));
						allocPerc = Double.parseDouble((String)cctrDataMap.get("alloc_perc"));
						allocUnit = Math.round(((totUnit*allocPerc)/100)); 
						System.out.println("allocUnit:::"+allocUnit);
						//percentage = Double.parseDouble((String)cctrDataMap.get("alloc_perc"));
						valueXmlString.append("<allocation><![CDATA[" ).append(allocPerc ).append( "]]></allocation>\r\n" );
					}
															
					valueXmlString.append("<site_code><![CDATA[" ).append(checkNull(siteCode)).append( "]]></site_code>\r\n" );
					valueXmlString.append("<acct_code><![CDATA[" ).append(checkNull(acctCodeFor)).append( "]]></acct_code>\r\n" );
					valueXmlString.append("<cctr_code_alloc><![CDATA[" ).append(checkNull(ccctrCode)).append( "]]></cctr_code_alloc>\r\n" );
					valueXmlString.append("<cctr_descr><![CDATA[" ).append(checkNull(cctrsDescription)).append( "]]></cctr_descr>\r\n" );
					valueXmlString.append("<unit_alloc><![CDATA[" ).append(deciFormater.format(allocUnit)).append( "]]></unit_alloc>\r\n" );	
					valueXmlString.append("<tot_units><![CDATA[" ).append(deciFormater.format(totUnit)).append( "]]></tot_units>\r\n" );	
					valueXmlString.append("</Detail3>\r\n");				
				}//end of for loop
			}//end of if block if costCtrtListLength > 0		
		}//end of try block 
		catch (Exception e) 
		{						
			// TODO: handle exception
			System.out.println(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("getCostCenetrAllocationDetail :::::"+valueXmlString.toString());
		
		return valueXmlString.toString();		
	}//end of method getCostCenetrAllocationDetail

	private String errorType(Connection conn, String errorCode) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			}
		} 
		catch (Exception ex)
		{
			System.out.println("Exception inside errorType method"+ex);
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}//end of method errorType
	
	@Override
	public String handleRequest(HashMap<String, String> reqParamMap) 
	{
		System.out.println("Inside CostCtrAllocIC handleRequest method!!!!");
		System.out.println("reqParamMap :::"+reqParamMap);
		String action = "", retXMLStr = "";
		InitialContext ctx = null;
		CostCtrAllocICRemote costCtrAllocICRemote = null;
		Connection conn = null;
		boolean isError = false;
		
		try
		{
			action = (String)reqParamMap.get("action");
			System.out.println("action is :::"+action);
			if("ITEM_CHANGE".equalsIgnoreCase(action))
			{
				String currXmlDataStr = "", hdrXmlDataStr = "", allXmlDataStr = "", currentColumn = "", objContext = "", editFlag = "";
				
				ctx=getInitialContext();
				currXmlDataStr = (String)reqParamMap.get("CUR_XML_STR");
				hdrXmlDataStr = (String)reqParamMap.get("HDR_XML_STR");
				allXmlDataStr = (String)reqParamMap.get("ALL_XML_STR");
				currentColumn = (String)reqParamMap.get("CUR_COLUMN");
				objContext = (String)reqParamMap.get("OBJ_CONTEXT");
				editFlag = (String)reqParamMap.get("EDIT_FLAG");
				
				System.out.println("currXmlDataStr###"+currXmlDataStr);
				costCtrAllocICRemote = (ibase.webitm.ejb.fin.adv.CostCtrAllocICRemote) ctx.lookup("ibase/CostCtrAllocIC/remote");
		   	    retXMLStr = costCtrAllocICRemote.itemChanged(currXmlDataStr, hdrXmlDataStr, allXmlDataStr, objContext, currentColumn, editFlag, globalXtraParams);
				
				System.out.println("retXMLStr["+retXMLStr+"] for action ["+action+"]");
			}
			else if("deleteRow".equalsIgnoreCase(action))
			{
				String userId,signMethod,docType;
				int count;
				PreparedStatement pstmt = null;
				conn = getConnection();
				
				userId=(String)reqParamMap.get("userid");
				signMethod=(String)reqParamMap.get("signmethod");
				docType=(String)reqParamMap.get("doctype");
				
				String sql = "delete from  user_sign_acc where user_id= ? and sign_method=? and doc_type=?";
				System.out.println("sql"+sql);
				pstmt = conn.prepareStatement(sql);
					
				pstmt.setString(1,userId);
				pstmt.setString(2,signMethod);
				pstmt.setString(3,docType);
					
				count=	pstmt.executeUpdate();
					

				if(pstmt != null)
				{
					 pstmt.close(); 
					 pstmt = null;
				}
				
				if (count > 0)
				{
					conn.commit();

				}
				else if(count == 0)
				{
					conn.rollback();
				}
					
				retXMLStr="row deleted successfully";
			}
			/*else if("GET_IMG_PATH".equalsIgnoreCase(action))
			{
				String lineItemStr = "";
				String itemCode = (String)reqParamMap.get("REF_ID");
				String itemDescr = (String)reqParamMap.get("ITEM_DESCR");
				
				lineItemStr += "<item_code><![CDATA["+itemCode+"]]></item_code>";
				lineItemStr	+= "<item_descr><![CDATA["+itemDescr+"]]></item_descr>";
				
				retXMLStr = "<imgPath><![CDATA["+getImagePath(lineItemStr)+"]]></imgPath>";
				
				System.out.println("retXMLStr["+retXMLStr+"] for action ["+action+"]");
			}*/			
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("GstRegNoPosEJB.handleRequest()"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try{
				if (conn != null && !conn.isClosed())
				{
					conn.close();
					conn=null;
				}
			}
			catch(Exception ex)
			{
				System.out.println("exception "+ex);
			}
		}
			
		return retXMLStr;
	}//END OF METHOD handleRequest
	
	public InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("GstRegNoPosEJB.getInitialContext()");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("GstRegNoPosEJB.getInitialContext()"+e.getMessage());
			throw new ITMException(e);
		}
		return ctx;
	}//end of method getInitialContext
	
	public boolean preDomExists(Document dom, String currentFormNo) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node childNode = null;
		boolean selected = false;

		try
		{
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			if ( parentList.item(0) != null )
			{
				childList = parentList.item(0).getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))					
					{
						System.out.println("Column found!!!" + childNode.getNodeName());
						selected = true; 
						break;
					}
				}
			}
		}
		catch ( Exception e )
		{
			System.out.println( "Exception preDomExists :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("preDomExists =["+selected+"] and currentFormNo =["+currentFormNo+"]");
		return selected;
	}//end of method preDomExists
	
	public String getPrevFormVal( Document dom, String currentFormNo, ArrayList temp, String colName ) throws ITMException
	{		
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		int domID = 0;
		
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			//System.out.println("currentFormNo ["+currentFormNo+"] \n dom["+genericUtility.serializeDom(dom)+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentlistlength["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{							
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))					
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						//	System.out.println("childNode.getNodeName()["+childNode.getNodeName()+"]columnValue["+columnValue+"]temp["+temp+"] ");
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains(columnValue))
						{
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								//Changes By Prajyot On 22-11-2011 
								//[ For Items Details to maintain the default domID it is necessary to discard the new domID generation ]
								//elementAttr.setAttribute( "domID" , Integer.toString(domID) );
								elementAttr.setAttribute( "selected" , "Y" );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}

					}
				}
			}//END OF FOR LOOP
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}//end of try block
		catch ( Exception e )
		{
			System.out.println( "Exception : :getPrevFormValues :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return returnPrevStr;
	}//end of method getPrevFormVal 
	
	public double getNumOftotalallocPercentage(Document dom2,String CurrentLineNo) throws ITMException
	{		
		String perAmt="",lineNo="";
		double num=0;
		System.out.println("Inside getXmlDocument method!!!!!!!!!!!!!!");
		try
		{
			NodeList detailNoteList = dom2.getElementsByTagName("Detail3");
			System.out.println("Value of dom2 is :::::["+dom2+"]");
			System.out.println("Length of detailNoteList" +detailNoteList.getLength());
			for(int cnt = 0;cnt<detailNoteList.getLength();cnt++)
			{
				Element pNode=(Element) detailNoteList.item(cnt);
				perAmt= pNode.getElementsByTagName("allocation").item(0).getFirstChild().getNodeValue();
				lineNo= pNode.getElementsByTagName("line_no").item(0).getFirstChild().getNodeValue();
				
               if(!lineNo.equalsIgnoreCase(CurrentLineNo.trim()))
               {
           		   System.out.println("Line No is.. "+CurrentLineNo);
            	   num += Double.parseDouble(perAmt);
            	   System.out.println("perAmt is ==="+perAmt);	
               }
			}
			System.out.println("num is ==="+num);	
		}
		catch(Exception e)
		{
			System.out.println("Exception : : getNumOftotalallocPercentage :"+e); 
			e.printStackTrace();
			throw new ITMException(e);
		}
		return num;
	}//end of method getNumOftotalallocPercentage
	
	public double setUnitAllocationValue(double totUnit,double allocation_perc )
	{
		double unitAlloc=0;
		System.out.println("totUnit :: ["+totUnit+"]" + "allocation_perc :: ["+allocation_perc+"]");
		unitAlloc = Math.round(((totUnit*allocation_perc)/100)); 
		System.out.println("Value of unitAlloc:::"+unitAlloc);
		return unitAlloc;
	}//end of method setUnitAllocationValue
	
	public String getResourceBasVal(Connection conn) throws ITMException
	{
		System.out.println("Inside getResourceBasVal Method!!!");
		String resBas="",sql="";
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			sql = "select res_basis from costalloc_bas where alloc_basis=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,"2");
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				resBas = rs.getString("res_basis");
				System.out.println("Value of Resource Basis is ====="+resBas);
			}
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception : : getResourceBasVal :"+e);
			throw new ITMException(e);
		}
		return resBas;
	}//end of method getResourceBasVal
	
	//Added by sarita on 06NOV2017
	public String getAttributeVal(Node dom, String attribName )throws ITMException
	{
		String AttribValue = null;
		try
		{
			NodeList detailList = dom.getChildNodes(); 
			int detListLength = detailList.getLength();
			for(int ctr = 0; ctr < detListLength; ctr++)
			{
				Node curDetail = detailList.item(ctr);
				if(curDetail.getNodeName().equals("attribute")) 
				{
					AttribValue = curDetail.getAttributes().getNamedItem(attribName).getNodeValue();
					break;
				}
				else
				{
					continue;
				}
			}		
		}
		catch (Exception e)
		{
			System.out.println("Exception : : searchNode :"+e); 
			throw new ITMException(e);
		}
		return AttribValue;
	}
	//Added by sarita on 6NOV2017
	public int getNumOfNonDelDetail(Document dom2,int detailNo)
	{
		Node childNode = null;
		NodeList updateList;
		String childNodeName = "";
		String updateFlag="";
		int cntr=0;
		System.out.println("Inside getXmlDocument method!!!!!!!!!!!!!!");
		try
		{
			System.out.println("detailString value is =="+genericUtility.serializeDom(dom2));
			NodeList detailNoteList = dom2.getElementsByTagName("Detail"+detailNo);
			for(int cnt = 0;cnt<detailNoteList.getLength();cnt++)
			{
				Node pNode=detailNoteList.item(cnt);
				/*NodeList cNodeList=pNode.getChildNodes();
				childNodeListLength = cNodeList.getLength();*/			
				childNodeName = pNode.getNodeName();
				//System.out.println("pNode::["+pNode+"]"+"cNodeList::["+cNodeList+"]");
				updateFlag = getAttributeVal(pNode,"updateFlag");
				System.out.println("updateFlag [" + updateFlag + "]");
				if(!updateFlag.equalsIgnoreCase("D"))
				{
					cntr++;
				}
				System.out.println("Counter is ==="+cntr);	
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : : getNumOfNonDelDetail :"+e); 
			e.printStackTrace();
		}
		return cntr;
	}
}//end of class CostCtrAllocIC














