package ibase.dashboard.sfa.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;

@Stateless
public class AllIndiaQTQ extends ValidatorEJB implements AllIndiaQTQLocal,AllIndiaQTQRemote
{
	public AllIndiaQTQ()
	{
	}

	@SuppressWarnings("unchecked")
	public JSONObject getAllIndiaQTQ(String loginCode,String dataSourceName,String fromDate,String toDate)throws RemoteException, ITMException
	{
		JSONObject rowDataAllIndiaQTQJson = new JSONObject();
		JSONObject rowData                = null;
		String sql                        = "";		
		ResultSet rs                      = null;
		PreparedStatement pstmt           = null;
		Connection conn                   = null;
		ConnDriver connDriver             = new ConnDriver();
		int count                         = 0;
		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		//DecimalFormat df =new DecimalFormat("#.##");
		DecimalFormat df =new DecimalFormat("#.#");
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;  
						
			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
				  calendar          = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate          = convertToDBDate.format(calendar.getTime());
				  toDate            = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("From date  inside in ALL India QTQ when From and To Date is null ===="+fromDate+" toDate==="+toDate);				
			  }
			else
			{
				e12GenericUtility = new E12GenericUtility();
				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
				toDate   = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy",  "dd-MMM-yy");
			}
		   //End the code of MTD format
			if(fromDate!=null && toDate!=null&& loginCode!=null)
			{
			sql =   "select " +
					"a.month, " +
					"a.year, " +
					"a.monthname, " +
					"round(sum(a.daysinfield)/sum(a.availdaysinfield),2) *100 as DAYINFIELD, " +
					"round(sum(A.DrMetCalls)/sum(a.daysinfield),2) as call_avg, " +
					"round(sum(STPERCENTPROD)/ sum(salesd_count),2) as STPERCENTPROD, " +
					"round(sum(T1PERCENTPROD) / sum(salesd_count),2)as T1PERCENTPROD, " +
					"round(sum(STPERCENTDRMET)/ sum(salesd_count),2) as STPERCENTDRMET , " +
					"ROUND(((B.daysinfield/B.availdaysinfield)*100),2)AS FLM_time " +
					"from " +
					" ( " +
					"select " +
					"count(*) as salesd_count, " +
					"vqt.DrMetCalls, " +
					"VQT.sales_pers, " +
					"VQT.month, " +
					"VQT.year, " +
					"VQT.monthname, " +
					"VQT.daysinfield, " +
					"VQT.availdaysinfield, " +
					"sm.mt, " +
					"VQT.STPERCENTPROD, " +
					"VQT.T1PERCENTPROD, " +
					"VQT.STPERCENTDRMET " +
					"from VW_QTQ_TEAMWISE  VQT " +
					"INNER JOIN USERS ON USERS.CODE=VQT.SALES_PERS " +
					"inner join ( " +
					"SELECT " +
					"sales_pers," +
					"count( distinct strg_code) as mt, " +
					"TO_CHAR(event_date,'mm') mm, " +
					"TO_CHAR(event_date,'YYYY') year " +
					"FROM strg_meet " +
					"where strg_meet.sales_pers in (Select " +
					"Emp_Code " +
					"From " +
					"Employee " +
					"Start With " +
					"Emp_Code =(select emp_code from users where code='"+loginCode+"')  " +     //pass user id
					"Connect By Prior " +
					"Emp_Code = Report_To) " +
					"and strg_meet.locality_code<>'DUM' " +
					"and (strg_code <> '-NA-' or strg_code is not null) " +
					"group by sales_pers, " +
					"  TO_CHAR(event_date,'mm'), " +
					"  TO_CHAR(event_date,'YYYY') " +
					"  ) sm " +
					"  on VQT.sales_pers=sm.sales_pers and VQT.month=sm.mm and VQT.year=sm.year " +
					"  inner join sales_pers sp  on sp.sales_pers=VQT.sales_pers " +
					"  inner join sub_bu_master sbm on sbm.sub_bu_code=sp.sub_bu_code " +
					"where VQT.sales_pers in (Select " +
					"Emp_Code " +
					"From " +
					"Employee " +
					"Start With " +
					"Emp_Code =(select emp_code from users where code ='"+loginCode+"') " + 
					"Connect By Prior " +
					"Emp_Code = Report_To) " +
					//"and VQT.year='2015' " +
					"and VQT.month >= to_char(to_date('"+fromDate+"') ,'MM')  " +  
					"and VQT.month <= to_char(to_date('"+toDate+"') ,'MM')  " +  
					"and VQT.year >= to_char(to_date('"+fromDate+"') ,'YYYY')  " +  
					"and VQT.year <= to_char(to_date('"+toDate+"') ,'YYYY')  " + 
					//"and sbm.sub_bu_code='T2'  " +
					"AND SP.sub_bu_code<>'OSTEO'" +
					"AND USERS.PROFILE_ID<>'FLM1'" +
					"group by " +
					"VQT.sales_pers,vqt.DrMetCalls, " +
					"VQT.month, " +
					"VQT.year, " +
					"VQT.monthname, " +
					"VQT.daysinfield, " +
					"VQT.availdaysinfield, " +
					"sm.mt, " +
					"VQT.STPERCENTPROD, " +
					"VQT.T1PERCENTPROD, " +
					"VQT.STPERCENTDRMET " +
					")A INNER JOIN " +
					"( " +
					"select " +
					"sum(daysinfield) as daysinfield, " +
					"sum(availdaysinfield) as availdaysinfield, " +
					"month, " +
					"year " +
					"from VW_FLM_QTQ_TEAMWISE VQT " +
					"inner join  sales_pers sp  on sp.sales_pers=VQT.sales_pers " +
					"LEFT join sub_bu_master sbm on sbm.sub_bu_code=sp.sub_bu_code " +
					"INNER JOIN EMPLOYEE E ON VQT.SALES_PERS=E.EMP_CODE " +
					"INNER JOIN USERS U ON U.CODE=E.EMP_CODE " +
					"where VQT.sales_pers in ( " +
					"Select " +
					"EMPLOYEE.Emp_Code " +
					"From " +
					"Employee " +
					"Start With " +
					"EMPLOYEE.Emp_Code =(select emp_code from users where code='"+loginCode+"') " +    
					"Connect By Prior " +
					"EMPLOYEE.Emp_Code = EMPLOYEE.Report_To " +
					") " +
					//"and VQT.year='2015' " +
					"and VQT.month >= to_char(to_date('"+fromDate+"') ,'MM') " +
					"and VQT.month <= to_char(to_date('"+toDate+"') ,'MM') " +
					"and VQT.year >= to_char(to_date('"+fromDate+"') ,'YYYY')  " +  
					"and VQT.year <= to_char(to_date('"+toDate+"') ,'YYYY')  " +
					//"and sp.sub_bu_code='T2'  "+     //--filter
					"AND U.PROFILE_ID='FLM1'" +
					"group by  month, " +
					"year " +
					")b ON A.MONTH=b.month AND a.year=B.YEAR " +
					"group by " +
					"a.month, " +
					"a.year, " +
					"a.monthname, " +
					"B.daysinfield, " +
					"B.availdaysinfield order by a.month " ;						
	
	pstmt                            = conn.prepareStatement(sql);
	rs                               = pstmt.executeQuery();	
	StringBuffer monthNameBuffer     = new StringBuffer ();
	StringBuffer daysInFieldBuffer   = new StringBuffer ();
	StringBuffer callAverageBuffer   = new StringBuffer ();
	StringBuffer doctorVisitBuffer   = new StringBuffer ();
	StringBuffer doctorVisitPFBuffer = new StringBuffer ();
	StringBuffer supertargetBuffer   = new StringBuffer ();
	StringBuffer flmCoachingBuffer   = new StringBuffer ();	
	rowData = new JSONObject();
	String ytdYear = "";
	
	double daysInFieldAvg   =0.0;
	double callAverageAvg   =0.0;
	double doctorVisitAvg   =0.0;
	double doctorVisitPFAvg =0.0;
	double supertargetAvg   =0.0;
	double flmCoachingAvg   =0.0;
	
	int avgCount=0;
	while (rs.next())
	{
		
		ytdYear =rs.getString("YEAR").substring(2);
		monthNameBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+rs.getString("MONTHNAME")+" - "+ytdYear+"</td>");
		
		if(Double.parseDouble(checkDouble(rs.getString("DAYINFIELD")))>=90)
	     {
			daysInFieldBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("DAYINFIELD"))))+"</td>");
			daysInFieldAvg=daysInFieldAvg+Double.parseDouble(checkDouble(rs.getString("DAYINFIELD")));
	     }
		else if(Double.parseDouble(checkDouble(rs.getString("DAYINFIELD")))<90 && Double.parseDouble(checkDouble(rs.getString("DAYINFIELD")))>=80)	
		 {
			daysInFieldBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("DAYINFIELD"))))+"</td>");
			daysInFieldAvg=daysInFieldAvg+Double.parseDouble(checkDouble(rs.getString("DAYINFIELD")));
		 }
		
		else if(Double.parseDouble(checkDouble(rs.getString("DAYINFIELD")))<80)	
		 {
			daysInFieldBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("DAYINFIELD"))))+"</td>");
			daysInFieldAvg=daysInFieldAvg+Double.parseDouble(checkDouble(rs.getString("DAYINFIELD")));
		 }
		
		
		if(Double.parseDouble(checkDouble(rs.getString("CALL_AVG")))>=10)
	     {
			callAverageBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("CALL_AVG"))))+"</td>");
			callAverageAvg =callAverageAvg+Double.parseDouble(checkDouble(rs.getString("CALL_AVG")));
	     }
		else if(Double.parseDouble(checkDouble(rs.getString("CALL_AVG")))<10 && Double.parseDouble(checkDouble(rs.getString("CALL_AVG")))>=8)	
		 {
			callAverageBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("CALL_AVG"))))+"</td>");
			callAverageAvg =callAverageAvg+Double.parseDouble(checkDouble(rs.getString("CALL_AVG")));
		 }
		
		else if(Double.parseDouble(checkDouble(rs.getString("CALL_AVG")))<8)	
		 {
			callAverageBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("CALL_AVG"))))+"</td>");
			callAverageAvg =callAverageAvg+Double.parseDouble(checkDouble(rs.getString("CALL_AVG")));
		 }
		
		
		if(Double.parseDouble(checkDouble(rs.getString("STPERCENTPROD")))>=85)
	     {
			doctorVisitBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("STPERCENTPROD"))))+"</td>");
			doctorVisitAvg=doctorVisitAvg+Double.parseDouble(checkDouble(rs.getString("STPERCENTPROD")));
	     }
		else if(Double.parseDouble(checkDouble(rs.getString("STPERCENTPROD")))<85 && Double.parseDouble(checkDouble(rs.getString("STPERCENTPROD")))>=65)	
		 {
			doctorVisitBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("STPERCENTPROD"))))+"</td>");
			doctorVisitAvg=doctorVisitAvg+Double.parseDouble(checkDouble(rs.getString("STPERCENTPROD")));
		 }
		
		else if(Double.parseDouble(checkDouble(rs.getString("STPERCENTPROD")))<65)	
		 {
			doctorVisitBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("STPERCENTPROD"))))+"</td>");
			doctorVisitAvg=doctorVisitAvg+Double.parseDouble(checkDouble(rs.getString("STPERCENTPROD")));
		 }
		
		
		if(Double.parseDouble(checkDouble(rs.getString("T1PERCENTPROD")))>=80)
	     {
			doctorVisitPFBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("T1PERCENTPROD"))))+"</td>");
			doctorVisitPFAvg=doctorVisitPFAvg+Double.parseDouble(checkDouble(rs.getString("T1PERCENTPROD")));
	     }
		else if(Double.parseDouble(checkDouble(rs.getString("T1PERCENTPROD")))<80 && Double.parseDouble(checkDouble(rs.getString("T1PERCENTPROD")))>=60)	
		 {
			doctorVisitPFBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("T1PERCENTPROD"))))+"</td>");
			doctorVisitPFAvg=doctorVisitPFAvg+Double.parseDouble(checkDouble(rs.getString("T1PERCENTPROD")));
		 }
		
		else if(Double.parseDouble(checkDouble(rs.getString("T1PERCENTPROD")))<60)	
		 {
			doctorVisitPFBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("T1PERCENTPROD"))))+"</td>");
			doctorVisitPFAvg=doctorVisitPFAvg+Double.parseDouble(checkDouble(rs.getString("T1PERCENTPROD")));
		 }
		
		if(Double.parseDouble(checkDouble(rs.getString("STPERCENTDRMET")))>=90)
	     {
			supertargetBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("STPERCENTDRMET"))))+"</td>");
			supertargetAvg=supertargetAvg+Double.parseDouble(checkDouble(rs.getString("STPERCENTDRMET")));
	     }
		else if(Double.parseDouble(checkDouble(rs.getString("STPERCENTDRMET")))<90 && Double.parseDouble(checkDouble(rs.getString("STPERCENTDRMET")))>=80)	
		 {
			supertargetBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("STPERCENTDRMET"))))+"</td>");
			supertargetAvg=supertargetAvg+Double.parseDouble(checkDouble(rs.getString("STPERCENTDRMET")));
		 }
		
		else if(Double.parseDouble(checkDouble(rs.getString("STPERCENTDRMET")))<80)	
		 {
			supertargetBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("STPERCENTDRMET"))))+"</td>");
			supertargetAvg=supertargetAvg+Double.parseDouble(checkDouble(rs.getString("STPERCENTDRMET")));
		 }
		
		
		if(Double.parseDouble(checkDouble(rs.getString("FLM_TIME")))>=70)
	     {
			flmCoachingBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("FLM_TIME"))))+"</td>");
			flmCoachingAvg=flmCoachingAvg+Double.parseDouble(checkDouble(rs.getString("FLM_TIME")));
	     }
		else if(Double.parseDouble(checkDouble(rs.getString("FLM_TIME")))<70 && Double.parseDouble(checkDouble(rs.getString("FLM_TIME")))>=60)	
		 {
			flmCoachingBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("FLM_TIME"))))+"</td>");
			flmCoachingAvg=flmCoachingAvg+Double.parseDouble(checkDouble(rs.getString("FLM_TIME")));
		 }
		
		else if(Double.parseDouble(checkDouble(rs.getString("FLM_TIME")))<60)	
		 {
			flmCoachingBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+dfFormatter(Double.parseDouble(checkDouble(rs.getString("FLM_TIME"))))+"</td>");
			flmCoachingAvg=flmCoachingAvg+Double.parseDouble(checkDouble(rs.getString("FLM_TIME")));
		 }
		avgCount++;
	 }
	    monthNameBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"YTD "+" - "+ytdYear+"</td>");	    
	    daysInFieldBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+finalYtdAvgRow(df.format(daysInFieldAvg/avgCount),"DAYINFIELD")+"</td>");
	    callAverageBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+finalYtdAvgRow(df.format(callAverageAvg/avgCount),"CALL_AVG")+"</td>");
	    doctorVisitBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+finalYtdAvgRow(df.format(doctorVisitAvg/avgCount),"STPERCENTPROD")+"</td>");
	    doctorVisitPFBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+finalYtdAvgRow(df.format(doctorVisitPFAvg/avgCount),"T1PERCENTPROD")+"</td>");
	    supertargetBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+finalYtdAvgRow(df.format(supertargetAvg/avgCount),"STPERCENTDRMET")+"</td>");
	    flmCoachingBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+finalYtdAvgRow(df.format(flmCoachingAvg/avgCount),"FLM_TIME")+"</td>");	    
	    
		rowData.put("monname", monthNameBuffer.toString());
		rowData.put("diffield", daysInFieldBuffer.toString());
		rowData.put("callavg", callAverageBuffer.toString());
		rowData.put("stperprod", doctorVisitBuffer.toString());
		rowData.put("tperprod", doctorVisitPFBuffer.toString());
		rowData.put("stperdrmet", supertargetBuffer.toString());
		rowData.put("flmtime", flmCoachingBuffer.toString());
		rowData.put("exporttoExcel", CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png");
		
		rowDataAllIndiaQTQJson.put(count, rowData);
		count++;
		
		rs.close();
		rs=null;
		pstmt.close();
		pstmt=null;
		
	   }//closed the if block	
		System.out.println(" rowDataAllIndiaQTQJson is =" + rowDataAllIndiaQTQJson);

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			}
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getTask():" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataAllIndiaQTQJson;
	}
 
	private String checkDouble(String str)
	{
	if (str == null)
	{
	return "0";
	} else
	{
	return str;
	}
	
	}
	
	private String finalYtdAvgRow(String columnValue, String colValue)
	{
		
		StringBuffer finalYtdAvg = new StringBuffer();
		double colAvg  = Double.parseDouble(columnValue);
		
		DecimalFormat df1 =new DecimalFormat("#.0");
		String average="";
		if(colAvg>0)
		{
			if(colAvg>1)
			{
				average=df1.format(colAvg);
			}
			else
			{
				average = "0"+df1.format(colAvg);
			}
		}
		else
		{
			average=colAvg+"";
		}
				
		if("DAYINFIELD".equalsIgnoreCase(colValue))
		{
			if(colAvg>=90)
			{
				finalYtdAvg.append("<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average);
			}
			else if(colAvg<90 && colAvg>=80)
			{
				finalYtdAvg.append("<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average);
			}
			else if(colAvg<80)	
			 {
				finalYtdAvg.append("<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average);
			 }
		}
		else if("CALL_AVG".equalsIgnoreCase(colValue))
		{
			if(colAvg>=10)
			{
				finalYtdAvg.append("<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average);
			}
			else if(colAvg<10 && colAvg>=8)
			{
				finalYtdAvg.append("<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average);
			}
			else if(colAvg<8)	
			 {
				finalYtdAvg.append("<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average);
			 }
		}
		else if("STPERCENTPROD".equalsIgnoreCase(colValue))
		{
			if(colAvg>=85)
			{
				finalYtdAvg.append("<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average);
			}
			else if(colAvg<85 && colAvg>=65)
			{
				finalYtdAvg.append("<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average);
			}
			else if(colAvg<65)	
			 {
				finalYtdAvg.append("<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average);
			 }
		}
		else if("T1PERCENTPROD".equalsIgnoreCase(colValue))
		{
			if(colAvg>=80)
			{
				finalYtdAvg.append("<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average);
			}
			else if(colAvg<80 && colAvg>=60)
			{
				finalYtdAvg.append("<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average);
			}
			else if(colAvg<60)	
			 {
				finalYtdAvg.append("<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average);
			 }
		}
		else if("STPERCENTDRMET".equalsIgnoreCase(colValue))
		{
			if(colAvg>=90)
			{
				finalYtdAvg.append("<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average);
			}
			else if(colAvg<90 && colAvg>=80)
			{
				finalYtdAvg.append("<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average);
			}
			else if(colAvg<80)	
			 {
				finalYtdAvg.append("<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average);
			 }
		}
		else if("FLM_TIME".equalsIgnoreCase(colValue))
		{
			if(colAvg>=70)
			{
				finalYtdAvg.append("<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average);
			}
			else if(colAvg<70 && colAvg>=60)
			{
				finalYtdAvg.append("<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average);
			}
			else if(colAvg<60)	
			 {
				finalYtdAvg.append("<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average);
			 }
		}
		return finalYtdAvg.toString();
	}
	
	private String dfFormatter(double columnValue)
	{
		DecimalFormat df1 =new DecimalFormat("#.0");
		String average="";
		if(columnValue>0)
		{
			if(columnValue>1)
			{
				average=df1.format(columnValue);
			}
			else
			{
				average = "0"+df1.format(columnValue);
			}
		}
		else
		{
			average=columnValue+"";
		}
		return average;
	}
	
}
