package ibase.webitm.ejb.adm.adv;


import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Properties;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

@Stateless
public class MPReqmntClose extends ActionHandlerEJB implements MPReqmntCloseLocal,MPReqmntCloseRemote
{
	public	String mprreqClose() throws RemoteException, ITMException
	{
		return "";
	}
	public	String mprreqClose( String tranID, String xtraParams,String forcedFlag )throws RemoteException, ITMException
	{
		String resultStr = "";		
		Connection conn = null;
			
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			
			resultStr  = mprreqClose(tranID,  xtraParams, forcedFlag, conn);
			
			System.out.println("resultStr:::::"+resultStr);

		}
		catch(Exception e)
		{
			System.out.println("Exception [01][close]::"+e.getMessage());
			e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;					
				}
			}
			catch(Exception ex)
			{
				System.out.println("Exception [01][confirm]::"+ex.getMessage());
				ex.printStackTrace();
				System.out.println("Exception ::"+ex.getMessage());
				throw new ITMException(ex);
			}
		}
		System.out.println("Returning Result from mprclose::"+resultStr);
		return resultStr;

	}
	public String mprreqClose( String tranId, String xtraParams,String xmlString,Connection conn) throws RemoteException,ITMException
	{
		String closeDateStr="",approved="",status="",errString="";
		String sqlDb="";
		int noPost=0,noVacFilled=0,cnt=0;
		boolean isError =false;
		ITMDBAccessLocal itmdbAccessLocal = null ;
		PreparedStatement pstmt =null;
		ResultSet rs = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			itmdbAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date currDate = new java.util.Date();		
			closeDateStr = sdf.format(currDate);
			String dbName= checkNull(CommonConstants.DB_NAME);
			System.out.println("dbName:::::::"+dbName);
			
			if(dbName.trim().equalsIgnoreCase("db2"))
			{
				sqlDb="select approved,no_post,noof_vac_filled,status from mpreq where vac_no = ? for update";
				pstmt=conn.prepareStatement(sqlDb);
				pstmt.setString(1, tranId);
				rs=pstmt.executeQuery();			
				while(rs.next())
				{
					approved = checkNull(rs.getString("approved"));
					status = checkNull(rs.getString("status"));
					noPost = rs.getInt("no_post");
					noVacFilled = rs.getInt("noof_vac_filled");
					if(approved == null || approved.trim().length() == 0)
					{
						approved="N";
					}
					if(status == null || status.trim().length() == 0)
					{
						status="U";
					}
					System.out.println("approved:::::"+approved);
					System.out.println("status:::::"+status);
					System.out.println("noPost:::::"+noPost);
					System.out.println("noVacFilled:::::"+noVacFilled);
				}
				close(pstmt, rs);
			}
			else
			{
				sqlDb="select approved,no_post,noof_vac_filled,status from mpreq where vac_no = ? for update nowait";
				pstmt=conn.prepareStatement(sqlDb);
				pstmt.setString(1, tranId);
				rs=pstmt.executeQuery();			
				while(rs.next())
				{
					approved = checkNull(rs.getString("approved"));
					status = checkNull(rs.getString("status"));
					noPost = rs.getInt("no_post");
					noVacFilled = rs.getInt("noof_vac_filled");
					if(approved == null || approved.trim().length() == 0)
					{
						approved="N";
					}
					if(status == null || status.trim().length() == 0)
					{
						status="U";
					}
					System.out.println("approved:::::"+approved);
					System.out.println("status:::::"+status);
					System.out.println("noPost:::::"+noPost);
					System.out.println("noVacFilled:::::"+noVacFilled);
				}
				close(pstmt, rs);
			}
			 if(!approved.trim().equalsIgnoreCase("Y"))
				{
					isError = true;
					errString = itmdbAccessLocal.getErrorString("","VTNOCONF1","");
					return errString;	
				}
			else if(status.trim().equalsIgnoreCase("C") || noPost <= noVacFilled)
				{
					isError = true;
					errString = itmdbAccessLocal.getErrorString("","VTVACCL","");
					return errString;	
				}
			else
			{
				String sql ="SELECT COUNT(*) AS CNT FROM RECRSL WHERE VAC_NO=? AND MPR_STATUS = 'A'";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					cnt=rs.getInt("CNT");
				}
				close(pstmt, rs);
				if(cnt > 0)
				{
					isError = true;
					errString = itmdbAccessLocal.getErrorString("","VTVACCL3","");
					return errString;	
				}
				else
				{
					String closeUpdate="UPDATE MPREQ SET STATUS = 'C',STATUS_DATE=? WHERE VAC_NO=? ";
					pstmt=conn.prepareStatement(closeUpdate);
					pstmt.setString(1, closeDateStr);
					pstmt.setString(2, tranId);
					int i = pstmt.executeUpdate();
					System.out.println("row update into mpreq ="+i);
					close(pstmt, rs);
				}
			}
			
		}
		catch(Exception e)
		{
			isError=true;
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( isError )
					{
						System.out.println("Rolling Back Changes......");
						conn.rollback();
					}
					else
					{
						System.out.println("Commiting Changes......");
						conn.commit();
						isError = true;
						errString = itmdbAccessLocal.getErrorString("","VTVACCL2","");
						return errString;
					}
					
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :CLOSE:==>\n" + e);
				throw new ITMException(e);
			}
		}
		return errString;
	}
	
	private void close(PreparedStatement pstmt,ResultSet rs) //Method to close PreparedStatement & ResultSet
	{
		try
		{
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
	
	private String checkNull(String input)//Method to check null string
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input =input.trim();
		}
		return input;
	}
}
