package ibase.webitm.ejb.adm;

import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;

import org.w3c.dom.*;


@javax.ejb.Stateless
public class EmpStatusDateChgPos extends ValidatorEJB implements EmpStatusDateChgPosLocal, EmpStatusDateChgPosRemote
{
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String xmlString, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{

		String empCode = "";
		String loginEmpCode = "";
		String errString = "";
		String sql = "";
		String userId = "";
		String chgTerm = "";
		String statDtStr = "";
		
		Timestamp  currDate = null;
		Timestamp  statusDate = null;

		PreparedStatement pstmt = null;		

//		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();		
//		AdmCommon admCommon = new AdmCommon();
		GenericUtility genericUtility = GenericUtility.getInstance();

//		SimpleDateFormat sdfAppl = null;

		Document headerDom = null;

		try
		{

			System.out.println("XML String :"+xmlString);
			headerDom = genericUtility.parseString(xmlString); 				

			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			loginEmpCode  = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");

			empCode = checkNullAndTrim(genericUtility.getColumnValue("emp_code",headerDom));
			statDtStr = checkNullAndTrim(genericUtility.getColumnValue("status_date",headerDom));
			System.out.println("@V@ Status date str :- ["+statDtStr+"]");
			
			statusDate=Timestamp.valueOf(genericUtility.getValidDateString(statDtStr, genericUtility.getApplDateFormat(),
					genericUtility.getDBDateFormat()) + " 00:00:00.0");
			System.out.println("@V@ Status date :- ["+statusDate+"]");
			
			sql="Update employee set M_STATUS_DATE=? where emp_code=?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setTimestamp(1, statusDate);
			pstmt.setString(2, empCode);
			int updateCnt=pstmt.executeUpdate();
			System.out.println("@V@ Employee Update count :- ["+updateCnt+"]");
						
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			try
			{

				System.out.println("Exception IN AttdDailyPos::::"+e.getMessage());
				e.printStackTrace();			
				throw new ITMException(e);
			}
			catch (Exception e1)
			{
				e1.printStackTrace();
				throw new ITMException(e1);
			}
		}
		finally
		{
			try
			{	
				if(errString != null && errString.trim().length() > 0)
				{
					{
						conn.rollback();
					}
				}				
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception "+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}

	private String checkNull( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal;
	}
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal.trim();
	}
}

