package ibase.dashboard.wms.servlet;
import ibase.dashboard.wms.ejb.FGWarehouseRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class PendingShipmentServlet extends HttpServlet
{
    private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		FGWarehouseRemote fgWarehouseRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		HttpSession session = null;
		UserInfoBean userInfo = null;
		String sessionSiteCode = "";
		String facilityCode="";
		try
		{
			response.setContentType("application/xml");

			session     	= request.getSession(true);
			userInfo 		= (UserInfoBean) session.getAttribute("USER_INFO");
			sessionSiteCode 	= userInfo.getSiteCode();
			//sessionSiteCode="TA821";
			//facilityCode=request.getParameter("facilityCode");
			dataSourceName = request.getParameter("dataSourceName");
			
			context = new InitialContext(appConnectParm.getProperty());

			fgWarehouseRemote = (FGWarehouseRemote) context.lookup("ibase/FGWarehouse/remote");
			//JSONObject jsonObjData = (JSONObject) misDashboardRemote.getPendingShipment(dataSourceName, sessionSiteCode);
			JSONObject jsonObjData = (JSONObject) fgWarehouseRemote.getPendingShipment(dataSourceName, sessionSiteCode, facilityCode);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for PendingShipmentServlet build the Graph is===" + jsonObjData);
		
			

		} catch (Exception e)
		{
			System.out.println("Exception : PendingShipmentServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

}