package ibase.dashboard.crm.servlet;

import ibase.dashboard.crm.ejb.ContactCommDashboardRemote;
import ibase.system.config.AppConnectParm;

import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;//Modified by Anjali Rawankar on[10/05/2017][Start]

import org.json.simple.JSONObject;

public class ContactCommDashboardServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {
		String dataSourceName = "";
		String loginCode = "";// Modified by Anjali Rawankar on[10/05/2017][Start]
		String empCode = "";
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		ContactCommDashboardRemote contactCommDashboardRemote = null;
		try {

			response.setContentType("application/xml");
			dataSourceName = request.getParameter("dataSourceName");

			empCode = request.getParameter("EMP_CODE");
			
			/*
			 * Modified by Anjali Rawankar on[10/05/2017][Start]
			 * [Purpose : To get logincode ]
			 */
			loginCode = request.getParameter("loginCode");
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");

			/*
			 * Modified by Anjali Rawankar on [16/05/2017][Start]
			 *  [Purpose : To get empcode ]
			 */
			// loginCode = userInfo.getLoginCode();
			loginCode = userInfo.getEmpCode();
			System.out.println("Login Code :: [ "+ loginCode +" ]");
			/*[Purpose : To get empcode ] 
			 * Modified by Anjali Rawankar on [16/05/2017][End]
			 */

			/*
			 * [Purpose : To get logincode ] 
			 * Modified by Anjali Rawankar on[10/05/2017][End]
			 */

			context = new InitialContext(appConnectParm.getProperty());
			contactCommDashboardRemote =  (ContactCommDashboardRemote) context.lookup("ibase/ContactCommDashboard/remote");

			/* Modified by Anjali Rawankar on[10/05/2017][Start] 
			 * [Purpose : Add parametere logincode in getcommunicationSchedule() ]
			 */
			// JSONObject jsonObjData = (JSONObject)
			// contactCommDashboardRemote.getCommunicationSchedule(dataSourceName);
			JSONObject jsonObjData = (JSONObject) contactCommDashboardRemote.getCommunicationSchedule(dataSourceName, loginCode, empCode);
			/*
			 * [Purpose : Add parametere logincode in getcommunicationSchedule()]
			 * Modified by Anjali Rawankar on[10/05/2017][End]
			 */
			OutputStream outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for ContactCommDashboardServlet==="+ jsonObjData);

		} 
		catch (Exception e) 
		{
			System.out.println("Exception : ContactCommDashboardServlet :doPost(HttpServletRequest request, HttpServletResponse response) :"+ e);
			try 
			{
				throw new ITMException(e);
			} 
			catch (ITMException e1) 
			{
				e1.printStackTrace();
			}
		}

	}

}