<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<body>
<script type="text/javascript" src="/ibase/webitm/js/WavegenWiz.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
		
<link href="/ibase/webitm/css/Galaxy/galaxy-theme.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/Standard/default.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/WavegenWiz.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/circle.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/jquery.datetimepicker.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>


<script>
<![CDATA[
	$(function() 
	{
		var acc = document.getElementsByClassName("accordion");
		var i;
		
		for (i = 0; i < acc.length; i++)
		{
		    acc[i].onclick = function()
		    {
		    	if(this.attributes.expanded.value == "false")
		   		{
		    		this.attributes.expanded.value = "true";
		   		}
		    	else
		   		{
		    		this.attributes.expanded.value = "false";
		   		}
	       		this.classList.remove("activeAccor");
		       	this.classList.toggle("active");
		        this.nextElementSibling.classList.toggle("show");
		        
		        var expAttributes = $("button[expanded='true']");
		        var expCnt = expAttributes.length;
		        
		        if(expCnt == acc.length)
		       	{
		        	document.getElementById("accorAct").value = "Collapse All";	
		       	}
		        else
		       	{
		        	document.getElementById("accorAct").value = "Expand All";	
		       	}
		  	}
		}
	});
	
	$(function() 
	{
		var panel = document.getElementsByClassName("panel");
	
		for (var j = 0; j < panel.length; j++)
		{
			panel[j].onclick = function()
		    {
		       if(this.id != "")
		       {
		       		var acc = document.getElementsByClassName("accordion");
		       		for(var i=0; i<acc.length; i++)
		       		{
		       			acc[i].classList.remove("activeAccor");
		       		}
		       		this.previousElementSibling.classList.add("activeAccor");
		       }
		  	}
		}
	});
	
	$(document).on("keydown", function (e) {
	    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
	        e.preventDefault();
	    }
	    else if(e.which === 13){
	    	 e.preventDefault();
	    }
	});
	
	window.onclick = function (event)
	{
		if(!event.target.matches(".imagePanelSrc") && !event.target.matches(".itemImg"))
		{
			document.getElementById("sideImagePanel").style.display="none";
		}
	}
]]>
</script>

<form name="wavegenWizForm2" id="wavegenWizForm2" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">
	<div class="contentHeaderLbl" style="position:fixed;overflow:hidden;width:97%;">
		&#160;&#160;<img src="/ibase/images/menuImages/web/wavegeneration.png" onerror="this.src='/ibase/images/menuImages/errMenu.png'" style="position: absolute; margin-left: -20px; height: 20px; width: 20px;"/>
		&#160;Wave Generation
		<input type="button" Value="Expand All" class="button" id="accorAct" onclick="expandCollapse();" style="float: right;margin-right:2px;"/>
		<input type="button" Value="Select All" class="button" id="selectAllRow" onclick="selectAllRows();" style="float: right;margin-right:2px;"/>
	</div><br/><br/>
	<!-- Changed by Santosh on 31/03/2017 to remove horizontal scroll bar -->
	<!-- <div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:100%;position:absolute;z-index:5;"> -->
	<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:98%;position:absolute;z-index:5;">
	    <table id="errorActivityTable" height="10%" class="tableClass"  style="margin: 12px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
            <xsl:for-each select="//error">
                <xsl:if test="position() = 1">
                    <tr>    
                        <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom">
                            Message :
                        </td> 
                        <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom">
                            Description :
                        </td>
                        <td class="tdss_rightAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
                            <a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
                <xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
                <xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
                <tr style="background: rgba(255, 204, 0, 0.66);">
                     <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="message"/>
                    </td> 
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="description"/>
                    </td>
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
                    </td>
                </tr>
                <script><![CDATA[]]>formatDetailWithErr();</script>
            </xsl:for-each>
            
            <xsl:for-each select="//error">
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:if test="position() = 1">
                    <xsl:if test="$type = 'W'">
                        <tr style="background: rgba(255, 204, 0, 0.66);">
                            <td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
                                <input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
                            </td>
                            <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true"></td>
                        </tr>
                    </xsl:if>
                </xsl:if>    
            </xsl:for-each>
	    </table>
	</div>
	<div id="sideImagePanel" class="imagePanel"></div>
	<div id="popHelpContainer"></div>
	<div id="overlay"></div>
	<div id="mainPageHeaderContatiner">
		<div id="detailPage-input-Container">
			<xsl:for-each select="//Detail2">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				<xsl:if test="$dbID = '0'">
					
					<xsl:variable name="site_code"><xsl:value-of select="site_code"/></xsl:variable>
					<xsl:variable name="sort_order"><xsl:value-of select="sort_order"/></xsl:variable>
					<xsl:variable name="item_ser__from"><xsl:value-of select="item_ser__from"/></xsl:variable>
					<xsl:variable name="item_ser__to"><xsl:value-of select="item_ser__to"/></xsl:variable>
					<xsl:variable name="product_style__from"><xsl:value-of select="product_style__from"/></xsl:variable>
					<xsl:variable name="product_style__to"><xsl:value-of select="product_style__to"/></xsl:variable>
					<xsl:variable name="item_code__from"><xsl:value-of select="item_code__from"/></xsl:variable>
					<xsl:variable name="item_code__to"><xsl:value-of select="item_code__to"/></xsl:variable>
					<xsl:variable name="cust_code__from"><xsl:value-of select="cust_code__from"/></xsl:variable>
					<xsl:variable name="cust_code__to"><xsl:value-of select="cust_code__to"/></xsl:variable>
					<xsl:variable name="due_date__from"><xsl:value-of select="due_date__from"/></xsl:variable>
					<xsl:variable name="due_date__to"><xsl:value-of select="due_date__to"/></xsl:variable>
					<xsl:variable name="sale_order__from"><xsl:value-of select="sale_order__from"/></xsl:variable>
					<xsl:variable name="sale_order__to"><xsl:value-of select="sale_order__to"/></xsl:variable>
					<xsl:variable name="cust_code__dlv__from"><xsl:value-of select="cust_code__dlv__from"/></xsl:variable>
					<xsl:variable name="cust_code__dlv__to"><xsl:value-of select="cust_code__dlv__to"/></xsl:variable>
					<xsl:variable name="credit_term__from"><xsl:value-of select="credit_term__from"/></xsl:variable>
					<xsl:variable name="credit_term__to"><xsl:value-of select="credit_term__to"/></xsl:variable>
					<xsl:variable name="carrier_code"><xsl:value-of select="carrier_code"/></xsl:variable>				
					<xsl:variable name="carrier_name"><xsl:value-of select="carrier_name"/></xsl:variable>
					<xsl:variable name="default_qty_flag"><xsl:value-of select="default_qty_flag"/></xsl:variable>
					<xsl:variable name="wave_mode"><xsl:value-of select="wave_mode"/></xsl:variable>
					<xsl:variable name="order_type"><xsl:value-of select="order_type"/></xsl:variable>
					<xsl:variable name="loc_type_parent"><xsl:value-of select="loc_type_parent"/></xsl:variable>
					<xsl:variable name="tran_code"><xsl:value-of select="tran_code"/></xsl:variable>
					<xsl:variable name="tran_name"><xsl:value-of select="tran_name"/></xsl:variable>
					<xsl:variable name="remarks"><xsl:value-of select="remarks"/></xsl:variable>
					<xsl:variable name="active_pick_allow"><xsl:value-of select="active_pick_allow"/></xsl:variable>
					<xsl:variable name="master_pack_allow"><xsl:value-of select="master_pack_allow"/></xsl:variable>
					<xsl:variable name="parcelpack_allow"><xsl:value-of select="parcelpack_allow"/></xsl:variable>
					<xsl:variable name="stock_to_dock_allow"><xsl:value-of select="stock_to_dock_allow"/></xsl:variable>
					<xsl:variable name="single_lot"><xsl:value-of select="single_lot"/></xsl:variable>
					<xsl:variable name="ship_type"><xsl:value-of select="ship_type"/></xsl:variable>
					<xsl:variable name="pallet_no"><xsl:value-of select="pallet_no"/></xsl:variable>
					<xsl:variable name="direct_pick_loc"><xsl:value-of select="direct_pick_loc"/></xsl:variable>
					<xsl:variable name="print_label"><xsl:value-of select="print_label"/></xsl:variable>
					<xsl:variable name="printer_name"><xsl:value-of select="printer_name"/></xsl:variable>
					<xsl:variable name="date_format"><xsl:value-of select="date_format"/></xsl:variable>
					<xsl:variable name="app_context"><xsl:value-of select="app_context"/></xsl:variable>
					
					<input type="hidden" value="{$site_code}" name="Detail2.{normalize-space($dbID)}.site_code" id="site_code" />
					<input type="hidden" value="{$sort_order}" name="Detail2.{normalize-space($dbID)}.sort_order" id="sort_order" />
					<input type="hidden" value="{$item_ser__from}" name="Detail2.{normalize-space($dbID)}.item_ser__from" id="item_ser__from" />
					<input type="hidden" value="{$item_ser__to}" name="Detail2.{normalize-space($dbID)}.item_ser__to" id="item_ser__to" />
					<input type="hidden" value="{$product_style__from}" name="Detail2.{normalize-space($dbID)}.product_style__from" id="product_style__from" />
					<input type="hidden" value="{$product_style__to}" name="Detail2.{normalize-space($dbID)}.product_style__to" id="product_style__to" />
					<input type="hidden" value="{$item_code__from}" name="Detail2.{normalize-space($dbID)}.item_code__from" id="item_code__from" />
					<input type="hidden" value="{$item_code__to}" name="Detail2.{normalize-space($dbID)}.item_code__to" id="item_code__to" />
					<input type="hidden" value="{$cust_code__from}" name="Detail2.{normalize-space($dbID)}.cust_code__from" id="cust_code__from" />
					<input type="hidden" value="{$cust_code__to}" name="Detail2.{normalize-space($dbID)}.cust_code__to" id="cust_code__to" />
					<input type="hidden" value="{$due_date__from}" name="Detail2.{normalize-space($dbID)}.due_date__from" id="due_date__from" />
					<input type="hidden" value="{$due_date__to}" name="Detail2.{normalize-space($dbID)}.due_date__to" id="due_date__to" />
					<input type="hidden" value="{$sale_order__from}" name="Detail2.{normalize-space($dbID)}.sale_order__from" id="sale_order__from" />
					<input type="hidden" value="{$sale_order__to}" name="Detail2.{normalize-space($dbID)}.sale_order__to" id="sale_order__to" />
					<input type="hidden" value="{$cust_code__dlv__from}" name="Detail2.{normalize-space($dbID)}.cust_code__dlv__from" id="cust_code__dlv__from" />
					<input type="hidden" value="{$cust_code__dlv__to}" name="Detail2.{normalize-space($dbID)}.cust_code__dlv__to" id="cust_code__dlv__to" />
					<input type="hidden" value="{$credit_term__from}" name="Detail2.{normalize-space($dbID)}.credit_term__from" id="credit_term__from" />
					<input type="hidden" value="{$credit_term__to}" name="Detail2.{normalize-space($dbID)}.credit_term__to" id="credit_term__to" />
					<input type="hidden" value="{$carrier_code}" name="Detail2.{normalize-space($dbID)}.carrier_code" id="carrier_code" />
					<input type="hidden" value="{$carrier_name}" name="Detail2.{normalize-space($dbID)}.carrier_name" id="carrier_name" />
					<input type="hidden" value="{$default_qty_flag}" name="Detail2.{normalize-space($dbID)}.default_qty_flag" id="default_qty_flag" />
					<input type="hidden" value="{$wave_mode}" name="Detail2.{normalize-space($dbID)}.wave_mode" id="wave_mode" />
					<input type="hidden" value="{$order_type}" name="Detail2.{normalize-space($dbID)}.order_type" id="order_type" />
					<input type="hidden" value="{$loc_type_parent}" name="Detail2.{normalize-space($dbID)}.loc_type_parent" id="loc_type_parent" />
					<input type="hidden" value="{$tran_code}" name="Detail2.{normalize-space($dbID)}.tran_code" id="tran_code" />
					<input type="hidden" value="{$tran_name}" name="Detail2.{normalize-space($dbID)}.tran_name" id="tran_name" />
					<input type="hidden" value="{$remarks}" name="Detail2.{normalize-space($dbID)}.remarks" id="remarks" />
					<input type="hidden" value="{$active_pick_allow}" name="Detail2.{normalize-space($dbID)}.active_pick_allow" id="active_pick_allow" />
					<input type="hidden" value="{$master_pack_allow}" name="Detail2.{normalize-space($dbID)}.master_pack_allow" id="master_pack_allow" />
					<input type="hidden" value="{$parcelpack_allow}" name="Detail2.{normalize-space($dbID)}.parcelpack_allow" id="parcelpack_allow" />
					<input type="hidden" value="{$stock_to_dock_allow}" name="Detail2.{normalize-space($dbID)}.stock_to_dock_allow" id="stock_to_dock_allow" />
					<input type="hidden" value="{$single_lot}" name="Detail2.{normalize-space($dbID)}.single_lot" id="single_lot" />
					<input type="hidden" value="{$ship_type}" name="Detail2.{normalize-space($dbID)}.ship_type" id="ship_type" />
					<input type="hidden" value="{$pallet_no}" name="Detail2.{normalize-space($dbID)}.pallet_no" id="pallet_no" />
					<input type="hidden" value="{$direct_pick_loc}" name="Detail2.{normalize-space($dbID)}.direct_pick_loc" id="direct_pick_loc" />
					<input type="hidden" value="{$print_label}" name="Detail2.{normalize-space($dbID)}.print_label" id="print_label" />
					<input type="hidden" value="{$printer_name}" name="Detail2.{normalize-space($dbID)}.printer_name" id="printer_name" />
					<input type="hidden" value="{$date_format}" name="Detail2.{normalize-space($dbID)}.date_format" id="date_format" />
					<input type="hidden" value="{$app_context}" name="Detail2.{normalize-space($dbID)}.app_context" id="app_context" />
				</xsl:if>
				<xsl:if test ="$dbID != '0'">
					<xsl:variable name="custDbID"><xsl:value-of select="@domID"/></xsl:variable>
					<xsl:variable name="custCode"><xsl:value-of select="cust_code"/></xsl:variable>
					<button class="accordion" id="custPerc{$custDbID}" type="button" expanded="false">
						<xsl:variable name="allocPerc"><xsl:value-of select="total_alloc_perc"/></xsl:variable>
						<input type="hidden" id="prevCustPerc{$custDbID}" value="{$allocPerc}"/>
						<div id="percClass{$custDbID}" class="c100 small p{$allocPerc}">
						  <img src="/ibase/resource/customer/{$custCode}.png" class="custImg"/>
						  <div class="slice">
							<div id="custbar{$custDbID}" class="bar"></div>
							<div id="custfill{$custDbID}" class="fill"></div>
						  </div>
						</div>
						<div style="margin-left:10px;" class="dataSummry">
							<span class="headerText"><xsl:value-of select="cust_name"/>, <xsl:value-of select="dlv_city"/>, (<xsl:value-of select="cust_code"/>)</span><br/>
							<span class="subText"><xsl:value-of select="order_count"/> Order(s), <xsl:value-of select="line_item_count"/> Line item(s), <xsl:value-of select="alloc_line_item"/> Line item(s) available</span>
						</div>
						<div class="selectSummry">
							<p><xsl:value-of select="total_alloc_perc"/>% in <xsl:value-of select="line_item_count"/> line(s) available</p>
							<p><span id="custPercVal{$custDbID}">0</span>% in <span id="custLine{$custDbID}">0</span> line(s) selected</p>
						</div>
					</button>
					<div class="panel" id="custPanel{$custDbID}">
						<xsl:for-each select="saleOrders/saleOrder">
						<xsl:variable name="soDbID"><xsl:value-of select="@domID"/></xsl:variable>
							<button class="accordion accordionSO" type="button" expanded="false">
								<xsl:variable name="soAllocPerc"><xsl:value-of select="alloc_perc"/></xsl:variable>
								<input type="hidden" id="prevSoPerc{$soDbID}" value="{$soAllocPerc}"/>
								<div id="soPercClass{$soDbID}" class="c100 small p{$soAllocPerc}" style="margin-left:10px !important;">
								  <span id="soPercText{$soDbID}" class="percText"><xsl:value-of select="alloc_perc"/>%</span>
								  <div class="slice">
									<div id="sobar{$soDbID}" class="bar"></div>
									<div id="sofill{$soDbID}" class="fill"></div>
								  </div>
								</div>
								<div style="margin-left:10px;" class="dataSummry">
									<span class="headerText"><xsl:value-of select="sale_order"/> - Customer PO# - <xsl:value-of select="cust_pord"/>, Customer PO Date - <xsl:value-of select="pord_date"/></span><br></br>
									<span class="subText"><xsl:value-of select="no_line_item"/> Line item(s), <xsl:value-of select="so_alloc_line_item"/> Line item(s) available</span>
								</div>
								<div class="selectSummry">
									<p><xsl:value-of select="alloc_perc"/>% in <xsl:value-of select="no_line_item"/> line(s) available</p>
									<p><span id="soPerc{$soDbID}">0</span>% in <span  id="soLine{$soDbID}">0</span> line(s) selected</p>
								</div>
						  	</button>
						  	<div class="panel panelSO">
							  <table id ="details{$soDbID}" class="tableClass">
								<thead class="table-head">
									<tr>
										<th nowrap="true" style="border-left:0px solid black !important;" ><Input id='selectAll{$soDbID}' type='checkbox' name='selectAll' custId='{$custDbID}' tableId='{$soDbID}' onClick="checkAll('{$custDbID}','details{$soDbID}','{$soDbID}')"/></th>
										<th nowrap="true" style="display:none;">Customer Code</th>
										<th nowrap="true" style="display:none;">Customer Name</th>
										<th nowrap="true" style="display:none;">Customer Code Delivery</th>
										<th nowrap="true" style="display:none;">Customer Code Delivery Name</th>
										<th nowrap="true" style="display:none;">Sale Order</th>
										<th nowrap="true" style="padding:0 2px;">Line#</th>
										<th nowrap="true">Due Date</th>
										<th nowrap="true">Item Code</th>
										<th nowrap="true">Description</th>
										<th nowrap="true">Part Qty</th>
										<th nowrap="true">Pendg Qty</th>
										<th nowrap="true">Stock Qty</th>
										<th nowrap="true">Qty Alloc</th>
										<th nowrap="true">Hold Qty</th>
										<th nowrap="true">Bal Qty</th>
										<th nowrap="true" align="right">Quantity</th>
										<th nowrap="true">Manual Alloc Qty</th>
										<th nowrap="true">Alloc Flag</th>
										<th nowrap="true">Transporter Code</th>
										<th nowrap="true">Transporter Name</th>
										<th nowrap="true">Single Lot</th>
										<th nowrap="true">Master Pack</th>
										<th nowrap="true">Active Pick</th>
										<th nowrap="true">Stock To Dock</th>
										<th nowrap="true">Parcel Pick Allow</th>
										<th nowrap="true">Shipment Type</th>
										<th nowrap="true">Dock Location</th>
										<th nowrap="true">Packing Instruction</th>
										<th nowrap="true">Site Code</th>
										<th nowrap="true" style="border-right:0px solid black !important;">Exp Lev</th>
										<th nowrap="true" style="display:none;">Last Col</th>
										<th nowrap="true" style="display:none;">Part Qty Real</th>
									</tr>
								</thead>
								<tbody class="table-body">
									<xsl:for-each select="lineItems/lineItem">
									<xsl:variable name="linedbID"><xsl:value-of select="@domID"/></xsl:variable>
									<xsl:variable name="cust_code"><xsl:value-of select="cust_code"/></xsl:variable>
									<xsl:variable name="cust_name"><xsl:value-of select=" cust_name"/></xsl:variable>
									<xsl:variable name="cust_code__dlv"><xsl:value-of select="cust_code__dlv"/></xsl:variable>
									<xsl:variable name="customer_cust_name"><xsl:value-of select="customer_cust_name"/></xsl:variable>
									<xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
									<xsl:variable name="sale_order"><xsl:value-of select="sale_order"/></xsl:variable>
									<xsl:variable name="due_date"><xsl:value-of select="due_date"/></xsl:variable>
									<xsl:variable name="item_code"><xsl:value-of select="item_code"/></xsl:variable>
									<xsl:variable name="item_descr"><xsl:value-of select="item_descr"/></xsl:variable>
									<xsl:variable name="single_lot"><xsl:value-of select="single_lot"/></xsl:variable>
									<xsl:variable name="master_pack_allow"><xsl:value-of select="master_pack_allow"/></xsl:variable>
									<xsl:variable name="active_pick_allow"><xsl:value-of select="active_pick_allow"/></xsl:variable>
									<xsl:variable name="stock_to_dock_allow"><xsl:value-of select="stock_to_dock_allow"/></xsl:variable>
									<xsl:variable name="parcelpack_allow"><xsl:value-of select="parcelpack_allow"/></xsl:variable>
									<xsl:variable name="ship_type"><xsl:value-of select="ship_type"/></xsl:variable>
									<xsl:variable name="quantity"><xsl:value-of select="quantity"/></xsl:variable>
									<xsl:variable name="part_qty"><xsl:value-of select="part_qty"/></xsl:variable>
									<xsl:variable name="pending_quantity"><xsl:value-of select="pending_quantity"/></xsl:variable>
									<xsl:variable name="stock_quantity"><xsl:value-of select="stock_quantity"/></xsl:variable>
									<xsl:variable name="hold_qty"><xsl:value-of select="hold_qty"/></xsl:variable>
									<xsl:variable name="qty_alloc"><xsl:value-of select="qty_alloc"/></xsl:variable>
									<xsl:variable name="bal_qty"><xsl:value-of select="bal_qty"/></xsl:variable>
									<xsl:variable name="manual_allocqty"><xsl:value-of select="manual_allocqty"/></xsl:variable>
									<xsl:variable name="alloc_flag"><xsl:value-of select="alloc_flag"/></xsl:variable>
									<xsl:variable name="tran_code"><xsl:value-of select="tran_code"/></xsl:variable>
									<xsl:variable name="tran_name"><xsl:value-of select="tran_name"/></xsl:variable>
									<xsl:variable name="lock_code__dock"><xsl:value-of select="lock_code__dock"/></xsl:variable>
									<xsl:variable name="pack_instr"><xsl:value-of select="pack_instr"/></xsl:variable>
									<xsl:variable name="site_code"><xsl:value-of select="site_code"/></xsl:variable>
									<xsl:variable name="exp_lev"><xsl:value-of select="exp_lev"/></xsl:variable>
									<xsl:variable name="last_col"><xsl:value-of select="last_col"/></xsl:variable>
									<xsl:variable name="part_qty_real"><xsl:value-of select="part_qty_real"/></xsl:variable>
									<xsl:variable name="qty_highlighter"><xsl:value-of select="qty_highlighter"/></xsl:variable>
									<xsl:variable name="image_path"><xsl:value-of select="image_path"/></xsl:variable>
									<tr class='trClass' id="{$linedbID}" onclick="setCheckboxRow(event,this,{$soDbID},'{$custDbID}','details{$soDbID}');">
										<td nowrap="true" style="border-left:0px solid black !important;">
											<Input type='checkbox' value="true" class="selectAll{$soDbID}" name="Detail2.{normalize-space($linedbID)}.selectbox" id="Detail2.{normalize-space($linedbID)}.selectbox" onclick="setCheckbox(this,'{$linedbID}','{$soDbID}','{$custDbID}','details{$soDbID}');" tabindex="-1" />
										</td>
										<td nowrap="true" style="display:none;">
											<xsl:value-of select="cust_code"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cust_code" value="{$cust_code}"></input>
										</td>
										<td nowrap="true" style="display:none;">
											<xsl:value-of select="cust_name"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cust_name" value="{$cust_name}"></input>
										</td>
										<td nowrap="true" style="display:none;">
											<xsl:value-of select="cust_code__dlv"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cust_code__dlv" value="{$cust_code__dlv}"></input>
										</td>
										<td nowrap="true" style="display:none;">
											<xsl:value-of select="customer_cust_name"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.customer_cust_name" value="{$customer_cust_name}"></input>
										</td>
										<td nowrap="true" style="display:none;">
											<xsl:value-of select="sale_order"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.sale_order" value="{$sale_order}"></input>
										</td>
										<td nowrap="true" align="right">
											<xsl:value-of select="line_no"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.line_no" value="{$line_no}"></input>
										</td>
										<td nowrap="true">
											<xsl:value-of select="due_date"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.due_date" value="{$due_date}"></input>
										</td>
										<td nowrap="true" style="padding:0 3px;">
										  <div style="height:31px;line-height:31px;">
											<xsl:value-of select="item_code"/>
											<img type="image" src="{$image_path}" class="itemImg" onclick="showItemImage('{normalize-space($item_code)}','{$item_descr}');" />
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.item_code" value="{$item_code}"></input>
										  </div>
										</td>
										<td nowrap="true">
											<xsl:value-of select="item_descr"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.item_descr" value="{$item_descr}"></input>
										</td>
										<td nowrap="true" align="right">
											<xsl:value-of select="part_qty"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.part_qty" value="{$part_qty}"></input>
										</td>
										<td nowrap="true" align="right">
											<xsl:value-of select="pending_quantity"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.pending_quantity" value="{$pending_quantity}"></input>
										</td>
										<td nowrap="true" align="right">
											<xsl:value-of select="stock_quantity"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.stock_quantity" value="{$stock_quantity}"></input>
										</td>
										<td nowrap="true" align="right" style="padding: 0 3px;vertical-align:middle;">
											<input type="text" name="Detail2.{normalize-space($linedbID)}.qty_alloc" id="Detail2.{normalize-space($linedbID)}.qty_alloc" value="{$qty_alloc}" onchange="selectThisRow(this,{$linedbID}, {$soDbID},'{$custDbID}','details{$soDbID}');" onpaste="return false;" onkeypress="return isNumberKey(event);" style="text-align:right;width:65px;float:left;"></input>
											<div class="qtyHighlight" style="background-color:{$qty_highlighter}"></div>
										</td>
										<td nowrap="true" align="right">
											<xsl:value-of select="hold_qty"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.hold_qty" value="{$hold_qty}"></input>
										</td>
										<td nowrap="true" align="right">
											<xsl:value-of select="bal_qty"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.bal_qty" value="{$bal_qty}"></input>
										</td>
										<td nowrap="true" align="right">
											<xsl:value-of select="quantity"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.quantity" value="{$quantity}"></input>
										</td>
										<td nowrap="true" align="right">
											<xsl:value-of select="manual_allocqty"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.manual_allocqty" value="{$manual_allocqty}"></input>
										</td>
										<td nowrap="true">
											<xsl:value-of select="alloc_flag"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.alloc_flag" value="{$alloc_flag}"></input>
										</td>
										<td nowrap="true">
											<xsl:value-of select="tran_code"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.tran_code" value="{$tran_code}"></input>
										</td>
										<td nowrap="true">
											<xsl:value-of select="tran_name"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.tran_name" value="{$tran_name}"></input>
										</td>
										<td nowrap="true" align="center">
											<SELECT class="input_editable" onchange="setSelected(this);" name="Detail2.{normalize-space($linedbID)}.single_lot" tabindex="-1">
												<OPTION value="Y"><xsl:choose><xsl:when test="$single_lot='Y'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Yes]]></OPTION>
												<OPTION value="N"><xsl:choose><xsl:when test="$single_lot='N'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[No]]></OPTION>
											</SELECT>
										</td>
										<td nowrap="true" align="center">
											<SELECT class="input_editable" onchange="setSelected(this);" name="Detail2.{normalize-space($linedbID)}.master_pack_allow" tabindex="-1">
												<OPTION value="Y"><xsl:choose><xsl:when test="$master_pack_allow='Y'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Yes]]></OPTION>
												<OPTION value="N"><xsl:choose><xsl:when test="$master_pack_allow='N'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[No]]></OPTION>
											</SELECT>
										</td>
										<td nowrap="true" align="center">
											<SELECT class="input_editable" onchange="setSelected(this);" name="Detail2.{normalize-space($linedbID)}.active_pick_allow" tabindex="-1">
												<OPTION value="Y"><xsl:choose><xsl:when test="$active_pick_allow='Y'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Yes]]></OPTION>
												<OPTION value="N"><xsl:choose><xsl:when test="$active_pick_allow='N'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[No]]></OPTION>
											</SELECT>
										</td>
										<td nowrap="true" align="center">
											<SELECT class="input_editable" onchange="setSelected(this);" name="Detail2.{normalize-space($linedbID)}.stock_to_dock_allow" tabindex="-1">
												<OPTION value="Y"><xsl:choose><xsl:when test="$stock_to_dock_allow='Y'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Yes]]></OPTION>
												<OPTION value="N"><xsl:choose><xsl:when test="$stock_to_dock_allow='N'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[No]]></OPTION>
											</SELECT>
										</td>
										<td nowrap="true" align="center">
											<SELECT class="input_editable" onchange="setSelected(this);" name="Detail2.{normalize-space($linedbID)}.parcelpack_allow" tabindex="-1">
												<OPTION value="Y"><xsl:choose><xsl:when test="$parcelpack_allow='Y'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Yes]]></OPTION>
												<OPTION value="N"><xsl:choose><xsl:when test="$parcelpack_allow='N'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[No]]></OPTION>
											</SELECT>
										</td>
										<td nowrap="true" align="center">
											<SELECT class="input_editable" onchange="setSelected(this);" name="Detail2.{normalize-space($linedbID)}.ship_type" tabindex="-1">
												<OPTION value="A"><xsl:choose><xsl:when test="ship_type='A'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[As per Routing]]></OPTION>
												<OPTION value="L"><xsl:choose><xsl:when test="ship_type='L'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[LTL]]></OPTION>
												<OPTION value="M"><xsl:choose><xsl:when test="ship_type='M'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Master Pack]]></OPTION>
												<OPTION value="P"><xsl:choose><xsl:when test="ship_type='P'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Parcel Pack]]></OPTION>
											</SELECT>
										</td>
										<td nowrap="true">
											<xsl:value-of select="lock_code__dock"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.lock_code__dock" value="{$lock_code__dock}"></input>
										</td>
										<td nowrap="true">
											<xsl:value-of select="pack_instr"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.pack_instr" value="{$pack_instr}"></input>
										</td>
										<td nowrap="true">
											<xsl:value-of select="site_code"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.site_code" value="{$site_code}"></input>
										</td>
										<td nowrap="true" align="right" style="border-right:0px solid black !important;">
											<xsl:value-of select="exp_lev"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.exp_lev" value="{$exp_lev}"></input>
										</td>
										<td nowrap="true" style="display:none;">
											<xsl:value-of select="last_col"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.last_col" value="{$last_col}"></input>
										</td>
										<td nowrap="true" style="display:none;">
											<xsl:value-of select="part_qty_real"/>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.part_qty_real" value="{$part_qty_real}"></input>
										</td>
									</tr>
									</xsl:for-each>
								</tbody>
							  </table>
							</div>
						</xsl:for-each>
					</div>
				</xsl:if>
			</xsl:for-each>
		</div>
		<div id="btnDiv" style="width:100%;">
			<input type="hidden" value="2" name="FORM_NO" ID="FORM_NO" />
			<input type="hidden"  value="wavegen_wiz" name="OBJ_NAME" />
			<input type="hidden"  name="PRE_FORM_VAL" ID="PRE_FORM_VAL" />
			<input type="hidden" value="1:MP" name="formType" id="formType" />
			<input type="hidden"  value="finish" name="action" id="action" />
			<input type="button" style="margin-left:2px;" value="Previous" class="button" title="back" id="back" onclick="form2Previous();"/>
			<input type="submit" style="margin-left:2px;" value="Finish" class="button" title="finish" id="finish" onclick="return validateSubmit();" />
		</div>
	</div>
	
	<div id="buttonreplacement">
		<img src="/ibase/images/preload.gif" alt="Please wait work in progress" ></img>
		<span>Please wait......</span>
	</div>
</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
