package ibase.webitm.ejb.gst;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.util.gst.GSTCommonUtil;
import ibase.webitm.utility.ITMException;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class GstrIC
 */
@Stateless
public class Gstr3BIC extends ValidatorEJB implements Gstr3BICRemote, Gstr3BICLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	GSTCommonUtil gstUtility = new GSTCommonUtil();
	
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException 
	{
		Document dom = null; 
   		Document dom1 = null; 
   		Document dom2 = null;
   		String retString = "";	
   		try
   		{
   			System.out.println("*************** Inside wfValData *******************");  
    	    System.out.println("xmlString::::::::::::"+xmlString);
    	    System.out.println("xmlString1::::::::::::"+xmlString1);
    	    System.out.println("xmlString2::::::::::::"+xmlString2);
    	    
	   		if(xmlString != null && xmlString.trim().length()>0)
	   		{
	   			dom = genericUtility.parseString(xmlString);		
	   		}
	   		if(xmlString1 != null && xmlString1.trim().length()>0)
	   		{
	   			dom1 = genericUtility.parseString(xmlString1);
	   		}
	   		if(xmlString2 != null && xmlString2.trim().length()>0)
	   		{
	   			dom2 = genericUtility.parseString(xmlString2);
	   		}
	   		retString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
	   		System.out.println("errorString::::::::::"+retString);
		}
        catch(Exception e)
        {
        	System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 
        }
        return retString;	    
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2,String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
		E12GenericUtility genericUtility = new E12GenericUtility();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String sql="";
		String userId = "";
		int currentFormNo = 0;
		NodeList parentNodeList = null;
		Node parentNode = null;
		NodeList childNodeList = null;
		Node childNode = null;
		int childNodeLength = 0;
	    int ctr = 0, cnt = 0;
		String childNodeName = "";
		String errorType = "",errString="",cust_name="";
		String errCode = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		String tran_type="",gst_type="",gst_rate="",finalCode="",rec_type="";
		String state_code="",tax_reg_no = "",itc_type="",state_code_cdn="";
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		String doc_type="",doc_date="",amount="",doc_no="",ecom_reg_no="",loginSite="",gs_code="",gs_descr="";
		String quantity="",unit="",taxable_amt="",igst_perc="",igst_amt="",cgst_amt="",sgst_amt="",cess_amt="";
		String ref_id__inv="",ref_date__inv="",lr_no="",lr_date="",supply_type="",cgst_perc="",sgst_perc="",reverse_chrg="";
		String name="",addr1="",addr2="",addr3="",city="",state="",pin="",loginSiteCode="",ecomRegNo="",orderNo="";
		double cgst_amtVal=0.0,sgst_amtVal=0.0,cgst_percVal=0.0,sgst_percVal=0.0;
		double igst_percVal=0.0,igst_amtVal=0.0,gstRate=0.0;
		String refIdInv="",gstCode="";
		
		Timestamp refInvDateDate = null,invDate = null;
		try
		{	
			conn = getConnection();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"); 
			loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
		    
			if(objContext != null && objContext.trim().length()>0)
		    {
				currentFormNo = Integer.parseInt(objContext); //System.out.println("currentFormNo:::"+currentFormNo);
			   	    
				switch(currentFormNo)
		    	{
		    		case 1:
		    		{	
		    			parentNodeList = dom.getElementsByTagName("Detail1");
		    			parentNode = parentNodeList.item(0);
		    			childNodeList = parentNode.getChildNodes();
		    			childNodeLength = childNodeList.getLength();
		    			
		    			for(ctr = 0; ctr < childNodeLength; ctr++)
		    			{
		    				childNode =  childNodeList.item(ctr);
		    				childNodeName = childNode.getNodeName();
		    				if("gst_type".equalsIgnoreCase(childNodeName))
		    				{
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();//System.out.println("childNodeName:::"+childNodeName+"childNode["+childNode+"]"+"gst_type["+gst_type+"]");
		    					if(gst_type == null || gst_type.trim().length() == 0)
		    					{
		    						errCode = "NULLDOCTYP";
		    						errList.add(errCode);
		    						errFields.add(childNodeName.toLowerCase());
		    					}
		    					else
		    					{
		    						gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    						sql = "select count(*) as cnt from gencodes where fld_name='GST_TYPE' and fld_value=?";
		    						pstmt = conn.prepareStatement(sql);
		    						pstmt.setString(1,gst_type);
		    						rs = pstmt.executeQuery();
		    						if(rs.next())
		    						{
		    							cnt = rs.getInt("cnt");
		    						}
		    						if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									} 
		    						if(cnt==0)
		    						{
		    							errCode = "INVDOCUMEN";
		    							errList.add(errCode);
		    							errFields.add(childNodeName.toLowerCase());	
		    						}
		    					}	
		    				}//end of if block for gst_type
		    			    
		    			    else if("doc_type".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	doc_type = gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom)).trim();
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    					System.out.println("INPUT VALUE"+"Document Type is ["+doc_type+"]"+"gst_type["+gst_type+"]");
		    			    }//end of if block for doc_type
		    			    	    		    			    		    			   
		    			    else if("gst_code_state".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom)).trim();
		    			    	doc_type = gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom)).trim();
		    			    	System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"gst_code_state["+state_code+"]");
		    			    }//end of if block for gst_code_state
		    			    
		    			    else if("doc_date".equalsIgnoreCase(childNodeName))
		    			    {
		    			    	gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom)).trim();
		    			    	doc_date = gstUtility.checkNull(genericUtility.getColumnValue("doc_date", dom)).trim();
		    			    	System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"doc_date["+doc_date+"]");
		    			    }//end of if block for doc_date		    			    		    			  
		    			}//end of for loop  
		    			
		    			
		    			// **************************** Validation for DOC_TYPE [start] ***************************************
		    			if("E".equalsIgnoreCase(gst_type))
						{
							if(doc_type == null || doc_type.trim().length() == 0)
		    				{
								errCode = "NULDOCTYPE";
								errList.add(errCode);
								errFields.add("doc_type");
		    				}
						}
		    			// *************************** Validation for DOC_TYPE [end] ****************************************		    			
		    			
		    			// **************************** Validation for Place of  Supply [start] ******************************
		    			if("D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type) || "I".equalsIgnoreCase(gst_type)
		    			|| "N".equalsIgnoreCase(gst_type))		    			
		    			{	
		    				if(state_code == null || state_code.trim().length() == 0)
		    				{
		    					errCode = "NULLPLSUPP";
		    					errList.add(errCode);
		    					errFields.add("state_code");
		    				}	
		    			}
		    			// *************************** Validation for Place of  Supply [end] *********************************
		    			
		    			// ************************** Validation for Document Date [start] ***********************************
		    			if("D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type) || "I".equalsIgnoreCase(gst_type)
		    		    || "E".equalsIgnoreCase(gst_type) || "N".equalsIgnoreCase(gst_type) || "L".equalsIgnoreCase(gst_type))
		    			{
		    			   	if(doc_date == null || doc_date.trim().length() == 0)
		    				{
		    					errCode = "INVDOCDATE";
		    					errList.add(errCode);
		    					errFields.add("doc_date");
		    				}
		 		  		}
		    			// ************************** Validation for Document Date [end] *************************************				    			
		    		}//end of case1	    	
		    		break;
		    		
		    		case 2:
		    		{
		    			parentNodeList = dom.getElementsByTagName("Detail2");
						parentNode = parentNodeList.item(0);
						childNodeList = parentNode.getChildNodes();
						childNodeLength = childNodeList.getLength();
								    				    			
		    			for(int ctr1=0;ctr1<childNodeLength;ctr1++)
		    			{
		    				childNode =  childNodeList.item(ctr1);
		    				childNodeName = childNode.getNodeName();
		    				System.out.println("childNodeNameForDetail2:::"+childNodeName+"childNode["+childNode+"]");
		    				
		    				if("taxable_amt".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					taxable_amt = gstUtility.checkNull(genericUtility.getColumnValue("taxable_amt", dom)).trim();
		    			    	//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"taxable_amt["+taxable_amt+"]");	
		    				}//end of if block for taxable_amt		    				
		    						    				
		    				else if("igst_amt".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1)).trim();
		    					loginSiteCode = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
		    					igst_amt = gstUtility.checkNull(genericUtility.getColumnValue("igst_amt", dom)).trim();
		    			    	//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"state_code["+state_code+"]"+"loginSiteCode["+loginSiteCode+"]"+"igst_amt["+igst_amt+"]"+"igst_amtVal["+igst_amtVal+"]");
		    				}//end of if block for igst_amt
		    				
		    				else if("cgst_amt".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1)).trim();
		    					cgst_amt = gstUtility.checkNull(genericUtility.getColumnValue("cgst_amt", dom)).trim();
		    					loginSiteCode = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
		    					//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"state_code["+state_code+"]"+"cgst_amt["+cgst_amt+"]"+"loginSiteCode["+loginSiteCode+"]"+"cgst_amtVal["+cgst_amtVal+"]");
		    				}//end of if block for cgst_amt
		    				
		    				else if("sgst_amt".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1)).trim();
		    					sgst_amt = gstUtility.checkNull(genericUtility.getColumnValue("sgst_amt", dom)).trim();
		    					loginSiteCode = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
		    					//System.out.println("INPUT VALUE"+"gst_type["+gst_type+"]"+"state_code["+state_code+"]"+"sgst_amt["+sgst_amt+"]"+"loginSiteCode["+loginSiteCode+"]"+"sgst_amtVal["+sgst_amtVal+"]");
		    				}//end of if block for sgst_amt
		    						
		    				else if("supply_type".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					supply_type = gstUtility.checkNull(genericUtility.getColumnValue("supply_type", dom)).trim();
		    					state_code = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1)).trim();
		    					loginSiteCode = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
		    					System.out.println("gst_type["+gst_type+"]"+"supply_type["+supply_type+"]"+"state_code["+state_code+"]"+"loginSiteCode["+loginSiteCode+"]");
		    				}//end of if block for itc_type
		    				
		    				else if("itc_type".equalsIgnoreCase(childNodeName))
		    				{
		    					gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1)).trim();
		    					itc_type = gstUtility.checkNull(genericUtility.getColumnValue("itc_type", dom)).trim();
		    					doc_type = gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom1)).trim();
		    					System.out.println("gst_type["+gst_type+"]"+"itc_type["+itc_type+"]"+"doc_type["+doc_type+"]");
		    				}//end of if block for itc_type		    				
		    			}//end of for loop
		    			 // Removed validation for gst_type N and E by sarita on 14AUG2017[START]
		    			 // ******************************* Validation for supply_type [START]*************************************
		    			/*    if("N".equalsIgnoreCase(gst_type))
		    			    {
		    			    	if(supply_type.equalsIgnoreCase("NA"))
		    			    	{
		    			    		errCode = "INVSUPPTYP";
			    					errList.add(errCode);
			    					errFields.add("supply_type");
		    			    	}
		    			    	else if(!supply_type.equalsIgnoreCase("NA") && (supply_type.equalsIgnoreCase("GI") || supply_type.equalsIgnoreCase("NI")))
		    			    	{
		    			    		System.out.println("state_code in 1::::["+state_code+"]");
		    			    		if(!(state_code.equalsIgnoreCase(loginSiteCode)))
		    			    		{
			    			    		errCode = "INVINTESUP";
				    					errList.add(errCode);
				    					errFields.add("supply_type");
		    			    		}
		    			    	}
		    			    	else if(!supply_type.equalsIgnoreCase("NA") && (supply_type.equalsIgnoreCase("GT") || supply_type.equalsIgnoreCase("NT")))
		    			    	{
		    			    		System.out.println("state_code in 2::::["+state_code+"]");
		    			    		if((state_code.equalsIgnoreCase(loginSiteCode)))
		    			    		{
			    			    		errCode = "INVINTRSUP";
				    					errList.add(errCode);
				    					errFields.add("supply_type");
		    			    		}
		    			    	}    			    	
		    			    }*/
		    			 // ******************************* Validation for supply_type [END]***************************************
		    			 
		    			// ******************************* Validation for itc_type [START]**************************************
		    			  /*  if("E".equalsIgnoreCase(gst_type) && !("R".equalsIgnoreCase(doc_type.trim())))
		    			    {
		    			    	if(itc_type.equalsIgnoreCase("NA"))
		    			    	{
		    			    		errCode = "INVITCTYPE";
			    					errList.add(errCode);
			    					errFields.add("itc_type");
		    			    	}
		    			    }  */
		    			 // ******************************* Validation for itc_type [END]****************************************
		    			// Removed validation for gst_type N and E by sarita on 14AUG2017[END]
		    		}//end of case2	
		    		break;
		    	}//end of switch statement
		        	
		        int errListSize = errList.size();
		        System.out.println("errListSize::::::::::"+errListSize);
		        int count = 0;
		        String errFldName = null;
		        if (errList != null && errListSize > 0)
		        {
		        	for (count = 0; count < errListSize; count++)
		        	{
		        		errCode = errList.get(count);
		        		errFldName = errFields.get(count);
		        		System.out.println(" testing :errCode .:" + errCode+"errString>>>>>>>>>"+errString);
		        		errString = getErrorString(errFldName, errCode, userId);
		        		errorType = errorType(conn, errCode);
		        		if (errString.length() > 0)
		        		{
		        			String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
		        			bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
		        			errStringXml.append(bifurErrString);
		        			errString = "";
		        		}
		        		if (errorType.equalsIgnoreCase("E"))
		        		{
		        			break;
		        		}
		        	}
		        	errList.clear();
		        	errList = null;
		        	errFields.clear();
		        	errFields = null;
		        	errStringXml.append("</Errors> </Root> \r\n");
		        }//end of if for errList 
		        else
		        {
		        	errStringXml = new StringBuffer("");
		        }
		    }//end of if for objContext
		}//end of try block
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
						conn.close();
				}
					conn = null;
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		System.out.println("testing : final errString : " + errString);
		return errString;
	}//end of wfValData method....
	
	private String errorType(Connection conn, String errorCode) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			}
		} 
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
	
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn,String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom=null;
		Document domhr=null;
		Document domAll=null;
		String retString="";
		try
		{
			System.out.println("**************  Inside itemChanged method ****************");
			if(xmlString != null && xmlString.trim().length()>0)
	   		{
				dom = genericUtility.parseString(xmlString);		
	   		}
			if(xmlString1 != null && xmlString1.trim().length()>0)
	   		{
				domhr = genericUtility.parseString(xmlString1);		
	   		}
			if(xmlString2 != null && xmlString2.trim().length()>0)
	   		{
				domAll = genericUtility.parseString(xmlString2);		
	   		}
			retString = itemChanged(dom,domhr,domAll,objContext,currentColumn,editFlag,xtraParams);	//System.out.println("retString::::::::::"+retString);
		}
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 	
		}
		return retString;
	}
	
	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag,String xtraParams) throws RemoteException, ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		SimpleDateFormat sdf;
		String loginSite = "",objName="",rec_type="",recDescr="",sql="",doc_type="";
		String gst_type="",gst_codeVal="",gstDescr="", code="",mnth="",year="",finalCode="",docDate="";
		String gstTypeEdit="",docTypeEdit="",docDateEdit="",gstCodeEdit="";
		String taxableAmtEdit="",igst_amtEdit="",cgst_amtEdit="",sgst_amtEdit="",cess_amtEdit="",supply_typeEdit="",itc_typeEdit="";
		int currentFormNo=0,ctr = 0;
		NodeList parentNodeList,parentNodeList1 = null;
		Node parentNode = null;
		Node childNode = null;
		NodeList childNodeList = null;
		int childNodeLength = 0;
		String childNodeName = "";
		String columnValue="";
		int childNodeListLength = 0,cnt=0;
		NodeList parentList = null;
		Timestamp doc_date=null;
		try
		{
			conn = getConnection();
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("[Gstr3b] [itemChanged] :currentFormNo ....." +currentFormNo);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			
			System.out.println("Value of dom::["+dom+"]"+"dom1::["+dom1+"]"+"dom2::["+dom2+"]"+"objContext::["+objContext+"]"+"editFlag::["+editFlag+"]"+"xtraParams::["+xtraParams+"]");
			
			switch(currentFormNo)
			{
				case 1:
				{
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentList = dom.getElementsByTagName( "Detail" + currentFormNo );
	    			objName = getObjNameFromDom( dom, "objName", "1" );
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					valueXmlString.append("<Detail1>");
					childNodeListLength = childNodeList.getLength();
					System.out.println("currentColumn-------->>[" + currentColumn + "]"+"objName["+objName+"]");
					
					if("itm_default".equalsIgnoreCase(currentColumn.trim()))
					{
						loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
						valueXmlString.append("<site_code>").append("<![CDATA["+loginSite+"]]>").append("</site_code>");
						valueXmlString.append("<tran_date>").append("<![CDATA[" + sdf.format(new Date())+ "]]>").append("</tran_date>");
						
						if("gstr3b".equalsIgnoreCase(objName.trim()))
						{
							sql = "select fld_value,descr from gencodes where fld_name='REC_TYPE' and mod_name='W_GSTR3B'";
							pstmt = conn.prepareStatement(sql);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								rec_type = rs.getString("fld_value");
								recDescr = rs.getString("descr");
								if(rec_type.equalsIgnoreCase("6") && recDescr.equalsIgnoreCase("GSTR3B"))
								{
									System.out.println("Return Value"+"rec_type::["+rec_type+"]"+"recDescr::["+recDescr+"]");
									valueXmlString.append("<rec_type>").append("<![CDATA["+rec_type+"]]>").append("</rec_type>");
									valueXmlString.append("<rec_type_descr>").append("<![CDATA["+recDescr+"]]>").append("</rec_type_descr>");
								}
							}
							if(pstmt != null)
							{
							    pstmt.close(); 
							    pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
							    rs = null;
							}
						}//end of if block for obj_name='gstr3b'	
						gst_codeVal = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
						
						valueXmlString.append("<doc_type protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						valueXmlString.append("<gst_code_state protect = \"0\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
						valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");
					}
					else if("itm_defaultedit".equalsIgnoreCase(currentColumn.trim()))
					{
						gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom));
						System.out.println("Return Value"+"gst_type ::::::::::"+gst_type);			
						sql = "select descr from gencodes where fld_name='GST_TYPE' and mod_name='W_GSTR3B' and fld_value=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,gst_type);
						rs = pstmt.executeQuery();	
						if(rs.next())
						{
							gstDescr = rs.getString("descr");
							System.out.println("gstDescr["+gstDescr+"]");	
						}
						if(pstmt != null)
						{
							pstmt.close(); 
							pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						valueXmlString.append("<gst_type_descr>").append("<![CDATA["+gstDescr+"]]>").append("</gst_type_descr>");
					
						gstTypeEdit = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom));
						docTypeEdit=   gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom));
						docDateEdit =  gstUtility.checkNull(genericUtility.getColumnValue("doc_date", dom));
						gstCodeEdit = gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom));
						System.out.println("gstTypeEdit::["+gstTypeEdit+"]"+"docTypeEdit::["+docTypeEdit+"]"+"docDateEdit::["+docDateEdit+"]"+"gstCodeEdit::["+gstCodeEdit+"]");
                        System.out.println("Value of dom2:::::"+dom2.getElementsByTagName("Detail2").getLength());
						                        
						if(dom2.getElementsByTagName("Detail2") != null && dom2.getElementsByTagName("Detail2").getLength() > 0)
						{
							System.out.println("in detail 1");
							valueXmlString.append("<gst_type protect = \"1\"  visible = \"1\">").append("<![CDATA["+gstTypeEdit+"]]>").append("</gst_type>");
							valueXmlString.append("<doc_type protect = \"1\"  visible = \"1\">").append("<![CDATA["+docTypeEdit+"]]>").append("</doc_type>");
							valueXmlString.append("<gst_code_state protect = \"1\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code_state>");
						}						
						if("O".equalsIgnoreCase(gst_type))
						{							
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");
							valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}			
						else if("D".equalsIgnoreCase(gst_type))
						{
							//valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code_state>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}
						else if("C".equalsIgnoreCase(gst_type))
						{
							//valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gst_codeVal+"]]>").append("</gst_code_state>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}
						else if("I".equalsIgnoreCase(gst_type))
						{
							//valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code_state>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}
						else if("E".equalsIgnoreCase(gst_type))
						{
							//changed by sarita on 14AUGUST2017
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA["+docTypeEdit+"]]>").append("</doc_type>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");
							valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
						}
						else if("N".equalsIgnoreCase(gst_type))
						{
							//changes by sarita on 14AUG 2017
							valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA["+gstCodeEdit+"]]>").append("</gst_code_state>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}
						else if("L".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA["+docDateEdit+"]]>").append("</doc_date>");
							valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}						
					}
					else if("gst_type".equalsIgnoreCase(currentColumn.trim()))
					{
						gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom));
						gst_codeVal = gstUtility.checkNull(getStateFromLoginSite(loginSite,conn));
						System.out.println("Input Value::"+"gst_type:::["+gst_type+"]");
						sql = "select descr from gencodes where fld_name='GST_TYPE' and mod_name='W_GSTR' and fld_value=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,gst_type);
						rs = pstmt.executeQuery();	
						if(rs.next())
						{
							gstDescr = rs.getString("descr");
							System.out.println("descr>>"+gstDescr);	
						}
						if(pstmt != null)
						{
							pstmt.close(); 
							pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						valueXmlString.append("<gst_type_descr>").append("<![CDATA["+gstDescr+"]]>").append("</gst_type_descr>");
						
						if("O".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");
							valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}						
						else if("D".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gst_codeVal+"]]>").append("</gst_code_state>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}
						else if("C".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gst_codeVal+"]]>").append("</gst_code_state>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}
						else if("I".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<gst_code_state protect = \"0\" visible = \"1\">").append("<![CDATA["+gst_codeVal+"]]>").append("</gst_code_state>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}
						else if("E".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");
							valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
						}
						else if("N".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA["+gst_codeVal+"]]>").append("</gst_code_state>");
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}
						else if("L".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<doc_date protect = \"0\" visible = \"1\">").append("<![CDATA[]]>").append("</doc_date>");
							valueXmlString.append("<gst_code_state protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</gst_code_state>");
							valueXmlString.append("<doc_type protect = \"1\" visible = \"0\">").append("<![CDATA[]]>").append("</doc_type>");
						}
					}
					else if("doc_date".equalsIgnoreCase(currentColumn.trim()))	
					{
						docDate = gstUtility.checkNull(genericUtility.getColumnValue("doc_date", dom));
						doc_date = Timestamp.valueOf(genericUtility.getValidDateString(docDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
						System.out.println("docDate:::::::::"+docDate+"doc_date>>>>>>>>>"+doc_date);		
						sql = "select code from period where ? between fr_date and to_date";
						pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1,doc_date);
						rs = pstmt.executeQuery();	
						if(rs.next())
						{
							code = rs.getString("code");
							System.out.println("code////"+code);
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}	
						year = code.substring(0,4);
						mnth = code.substring(4,6);
						finalCode = mnth+year;
						System.out.println("Return Value::"+"Month["+mnth+"]"+"Year["+year+"]"+"Final Code["+finalCode+"]");
						valueXmlString.append("<prd_code>").append("<![CDATA["+finalCode+"]]>").append("</prd_code>");				
					}//end of if block for doc_date 
					valueXmlString.append("</Detail1>");
					break;
				}//end of case1 for itemchange	
				
				case 2:
				{
					parentNodeList = dom.getElementsByTagName("Detail2");
					objName = getObjNameFromDom( dom, "objName", "1" );
					System.out.println("Inside Itemchange OBJ Name="+objName);
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					
					childNodeListLength = childNodeList.getLength();
					System.out.println("childNodeName-------->>[" + childNodeName + "]"+"currentColumn-------->>[" + currentColumn + "]");
					
					if("itm_default".equalsIgnoreCase(currentColumn.trim()))
					{
						valueXmlString.append("<Detail2>");
						gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1));
						doc_type = gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom1)).trim();
						System.out.println("gst_type::["+gst_type+"]"+"doc_type::["+doc_type+"]");
						
						if("D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type) || "I".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<taxable_amt protect = \"0\">").append("<![CDATA[0]]>").append("</taxable_amt>");
							valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA[0]]>").append("</igst_amt>");
							valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA[]]>").append("</cgst_amt>");
							valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA[]]>").append("</sgst_amt>");
							valueXmlString.append("<cess_amt protect = \"1\">").append("<![CDATA[]]>").append("</cess_amt>");
							valueXmlString.append("<supply_type protect = \"1\">").append("<![CDATA[NA]]>").append("</supply_type>");
							valueXmlString.append("<itc_type protect = \"1\">").append("<![CDATA[NA]]>").append("</itc_type>");
						}
						else if("E".equalsIgnoreCase(gst_type) && !("R".equalsIgnoreCase(doc_type)))
						{
							valueXmlString.append("<taxable_amt protect = \"1\">").append("<![CDATA[]]>").append("</taxable_amt>");
							valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA[0]]>").append("</igst_amt>");
							valueXmlString.append("<cgst_amt protect = \"0\">").append("<![CDATA[0]]>").append("</cgst_amt>");
							valueXmlString.append("<sgst_amt protect = \"0\">").append("<![CDATA[0]]>").append("</sgst_amt>");
							valueXmlString.append("<cess_amt protect = \"0\">").append("<![CDATA[0]]>").append("</cess_amt>");
							valueXmlString.append("<supply_type protect = \"1\">").append("<![CDATA[NA]]>").append("</supply_type>");
							valueXmlString.append("<itc_type protect = \"0\">").append("<![CDATA[NA]]>").append("</itc_type>");
						}
						else if("E".equalsIgnoreCase(gst_type) && "R".equalsIgnoreCase(doc_type))
						{
							valueXmlString.append("<taxable_amt protect = \"1\">").append("<![CDATA[]]>").append("</taxable_amt>");
							valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA[0]]>").append("</igst_amt>");
							valueXmlString.append("<cgst_amt protect = \"0\">").append("<![CDATA[0]]>").append("</cgst_amt>");
							valueXmlString.append("<sgst_amt protect = \"0\">").append("<![CDATA[0]]>").append("</sgst_amt>");
							valueXmlString.append("<cess_amt protect = \"0\">").append("<![CDATA[0]]>").append("</cess_amt>");
							valueXmlString.append("<supply_type protect = \"1\">").append("<![CDATA[NA]]>").append("</supply_type>");
							valueXmlString.append("<itc_type protect = \"1\">").append("<![CDATA[NA]]>").append("</itc_type>");
						}
						else if("N".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<taxable_amt protect = \"0\">").append("<![CDATA[0]]>").append("</taxable_amt>");
							valueXmlString.append("<igst_amt protect = \"1\">").append("<![CDATA[]]>").append("</igst_amt>");
							valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA[]]>").append("</cgst_amt>");
							valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA[]]>").append("</sgst_amt>");
							valueXmlString.append("<cess_amt protect = \"1\">").append("<![CDATA[]]>").append("</cess_amt>");
							valueXmlString.append("<supply_type protect = \"0\">").append("<![CDATA[NA]]>").append("</supply_type>");
							valueXmlString.append("<itc_type protect = \"1\">").append("<![CDATA[NA]]>").append("</itc_type>");
						}
						else if("L".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<taxable_amt protect = \"1\">").append("<![CDATA[]]>").append("</taxable_amt>");
							valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA[0]]>").append("</igst_amt>");
							valueXmlString.append("<cgst_amt protect = \"0\">").append("<![CDATA[0]]>").append("</cgst_amt>");
							valueXmlString.append("<sgst_amt protect = \"0\">").append("<![CDATA[0]]>").append("</sgst_amt>");
							valueXmlString.append("<cess_amt protect = \"0\">").append("<![CDATA[0]]>").append("</cess_amt>");
							valueXmlString.append("<supply_type protect = \"1\">").append("<![CDATA[NA]]>").append("</supply_type>");
							valueXmlString.append("<itc_type protect = \"1\">").append("<![CDATA[NA]]>").append("</itc_type>");
						}
						
						valueXmlString.append("</Detail2>");
						valueXmlString.append("<Detail1>");
						valueXmlString.append("<gst_type protect = \"1\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1))+"]]>").append("</gst_type>");
						valueXmlString.append("<doc_type protect = \"1\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom1))+"]]>").append("</doc_type>");
						valueXmlString.append("<gst_code_state protect = \"1\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1))+"]]>").append("</gst_code_state>");
                		valueXmlString.append("</Detail1>");
						
					}
					else if("itm_defaultedit".equalsIgnoreCase(currentColumn.trim()))
					{
						
						gst_type = gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1));
						doc_type = gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom1)).trim();
						System.out.println("gst_type_EDIT::["+gst_type+"]"+"doc_type_EDIT::["+doc_type+"]");
						
						taxableAmtEdit = gstUtility.checkNull(genericUtility.getColumnValue("taxable_amt", dom));
						igst_amtEdit = gstUtility.checkNull(genericUtility.getColumnValue("igst_amt", dom));
						cgst_amtEdit = gstUtility.checkNull(genericUtility.getColumnValue("cgst_amt", dom));
						sgst_amtEdit = gstUtility.checkNull(genericUtility.getColumnValue("sgst_amt", dom));
						cess_amtEdit = gstUtility.checkNull(genericUtility.getColumnValue("cess_amt", dom));
						supply_typeEdit = gstUtility.checkNull(genericUtility.getColumnValue("supply_type", dom));
						itc_typeEdit = gstUtility.checkNull(genericUtility.getColumnValue("itc_type", dom));
						System.out.println("taxableAmtEdit::["+taxableAmtEdit+"]"+"igst_amtEdit::["+igst_amtEdit+"]"+"cgst_amtEdit::["+cgst_amtEdit+"]"+"sgst_amtEdit::["+sgst_amtEdit+"]"+"supply_typeEdit::["+supply_typeEdit+"]"+"itc_typeEdit::["+itc_typeEdit+"]"+"cess_amtEdit::["+cess_amtEdit+"]");
						valueXmlString.append("<Detail2>");
						
						if("D".equalsIgnoreCase(gst_type) || "C".equalsIgnoreCase(gst_type) || "I".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<taxable_amt protect = \"0\">").append("<![CDATA["+taxableAmtEdit+"]]>").append("</taxable_amt>");
							valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA["+igst_amtEdit+"]]>").append("</igst_amt>");
							valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA[]]>").append("</cgst_amt>");
							valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA[]]>").append("</sgst_amt>");
							valueXmlString.append("<cess_amt protect = \"1\">").append("<![CDATA[]]>").append("</cess_amt>");
							valueXmlString.append("<supply_type protect = \"1\">").append("<![CDATA[NA]]>").append("</supply_type>");
							valueXmlString.append("<itc_type protect = \"1\">").append("<![CDATA[NA]]>").append("</itc_type>");
						}
						else if("E".equalsIgnoreCase(gst_type) && !("R".equalsIgnoreCase(doc_type)))
						{
							valueXmlString.append("<taxable_amt protect = \"1\">").append("<![CDATA[]]>").append("</taxable_amt>");
							valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA["+igst_amtEdit+"]]>").append("</igst_amt>");
							valueXmlString.append("<cgst_amt protect = \"0\">").append("<![CDATA["+cgst_amtEdit+"]]>").append("</cgst_amt>");
							valueXmlString.append("<sgst_amt protect = \"0\">").append("<![CDATA["+sgst_amtEdit+"]]>").append("</sgst_amt>");
							valueXmlString.append("<cess_amt protect = \"0\">").append("<![CDATA["+cess_amtEdit+"]]>").append("</cess_amt>");
							valueXmlString.append("<supply_type protect = \"1\">").append("<![CDATA[NA]]>").append("</supply_type>");
							valueXmlString.append("<itc_type protect = \"0\">").append("<![CDATA["+itc_typeEdit+"]]>").append("</itc_type>");
						}
						else if("E".equalsIgnoreCase(gst_type) && "R".equalsIgnoreCase(doc_type))
						{
							valueXmlString.append("<taxable_amt protect = \"1\">").append("<![CDATA[]]>").append("</taxable_amt>");
							valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA["+igst_amtEdit+"]]>").append("</igst_amt>");
							valueXmlString.append("<cgst_amt protect = \"0\">").append("<![CDATA["+cgst_amtEdit+"]]>").append("</cgst_amt>");
							valueXmlString.append("<sgst_amt protect = \"0\">").append("<![CDATA["+sgst_amtEdit+"]]>").append("</sgst_amt>");
							valueXmlString.append("<cess_amt protect = \"0\">").append("<![CDATA["+cess_amtEdit+"]]>").append("</cess_amt>");
							valueXmlString.append("<supply_type protect = \"1\">").append("<![CDATA[NA]]>").append("</supply_type>");
							valueXmlString.append("<itc_type protect = \"1\">").append("<![CDATA[NA]]>").append("</itc_type>");
						}
						else if("N".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<taxable_amt protect = \"0\">").append("<![CDATA["+taxableAmtEdit+"]]>").append("</taxable_amt>");
							valueXmlString.append("<igst_amt protect = \"1\">").append("<![CDATA[]]>").append("</igst_amt>");
							valueXmlString.append("<cgst_amt protect = \"1\">").append("<![CDATA[]]>").append("</cgst_amt>");
							valueXmlString.append("<sgst_amt protect = \"1\">").append("<![CDATA[]]>").append("</sgst_amt>");
							valueXmlString.append("<cess_amt protect = \"1\">").append("<![CDATA[]]>").append("</cess_amt>");
							valueXmlString.append("<supply_type protect = \"0\">").append("<![CDATA["+supply_typeEdit+"]]>").append("</supply_type>");
							valueXmlString.append("<itc_type protect = \"1\">").append("<![CDATA[NA]]>").append("</itc_type>");
						}
						else if("L".equalsIgnoreCase(gst_type))
						{
							valueXmlString.append("<taxable_amt protect = \"1\">").append("<![CDATA[]]>").append("</taxable_amt>");
							valueXmlString.append("<igst_amt protect = \"0\">").append("<![CDATA["+igst_amtEdit+"]]>").append("</igst_amt>");
							valueXmlString.append("<cgst_amt protect = \"0\">").append("<![CDATA["+cgst_amtEdit+"]]>").append("</cgst_amt>");
							valueXmlString.append("<sgst_amt protect = \"0\">").append("<![CDATA["+sgst_amtEdit+"]]>").append("</sgst_amt>");
							valueXmlString.append("<cess_amt protect = \"0\">").append("<![CDATA["+cess_amtEdit+"]]>").append("</cess_amt>");
							valueXmlString.append("<supply_type protect = \"1\">").append("<![CDATA[NA]]>").append("</supply_type>");
							valueXmlString.append("<itc_type protect = \"1\">").append("<![CDATA[NA]]>").append("</itc_type>");
						}					
						 valueXmlString.append("</Detail2>");
						 
                         System.out.println("dom2.getElementsByTagName(DEATILS)"+dom2.getElementsByTagName("Detail2"));
						 System.out.println("Detail2 length::["+dom2.getElementsByTagName("Detail2").getLength()+"]");
						 int cnt1 = gstUtility.getNumOfNonDelDetail(dom2,currentFormNo);
						 System.out.println("Detail2 none deleted cnter"+cnt1);
						 if(cnt1 == 0)
						 {
							 System.out.println("in detail 1");
							 valueXmlString.append("<Detail1>");
							 valueXmlString.append("<gst_type protect = \"0\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("gst_type", dom1))+"]]>").append("</gst_type>");
							 valueXmlString.append("<doc_type protect = \"0\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("doc_type", dom1))+"]]>").append("</doc_type>");
							 valueXmlString.append("<gst_code_state protect = \"0\">").append("<![CDATA["+gstUtility.checkNull(genericUtility.getColumnValue("gst_code_state", dom1))+"]]>").append("</gst_code_state>");
							 valueXmlString.append("</Detail1>");
						 }	 
					System.out.println("valueXmlString in itmdefaultedit:::["+valueXmlString.toString()+"]");	
					}
					break;
				}
			}//end of switch case for itemchange	
			valueXmlString.append("</Root>");	
		}//end of try block for itemchange
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return valueXmlString.toString();
	}
	
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		System.out.println("Inside getObjNameFromDom method");
		NodeList detailList = null;
		Node currDetail = null,reqDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			System.out.println("detailList>>>"+detailList.getLength());
			System.out.println("detailListLength>>>"+detailListLength);
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				System.out.println("Inside for loop....");
				currDetail = detailList.item(ctr);
				System.out.println("currDetail>>>>>>"+currDetail);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				System.out.println("objName>>>>>>"+objName);
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return objName;
	}
	
	public String getStateFromLoginSite(String loginSite,Connection conn) throws ITMException
	{
		String sql="",state="",gst_code="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			System.out.println("Login Site Code is===="+loginSite);
			sql = "select state_code from site where site_code=?"; 
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSite);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				state = rs.getString("state_code");
			}
			System.out.println("State Code==========================="+state);
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			}
			
			System.out.println("State code is ==================="+state);
			
			sql = "select gst_code from state where state_code=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, state);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				gst_code = rs.getString("gst_code");
			}
			System.out.println("GST CODE is ====================="+gst_code);
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return gst_code;
	}
}
