/*
* PURPOSE : presave InvFreeze
* AUTHOR : Changed By Sumit On 22/09/2011 
*/

package ibase.webitm.ejb.wms;
import java.rmi.RemoteException;
import java.sql.*;
import org.w3c.dom.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;


@javax.ejb.Stateless
public class InvFreezePreSave extends ValidatorEJB implements InvFreezePreSaveLocal, InvFreezePreSaveRemote
{
	public String preSave()throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave( String domString, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		String retString = "";
		PreparedStatement pStmt = null;
		Document dom = null;		
		java.sql.Timestamp effDate = null;		
		boolean isError = false;
		
		try
		{
			conn.setAutoCommit( false );
			
			E12GenericUtility genericUtility = new E12GenericUtility();
			dom = genericUtility.parseString(domString);
			
			System.out.println("--- domString InvFreezePreSave ["+domString+"]");
			String tranId = genericUtility.getColumnValue("tran_id",dom);
			String effDateStr = genericUtility.getColumnValue("eff_date",dom);
			effDateStr = genericUtility.getValidDateString(effDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
			effDate = java.sql.Timestamp.valueOf(effDateStr + " 00:00:00");
			
			System.out.println("--- effDate--> [" + effDate + "]");
			
			String sql="";
			int updateCnt = 0;

			sql = "DELETE FROM INV_FREEZE WHERE EFF_DATE = ? AND TRAN_ID = ?";
			System.out.println("--- Delete if record exist  ["+sql+"]");
			pStmt = conn.prepareStatement( sql );
			pStmt.setTimestamp(1, effDate);
			pStmt.setString(2, tranId);
			updateCnt = pStmt.executeUpdate();
			System.out.println("******** Query Executed  **********");
			System.out.println("[ DespPackPreSave ] Update Count for deleting  :"+updateCnt);

			if(pStmt !=null)
			{
				pStmt.close();
				pStmt = null;
			}
			
			sql = "DELETE FROM INV_FREEZE_DET WHERE TRAN_ID = ? ";
			System.out.println("--- Delete if record exist in table ["+sql+"]");
			pStmt = conn.prepareStatement( sql );
			pStmt.setString( 1, tranId);
			updateCnt = pStmt.executeUpdate();
			System.out.println("******** Query Executed @ **********");
			System.out.println("[ InvFreezePreSave ] Update Count for deleting :"+updateCnt);
			if(pStmt !=null)
			{
				pStmt.close();
				pStmt = null;
			}			
            
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception :InvFreezePreSave : :==>\n"+e.getMessage());
			retString = e.getMessage();
			throw new ITMException(e);
			
		}
		finally
		{
			try
			{
				System.out.println("isError ["+isError+"]");
							
				    if( isError )
					{
						conn.rollback();
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					
					//conn.close();	
			}
			catch(Exception e)
			{
				System.out.println("Exception :InvFreezePreSave : :==>\n"+e.getMessage());
				try
				{
					System.out.println("Before rollback");
					conn.rollback();
				}
			
				catch(SQLException sqle)
				{
                    System.out.println(sqle);
				}
				throw new ITMException(e);
			
			}
		}
		System.out.println("Return string :"+retString);
		return retString;		
	}
}
