package ibase.webitm.ejb.gst;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;

import javax.annotation.PostConstruct;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.HttpRequest;
import com.sun.jmx.snmp.Timestamp;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.gst.APICallData;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.util.gst.AESEncryption;
import ibase.webitm.util.gst.GSPSignature;
import ibase.webitm.util.gst.GSTCommonUtil;
import ibase.webitm.util.gst.PubKeyEncryption;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless
public class GSTDataSubmitWizEJB extends ValidatorEJB implements GSTDataSubmitWizEJBLocal, GSTDataSubmitWizEJBRemote  
{
	private String BASE_API_URL = "";
	private String AUTH_TOKEN_URL = "";
	private String GSTR_RETSTAT_URL = "";
	private String GSTR1_URL = "";
	private String GSTR2_URL = "";
	private String GSTR3B_URL = "";
	private String FILEDET_URL = "";
	private final String APPLICATION_JSON = "application/json";
	private String appKey = "";
	String ipAddress = "";
	private byte[] appKeyInBytes = null;
	private String appKeyEncryptedAndCoded = "";
	private String clientId = "";
	private String clientSecret = "";
	private String fileDownloadDir = "";
	private String saveFilePath = "";
	AESEncryption aesEncryption = null;
	PubKeyEncryption pubKeyEncryption = null;
	GSPSignature gspSignature;
	PrivateKey aspPrivateKey = null;
	
	GSTCommonUtil gstCommonUtil = new GSTCommonUtil();
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	
	@PostConstruct
	public void postConstruct()
	{
		String gstnPublicKeyName = "", gspPrivateKeyName = "";
		Connection conn = null;
		try(java.util.Scanner sc = new java.util.Scanner(new java.net.URL("https://api.ipify.org").openStream(), "UTF-8").useDelimiter("\\A"))
		{
			System.out.println("GSTDataSubmitWizEJB PostConstruct called!");
			conn = getConnection();
			FinCommon finCommon = new FinCommon();
			gstnPublicKeyName = finCommon.getFinparams("999999", "GSTN_PUB_KEY_NAME", conn);
			gspPrivateKeyName = finCommon.getFinparams("999999", "GSP_PRI_KEY_NAME", conn);
			if("NULLFOUND".equalsIgnoreCase(gstnPublicKeyName))
			{
				gstnPublicKeyName = "GSTN_G2B_Prod_Public";
			}
			if("NULLFOUND".equalsIgnoreCase(gspPrivateKeyName))
			{
				gspPrivateKeyName = "GSP_Private_Prod_Key";
			}
			System.out.println("gstnPublicKeyName["+gstnPublicKeyName+"]");
			System.out.println("gspPrivateKeyName["+gspPrivateKeyName+"]");
			InputStream pubKeyInpStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("ibase/webitm/resources/gst/"+gstnPublicKeyName.trim()+".cer");
			clientId = finCommon.getFinparams("999999", "GST_CLIENT_ID", conn);
			clientSecret = finCommon.getFinparams("999999", "GST_CLIENT_SECRET", conn);
			fileDownloadDir = finCommon.getFinparams("999999", "GST_DOWNLOAD_DIR", conn);
			aesEncryption = new AESEncryption();
			pubKeyEncryption = new PubKeyEncryption(pubKeyInpStream);
			ipAddress = sc.next();
			if(ipAddress== null || ipAddress.trim().length() == 0)
			{
				String tomcatHome = CommonConstants.TOMCAT_HOME;
				ipAddress = tomcatHome.substring(tomcatHome.lastIndexOf("/")+1, tomcatHome.lastIndexOf(":"));
			}
			System.out.println("host ipAddress["+ipAddress+"]");
			gspSignature = new GSPSignature();
			String privateKeyPath = "/ibase/webitm/resources/gst/"+gspPrivateKeyName.trim()+".pem";
			aspPrivateKey = gspSignature.loadPrivateKey(Thread.currentThread().getContextClassLoader().getResourceAsStream(privateKeyPath));
			
			File folder = new File(fileDownloadDir);
			
			if(!folder.exists())
			{
				folder.mkdirs();
				System.out.println("GSTN Folder created");
			}
			
			saveFilePath = folder.getAbsolutePath();
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizEJB.postConstruct()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn!= null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizEJB.postConstruct()["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		
	}
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String retString = null;
		
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			retString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :GSTDataSubmitWizEJB :itemChanged(String,String):" + e.getMessage() + ":" );
			e.printStackTrace();
		}
		System.out.println ( "Return String from GSTDataSubmitWizEJB ["+retString+"]" );
		
		return retString;
	}
	
	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		String sql = "", siteCode = "", siteDescr = "", gstinNo = "", userName = "", stateCode = "", stateDescr = "", grossTurnover = "", periodCode = "", currentYearGrossTurnover = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			System.out.println("Inside GSTDataSubmitWizEJB itemchanged");
			conn = getConnection();
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			
			System.out.println("currentColumn["+currentColumn+"] currentFormNo["+currentFormNo+"]" );
			
			sql = "SELECT SERVICE_CODE, SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE METHOD_NAME = 'GST_API_URL'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				switch(rs.getString("SERVICE_CODE"))
				{
					case "base_url" :
					{
						BASE_API_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr_auth_url" :
					{
						AUTH_TOKEN_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr_retstatus_url" :
					{
						GSTR_RETSTAT_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr1_url" :
					{
						GSTR1_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr2_url" :
					{
						GSTR2_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr3b_url" :
					{
						GSTR3B_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr_filedet_url" :
					{
						FILEDET_URL = rs.getString("SERVICE_URI");
					}
					break;
				}
			}
			closeResources(rs, pstmt);
			
			System.out.println("BASE_API_URL["+BASE_API_URL+"]");
			System.out.println("AUTH_TOKEN_URL["+AUTH_TOKEN_URL+"]");
			System.out.println("GSTR_URL["+GSTR_RETSTAT_URL+"]");
			System.out.println("GSTR1_URL["+GSTR1_URL+"]");
			System.out.println("GSTR2_URL["+GSTR2_URL+"]");
			System.out.println("GSTR3B_URL["+GSTR3B_URL+"]");
			System.out.println("FILEDET_URL["+FILEDET_URL+"]");
			
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?><Root><Header><editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag></Header>" );
			
			switch(currentFormNo)
			{
				case 1:
				{
					System.out.println(" -------- Inside itemchange case 1111111 ------------ ");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						appKey = aesEncryption.generateSecureKey();
						appKeyInBytes = aesEncryption.decodeBase64StringTOByte(appKey);
						appKeyEncryptedAndCoded = pubKeyEncryption.encrypt(appKeyInBytes);
						
						sql = " SELECT S.SITE_CODE, S.SH_DESCR, ST.GST_CODE, ST.DESCR, SR.REF_CODE, SR.REG_NO FROM SITE S, SITEREGNO SR, STATE ST"
							+ "	WHERE S.SITE_CODE = SR.SITE_CODE AND S.FIN_ENTITY = SR.FIN_ENTITY AND S.STATE_CODE = ST.STATE_CODE AND SR.REF_CODE IN ('GSTIN_NO','GST_UNAME','GST_GT','GST_CUR_GT')"
							+ " AND SR.SITE_CODE =  ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						
						while(rs.next())
						{
							siteDescr = checkNull(rs.getString("SH_DESCR"));
							if("GSTIN_NO".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
							{
								gstinNo = checkNull(rs.getString("REG_NO"));
							}
							if("GST_UNAME".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
							{
								userName = checkNull(rs.getString("REG_NO"));
							}
							if("GST_GT".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
							{
								grossTurnover =  checkNull(rs.getString("REG_NO"));
							}
							if("GST_CUR_GT".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
							{
								currentYearGrossTurnover =  checkNull(rs.getString("REG_NO"));
							}
							stateCode = checkNull(rs.getString("GST_CODE"));
							stateDescr = checkNull(rs.getString("DESCR"));
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						
						valueXmlString.append("<Detail1 domID='1'>");
						valueXmlString.append("<period_code><![CDATA[]]></period_code>");
						valueXmlString.append("<site_code><![CDATA[").append(siteCode).append( "]]></site_code>");
						valueXmlString.append("<site_descr><![CDATA[").append(siteDescr).append( "]]></site_descr>");
						valueXmlString.append("<gstin><![CDATA[" ).append(gstinNo).append( "]]></gstin>");
						valueXmlString.append("<username><![CDATA[").append(userName).append( "]]></username>");
						valueXmlString.append("<state_code><![CDATA[").append(stateCode).append( "]]></state_code>");
						valueXmlString.append("<state_descr><![CDATA[").append(stateDescr).append( "]]></state_descr>");
						valueXmlString.append("<gross_turnover><![CDATA[").append(grossTurnover).append( "]]></gross_turnover>");
						valueXmlString.append("<cur_gross_turnover><![CDATA[").append(currentYearGrossTurnover).append( "]]></cur_gross_turnover>");
						valueXmlString.append("<otp><![CDATA[]]></otp>");
						valueXmlString.append("<app_key><![CDATA["+appKey+"]]></app_key>");
						valueXmlString.append("</Detail1>" );
					}
					break;
				}
				case 2:
				{
					String otp = "", transactionId = "", authToken = "", sek = "", retXML = "", errorXML = "", errMsg = "", returnType = "", action = "";
					String gspAuthString = "", gspAuthSignature = "";
					long timeStamp = new Timestamp().getDateTime();
					byte[] authSEK = null;
					String loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "", recType = "";
					String signDataXML = "", summaryDataJsonStr = "";
					
					System.out.println(" -------- Inside itemchange case 2222222 ------------ ");
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
						chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
						
						gstinNo = checkNull(e12GenericUtility.getColumnValue("gstin", dom1));
						periodCode = checkNull(e12GenericUtility.getColumnValue("period_code", dom1));
						stateCode = checkNull(e12GenericUtility.getColumnValue("state_code", dom1));
						userName = checkNull(e12GenericUtility.getColumnValue("username", dom1));
						returnType = checkNull(e12GenericUtility.getColumnValue("returns_type", dom1));
						action = checkNull(e12GenericUtility.getColumnValue("action", dom1));
						siteCode = checkNull(e12GenericUtility.getColumnValue("site_code", dom1));
						
						if("GSTR1".equalsIgnoreCase(returnType.trim()))
						{
							recType = "1";
							if("SUBMIT".equalsIgnoreCase(action.trim()))
							{
								retXML += getPendingData(recType, siteCode, periodCode, conn);
							}
							else if("FILE".equalsIgnoreCase(action.trim()))
							{
								signDataXML = getSignConfig(loginCode, returnType, conn);
							}
						}
						else if("GSTR2".equalsIgnoreCase(returnType))
						{
							recType = "2";
							if("SUBMIT".equalsIgnoreCase(action.trim()))
							{
								retXML += getPendingData(recType, siteCode, periodCode, conn);
							}
							else if("FILE".equalsIgnoreCase(action.trim()))
							{
								signDataXML = getSignConfig(loginCode, returnType, conn);
							}
						}
						else if("GSTR3".equalsIgnoreCase(returnType) || "GSTR3B".equalsIgnoreCase(returnType))
						{
							recType = "3";
							if("FILE".equalsIgnoreCase(action.trim()))
							{
								signDataXML = getSignConfig(loginCode, returnType, conn);
							}
						}
						
						transactionId = UUID.randomUUID().toString().replaceAll("-", "");

						gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstinNo;
						gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
						
						otp = checkNull(e12GenericUtility.getColumnValue("otp", dom1));
						
						String encryptedOTP = aesEncryption.encryptEK(otp.getBytes(), appKeyInBytes);
						
						JSONObject authTokenReqObj = new JSONObject();
						authTokenReqObj.put("action", "AUTHTOKEN");
						authTokenReqObj.put("username", userName);
						authTokenReqObj.put("app_key", appKeyEncryptedAndCoded);
						authTokenReqObj.put("otp", encryptedOTP);

				        HttpRequest authTokenReq = Unirest.post(String.format("%s%s", BASE_API_URL, AUTH_TOKEN_URL))
												   .header("Content-Type",APPLICATION_JSON)
												   .header("clientid", clientId)
												   .header("client-secret", clientSecret)
												   .header("state-cd", stateCode)
												   .header("ip-usr", ipAddress)
												   .header("txn", transactionId)
												   .header("app_key", appKeyEncryptedAndCoded)
												   .header("X-Asp-Auth-Token", gspAuthString)
							    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
												   .body(new JsonNode(authTokenReqObj.toString()))
												   .getHttpRequest();
				        
				        System.out.println("authtoken url["+authTokenReq.getUrl()+"]");
				        System.out.println("authtoken method["+authTokenReq.getHttpMethod()+"]");
						System.out.println("authtoken request header["+authTokenReq.getHeaders()+"]");
						System.out.println("authtoken request payload["+IOUtils.toString(authTokenReq.getBody().getEntity().getContent())+"]");
				        
				        HttpResponse<JsonNode> authTokenResp = authTokenReq.asJson();

				        System.out.println(String.format("authTokenResp Request : Status[%s] Response[%s]", authTokenResp.getStatus(), authTokenResp.getBody()));
				        
				        if(authTokenResp.getStatus() == 200) 
				        {
				            JSONObject object = authTokenResp.getBody().getObject();
				            if (object.has("auth_token") && object.has("sek") && object.has("status_cd") && Objects.equals(object.getString("status_cd"), "1")) 
				            {
				            	callStatus = "1";
				                authToken = object.getString("auth_token");
				                sek = object.getString("sek");
				                authSEK = aesEncryption.decrypt(sek, appKeyInBytes);
				                System.out.println("AuthSEK = "+ aesEncryption.encodeBase64String(authSEK));
				                
				            }
				            else
				            {
				            	callStatus = "2";
				            	JSONObject errorJSON = authTokenResp.getBody().getObject().getJSONObject("error");
				            	responseJsonStr = errorJSON.toString();
				            	
				            	if("AUTH4033".equalsIgnoreCase(errorJSON.getString("error_cd")))
				            	{
				            		errorXML = new ITMDBAccessEJB().getErrorString("","VTINVOTP","","",conn);
				            	}
				            	else
				            	{
				            		errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
				            		errorXML = getError(errMsg, "GSTAPIERR", conn);
				            	}
				            }
				        }
				        else if(authTokenResp.getStatus() == 500)
				        {
				        	callStatus = "2";
				        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+authTokenResp.getStatus();
				        	responseJsonStr = errMsg;
				        	errorXML = getError(errMsg, "GSTAPIERR", conn);
				        }
				        else
				        {
				        	callStatus = "2";
				        	JSONObject errorJSON = authTokenResp.getBody().getObject().getJSONObject("error");
				        	responseJsonStr = errorJSON.toString();
				        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
				        	errorXML = getError(errMsg, "GSTAPIERR", conn);
				        }
				        
				        APICallData apiCallData = new APICallData();
				        apiCallData.setPeriodCode(periodCode);
				        apiCallData.setCallDate(new Date());
				        apiCallData.setSiteCode(siteCode);
				        apiCallData.setUserId(loginCode);
				        apiCallData.setCallType("AUTHTOKEN");
				        apiCallData.setRecType(recType);
				        apiCallData.setNoOfRecords(0);
				        apiCallData.setCallStatus(callStatus);
				        apiCallData.setResponseId(responseId);
				        apiCallData.setResponseJsonStr(responseJsonStr);
				        apiCallData.setChgUser(loginCode);
				        apiCallData.setChgDate(new Date());
				        apiCallData.setChgTerm(chgTerm);
				        
				        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
				        
				        if( authToken != null && authToken.trim().length()>0 && authSEK != null)
				        {
				        	if("GSTR1".equalsIgnoreCase(returnType))
				        	{
				        		if("SUBMIT".equalsIgnoreCase(action))
				        		{
				        			summaryDataJsonStr += getGstr1Summary(authToken, stateCode, userName, gstinNo, periodCode, authSEK, appKeyEncryptedAndCoded, xtraParams, conn);
				        			if(summaryDataJsonStr!= null && summaryDataJsonStr.trim().length() > 0 && summaryDataJsonStr.indexOf("Message :") == -1)
				        			{
				        				retXML += "<summary_data>" + XML.toString(new JSONObject(summaryDataJsonStr)) + "</summary_data>";
				        			}
				        			else if(summaryDataJsonStr.indexOf("Message :") >= 0)
				        			{
				        				retXML += summaryDataJsonStr;
				        			}
				        			retXML += downloadGstr1Data(gstinNo, periodCode, authToken, userName, stateCode, appKeyEncryptedAndCoded, xtraParams, authSEK);
				        		}
				        		else if("FILE".equalsIgnoreCase(action))
				        		{
				        			summaryDataJsonStr += getGstr1Summary(authToken, stateCode, userName, gstinNo, periodCode, authSEK, appKeyEncryptedAndCoded, xtraParams, conn);
				        			if(summaryDataJsonStr!= null && summaryDataJsonStr.trim().length() > 0 && summaryDataJsonStr.indexOf("Message :") == -1)
				        			{
				        				retXML += "<summary_data>" + XML.toString(new JSONObject(summaryDataJsonStr)) + "</summary_data>";
				        			}
				        			else if(summaryDataJsonStr.indexOf("Message :") >= 0)
				        			{
				        				retXML += summaryDataJsonStr;
				        			}
				        		}
				        		else if("GETINV".equalsIgnoreCase(action))
				        		{
				        			retXML += downloadGstr1Data(gstinNo, periodCode, authToken, userName, stateCode, appKeyEncryptedAndCoded, xtraParams, authSEK);
				        		}
				        	}
				        	if("GSTR2".equalsIgnoreCase(returnType))
				        	{
				        		if("SUBMIT".equalsIgnoreCase(action))
				        		{
				        			summaryDataJsonStr += getGstr2Summary(authToken, stateCode, userName, gstinNo, periodCode, authSEK, appKeyEncryptedAndCoded, xtraParams, conn);
				        			if(summaryDataJsonStr!= null && summaryDataJsonStr.trim().length() > 0 && summaryDataJsonStr.indexOf("Message :") == -1)
				        			{
				        				retXML += "<summary_data>" + XML.toString(new JSONObject(summaryDataJsonStr)) + "</summary_data>";
				        			}
				        			else if(summaryDataJsonStr.indexOf("Message :") >= 0)
				        			{
				        				retXML += summaryDataJsonStr;
				        			}
				        			retXML += downloadGstr2Data(gstinNo, periodCode, authToken, userName, stateCode, appKeyEncryptedAndCoded, xtraParams, authSEK);
				        		}
				        		else if("FILE".equalsIgnoreCase(action))
				        		{
				        			summaryDataJsonStr += getGstr2Summary(authToken, stateCode, userName, gstinNo, periodCode, authSEK, appKeyEncryptedAndCoded, xtraParams, conn);
				        			if(summaryDataJsonStr!= null && summaryDataJsonStr.trim().length() > 0 && summaryDataJsonStr.indexOf("Message :") == -1)
				        			{
				        				retXML += "<summary_data>" + XML.toString(new JSONObject(summaryDataJsonStr)) + "</summary_data>";
				        			}
				        			else if(summaryDataJsonStr.indexOf("Message :") >= 0)
				        			{
				        				retXML += summaryDataJsonStr;
				        			}
				        		}
				        		else if("GETINV".equalsIgnoreCase(action))
				        		{
				        			retXML += downloadGstr2Data(gstinNo, periodCode, authToken, userName, stateCode, appKeyEncryptedAndCoded, xtraParams, authSEK);
				        		}
				        	}
				        	if("GSTR3B".equalsIgnoreCase(returnType))
				        	{
				        		if("SUBMIT".equalsIgnoreCase(action))
				        		{
				        			summaryDataJsonStr += getGstr3bSummary(authToken, stateCode, userName, gstinNo, periodCode, authSEK, appKeyEncryptedAndCoded, xtraParams, conn);
				        			if(summaryDataJsonStr!= null && summaryDataJsonStr.trim().length() > 0 && summaryDataJsonStr.indexOf("Message :") == -1)
				        			{
				        				retXML += "<summary_data>" + XML.toString(new JSONObject(summaryDataJsonStr)) + "</summary_data>";
				        			}
				        			else if(summaryDataJsonStr.indexOf("Message :") >= 0)
				        			{
				        				retXML += summaryDataJsonStr;
				        			}
				        		}
				        		else if("FILE".equalsIgnoreCase(action))
				        		{
				        			summaryDataJsonStr += getGstr3bSummary(authToken, stateCode, userName, gstinNo, periodCode, authSEK, appKeyEncryptedAndCoded, xtraParams, conn);
				        			if(summaryDataJsonStr!= null && summaryDataJsonStr.trim().length() > 0 && summaryDataJsonStr.indexOf("Message :") == -1)
				        			{
				        				retXML += "<summary_data>" + XML.toString(new JSONObject(summaryDataJsonStr)) + "</summary_data>";
				        			}
				        			else if(summaryDataJsonStr.indexOf("Message :") >= 0)
				        			{
				        				retXML += summaryDataJsonStr;
				        			}
				        		}
				        	}
				        }
				        
				        valueXmlString.append("<Detail2 domID='1'>");
				        valueXmlString.append("<auth_token><![CDATA["+ authToken +"]]></auth_token>");
				        valueXmlString.append("<auth_sek><![CDATA["+ sek +"]]></auth_sek>");
				        valueXmlString.append("<summary_data><![CDATA["+ summaryDataJsonStr +"]]></summary_data>");
				        valueXmlString.append(signDataXML);
				        valueXmlString.append("</Detail2>" );
				        valueXmlString.append("<Detail2 domID='2'>");
				        valueXmlString.append("<period_code><![CDATA["+periodCode+"]]></period_code>");
				        valueXmlString.append(retXML);
				        valueXmlString.append("</Detail2>" );
				        if(errorXML.trim().length() > 0)
				        {
				        	valueXmlString.append(errorXML);
				        }
					}
					break;
				}
			}
			valueXmlString.append( "</Root>" );	
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizEJB.itemChanged()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(!conn.isClosed() && conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizEJB.itemChanged():finally block["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		System.out.println("final return xml string["+valueXmlString.toString()+"]");
		return valueXmlString.toString();
	}
	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		System.out.println("GSTDataSubmitWiz.wfValData()");
		System.out.println("xmlString :"+xmlString);
		System.out.println("xmlString1 :"+xmlString1);
		System.out.println("xmlString2 :"+xmlString2);
		System.out.println("objContext :"+objContext);
		System.out.println("editFlag :"+editFlag);
		System.out.println("xtraParams :"+xtraParams);
		try
		{
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0)
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0)
			{
				dom2 = parseString(xmlString2);
			}
			System.out.println("Before calling function wfvalData****");
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);

			System.out.println("After calling method wfVAlData Error String===="+errString);
		} 
		catch (Exception e)
		{
			System.out.println("Exception : [GSTDataSubmitWiz][wfValData( String, String )] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return errString;
	}
	@Override
	public String wfValData(Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String errString = "", userId = "", loginSiteCode = "";
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		int currentFormNo = 0;
		String sql = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String errorType = "", errCode = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		E12GenericUtility e12GenericUtility = new E12GenericUtility();
		try
		{
			userId = e12GenericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			loginSiteCode = e12GenericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			if (objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
				System.out.println("currentFormNo ["+currentFormNo+"]");
			}
			conn = getConnection();
			
			switch (currentFormNo)
			{
				case 1:
				{
					String returnType = "", action = "", periodCode = "", recType = "";
					NodeList parentList = null, childList = null;
					Node childNode = null;
					String childNodeName = "", columnValue = "";
					int noOfChilds = 0;
					parentList = currFormDataDom.getElementsByTagName( "Detail" + currentFormNo );
					childList = parentList.item( 0 ).getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{	
						childNode = childList.item( ctr );
						childNodeName = childNode.getNodeName();
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
						if("period_code".equalsIgnoreCase(childNodeName))
						{
							sql = "SELECT COUNT(*) AS CNT FROM PERIOD WHERE TO_CHAR(TO_DATE(CODE,'yyyymm'),'mmyyyy') = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, columnValue);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								if(rs.getInt("CNT") == 0)
								{
									errList.add( "VTMONATD10" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
						}
						if("site_code".equalsIgnoreCase(childNodeName))
						{
							sql = "SELECT COUNT(*) AS CNT FROM SITE WHERE SITE_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, columnValue);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								if(rs.getInt("CNT") == 0)
								{
									errList.add( "INVDSITECD" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
						}
					}
					
					returnType = e12GenericUtility.getColumnValue("returns_type", hdrDataDom);
					action = e12GenericUtility.getColumnValue("action", hdrDataDom);
					periodCode = e12GenericUtility.getColumnValue("period_code", hdrDataDom);
					
					System.out.println("returnType["+returnType+"] action["+action+"] periodCode["+periodCode+"]");
					
					if("GSTR1".equalsIgnoreCase(returnType))
					{
						recType = "1";
					}
					else if("GSTR2".equalsIgnoreCase(returnType))
					{
						recType = "2";
					}
					else if("GSTR3".equalsIgnoreCase(returnType) || "GSTR3B".equalsIgnoreCase(returnType))
					{
						recType = "3";
					}
					
					if("SAVE".equalsIgnoreCase(action) && !"GSTR3B".equalsIgnoreCase(returnType))
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'P' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, loginSiteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") == 0)
							{
								errList.add( "VTNOGSDATA" );
								errFields.add("returns_type");
							}
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
					}
					if("SUBMIT".equalsIgnoreCase(action) && !"GSTR3B".equalsIgnoreCase(returnType))
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'S' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, loginSiteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								errList.add( "VTSUBALRDY" );
								errFields.add("returns_type");
							}
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'T' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, loginSiteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") == 0)
							{
								errList.add( "VTNORECSAV" );
								errFields.add("returns_type");
							}
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
					}
					if("FILE".equalsIgnoreCase(action) && !"GSTR3B".equalsIgnoreCase(returnType))
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'S' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, loginSiteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") == 0)
							{
								errList.add( "VTNORECSAV" );
								errFields.add("returns_type");
							}
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'R' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, loginSiteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								errList.add( "VTGSTFILE" );
								errFields.add("returns_type");
							}
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
					}
					if("FILE".equalsIgnoreCase(action))
					{
						sql = "SELECT COUNT(1) AS CNT FROM USER_SIGN_ACC WHERE USER_ID = ? AND DOC_TYPE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, userId);
						pstmt.setString(2, returnType);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") == 0)
							{
								errList.add( "VTNOSIGCON" );
								errFields.add("returns_type");
							}
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
					}
					break;
				}
				case 2:
				{
					
					break;
				}
			}
			int errListSize = errList.size();
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (int i = 0; i < errListSize; i++ )
				{
					errCode = (String)errList.get(i);
					errFldName = (String)errFields.get(i);
					System.out.println("errCode .........."+errCode);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizEJB.wfValData()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	
		return errStringXml.toString();
	}
	
	@Override
	public String handleRequest(HashMap<String, String> reqParamMap, UserInfoBean userInfo) throws ITMException 
	{
		String retResponseXML = "", action = "", dataAction = "", errorCode = "", dataErrMsg = "";
		String sql = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean isDataError = false;
		try
		{
			action = reqParamMap.get("action");
			conn = getConnection();
			
			if("GENERATE_OTP".equalsIgnoreCase(action))
			{
				String userName = "", stateCode = "", gspAuthString = "", gspAuthSignature = "", gstinNo = "", periodCode = "", siteCode = "", recType = "", recordType = "";
				String responseId = "", responseJsonStr = "", callStatus = "";
				String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
				long timeStamp = new Timestamp().getDateTime();
				
				if("NULLFOUND".equalsIgnoreCase(clientId) || "NULLFOUND".equalsIgnoreCase(clientSecret))
				{
					retResponseXML = "<root><message><![CDATA[Client ID/Client secret API configuration is missing.]]></message></root>";
					return retResponseXML;
				}
				
				userName = reqParamMap.get("user_name");
				stateCode = reqParamMap.get("state_code");
				gstinNo = reqParamMap.get("gstin_no");
				periodCode = reqParamMap.get("period_code");
				siteCode = reqParamMap.get("site_code");
				dataAction = reqParamMap.get("data_action");
				recordType = reqParamMap.get("rec_type");
				
				if("GSTR1".equalsIgnoreCase(recordType))
				{
					recType = "1";
				}
				else if("GSTR2".equalsIgnoreCase(recordType))
				{
					recType = "2";
				}
				else if("GSTR3".equalsIgnoreCase(recordType))
				{
					recType = "3";
				}
				else if("GSTR3B".equalsIgnoreCase(recordType))
				{
					recType = "6";
				}
				
				if("SAVE".equalsIgnoreCase(dataAction))
				{
					sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'P' AND PRD_CODE = ? AND SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, recType);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(rs.getInt("CNT") == 0)
						{
							isDataError = true;
							errorCode =  "VTNOGSDATA";
						}
					}
					closeResources(rs, pstmt);

					sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'S' AND PRD_CODE = ? AND SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, recType);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(rs.getInt("CNT") > 0)
						{
							isDataError = true;
							errorCode =  "VTSUBALRDY";
						}
					}
					closeResources(rs, pstmt);
					
					sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'R' AND PRD_CODE = ? AND SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, recType);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(rs.getInt("CNT") > 0)
						{
							isDataError = true;
							errorCode = "VTFILALRDY";
						}
					}
					closeResources(rs, pstmt);
				}
				else if("SUBMIT".equalsIgnoreCase(dataAction))
				{
					sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'S' AND PRD_CODE = ? AND SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, recType);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(rs.getInt("CNT") > 0)
						{
							isDataError = true;
							errorCode =  "VTSUBALRDY";
						}
					}
					closeResources(rs, pstmt);
					
					sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'T' AND PRD_CODE = ? AND SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, recType);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(rs.getInt("CNT") == 0)
						{
							isDataError = true;
							errorCode = "VTNORECSAV";
						}
					}
					closeResources(rs, pstmt);
					
					sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'R' AND PRD_CODE = ? AND SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, recType);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(rs.getInt("CNT") > 0)
						{
							isDataError = true;
							errorCode = "VTFILALRDY";
						}
					}
					closeResources(rs, pstmt);
				}
				else if("FILE".equalsIgnoreCase(dataAction))
				{
					sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'S' AND PRD_CODE = ? AND SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, recType);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(rs.getInt("CNT") == 0)
						{
							isDataError = true;
							errorCode = "VTGSTSUBPN";
						}
					}
					closeResources(rs, pstmt);
					
					sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'R' AND PRD_CODE = ? AND SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, recType);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(rs.getInt("CNT") > 0)
						{
							isDataError = true;
							errorCode = "VTGSTFILE";
						}
					}
					closeResources(rs, pstmt);
				}
				else if("GETINV".equalsIgnoreCase(dataAction) && !"GSTR2A".equalsIgnoreCase(recordType))
				{
					sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS IN ('T','S','R') AND PRD_CODE = ? AND SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, recType);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(rs.getInt("CNT") == 0)
						{
							isDataError = true;
							errorCode = "VTNORECSAV";
						}
					}
					closeResources(rs, pstmt);
				}
				else if("DELETE".equalsIgnoreCase(dataAction))
				{
					int saveRecCnt = 0;
					
					sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'T' AND PRD_CODE = ? AND SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, recType);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						saveRecCnt = rs.getInt("CNT");
						if(saveRecCnt == 0)
						{
							isDataError = true;
							errorCode =  "VTNORECDEL";
						}
					}
					closeResources(rs, pstmt);
					
					if(saveRecCnt == 0)
					{
						int pendRecDnt = 0;
						
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'P' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							pendRecDnt = rs.getInt("CNT");
							if(pendRecDnt == 0)
							{
								isDataError = true;
								errorCode =  "VTNDGSDATA";
							}
							else
							{
								isDataError = true;
								errorCode =  "VTPENGSDAT";
							}
						}
						closeResources(rs, pstmt);
					}
					
					sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'S' AND PRD_CODE = ? AND SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, recType);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(rs.getInt("CNT") > 0)
						{
							isDataError = true;
							errorCode =  "VTSUBALRDY";
						}
					}
					closeResources(rs, pstmt);
					
					sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'R' AND PRD_CODE = ? AND SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, recType);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						if(rs.getInt("CNT") > 0)
						{
							isDataError = true;
							errorCode = "VTFILALRDY";
						}
					}
					closeResources(rs, pstmt);
					
				}
				
				if(!isDataError)
				{
					gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstinNo;
					gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
					
					JSONObject otpRequest = new JSONObject();
			        otpRequest.put("action", "OTPREQUEST");
			        otpRequest.put("app_key", appKeyEncryptedAndCoded);
			        otpRequest.put("username", userName);

			        HttpRequest otpReq = Unirest.post(String.format("%s%s", BASE_API_URL,AUTH_TOKEN_URL))
						        		.header("Content-Type", APPLICATION_JSON)
						                .header("clientid", clientId)
						                .header("client-secret", clientSecret)
						                .header("state-cd", stateCode)
						                .header("ip-usr", ipAddress)
						                .header("username", userName)
						                .header("txn", transactionId)
						                .header("app_key", appKeyEncryptedAndCoded)
						                .header("X-Asp-Auth-Token", gspAuthString)
				    	                .header("X-Asp-Auth-Signature", gspAuthSignature)
						                .body(new JsonNode(otpRequest.toString()))
						                .getHttpRequest();
			        
			        System.out.println("OTP url["+otpReq.getUrl()+"]");
			        System.out.println("OTP method["+otpReq.getHttpMethod()+"]");
					System.out.println("OTP request header["+otpReq.getHeaders()+"]");
					System.out.println("OTP request payload["+IOUtils.toString(otpReq.getBody().getEntity().getContent())+"]");
			        
			        HttpResponse<JsonNode> otpResp =  otpReq.asJson();

			        System.out.println(String.format("OTP Request : Status[%s] Response[%s]", otpResp.getStatus(), otpResp.getBody()));

			        if (otpResp.getStatus() == 200) 
			        {
			            JSONObject object = otpResp.getBody().getObject();
			            if( object.has("status_cd") && "1".equalsIgnoreCase(object.getString("status_cd")))
			            {
			            	callStatus = "1";
			            	retResponseXML = "<root><message><![CDATA["+object.getString("status_cd")+"]]></message></root>";
			            }
			            else
			            {
			            	callStatus = "2";
			            	JSONObject errorJSON = otpResp.getBody().getObject().getJSONObject("error");
			            	responseJsonStr = errorJSON.toString();
			            	retResponseXML = "<root><message><![CDATA[Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd")+"]]></message></root>";
			            }
			        }
			        else if(otpResp.getStatus() == 500)
			        {
			        	callStatus = "2";
			        	String errMsg = "Message : Error occurred at GSTN server \nResponse code : "+otpResp.getStatus();
			        	responseJsonStr = errMsg;
			        	retResponseXML = "<root><message><![CDATA[Message : "+errMsg+" \nError code : "+otpResp.getStatus()+"]]></message></root>";
			        }
			        else
			        {
			        	callStatus = "2";
			        	JSONObject errorJSON = otpResp.getBody().getObject().getJSONObject("error");
			        	responseJsonStr = errorJSON.toString();
			        	retResponseXML = "<root><message><![CDATA[Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd")+"]]></message></root>";
			        }
			        
			        APICallData apiCallData = new APICallData();
			        apiCallData.setPeriodCode(periodCode);
			        apiCallData.setCallDate(new Date());
			        apiCallData.setSiteCode(siteCode);
			        apiCallData.setUserId(userInfo.getLoginCode());
			        apiCallData.setCallType("OTPREQUEST");
			        apiCallData.setRecType(recType);
			        apiCallData.setNoOfRecords(0);
			        apiCallData.setCallStatus(callStatus);
			        apiCallData.setResponseId(responseId);
			        apiCallData.setResponseJsonStr(responseJsonStr);
			        apiCallData.setChgUser(userInfo.getLoginCode());
			        apiCallData.setChgDate(new Date());
			        apiCallData.setChgTerm(userInfo.getRemoteHost());
			        
			        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
				}
				else
				{
					sql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, errorCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						dataErrMsg = rs.getString("MSG_DESCR");
					}
					closeResources(rs, pstmt);
					
					retResponseXML = "<root><message><![CDATA[Message : "+dataErrMsg+"]]></message></root>";
				}
			}
			else if ("ITEM_CHANGE".equalsIgnoreCase(action))
			{
				String currColumn = "", currFieldData = "", siteDescr = "", gstinNo = "", userName = "", stateCode = "", stateDescr = "", grossTurnover = "";
				
				currColumn = reqParamMap.get("focused_column");
				currFieldData = reqParamMap.get("data_value");
				
				System.out.println("custom itemchange logic for ["+currColumn+"] and data["+currFieldData+"]");
				if("SITE_CODE".equalsIgnoreCase(currColumn))
				{
					sql = " SELECT S.SITE_CODE, S.SH_DESCR, ST.GST_CODE, ST.DESCR, SR.REF_CODE, SR.REG_NO FROM SITE S, SITEREGNO SR, STATE ST"
						+ "	WHERE S.SITE_CODE = SR.SITE_CODE AND S.FIN_ENTITY = SR.FIN_ENTITY AND S.STATE_CODE = ST.STATE_CODE AND SR.REF_CODE IN ('GSTIN_NO','GST_UNAME','GST_GT')"
						+ " AND SR.SITE_CODE =  ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, currFieldData);
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						siteDescr = checkNull(rs.getString("SH_DESCR"));
						if("GSTIN_NO".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
						{
							gstinNo = checkNull(rs.getString("REG_NO"));
						}
						if("GST_UNAME".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
						{
							userName = checkNull(rs.getString("REG_NO"));
						}
						if("GST_GT".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
						{
							grossTurnover = checkNull(rs.getString("REG_NO"));
						}
						stateCode = checkNull(rs.getString("GST_CODE"));
						stateDescr = checkNull(rs.getString("DESCR"));
					}
					closeResources(rs, pstmt);
					
					retResponseXML = "<root><Detail1>"
								   + "<site_descr><![CDATA["+siteDescr+"]]></site_descr>"
								   + "<gstin><![CDATA["+gstinNo+"]]></gstin>"
								   + "<username><![CDATA["+userName+"]]></username>"
								   + "<state_code><![CDATA["+stateCode+"]]></state_code>"
								   + "<state_descr><![CDATA["+stateDescr+"]]></state_descr>"
								   + "<gross_turnover><![CDATA["+grossTurnover+"]]></gross_turnover>"
								   + "</Detail1></root>";
					
				}
			}
			else if("GET_GSTR3B_DATA".equalsIgnoreCase(action))
			{
				String gstr3bXMLStr = "", siteCode = "", periodCode = "";
				siteCode = reqParamMap.get("site_code");
				periodCode = reqParamMap.get("period_code");
				
				sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND PRD_CODE = ? AND SITE_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "6");
				pstmt.setString(2, periodCode);
				pstmt.setString(3, siteCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					if(rs.getInt("CNT") == 0)
					{
						isDataError = true;
						errorCode =  "VTNOGSDATA";
					}
				}
				closeResources(rs, pstmt);
				
				if(!isDataError)
				{
					gstr3bXMLStr = getGSTR3BXMLData(siteCode, periodCode, conn);
					String xslFilePath = CommonConstants.APPLICATION_CONTEXT + "webitm" + File.separator + "xsl"+ File.separator + "Standard"+ File.separator + "WIZARD" + File.separator + "Galaxy"+ File.separator + "gstr3bdata_wiz_en_US_A.xsl";
					retResponseXML = e12GenericUtility.transformToString( xslFilePath, gstr3bXMLStr, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
				}
				else
				{
					sql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, errorCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						dataErrMsg = rs.getString("MSG_DESCR");
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					
					retResponseXML = "<root><error_message><![CDATA[Message : "+dataErrMsg+"]]></error_message></root>";
				}
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizEJB.handleRequest()["+e.getMessage()+"]");
			e.printStackTrace();
			retResponseXML = "<root><message><![CDATA[Message :"+e.getMessage()+"]]></message></root>";
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(!conn.isClosed() && conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizEJB.handleRequest():finally block["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		System.out.println("final retResonseXML ["+retResponseXML+"]");
		return retResponseXML;
	}
	private String downloadGstr1Data (String gstinNo, String periodCode, String authToken, String userName, String stateCode, String appKeyEncryptedAndCoded, String xtraParams, byte[] authSek) throws ITMException
	{
		StringBuffer retStringBuff = new StringBuffer();
		String[] gstr1Section = {"B2B","B2CL","B2CS","CDNR","AT","TXP","NIL","EXP","HSNSUM","CDNUR"};
		String gspAuthString = "", gspAuthSignature = "";
		String siteCode = "", loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "", dataXML = "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			for(String action : gstr1Section)
			{
				long timeStamp = new Timestamp().getDateTime();
				System.out.println("calling for ["+action+"]");
				String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
				
				gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstinNo;
				gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
				
				HttpRequest getDataReq = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR1_URL))
				        				 .queryString("action", action)
				        				 .queryString("gstin", gstinNo)
				        				 .queryString("ret_period", periodCode)
				        				 .header("Content-Type", APPLICATION_JSON)
				        				 .header("state-cd", stateCode)
				        				 .header("clientid", clientId)
				        				 .header("client-secret", clientSecret)
				        				 .header("ip-usr", ipAddress)
				        				 .header("username", userName)
				        				 .header("auth-token", authToken)
				        				 .header("app_key", appKeyEncryptedAndCoded)
				        				 .header("txn", transactionId)
				        				 .header("ret_period", periodCode)
				        				 .header("gstin", gstinNo)
				        				 .header("X-Asp-Auth-Token", gspAuthString)
					    	             .header("X-Asp-Auth-Signature", gspAuthSignature)
				        				 .getHttpRequest();
				
				System.out.println("get GSTR1 ["+action+"] invoices url["+getDataReq.getUrl()+"]");
		        System.out.println("get GSTR1 ["+action+"] invoices method["+getDataReq.getHttpMethod()+"]");
				System.out.println("get GSTR1 ["+action+"] invoices request header["+getDataReq.getHeaders()+"]");
				
				HttpResponse<JsonNode> getDataResp = getDataReq.asJson();
				
				System.out.println("getDataResp.getStatus()["+getDataResp.getStatus()+"]");
				
				if(getDataResp.getStatus() == 200)
				{
					JSONObject getDataRespObj = getDataResp.getBody().getObject();
					if(getDataRespObj.has("data") && getDataRespObj.has("rek"))
					{
						callStatus = "1";
						String getdata = getDataRespObj.getString("data");
		                String getrek = getDataRespObj.getString("rek");

		                byte[] getapiEK = aesEncryption.decrypt(getrek, authSek);

		                String getrespJsoninBase64 = new String(aesEncryption.decrypt(getdata, getapiEK));

		                byte[] getrespJsonInBytes = aesEncryption.decodeBase64StringTOByte(getrespJsoninBase64);

		                String getjsonData = new String(getrespJsonInBytes);
		                System.out.println("json response["+getjsonData+"] for ["+action+"]");
		                
		                JSONObject getJsonDataJsonObj = new JSONObject(getjsonData);
		                
		                if(getJsonDataJsonObj.has("est") && getJsonDataJsonObj.has("token"))
		                {
		                	dataXML = getDataFromFileServer(gstinNo, "1", periodCode, authToken, userName, stateCode, authSek, getJsonDataJsonObj, action, xtraParams);
		                }
		                else
		                {
		                	dataXML = XML.toString(getJsonDataJsonObj);
		                	//writeDatatoJsonFile(getJsonDataJsonObj.toString(), action);
		                }
		                
		                
		                if("B2B".equalsIgnoreCase(action))
		                {
		                	retStringBuff.append("<b2b_invoices>");
		                	retStringBuff.append(dataXML);
		                	retStringBuff.append("</b2b_invoices>");
		                }
		                else if("B2CL".equalsIgnoreCase(action))
		                {
		                	retStringBuff.append("<b2cl_invoices>");
		                	retStringBuff.append(dataXML);
		                	retStringBuff.append("</b2cl_invoices>");
		                }
		                else if("B2CS".equalsIgnoreCase(action))
		                {
		                	retStringBuff.append("<b2cs_invoices>");
		                	retStringBuff.append(dataXML);
		                	retStringBuff.append("</b2cs_invoices>");
		                }
		                else if("CDNR".equalsIgnoreCase(action))
		                {
		                	retStringBuff.append("<cdnr_data>");
		                	retStringBuff.append(dataXML);
		                	retStringBuff.append("</cdnr_data>");
		                }
		                else if("CDNUR".equalsIgnoreCase(action))
		                {
		                	retStringBuff.append("<cdnur_data>");
		                	retStringBuff.append(dataXML);
		                	retStringBuff.append("</cdnur_data>");
		                }
		                else if("AT".equalsIgnoreCase(action))
		                {
		                	retStringBuff.append("<at_data>");
		                	retStringBuff.append(dataXML);
		                	retStringBuff.append("</at_data>");
		                }
		                else if("TXP".equalsIgnoreCase(action))
		                {
		                	retStringBuff.append("<txp_data>");
		                	retStringBuff.append(dataXML);
		                	retStringBuff.append("</txp_data>");
		                }
		                else if("NIL".equalsIgnoreCase(action))
		                {
		                	retStringBuff.append("<nil_data>");
		                	retStringBuff.append(dataXML);
		                	retStringBuff.append("</nil_data>");
		                }
		                else if("EXP".equalsIgnoreCase(action))
		                {
		                	retStringBuff.append("<exp_data>");
		                	retStringBuff.append(dataXML);
		                	retStringBuff.append("</exp_data>");
		                }
		                else if("HSNSUM".equalsIgnoreCase(action))
		                {
		                	retStringBuff.append("<hsnsum_data>");
		                	retStringBuff.append(dataXML);
		                	retStringBuff.append("</hsnsum_data>");
		                }
					}
					else
					{
						callStatus = "2";
						JSONObject errorJSON = getDataResp.getBody().getObject().getJSONObject("error");
						responseJsonStr = errorJSON.toString();
			        	System.out.println("errorJSON["+errorJSON+"]");
					}
				}
				else if(getDataResp.getStatus() == 500)
		        {
		        	callStatus = "2";
		        	String errMsg = "Message : Error occurred at GSTN server \nResponse code : "+getDataResp.getStatus();
		        	responseJsonStr = errMsg;
		        	System.out.println("errMsg["+errMsg+"]");
		        }
				else
	            {
					callStatus = "2";
	            	JSONObject errorJSON = getDataResp.getBody().getObject().getJSONObject("error");
	            	responseJsonStr = errorJSON.toString();
	            	System.out.println("errorJSON["+errorJSON+"]");
	            }
				
				APICallData apiCallData = new APICallData();
		        apiCallData.setPeriodCode(periodCode);
		        apiCallData.setCallDate(new Date());
		        apiCallData.setSiteCode(siteCode);
		        apiCallData.setUserId(loginCode);
		        apiCallData.setCallType("GET_"+action);
		        apiCallData.setRecType("1");
		        apiCallData.setNoOfRecords(0);
		        apiCallData.setCallStatus(callStatus);
		        apiCallData.setResponseId(responseId);
		        apiCallData.setResponseJsonStr(responseJsonStr);
		        apiCallData.setChgUser(loginCode);
		        apiCallData.setChgDate(new Date());
		        apiCallData.setChgTerm(chgTerm);
		        
		        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizEJB.downloadGstr1Data()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("final retStringBuff.toSting["+retStringBuff.toString()+"]");
		return retStringBuff.toString();
	}
	private String downloadGstr2Data (String gstinNo, String periodCode, String authToken, String userName, String stateCode, String appKeyEncryptedAndCoded, String xtraParams, byte[] authSek) throws ITMException
	{
		StringBuffer retStringBuff = new StringBuffer();
		String[] gstr2Section = {"B2B","IMPG","IMPS","CDN","NIL","TXLI","TXP","HSNSUM","B2BUR","ITCRVSL","CDNUR"};
		String gspAuthString = "", gspAuthSignature = "";
		String siteCode = "", loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");

			for(String action : gstr2Section)
			{
				long timeStamp = new Timestamp().getDateTime();
				System.out.println("calling for ["+action+"]");
				String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
				
				gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstinNo;
				gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
				
				HttpRequest getDataReq = Unirest.get(String.format("%s%s", BASE_API_URL,GSTR2_URL))
				        				 .queryString("action", action)
				        				 .queryString("gstin", gstinNo)
				        				 .queryString("ret_period", periodCode)
				        				 .header("Content-Type", APPLICATION_JSON)
				        				 .header("state-cd", stateCode)
				        				 .header("clientid", clientId)
				        				 .header("client-secret", clientSecret)
				        				 .header("ip-usr", ipAddress)
				        				 .header("username", userName)
				        				 .header("auth-token", authToken)
				        				 .header("app_key", appKeyEncryptedAndCoded)
				        				 .header("txn", transactionId)
				        				 .header("ret_period", periodCode)
				        				 .header("gstin", gstinNo)
				        				 .header("X-Asp-Auth-Token", gspAuthString)
					    	             .header("X-Asp-Auth-Signature", gspAuthSignature)
				        				 .getHttpRequest();
				
				System.out.println("get GSTR2 ["+action+"] invoices url["+getDataReq.getUrl()+"]");
		        System.out.println("get GSTR2 ["+action+"] invoices method["+getDataReq.getHttpMethod()+"]");
				System.out.println("get GSTR2 ["+action+"] invoices request header["+getDataReq.getHeaders()+"]");
				
				HttpResponse<JsonNode> getDataResp = getDataReq.asJson();
				
				System.out.println("getDataResp.getStatus()["+getDataResp.getStatus()+"]");
				
				if(getDataResp.getStatus() == 200)
				{
					JSONObject getDataRespObj = getDataResp.getBody().getObject();
					if(getDataRespObj.has("data") && getDataRespObj.has("rek"))
					{
						callStatus = "1";
						String getdata = getDataRespObj.getString("data");
		                String getrek = getDataRespObj.getString("rek");

		                byte[] getapiEK = aesEncryption.decrypt(getrek, authSek);

		                String getrespJsoninBase64 = new String(aesEncryption.decrypt(getdata, getapiEK));

		                byte[] getrespJsonInBytes = aesEncryption.decodeBase64StringTOByte(getrespJsoninBase64);

		                String getjsonData = new String(getrespJsonInBytes);
		                System.out.println("json response["+getjsonData+"] for ["+action+"]");
		                
		                if("B2B".equalsIgnoreCase(action))
		                {
		                	String b2bXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
		                	retStringBuff.append("<b2b_invoices>");
		                	retStringBuff.append(b2bXML);
		                	retStringBuff.append("</b2b_invoices>");
		                }
		                else if("IMPG".equalsIgnoreCase(action))
		                {
		                	String impgXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
		                	retStringBuff.append("<impg_data>");
		                	retStringBuff.append(impgXML);
		                	retStringBuff.append("</impg_data>");
		                }
		                else if("IMPS".equalsIgnoreCase(action))
		                {
		                	String impsXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
		                	retStringBuff.append("<imps_data>");
		                	retStringBuff.append(impsXML);
		                	retStringBuff.append("</imps_data>");
		                }
		                else if("CDN".equalsIgnoreCase(action))
		                {
		                	String cdnrXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
		                	retStringBuff.append("<cdnr_data>");
		                	retStringBuff.append(cdnrXML);
		                	retStringBuff.append("</cdnr_data>");
		                }
		                else if("CDNUR".equalsIgnoreCase(action))
		                {
		                	String cdnurXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
		                	retStringBuff.append("<cdnur_data>");
		                	retStringBuff.append(cdnurXML);
		                	retStringBuff.append("</cdnur_data>");
		                }
		                else if("NIL".equalsIgnoreCase(action))
		                {
		                	String nilData = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
		                	retStringBuff.append("<nil_data>");
		                	retStringBuff.append(nilData);
		                	retStringBuff.append("</nil_data>");
		                }
		                else if("TXLI".equalsIgnoreCase(action))
		                {
		                	String taxLiabXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
		                	retStringBuff.append("<txli_data>");
		                	retStringBuff.append(taxLiabXML);
		                	retStringBuff.append("</txli_data>");
		                }
		                else if("TXP".equalsIgnoreCase(action))
		                {
		                	String taxPaidXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
		                	retStringBuff.append("<txp_data>");
		                	retStringBuff.append(taxPaidXML);
		                	retStringBuff.append("</txp_data>");
		                }
		                else if("HSNSUM".equalsIgnoreCase(action))
		                {
		                	String hsnSumXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
		                	retStringBuff.append("<hsnsum_data>");
		                	retStringBuff.append(hsnSumXML);
		                	retStringBuff.append("</hsnsum_data>");
		                }
		                else if("B2BUR".equalsIgnoreCase(action))
		                {
		                	String b2burXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
		                	retStringBuff.append("<b2bur_data>");
		                	retStringBuff.append(b2burXML);
		                	retStringBuff.append("</b2bur_data>");
		                }
		                else if("ITCRVSL".equalsIgnoreCase(action))
		                {
		                	String itcRverslXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
		                	retStringBuff.append("<itcrvsl_data>");
		                	retStringBuff.append(itcRverslXML);
		                	retStringBuff.append("</itcrvsl_data>");
		                }
					}
					else
					{
						callStatus = "2";
						JSONObject errorJSON = getDataResp.getBody().getObject().getJSONObject("error");
						responseJsonStr = errorJSON.toString();
			        	System.out.println("errorJSON["+errorJSON+"]");
					}
				}
				else if(getDataResp.getStatus() == 500)
		        {
		        	callStatus = "2";
		        	String errMsg = "Message : Error occurred at GSTN server \nResponse code : "+getDataResp.getStatus();
		        	responseJsonStr = errMsg;
		        	System.out.println("errMsg["+errMsg+"]");
		        }
				else
	            {
					callStatus = "2";
	            	JSONObject errorJSON = getDataResp.getBody().getObject().getJSONObject("error");
	            	responseJsonStr = errorJSON.toString();
	            	System.out.println("errorJSON["+errorJSON+"]");
	            }
				
				APICallData apiCallData = new APICallData();
		        apiCallData.setPeriodCode(periodCode);
		        apiCallData.setCallDate(new Date());
		        apiCallData.setSiteCode(siteCode);
		        apiCallData.setUserId(loginCode);
		        apiCallData.setCallType("GET_"+action);
		        apiCallData.setRecType("2");
		        apiCallData.setNoOfRecords(0);
		        apiCallData.setCallStatus(callStatus);
		        apiCallData.setResponseId(responseId);
		        apiCallData.setResponseJsonStr(responseJsonStr);
		        apiCallData.setChgUser(loginCode);
		        apiCallData.setChgDate(new Date());
		        apiCallData.setChgTerm(chgTerm);
		        
		        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizEJB.downloadGstr2Data()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("final retStringBuff.toSting["+retStringBuff.toString()+"]");
		return retStringBuff.toString();
	}
	private String getGstr1Summary(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSek, String appKeyEncryptedAndCoded, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String siteCode = "", loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			HttpRequest getGstr1SumryReq = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR1_URL))
										   .queryString("action","RETSUM")
										   .queryString("gstin", gstin)
										   .queryString("ret_period", periodCode)
										   .header("Content-Type", APPLICATION_JSON)
										   .header("state-cd", stateCode)
										   .header("clientid", clientId)
										   .header("client-secret", clientSecret)
										   .header("ip-usr", ipAddress)
										   .header("username", userName)
										   .header("auth-token", authToken)
										   .header("txn", transactionId)
										   .header("ret_period", periodCode)
										   .header("gstin", gstin)
										   .header("X-Asp-Auth-Token", gspAuthString)
					    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
										   .getHttpRequest();
			
			System.out.println("get GSTR1 summary url["+getGstr1SumryReq.getUrl()+"]");
	        System.out.println("get GSTR1 summary method["+getGstr1SumryReq.getHttpMethod()+"]");
			System.out.println("get GSTR1 summary invoices request header["+getGstr1SumryReq.getHeaders()+"]");
			
			HttpResponse<JsonNode> getGstr1SumryResp = getGstr1SumryReq.asJson();
			
			System.out.println(String.format("getGstr1SumryResp Request : Status[%s] Response[%s]", getGstr1SumryResp.getStatus(), getGstr1SumryResp.getBody()));
			
			if (getGstr1SumryResp.getStatus() == 200) 
	        {
				JSONObject getGstr1SumryRespObj = getGstr1SumryResp.getBody().getObject();
				if(getGstr1SumryRespObj.has("data") && getGstr1SumryRespObj.has("rek"))
				{
					callStatus = "1";
					String gstr1Sumrydata = getGstr1SumryRespObj.getString("data");
					String gstr1Sumryrek = getGstr1SumryRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr1Sumryrek, authSek);
					
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr1Sumrydata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					
					JSONObject gstr1SumryJsonObj = new JSONObject(new String(respJsonInBytes));

					retString = gstr1SumryJsonObj.toString();
					
					System.out.println("retString in getGstr1Summary["+retString+"]");
				}
				else
	            {
					callStatus = "2";
					JSONObject errorJSON = getGstr1SumryResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	//retString = getError(errMsg, "GSTAPIERR", conn);
		        	retString = errMsg;
	            }
	        }
			else if(getGstr1SumryResp.getStatus() == 500)
	        {
	        	callStatus = "2";
	        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+getGstr1SumryResp.getStatus();
	        	responseJsonStr = errMsg;
	        	//retString = getError(errMsg, "GSTAPIERR", conn);
	        	retString = errMsg;
	        }
			else
            {
				callStatus = "2";
            	JSONObject errorJSON = getGstr1SumryResp.getBody().getObject().getJSONObject("error");
            	responseJsonStr = errorJSON.toString();
            	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
            	//retString = getError(errMsg, "GSTAPIERR", conn);
	        	retString = errMsg;
            }
			
			APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("RETSUM");
	        apiCallData.setRecType("1");
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWiz.getGstr1Summary()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String getGstr2Summary(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSek, String appKeyEncryptedAndCoded, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String siteCode = "", loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			HttpRequest getGstr2SumryReq = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR2_URL))
										   .queryString("action","RETSUM")
										   .queryString("gstin", gstin)
										   .queryString("ret_period", periodCode)
										   .header("Content-Type", APPLICATION_JSON)
										   .header("state-cd", stateCode)
										   .header("clientid", clientId)
										   .header("client-secret", clientSecret)
										   .header("ip-usr", ipAddress)
										   .header("username", userName)
										   .header("auth-token", authToken)
										   .header("txn", transactionId)
										   .header("ret_period", periodCode)
										   .header("gstin", gstin)
										   .header("X-Asp-Auth-Token", gspAuthString)
					    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
										   .getHttpRequest();
			
			System.out.println("get GSTR2 summary url["+getGstr2SumryReq.getUrl()+"]");
	        System.out.println("get GSTR2 summary method["+getGstr2SumryReq.getHttpMethod()+"]");
			System.out.println("get GSTR2 summary invoices request header["+getGstr2SumryReq.getHeaders()+"]");
			
			HttpResponse<JsonNode> getGstr2SumryResp = getGstr2SumryReq.asJson();
			
			System.out.println(String.format("getGstr2SumryResp Request : Status[%s] Response[%s]", getGstr2SumryResp.getStatus(), getGstr2SumryResp.getBody()));
			
			if (getGstr2SumryResp.getStatus() == 200) 
	        {
				JSONObject getGstr2SumryRespObj = getGstr2SumryResp.getBody().getObject();
				if(getGstr2SumryRespObj.has("data") && getGstr2SumryRespObj.has("rek"))
				{
					callStatus = "1";
					String gstr2Sumrydata = getGstr2SumryRespObj.getString("data");
					String gstr2Sumryrek = getGstr2SumryRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr2Sumryrek, authSek);
					
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr2Sumrydata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					
					JSONObject gstr2SumryJsonObj = new JSONObject(new String(respJsonInBytes));

					retString = gstr2SumryJsonObj.toString();
					
					System.out.println("retString in getGstr2Summary["+retString+"]");
				}
				else
	            {
					callStatus = "2";
					JSONObject errorJSON = getGstr2SumryResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	//retString = getError(errMsg, "GSTAPIERR", conn);
		        	retString = errMsg;
	            }
	        }
			else if(getGstr2SumryResp.getStatus() == 500)
	        {
	        	callStatus = "2";
	        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+getGstr2SumryResp.getStatus();
	        	responseJsonStr = errMsg;
	        	//retString = getError(errMsg, "GSTAPIERR", conn);
	        	retString = errMsg;
	        }
			else
            {
				callStatus = "2";
            	JSONObject errorJSON = getGstr2SumryResp.getBody().getObject().getJSONObject("error");
            	responseJsonStr = errorJSON.toString();
            	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
            	//retString = getError(errMsg, "GSTAPIERR", conn);
	        	retString = errMsg;
            }
			
			APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("RETSUM");
	        apiCallData.setRecType("2");
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWiz.getGstr2Summary()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String getGstr3bSummary(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSek, String appKeyEncryptedAndCoded, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String siteCode = "", loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			HttpRequest getGstr3bSumryReq = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR3B_URL))
										   .queryString("action","RETSUM")
										   .queryString("gstin", gstin)
										   .queryString("ret_period", periodCode)
										   .header("Content-Type", APPLICATION_JSON)
										   .header("state-cd", stateCode)
										   .header("clientid", clientId)
										   .header("client-secret", clientSecret)
										   .header("ip-usr", ipAddress)
										   .header("username", userName)
										   .header("auth-token", authToken)
										   .header("txn", transactionId)
										   .header("ret_period", periodCode)
										   .header("gstin", gstin)
										   .header("X-Asp-Auth-Token", gspAuthString)
					    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
										   .getHttpRequest();
			
			System.out.println("get GSTR3B summary url["+getGstr3bSumryReq.getUrl()+"]");
	        System.out.println("get GSTR3B summary method["+getGstr3bSumryReq.getHttpMethod()+"]");
			System.out.println("get GSTR3B summary invoices request header["+getGstr3bSumryReq.getHeaders()+"]");
			
			HttpResponse<JsonNode> getGstr3bSumryResp = getGstr3bSumryReq.asJson();
			
			System.out.println(String.format("getGstr3bSumryResp Request : Status[%s] Response[%s]", getGstr3bSumryResp.getStatus(), getGstr3bSumryResp.getBody()));
			
			if (getGstr3bSumryResp.getStatus() == 200) 
	        {
				JSONObject getGstr3bSumryRespObj = getGstr3bSumryResp.getBody().getObject();
				if(getGstr3bSumryRespObj.has("data") && getGstr3bSumryRespObj.has("rek"))
				{
					callStatus = "1";
					String gstr3bSumrydata = getGstr3bSumryRespObj.getString("data");
					String gstr3bSumryrek = getGstr3bSumryRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr3bSumryrek, authSek);
					
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr3bSumrydata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					
					JSONObject gstr3bSumryJsonObj = new JSONObject(new String(respJsonInBytes));

					retString = gstr3bSumryJsonObj.toString();
					
					System.out.println("retString in getGstr3bSummary["+retString+"]");
				}
				else
	            {
					callStatus = "2";
					JSONObject errorJSON = getGstr3bSumryResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	//retString = getError(errMsg, "GSTAPIERR", conn);
		        	retString = errMsg;
	            }
	        }
			else if(getGstr3bSumryResp.getStatus() == 500)
	        {
	        	callStatus = "2";
	        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+getGstr3bSumryResp.getStatus();
	        	responseJsonStr = errMsg;
	        	//retString = getError(errMsg, "GSTAPIERR", conn);
	        	retString = errMsg;
	        }
			else
            {
				callStatus = "2";
            	JSONObject errorJSON = getGstr3bSumryResp.getBody().getObject().getJSONObject("error");
            	responseJsonStr = errorJSON.toString();
            	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
            	//retString = getError(errMsg, "GSTAPIERR", conn);
	        	retString = errMsg;
            }
			
			APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("RETSUM");
	        apiCallData.setRecType("3");
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWiz.getGstr3bSummary()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String getPendingData(String recType, String siteCode, String periodCode, Connection conn) throws ITMException
	{
		String retString = "";
		boolean isPendingDataFound = false;
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			retString = "<pending_data>";
			sql = "SELECT DOC_NO, DOC_DATE, AMOUNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'P' AND PRD_CODE = ? AND SITE_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, recType);
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				isPendingDataFound = true;
				retString += "<data>";
				retString += "<doc_no><![CDATA["+checkNull(rs.getString("DOC_NO"))+"]]></doc_no>";
				retString += "<doc_date><![CDATA["+checkNull(rs.getString("DOC_DATE"))+"]]></doc_date>";
				retString += "<amount><![CDATA["+rs.getDouble("AMOUNT")+"]]></amount>";
				retString += "</data>";
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			retString += "</pending_data>";
			
			if(!isPendingDataFound)
			{
				retString = "";
			}
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizEJB.getPendingData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String getSignConfig(String loginCode, String returnType, Connection conn) throws ITMException
	{
		String retString = "";
		boolean isSignConfigFound = false;
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			retString = "<sign_data>";
			
			sql = "SELECT SIGN_METHOD,DOC_TYPE FROM USER_SIGN_ACC WHERE USER_ID = ? AND DOC_TYPE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginCode);
			pstmt.setString(2, returnType.trim());
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				isSignConfigFound = true;
				retString += "<data>";
				retString += "<sign_method><![CDATA["+checkNull(rs.getString("SIGN_METHOD"))+"]]></sign_method>";
				retString += "<doc_type><![CDATA["+checkNull(rs.getString("DOC_TYPE"))+"]]></doc_type>";
				retString += "</data>";
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			retString += "</sign_data>";
			
			if(!isSignConfigFound)
			{
				retString = "";
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizEJB.getSignConfig()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String getGSTR3BXMLData(String siteCode, String periodCode, Connection conn) throws ITMException
	{
		String retString = "";
		
		StringBuffer xmlStringBuff = new StringBuffer(); 
		
		int domId = 0;
		
		double interAmount = 0.0, intraAmount = 0.0;
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			xmlStringBuff.append("<root>");
			xmlStringBuff.append("<section domID = '"+(++domId)+"'>");

			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('01','02','03','04','05') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				xmlStringBuff.append("<summary_data>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</summary_data>");
			}
			closeResources(rs,pstmt);
			
			xmlStringBuff.append("</section>");
			xmlStringBuff.append("<section domID = '"+(++domId)+"'>");
			
			sql = " SELECT GDH.TRAN_TYPE, GDH.GST_CODE, S.DESCR, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD, STATE S" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID AND GDH.GST_CODE = S.GST_CODE " 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('06') GROUP BY TRAN_TYPE, GDH.GST_CODE, S.DESCR";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			xmlStringBuff.append("<unreg_data>");
			
			while(rs.next())
			{
				xmlStringBuff.append("<data>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<gst_code><![CDATA["+checkNull(rs.getString("GST_CODE"))+"]]></gst_code>");
				xmlStringBuff.append("<state_descr><![CDATA["+checkNull(rs.getString("DESCR"))+"]]></state_descr>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</data>");
			}
			closeResources(rs,pstmt);
			xmlStringBuff.append("</unreg_data>");
			
			sql = " SELECT GDH.TRAN_TYPE, GDH.GST_CODE, S.DESCR, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD, STATE S" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID AND GDH.GST_CODE = S.GST_CODE " 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('07') GROUP BY TRAN_TYPE, GDH.GST_CODE, S.DESCR";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			xmlStringBuff.append("<comp_data>");
			
			while(rs.next())
			{
				xmlStringBuff.append("<data>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<gst_code><![CDATA["+checkNull(rs.getString("GST_CODE"))+"]]></gst_code>");
				xmlStringBuff.append("<state_descr><![CDATA["+checkNull(rs.getString("DESCR"))+"]]></state_descr>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</data>");
			}
			closeResources(rs,pstmt);
			xmlStringBuff.append("</comp_data>");
			
			sql = " SELECT GDH.TRAN_TYPE, GDH.GST_CODE, S.DESCR, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD, STATE S" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID AND GDH.GST_CODE = S.GST_CODE " 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('08') GROUP BY TRAN_TYPE, GDH.GST_CODE, S.DESCR ORDER BY GDH.GST_CODE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			xmlStringBuff.append("<uin_data>");
			
			while(rs.next())
			{
				xmlStringBuff.append("<data>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<gst_code><![CDATA["+checkNull(rs.getString("GST_CODE"))+"]]></gst_code>");
				xmlStringBuff.append("<state_descr><![CDATA["+checkNull(rs.getString("DESCR"))+"]]></state_descr>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</data>");
			}
			closeResources(rs,pstmt);
			xmlStringBuff.append("</uin_data>");
			
			xmlStringBuff.append("</section>");
			xmlStringBuff.append("<section domID = '"+(++domId)+"'>");
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('09','10','11','12','13','14') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				xmlStringBuff.append("<itc_available>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</itc_available>");
			}
			closeResources(rs,pstmt);
				
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('15','16','17','18','19','20') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				xmlStringBuff.append("<itc_reversed>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</itc_reversed>");
			}
			closeResources(rs,pstmt);
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('21') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				xmlStringBuff.append("<itc_net>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</itc_net>");
			}
			closeResources(rs,pstmt);
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('22','23','24','25','26','27') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				xmlStringBuff.append("<itc_ineligible>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</itc_ineligible>");
			}
			closeResources(rs,pstmt);
			
			xmlStringBuff.append("</section>");
			xmlStringBuff.append("<section domID = '"+(++domId)+"'>");
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('28') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				interAmount = rs.getDouble("TAXABLE_AMT");
			}
			closeResources(rs,pstmt);
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('30') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				intraAmount = rs.getDouble("TAXABLE_AMT");
			}
			closeResources(rs,pstmt);
			
			xmlStringBuff.append("<gst_data>");
			xmlStringBuff.append("<tran_type><![CDATA[GST]]></tran_type>");
			xmlStringBuff.append("<inter><![CDATA["+interAmount+"]]></inter>");
			xmlStringBuff.append("<intra><![CDATA["+intraAmount+"]]></intra>");
			xmlStringBuff.append("</gst_data>");
			
			interAmount = 0.0; intraAmount = 0.0;
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('29') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				interAmount = rs.getDouble("TAXABLE_AMT");
			}
			closeResources(rs,pstmt);
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('31') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				intraAmount = rs.getDouble("TAXABLE_AMT");
			}
			closeResources(rs,pstmt);
			
			xmlStringBuff.append("<non_gst_data>");
			xmlStringBuff.append("<tran_type><![CDATA[NONGST]]></tran_type>");
			xmlStringBuff.append("<inter><![CDATA["+interAmount+"]]></inter>");
			xmlStringBuff.append("<intra><![CDATA["+intraAmount+"]]></intra>");
			xmlStringBuff.append("</non_gst_data>");
			
			xmlStringBuff.append("</section>");
			xmlStringBuff.append("<section domID = '"+(++domId)+"'>");
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('32') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				xmlStringBuff.append("<interest_latefee>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</interest_latefee>");
			}
			closeResources(rs,pstmt);
			
			xmlStringBuff.append("</section>");
				
			xmlStringBuff.append("</root>");
			
			retString = xmlStringBuff.toString();
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizEJB.getGSTR3BXMLData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("final retString ["+retString+"]");
		return retString;
	}
	private String getDataFromFileServer(String gstin, String recType, String periodCode, String authToken, String userName, String stateCode, byte[] authSek, JSONObject dataJSONObject, String sectionName, String xtraParams) throws ITMException
	{
		String retString = null;
		String transactionId = "", retFolderPath = "", gspAuthString = "", gspAuthSignature = "";
		String siteCode = "", loginCode = "", chgTerm = "", responseId = "", responseJsonStr = "", callStatus = "";
		String sep = File.separator;
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			retFolderPath = saveFilePath + sep + gstin + sep + periodCode + sep + "GSTR"+recType + sep + sectionName;
			File sectionFolder = new File(retFolderPath);
			
			if(!sectionFolder.exists())
			{
				sectionFolder.mkdirs();
				System.out.println("section folder created for ["+sectionName+"]");
			}
			
			transactionId = UUID.randomUUID().toString().replaceAll("-", "");
			long timeStamp = new Timestamp().getDateTime();
			gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);

			HttpRequest fileDetailsReq = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR_RETSTAT_URL))
										.queryString("gstin", gstin)
										.queryString("ret_period",periodCode)
										.queryString("token",dataJSONObject.getString("token"))
										.queryString("action","FILEDET")
										.header("Content-Type", APPLICATION_JSON)
										.header("state-cd", stateCode)
										.header("clientid", clientId)
										.header("client-secret", clientSecret)
										.header("ip-usr", ipAddress)
										.header("username", userName)
										.header("auth-token", authToken)
										.header("txn", transactionId)
										.header("ret_period", periodCode)
										.header("gstin", gstin)
										.header("X-Asp-Auth-Token", gspAuthString)
										.header("X-Asp-Auth-Signature", gspAuthSignature)
										.getHttpRequest();
			
			System.out.println("download file url["+fileDetailsReq.getUrl()+"]");
	        System.out.println("download file method["+fileDetailsReq.getHttpMethod()+"]");
			System.out.println("download file request header["+fileDetailsReq.getHeaders()+"]");

			HttpResponse<JsonNode> fileDetailsResp = fileDetailsReq.asJson();
			
			System.out.println(String.format("fileDetailsResp Request : Status[%s] Response[%s]", fileDetailsResp.getStatus(), fileDetailsResp.getBody()));
			
			if (fileDetailsResp.getStatus() == 200) 
			{
				JSONObject fileGstr1RespObj = fileDetailsResp.getBody().getObject();
				if(fileGstr1RespObj.has("data") && fileGstr1RespObj.has("rek"))
				{	
					callStatus = "1";
					String fileGstr1Data = fileGstr1RespObj.getString("data");
					String fileGstr1Rek = fileGstr1RespObj.getString("rek");

					byte[] fileGstr1ApiEK = aesEncryption.decrypt(fileGstr1Rek, authSek);

					String fileGstr1JsoninBase64 = new String(aesEncryption.decrypt(fileGstr1Data, fileGstr1ApiEK));

					byte[] fileGstr1JsonInBytes = aesEncryption.decodeBase64StringTOByte(fileGstr1JsoninBase64);

					JSONObject filedetailsJsonObj = new JSONObject(new String(fileGstr1JsonInBytes));

					if(filedetailsJsonObj.has("urls")&&filedetailsJsonObj.has("ek"))
					{
						String sessionKey = filedetailsJsonObj.getString("ek");
						JSONArray fileDetailsArry = filedetailsJsonObj.getJSONArray("urls");

						System.out.println("sessionKey["+sessionKey+"]");
						String sessionKeyFilePath = sectionFolder.getAbsolutePath() + sep + "key.txt";
						FileOutputStream keyFileOutStream = new FileOutputStream(sessionKeyFilePath);
						keyFileOutStream.write(sessionKey.getBytes());
						keyFileOutStream.close();
						
						for(int i=0; i<fileDetailsArry.length(); i++)
						{
							String fileName = "", filePath = "";
							
							JSONObject tempJsonObj = fileDetailsArry.getJSONObject(i);

							if(tempJsonObj.has("ul"))
							{
								String fileUrl = tempJsonObj.getString("ul");
								fileUrl = FILEDET_URL + fileUrl;
								URL url = new URL(fileUrl);
								HttpURLConnection connection = (HttpURLConnection) url.openConnection();

								int responseCode = connection.getResponseCode();
								if (responseCode == HttpURLConnection.HTTP_OK) 
								{
									String disposition = connection.getHeaderField("Content-Disposition");

									if (disposition != null) 
									{
										int index = disposition.indexOf("filename=");
										if (index > 0)
										{
											fileName = disposition.substring(index + 10, disposition.length() - 1);
										}
									} 
									else 
									{
										fileName = fileUrl.substring(fileUrl.lastIndexOf("/") + 1,fileUrl.lastIndexOf("?"));
									}

									InputStream inputStream = connection.getInputStream();
									
									filePath = sectionFolder.getAbsolutePath() + sep + fileName;
									
									FileOutputStream outputStream = new FileOutputStream(filePath);

									int bytesRead = -1;
									byte[] buffer = new byte[1024];
									while ((bytesRead = inputStream.read(buffer)) != -1) 
									{
										outputStream.write(buffer, 0, bytesRead);
									}

									outputStream.close();
									inputStream.close();
								}

								TarArchiveInputStream tarInput = new TarArchiveInputStream(new GzipCompressorInputStream(new FileInputStream(filePath)));
								TarArchiveEntry currentEntry = tarInput.getNextTarEntry();
								BufferedReader br = null;
								while (currentEntry != null) 
								{
									br = new BufferedReader(new InputStreamReader(tarInput));
									//System.out.println("For File = " + currentEntry.getName());
									String line;
									while ((line = br.readLine()) != null) 
									{
										//System.out.println("line="+line);

										byte[] decryptEK =  aesEncryption.decodeBase64StringTOByte(sessionKey);
										String decryptedData = new String(aesEncryption.decrypt(line, decryptEK));
										String decodedJson = new String(Base64.decodeBase64(decryptedData));

										retString += XML.toString(new JSONObject(decodedJson));
									}
									currentEntry = tarInput.getNextTarEntry();
								}
								tarInput.close();
							}
						}
						
						//retString = getDataXMLFromJsonFile(sectionName);
					}
				}
				else
				{
					String errMsg = "";
					callStatus = "2";
					JSONObject errorJSON = fileDetailsResp.getBody().getObject();
					if(errorJSON.has("error"))
					{
						JSONObject tempJsonObj = errorJSON.getJSONObject("error");
						
						if(tempJsonObj.has("message"))
						{
							errMsg = tempJsonObj.getString("message");
							retString = "<data_error><![CDATA["+errMsg+"]]></data_error>";
						}
					}
				}
			}
			else
			{
				String errMsg = "";
				callStatus = "2";
				JSONObject errorJSON = fileDetailsResp.getBody().getObject();
				if(errorJSON.has("error"))
				{
					JSONObject tempJsonObj = errorJSON.getJSONObject("error");
					
					if(tempJsonObj.has("message"))
					{
						errMsg = tempJsonObj.getString("message");
						retString = "<data_error><![CDATA["+errMsg+"]]></data_error>";
					}
				}
			}
			
			APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("FILEDET");
	        apiCallData.setRecType(recType);
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		catch(Exception e)
		{
			System.out.println("GSTCommonUtil.getDataFromFileServer()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("final retString["+retString+"]");
		return retString;
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";
			
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			System.out.println("GSTDataSubmitWizEJB.errorType()["+ex.getMessage()+"]");
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	private String getError(String errMsg, String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
			mainStr = checkNull(begPart) + "<![CDATA[" +errMsg+ " ]]>" + checkNull(endDesc);
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	private void closeResources(ResultSet rs, PreparedStatement pstmt) throws SQLException
	{
		boolean isError = false;
		try
		{
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(SQLException se)
		{
			isError = true;
			System.out.println("GSTDataSubmitWizPos.closeResources()["+se.getMessage()+"]");
			se.printStackTrace();
			throw new SQLException(se);
		}
		finally
		{
			try
			{
				if(isError)
				{
					if(rs!=null)
					{
						rs.close();
						rs=null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			catch(SQLException se)
			{
				isError = true;
				System.out.println("GSTDataSubmitWizPos.closeResources()inside finally["+se.getMessage()+"]");
				se.printStackTrace();
				throw new SQLException(se);
			}
		}
	}
}
