<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:NonHtml="http://www.progress.com/StylusStudio/NonHtml" version="1.0" exclude-result-prefixes="NonHtml">
   <xsl:output method="html" omit-xml-declaration="no" standalone="no" indent="no" />
   <xsl:template match="/">
      <html>
         <head>
            <link href="../../css/xtree.css" type="text/css" rel="stylesheet" />
            <link href="default.css" type="text/css" rel="stylesheet" />
            <LINK type="text/css" rel="stylesheet" href="/ibase/css/pordercss.css" />
            <LINK type="text/css" rel="stylesheet" href="/ibase/css/workflowsign.css" />
            <style type="text/css">
					html,body { /*height:100%;*/
						background-color: #f7f8fa;
						font-family: 'MuseoLight', sans-serif;
						-webkit-font-smoothing: antialiased;
						font-size: 14px;
						font-weight: normal;
					}
					
					.gray {
						color: #555;
						text-align: right;
						font-size: 14px;
					}
					
					.brdrt {
						border-right: 1px solid #ccc;
					}
					
					.editDisplayColumnClass {
						readOnly: true;
						color: #555;
						TEXT-ALIGN: left;
						padding: 5px;
						font-size: 16px;
						font-weight: normal;
					}
					
					.editDisplayheaderClass {
						readOnly: true;
						color: #000;
						TEXT-ALIGN: left;
						padding: 5px;
						font-weight: normal;
						font-size: 14px;
					}
					
					.editDisplayrightClass {
						readOnly: true;
						border: inset 1;
						COLOR: black;
						BACKGROUND: #FFFFD9;
						TEXT-ALIGN: right;
						font-weight: normal;
					}
					
					.editDisplayecnterClass {
						readOnly: true;
						color: #5fdeb2;
						TEXT-ALIGN: left;
						font-size: 18px;
						padding: 5px 0;
						font-weight: normal;
					}
					
					.editDisplayecnterClass2 {
						readOnly: true;
						border: inset 1;
						COLOR: black;
						TEXT-ALIGN: center;
						font-weight: normal;
					}
					
					.editDisplayClass {
						background-color: transparent !important;
						readOnly: true;
						color: #555;
						TEXT-ALIGN: left;
						padding: 5px;
						font-weight: normal;
						font-size: 14px;
					}
					
					input {
						color: rgb(80, 80, 80) !important;
						/* font-size: 14px !important; */ /* TODO: Changes in I18NLabel */
						font-size: 14px !important;
						border: 1px solid #ccc;
						background: #fff;
					}
					
					@font-face { /* declare fonts */
						font-family: "MuseoLight";
						src: url("../fonts/Museo300-Regular.eot");
						src: local("Museo 300"), local("Museo-300"),
							url("../fonts/Museo300-Regular.woff") format("woff"),
							url("../fonts/Museo300-Regular.otf") format("opentype"),
							url("../fonts/Museo300-Regular.svg#Museo-300") format("svg");
					}
					
					.editDisplayecnterClass1 {
						readOnly: true;
						color: #5fdeb2;
						TEXT-ALIGN: left;
						font-size: 16px;
						padding: 10px 0 0 0;
					}
					
					.editDisplayecnterClass3 {
						readOnly: true;
						color: #5fdeb2;
						TEXT-ALIGN: left;
						font-size: 16px;
						padding: 10px 0 0 0;
					}
					
					.tableClass2 {
						border-top: 2px solid #5fdeb2;
						border-right: 1px solid #ccc;
						border-left: 1px solid #ccc;
						border-bottom: 1px solid #ccc;
						background: #FFF;
						margin-bottom:20px;
					}
					
					.tableClass2 td {/*
						font-size: 14px;*/
						padding:5px;
					}
					
					.rtalign {
						color: #5893bf;
						text-align: right;
						padding: 5px;
						font-size: 14px;
						font-weight: normal;
					}
                     
					.po {
						readOnly: true;
						color: #555;
						TEXT-ALIGN: left;
						padding: 10px;
						font-weight: normal;
						font-size: 18px;
					}
					
					.black {
						color: #000;
						font-weight: normal;
						font-size: 17px;
					}
						
					.editDisplayClass211 {
						readOnly: true;
						color: #555;
						TEXT-ALIGN: left;
						padding: 5px;
						font-weight: normal;
						font-size: 14px;
					}
					.highlight {
						color:#FF9000;
					}
					
					.tableClass3 {
						border-left:1px solid #ccc;
						border-bottom:1px solid #ccc;
						border-right:1px solid #ccc;
						border-top:1px solid #ccc;
						background:#FFF;
					}
					
					.tableClass3 td {
						padding:5px;
					}
					
					.editDisplay1 {
						readonly:true;
						color:#999;
						font-weight:400;
						font-size:11px;
					}
					
					.name {
						color:#000;
						font-size:24px;
						text-align:center;
					}
					
					.amt {
						font-size:24px;
						text-align:center;
					}
					
					.center {
						text-align:center;
						color:#000;
						font-weight:400;
						font-size:16px;
					}
                </style>
         </head>
         <body>
            <input type="hidden" value="payment_exp" name="OBJ_NAME" />
            <input type="hidden" value="2" name="PAGE_CONTEXT" />
            <input type="hidden" value="1" name="OBJ_CONTEXT" />
            <form name="form">
               <xsl:for-each select="//Detail1">
                  <table cellSpacing="1" cellPadding="1" width="100%" border="0">
                     <tbody>
                        <tr>
                           <td colSpan="4" class="editDisplayColumnClass">Direct Payment</td>
                        </tr>
                        <tr />
                     </tbody>
                  </table>
               </xsl:for-each>
               <table cellSpacing="0" cellPadding="0" width="100%" border="0" class="tableClass2">
					<tbody>
						<xsl:for-each select="//Detail1">
							<tr>
								<td width="564" class="black">
									Tran Id:
									<xsl:value-of select="tran_id" />
								</td>
								<td width="562" class="black" align="right">
									<xsl:value-of select="tran_date" />
								</td>
							</tr>
							<tr>
								<td colspan="2"  align="center">
									<div class="name"><xsl:value-of select="sundry_type" /></div>
								</td>
							</tr>
							<tr>
								<td colspan="2"  align="center">
									<div class="name"><xsl:value-of select="sundry_code" />
								</td>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
				<table cellSpacing="0" cellPadding="0" width="100%" border="0" class="tableClass3">
					<tbody>
						<xsl:for-each select="//Detail1">
							<tr>
								<td width="33.33%" class="center" valign="top">
									Amount
								</td>
								<td width="33.33%" class="center" valign="center">
									Tax amount
								</td>
								<td width="33.33%" class="center" valign="center">
									Net amount
								</td>
							</tr>
							<tr>
								<td class="amt" valign="center" align="center">
									<div id="amount"><xsl:value-of select="amount" /></div>
								</td>
								<td class="amt" valign="center" align="center">
									<div id="tax_amt"><xsl:value-of select="tax_amt" /></div>
								</td>
								<td class="amt" valign="center" align="center">
									<div id="net_amt"><xsl:value-of select="net_amt" /></div>
								</td>
							</tr>
							<tr>
								<td colspan="3" valign="top" class="editDisplayClass211 ">
									Remarks:
									<span class="editDisplayClass211">
										<xsl:value-of select="remarks" />
									</span>
								</td>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
            </form>
         </body>
      </html>
   </xsl:template>
</xsl:stylesheet>