package ibase.dashboard.mfg.servlet;
import ibase.dashboard.mfg.ejb.HalolMFGCommitVsActualRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;
@SuppressWarnings("serial")
public class HalolWeekWiseActReleaseServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		HalolMFGCommitVsActualRemote halolMFGCommitVsActualRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String month = "";
		String week = "",geoLoc="";
		
		try
		{
			response.setContentType("application/xml");
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			dataSourceName    = request.getParameter("dataSourceName"); 
			month = (request.getParameter("month"));	
			week = (request.getParameter("week"));		
			geoLoc  = (request.getParameter("geolocation"));
			context = new InitialContext(appConnectParm.getProperty());
			halolMFGCommitVsActualRemote = (HalolMFGCommitVsActualRemote) context.lookup("ibase/HalolMFGCommitVsActual/remote");
			/*setUserInfo(userInfo) for DB connection on dated:14062016*/
			halolMFGCommitVsActualRemote.setUserInfo(userInfo);
			JSONObject jsonObjData       = (JSONObject)halolMFGCommitVsActualRemote.getWeekWiseActualRelease(dataSourceName,month,week,geoLoc);
			OutputStream outputStream    = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set inside HalolWeekWiseActReleaseServlet build the Graph is===" + jsonObjData);	
			
		} catch (Exception e)
		{
			System.out.println("Exception : HalolWeekWiseActReleaseServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e.getMessage());
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}
}