SET DEFINE OFF

/*
CREATE TABLE STD_PAYSTRU
(
	PAY_TABLE CHAR(5) NOT NULL,
	GRADE CHAR(5) NOT NULL,
	AD_CODE CHAR(5) NOT NULL,
	EFF_DATE DATE NOT NULL,
	VALID_UPTO DATE NOT NULL,
	AMOUNT NUMBER(14,3),
	AMOUNT_TYPE CHAR(1),
	FREQUENCY CHAR(1),
	PAY_METHOD CHAR(1),
	RES_FORMULA VARCHAR2(100),
	UPD_PAYSTRU CHAR(1),
	APPL_MODE CHAR(1),
	MTAKEHOME_MODE CHAR(1),
	CAN_MODIFY CHAR(1),
	MGROSS_MODE CHAR(1),
	PAGROSS_MODE CHAR(1),
	CHG_DATE DATE NOT NULL,
	CHG_USER CHAR(10) NOT NULL,
	CHG_TERM CHAR(15) NOT NULL
);
ALTER TABLE STD_PAYSTRU ADD CONSTRAINT STD_PAYSTRU_X PRIMARY KEY(PAY_TABLE, GRADE, AD_CODE, EFF_DATE, VALID_UPTO);
*/

INSERT INTO ITM2MENU 
(
	application,
	level_1,
	level_2,
	level_3,
	level_4,
	level_5,
	win_name,
	descr,
	comments,
	menu_path,
	icon_path,
	obj_type,
	mob_deploy,
	chg_user,
	chg_term,
	chg_date
) 
VALUES 
(
	'ADM',
	3,
	37,
	0,
	0,
	0,
	'w_std_paystru',
	'Standard Pay Structure',
	'Standard Pay Structure',
	'ADM.3.37.0.0.0',
	'e12_logo.gif',
	'T',
	NULL,
	'AALI',
	'BASE',
	fn_sysdate()
);

INSERT INTO  TRANSETUP 
(
	TRAN_WINDOW,
	SAVE_FLAG,
	VAL_FLAG,
	KEY_FLAG,
	KEY_STRING,
	REPEATE_ADD,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	EDI_OPTION,
	TRAN_ID_COL,
	MAIL_OPTION,
	CONFIRM_MODE,
	GARBAGE_OPT,
	TABLE_NAME,
	REF_SER,
	VIEW_MODE,
	APPLICATION
) 
VALUES 
(
	'w_std_paystru',
	2,
	2,
	'M',
	'seq10',
	'N',
	fn_sysdate(),
	'AALI',
	'BASE',
	0,
	'PAY_TABLE:GRADE:AD_CODE:EFF_DATE:VALID_UPTO',
	0,
	0,
	'N',
	'STD_PAYSTRU',
	NULL,
	'F',
	'ADM'
);

INSERT INTO OBJ_FORMS
(
	WIN_NAME,
	TITLE,
	OBJ_BROW_NAME,
	OBJ_EDIT_NAME,
	FORM_NO
) 
VALUES
(
	'w_std_paystru',
	'Std Pay Structure',
	'd_std_paystru11',
	'd_std_paystru21',
	'1'
);

INSERT INTO OBJ_ACTIONS 
(
	OBJ_NAME,
	LINE_NO,
	RIGHTS_CHAR,
	INTERACTIVE,
	SERVICE_CODE,
	DESCRIPTION,
	TITLE,
	IMAGE,
	FORM_NO,
	SERVICE_HANDLER,
	PLACEMENT,
	ACTION_TYPE
)
VALUES 
(
	'std_paystru',
	1,
	'A',
	'a',
	'a',
	'Add New',
	'Add',
	'add.gif',
	'1',
	null,
	null,
	'S'
);

INSERT INTO OBJ_ACTIONS 
(
	OBJ_NAME,
	LINE_NO,
	RIGHTS_CHAR,
	INTERACTIVE,
	SERVICE_CODE,
	DESCRIPTION,
	TITLE,
	IMAGE,
	FORM_NO,
	SERVICE_HANDLER,
	PLACEMENT,
	ACTION_TYPE
)
VALUES 
(
	'std_paystru',
	2,
	'E',
	'a',
	'a',
	'Edit',
	'Edit',
	'edit.gif',
	'1',
	null,
	null,
	'S'
);

INSERT INTO OBJ_ACTIONS 
(
	OBJ_NAME,
	LINE_NO,
	RIGHTS_CHAR,
	INTERACTIVE,
	SERVICE_CODE,
	DESCRIPTION,
	TITLE,
	IMAGE,
	FORM_NO,
	SERVICE_HANDLER,
	PLACEMENT,
	ACTION_TYPE
)
VALUES 
(
	'std_paystru',
	3,
	'D',
	'a',
	'a',
	'Delete',
	'Delete',
	'delete.gif',
	'1',
	null,
	null,
	'S'
);

INSERT INTO OBJ_ITEMCHANGE
(
	OBJ_NAME, 
	FORM_NO, 
	FIELD_NAME, 
	MANDATORY
)
VALUES 
(
	'std_paystru', 
	'1', 
	'itm_default', 
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
) 
VALUES 
(
	'std_paystru',
	'1',
	'pay_table',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
) 
VALUES 
(
	'std_paystru',
	'1',
	'grade',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME, 
	FORM_NO, 
	FIELD_NAME, 
	MANDATORY
) 
VALUES 
(
	'std_paystru',
	'1',
	'ad_code',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME, 
	FORM_NO, 
	FIELD_NAME, 
	MANDATORY
) 
VALUES 
(
	'std_paystru',
	'1',
	'mtakehome_mode',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE
(
	OBJ_NAME, 
	FORM_NO, 
	FIELD_NAME, 
	MANDATORY
)
VALUES 
(
	'std_paystru', 
	'1', 
	'itm_defaultedit', 
	'Y'
);

INSERT INTO SYSTEM_EVENTS 
(
	OBJ_NAME,
	EVENT_CODE,
	EVENT_CONTEXT,
	SERVICE_CODE,
	METHOD_RULE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	RESULT_HANDLE,
	OVERWRITE_CORE,
	COMP_TYPE,
	COMP_NAME,
	COMM_FORMAT
) 
VALUES 
(
	'std_paystru',
	'pre_validate',
	'1',
	'prv_std_paystru',
	NULL,
	fn_sysdate(),
	'AALI',
	'BASE',
	'2',
	'0',
	'EJB',
	'StdPayStru',
	NULL
);

INSERT INTO SYSTEM_EVENT_SERVICES
(
	SERVICE_CODE,
	SERVICE_DESCR,
	SERVICE_URI,
	SERVICE_PROVIDER,
	METHOD_NAME,
	RETURN_VALUE,
	RETURN_TYPE,
	RETURN_DESCR,
	RETURN_XFRM,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
) 
VALUES 
(
	'prv_std_paystru',
	'To validate the required fields',
	'http://localhost:9090/axis/services/ValidatorService',
	'base',
	'wfValData',
	'String',
	'S',
	NULL,
	NULL,
	fn_sysdate(),
	'AALI',
	'BASE'
);


INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_std_paystru',1,'COMPONENT_TYPE','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE','EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_std_paystru',2,'COMPONENT_NAME','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE','StdPayStru');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_std_paystru',3,'XML_DATA','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_std_paystru',4,'XML_DATA_1','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_std_paystru',5,'XML_DATA_ALL','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_std_paystru',6,'OBJ_CONTEXT','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_std_paystru',7,'EDIT_FLAG','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_std_paystru',8,'XTRA_PARAMS','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);


INSERT INTO SYSTEM_EVENTS 
(
	OBJ_NAME,
	EVENT_CODE,
	EVENT_CONTEXT,
	SERVICE_CODE,
	METHOD_RULE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	RESULT_HANDLE,
	OVERWRITE_CORE,
	COMP_TYPE,
	COMP_NAME,
	COMM_FORMAT
) 
VALUES 
(
	'std_paystru',
	'post_item_change',
	'1',
	'poic_std_paystru',
	NULL,
	fn_sysdate(),
	'AALI',
	'BASE',
	'2',
	'0',
	'EJB',
	'StdPayStru',
	NULL
);


INSERT INTO SYSTEM_EVENT_SERVICES
(
	SERVICE_CODE,
	SERVICE_DESCR,
	SERVICE_URI,
	SERVICE_PROVIDER,
	METHOD_NAME,
	RETURN_VALUE,
	RETURN_TYPE,
	RETURN_DESCR,
	RETURN_XFRM,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
) 
VALUES 
(
	'poic_std_paystru',
	'For item change on the required fields',
	'http://localhost:9090/axis/services/ValidatorService',
	'base',
	'itemChanged',
	'String',
	'S',
	NULL,
	NULL,
	fn_sysdate(),
	'AALI',
	'BASE'
);


INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_std_paystru',1,'COMPONENT_TYPE','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE','EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_std_paystru',2,'COMPONENT_NAME','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE','StdPayStru');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_std_paystru',3,'XML_DATA','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_std_paystru',4,'XML_DATA_1','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_std_paystru',5,'XML_DATA_ALL','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_std_paystru',6,'OBJ_CONTEXT','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_std_paystru',7,'FOCUSED_COLUMN','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('poic_std_paystru',8,'EDIT_FLAG','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_std_paystru',9,'XTRA_PARAMS','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);


INSERT INTO SYSTEM_EVENTS 
(
	OBJ_NAME,
	EVENT_CODE,
	EVENT_CONTEXT,
	SERVICE_CODE,
	METHOD_RULE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	RESULT_HANDLE,
	OVERWRITE_CORE,
	COMP_TYPE,
	COMP_NAME,
	COMM_FORMAT
) 
VALUES 
(
	'std_paystru',
	'pre_save',
	'1',
	'prs_std_paystru',
	NULL,
	fn_sysdate(),
	'AALI',
	'BASE',
	'2',
	'0',
	'EJB',
	'StdPayStruPrs',
	NULL
);


INSERT INTO SYSTEM_EVENT_SERVICES
(
	SERVICE_CODE,
	SERVICE_DESCR,
	SERVICE_URI,
	SERVICE_PROVIDER,
	METHOD_NAME,
	RETURN_VALUE,
	RETURN_TYPE,
	RETURN_DESCR,
	RETURN_XFRM,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
) 
VALUES 
(
	'prs_std_paystru',
	'For pre save updates on the desired fields',
	'http://localhost:9090/axis/services/ValidatorService',
	'base',
	'preSave',
	'String',
	'S',
	NULL,
	NULL,
	fn_sysdate(),
	'AALI',
	'BASE'
);


INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('prs_std_paystru',1,'COMPONENT_TYPE','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE','EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('prs_std_paystru',2,'COMPONENT_NAME','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE','StdPayStruPrs');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('prs_std_paystru',3,'XML_DATA_ALL','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('prs_std_paystru',4,'EDIT_FLAG','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('prs_std_paystru',5,'XTRA_PARAMS','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('prs_std_paystru',6,'DB_CONN','I',NULL,'S.Connection',NULL,fn_sysdate(),'AALI','BASE',NULL);


INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'PAY_TABLE',
	'W_STD_PAYSTRU',
	'SELECT PAY_TABLE, DESCR AS DESCRIPTION FROM PAYTABLE',
	'Pay Table',
	0,
	0,
	fn_sysdate(),
	'AALI',
	'BASE',
	NULL,
	1,
	1
);


INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'GRADE',
	'W_STD_PAYSTRU',
	'SELECT GRADE_CODE, DESCR AS DESCRIPTION FROM GRADE',
	'Grade',
	0,
	0,
	fn_sysdate(),
	'AALI',
	'BASE',
	NULL,
	1,
	1
);


INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'AD_CODE',
	'W_STD_PAYSTRU',
	'SELECT AD_CODE, DESCR AS DESCRIPTION FROM ALLWDEDN',
	'AD Code',
	0,
	0,
	fn_sysdate(),
	'AALI',
	'BASE',
	NULL,
	1,
	1
);


INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
   MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMSTDPAY01',
	'Pay Table is empty',
	'Pay Table is mandatory, please enter value in Pay Table',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMSTDPAY02',
	'Invalid Pay Table',
	'Entered Pay Table value is not existing in system, please enter valid Pay Table value',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMSTDPAY03',
	'Grade is empty',
	'Grade is mandatory, please enter Grade',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);


INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMSTDPAY04',
	'Invalid Grade',
	'Entered Grade does not exist in system, please enter valid Grade',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(	
	MSG_NO, 
	MSG_STR, 
	MSG_DESCR, 
	MSG_TYPE, 
	MSG_OPT, 
	CHG_DATE, 
	CHG_USER, 
	CHG_TERM
) 
VALUES 
(
	'VMSTDPAY05',
	'AD Code is Empty',
	'AD Code is mandatory, please enter AD Code',
	'E',
	'Y',
	fn_sysdate(),
	'AALI ',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMSTDPAY06',
	'Invalid AD Code',
	'Entered AD Code does not exist in the system, please enter valid AD Code',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMSTDPAY07',
	'Effective Date is Empty',
	'Effective Date is mandatory, please enter Effective Date',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMSTDPAY08',
	'Valid upto is Empty',
	'Valid upto is mandatory, please enter Valid upto',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);


INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMSTDPAY09',
	'Invalid Valid upto',
	'Valid upto should be greater than Effective Date',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMSTDPAY10',
	'Amount is empty',
	'Amount is mandatory, please enter Amount',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMSTDPAY11',
	'Update Failed',
	'Updating the previous valid upto in the database has failed',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMSTDPAY12',
	'Invalid Amount',
	'Entered value in Amount is invalid, please enter positive value in amount',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMSTDPAY13',
	'Invalid Date',
	'Entered value in effective date and valid upto is invalid, please enter new date',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

COMMIT;
