package ibase.java;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

import ibase.utility.CommonUtil;

public class MetisUpdate 
{
	Logger logger = Logger.getLogger(MetisUpdate.class);

	public String update(String ptcn) throws Exception 
	{
		String retString="Transaction Save Successfully";
		logger.info("Inside Updation................");
		CommonUtil commanUtil = new CommonUtil();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sqlStr = "";
		int rowUpd = 0;
		int rowUpd1 = 0;
		try 
		{
			
			conn = commanUtil.getConnection();
			conn.setAutoCommit(false);
			
			sqlStr = "update wave_task_det set status = 'Y',wave_status = 'V' where ref_id = (select ref_id from wave_task_det where ptcn = ? and ref_ser ='S-DSP')";
			logger.debug("SQL>>>>"+sqlStr);
			pstmt = conn.prepareStatement(sqlStr);
			logger.debug("SQL Param1>>>>"+ptcn);
			pstmt.setString(1, ptcn);
			rowUpd = pstmt.executeUpdate();
			pstmt.close();
			logger.debug("Rows Updated:"+rowUpd);
			
			sqlStr = "UPDATE SHIP_DOCS SET DESP_CONFIRMED = 'Y' , ERROR_MSG = NULL WHERE PTCN = ?";
			logger.debug("SQL>>>>"+sqlStr);
			pstmt = conn.prepareStatement(sqlStr);
			logger.debug("SQL Param1>>>>"+ptcn);
			pstmt.setString(1, ptcn);
			rowUpd1 = pstmt.executeUpdate();
			pstmt.close();
			
			logger.debug("Rows Updated:"+rowUpd1);
			
			if(rowUpd == 0 || rowUpd1 == 0)
			{
				retString ="No rows updated";
				conn.rollback();
			}
			else
			{
				retString="Transaction Save Successfully";
				logger.info("Commiting Connection............");
				conn.commit();	
			}
			
			
		} catch (Exception e) 
		{
			try 
			{
				conn.rollback();
			} catch (Exception e1) 
			{
				logger.error("Exception>>>>",e1);
				
			}
			logger.error("Exception>>>>",e);
			throw e;
		}
		finally
		{
			try {
				logger.info("Closing Connection............");
				pstmt.close();
				conn.close();
			} catch (Exception e) 
			{
				logger.error("Exception>>>>",e);
			}
		}

		return retString;
	}
	public String validate(String ptcn) throws Exception 
	{
		logger.info("Inside Validation................");
		String retString ="true";
		CommonUtil commanUtil = new CommonUtil();
		Connection conn = null;
		String str = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		if(ptcn.equals("")||ptcn.length()==0)
		{
			retString = "PTCN Can't Blank";
			return retString;
		}
		else
		{
			try 
			{
				conn = commanUtil.getConnection();
				conn.setAutoCommit(false);
				
				logger.debug("PTCN>>>>>>>>>>"+ptcn);

				str = "select count(1) from despatch where ptcn = ?";
				logger.debug("SQL>>>>"+str);
				pstmt = conn.prepareStatement(str);
				logger.debug("SQL Param1>>>>"+ptcn);
				pstmt.setString(1, ptcn);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					logger.debug("SQL Out>>>>"+rs.getInt(1));
					if(rs.getInt(1)==0)
					{
						retString = "PTCN Not Valid";
						return retString;
					}
				}
				pstmt.close();
				rs.close();

				str = "select count(1) from despatch where confirmed='Y' and ptcn = ?";
				logger.debug("SQL>>>>"+str);
				pstmt = conn.prepareStatement(str);
				logger.debug("SQL Param1>>>>"+ptcn);
				pstmt.setString(1, ptcn);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					logger.debug("SQL Out>>>>"+rs.getInt(1));
					if(rs.getInt(1)==0)
					{
						retString = "Corresponding despatch transaction should be confimed";
						return retString;
					}
				}
				pstmt.close();
				rs.close();

				str = "select count(*) from wave_task_det where ref_ser <> 'S-DSP' and status = 'N' "
						+ "and ptcn = ? ";
				logger.debug("SQL>>>>"+str);
				pstmt = conn.prepareStatement(str);
				logger.debug("SQL Param1>>>>"+ptcn);
				pstmt.setString(1, ptcn);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					logger.debug("SQL Out>>>>"+rs.getInt(1));
					if(rs.getInt(1) > 0)
					{
						retString = "Task Pending,all tasks must be completed before shipment.";
						return retString;
					}
				}
				pstmt.close();
				rs.close();

				str = "select count(*) from shipment s,ship_docs d where s.shipment_id =d.shipment_id "
						+ "and s.confirmed = 'Y' and d.ptcn = ? ";
				logger.debug("SQL>>>>"+str);
				pstmt = conn.prepareStatement(str);
				logger.debug("SQL Param1>>>>"+ptcn);
				pstmt.setString(1, ptcn);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					logger.debug("SQL Out>>>>"+rs.getInt(1));
					if(rs.getInt(1)==0)
					{
						retString = "The corresponding shipment transaction should be confirmed,before updating wave task status";
						return retString;
					}
				}
				pstmt.close();
				rs.close();
				
				str = "select count(*) from wave_task_det where ref_ser = 'S-DSP' and status = 'Y' and ptcn = ? ";
			logger.debug("SQL>>>>"+str);
			pstmt = conn.prepareStatement(str);
			logger.debug("SQL Param1>>>>"+ptcn);
			pstmt.setString(1, ptcn);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				logger.debug("SQL Out>>>>"+rs.getInt(1));
				if(rs.getInt(1) > 0)
				{
					retString = "Data Rectification for given PTCN already Done";
					return retString;
				}
			}
			pstmt.close();
			rs.close();

				conn.close();
			} catch (Exception e) 
			{
				logger.error("Exception>>>>",e);
				throw e;
			}
			finally
			{
				try 
				{
					logger.info("Closing Connection............");
					pstmt.close();
					rs.close();
					conn.close();
				} catch (SQLException e) 
				{
					logger.error("Exception>>>>",e);
				}
			}
		}
		return retString;
	}
}
