 package ibase.dashboard.pai.ejb;
 
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.ejb.Stateless;
import org.json.simple.JSONObject;
 
@Stateless
public class Outstanding extends ValidatorEJB  implements OutstandingRemote, OutstandingLocal

{
	GenericUtility genericUtility = new GenericUtility();
	
	/********** Start of method getOutstandingSummaryServlet()
	* EJB Name           : Outstanding.java
	* Method Name        : getPendingOrderServlet(String,String)
	* Servlet Name       : OutstandingSummaryServlet
	* Metadata xml Name  : outstandingsummary.xml
	* 
	* */
	
	@SuppressWarnings("unchecked")
	public JSONObject getOutstandingSummaryServlet(String dataSourceName,String custCode) throws RemoteException, ITMException
	{
		JSONObject outstandingSummaryJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		int count=0;
		try
		{
		  conn = connDriver.getConnectDB(dataSourceName);
		  connDriver = null;	
		  SimpleDateFormat appDateFormat = new SimpleDateFormat( genericUtility.getApplDateFormat());
		  SimpleDateFormat dbDateFormat= new SimpleDateFormat(genericUtility.getDBDateFormat());
		  System.out.println(" Inside getOutstandingSummaryServlet() Data Soruc Name ="+dataSourceName);
		  
		  sql = "select due_date,sum(tot_amt - adj_amt) as amount from receivables "
				+" where due_date between to_date(sysdate) and to_date(sysdate) + 3 "
				+" and cust_code = ? " +
				"group by due_date  ";   
		  
           pstmt = conn.prepareStatement(sql);
           pstmt.setString(1, custCode);
		   rs = pstmt.executeQuery();
		   while (rs.next())
			 {
				rowData = new JSONObject();
				String dueDate= checkNull(rs.getString("due_date"));
				if(dueDate.trim().length()>0)
				{
					rowData.put("date", appDateFormat.format(dbDateFormat.parse(dueDate)));
				}
				else
				{							
					rowData.put("date", checkNull(rs.getString("due_date")));
				}
				rowData.put("amount",checkNull(rs.getString("amount")));
				outstandingSummaryJson.put(count, rowData);
				count++;
			 }
		   rs.close();
		   rs = null;
		   pstmt.close();
		   pstmt = null;
			
		   sql =    " select due_date,sum(tot_amt - adj_amt) as amount from receivables "
				   +" where due_date > to_date(sysdate) + 3 " //and cust_code = ? " +
				  + "group by due_date ";
		    pstmt = conn.prepareStatement(sql);
		   // pstmt.setString(1, custCode);
		    rs = pstmt.executeQuery();
			while (rs.next())
			 {
				rowData = new JSONObject();
				rowData.put("date",   checkNull(rs.getString("due_date")));
				rowData.put("amount",   checkNull(rs.getString("amount")));
				outstandingSummaryJson.put(count, rowData);
				count++;
			 }
			System.out.println("JSON in getOutstandingSummaryServlet() : "+outstandingSummaryJson);
		 }
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :Outstanding: getOutstandingSummaryServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return outstandingSummaryJson;
	}
	/********** End of method getOutstandingSummaryServlet()  ******/
	

	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}
	}

 }

