package ibase.dashboard.scm.servlet;
import ibase.dashboard.scm.ejb.OrderVsShipmentRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class OrderVsShipmentServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData =null;
	JSONObject jsonMetaData = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}
  
	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		OrderVsShipmentRemote despatchOrderRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String siteCode = "";
		String lastMonth = "";
		String reportName="";
		String custCode="";
		String custCodeDlv="";
		try
		{
			response.setContentType("application/xml");
			HttpSession session = request.getSession(true);
			dataSourceName      = request.getParameter("dataSourceName");
			lastMonth           = request.getParameter("lastMonth");
			siteCode            = request.getParameter("siteCode");
			custCode            = request.getParameter("custCode");
			custCodeDlv         = request.getParameter("custCodeDlv");
			reportName			= request.getParameter("reportName");
			if(siteCode == null || siteCode.trim().length()<0 || siteCode.equals("") || siteCode == "")
			{
				ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
				siteCode     = userInfo.getSiteCode();  
				System.out.println("in OrderVsShipmentServlet siteCode from Session is=="+siteCode);
				
			}
			System.out.println("in doPost" + "siteCode is =" + siteCode+" lastMonth:"+lastMonth+" custCode:"+custCode+" custCodeDlv:"+custCodeDlv);
			session.setAttribute("reportName", reportName);
			System.out.println("reportName is =" + reportName );
			context = new InitialContext(appConnectParm.getProperty());
			despatchOrderRemote = (OrderVsShipmentRemote)context.lookup("ibase/OrderVsShipmentEJB/remote");
			JSONObject jsonObjData      = (JSONObject)despatchOrderRemote.getmonthWiseDespatchOrders(lastMonth,siteCode,custCode,custCodeDlv,dataSourceName);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for OrderVsShipmentServlet build the Graph is===" + jsonObjData);	

		} catch (Exception e)
		{
			System.out.println("Exception : OrderVsShipmentServlet :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
		
	}
}