package ibase.dashboard.sfa.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;


import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.ejb.Stateless;
import org.json.simple.JSONObject;

@Stateless
public class RejectionTemplSummary extends ValidatorEJB implements RejectionTemplSummaryLocal,RejectionTemplSummaryRemote
{

		
	GenericUtility genericUtility = GenericUtility.getInstance();
	SimpleDateFormat gridDateFormat=null;
	SimpleDateFormat convrtToTimStmDate=null;
	E12GenericUtility e12GenericUtility = null;
	
	//@SuppressWarnings({ "null", "unused", "unchecked" })
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getTemplSummary(String dataSourceName, String fromDate, String toDate, String projectmngr) throws RemoteException,ITMException 
	{
		JSONObject getTemplSummaryJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		Connection con = null;
		ConnDriver connDriver = new ConnDriver();
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Timestamp frmDateInTs = null;
		Timestamp toDateInTs  = null;
		
		SimpleDateFormat convertToDbDate  = null;
		SimpleDateFormat simpleDateFormat = null;
		Calendar calendar = null;		
		int count=0;
		
		try 
		{
			con = connDriver.getConnectDB(dataSourceName);
			connDriver=null;
			
			convertToDbDate     = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());			
			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				simpleDateFormat   = new SimpleDateFormat( genericUtility.getApplDateFormat());
	  			calendar           = Calendar.getInstance();
	  			toDate             = simpleDateFormat.format(calendar.getTime());	
	  			calendar           = Calendar.getInstance();
	  			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
         		fromDate        = simpleDateFormat.format(calendar.getTime());
         		frmDateInTs     = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString());
				toDateInTs      = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString());
			}  	 
			else
			{  
				
				frmDateInTs  = Timestamp.valueOf(genericUtility.getValidDateString(fromDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateTimeFormat()));
				toDateInTs   = Timestamp.valueOf(genericUtility.getValidDateString(toDate, genericUtility.getApplDateFormat(),  genericUtility.getDBDateTimeFormat()));
				
			}
			System.out.println("from date and to date after excution :"+frmDateInTs+"----- toDateInTs :"+toDateInTs);
		   
			if((frmDateInTs!=null && frmDateInTs.toString().length()>0) && (toDateInTs!=null && toDateInTs.toString().length()>0))
			{
				
			   sql = "SELECT to_char(SIH.TRAN_DATE,'dd-MON-yy') AS LOAD_DATE,SDT.TEMPLATE_ID AS TEMPLATE_ID,SDT.REF_ID AS TEMPLATE_NAME, "+
					" E.EMP_FNAME|| ' '|| E.EMP_LNAME AS MR_NAME, E1.EMP_FNAME|| ' '|| E1.EMP_LNAME AS REPORT_TO, "+
					" I.DESCR AS REJECTED_ITEM,SRD.QTY_RCP AS REJECTED_QUANTITY, to_char(SR.TRAN_DATE,'dd-MON-yy') AS REJECTION_DATE "+
					" FROM SAMPLE_INVTRACE SI INNER JOIN SAMPLE_RCP_DET SRD ON SRD.TRAN_ID=SI.REF_ID "+
					" AND SI.ITEM_CODE=SRD.ITEM_CODE INNER JOIN SAMPLE_RCP SR ON SR.TRAN_ID=SI.REF_ID "+
					" INNER JOIN SPRS_INV_HDR SIH ON SIH.TRAN_ID=SR.TRAN_ID__REF "+
					" INNER JOIN SAMPLE_DIST_TEMPL SDT ON SDT.TEMPLATE_ID=SIH.TEMPLATE_ID "+ 
					" INNER JOIN ITEM I ON SRD.ITEM_CODE=I.ITEM_CODE "+
					" INNER JOIN EMPLOYEE E ON TRIM(E.EMP_CODE)= TRIM(SIH.SPRS_CODE) "+ 
					" INNER JOIN EMPLOYEE E1 ON E1.EMP_CODE= E.REPORT_TO "+
					" WHERE SRD.QTY_ISS <> SRD.QTY_RCP "+
					" AND SIH.TRAN_DATE BETWEEN ? AND ? "+
					" ORDER BY SIH.TRAN_DATE";
			
			
				pstmt = con.prepareStatement(sql);
				pstmt.setTimestamp(1, frmDateInTs);
				pstmt.setTimestamp(2, toDateInTs);
				
				rs = pstmt.executeQuery();
				
				while(rs.next())
				{
					rowData = new JSONObject();
					rowData.put("tran_date", rs.getString("LOAD_DATE"));
					rowData.put("template_id", rs.getString("TEMPLATE_ID"));
					rowData.put("template_name", rs.getString("TEMPLATE_NAME"));
					rowData.put("mr_name", rs.getString("MR_NAME"));
					rowData.put("report_to", rs.getString("REPORT_TO"));
					rowData.put("rejected_item", rs.getString("REJECTED_ITEM"));
					rowData.put("rejected_quantity", rs.getString("REJECTED_QUANTITY"));
					rowData.put("rejection_date", rs.getString("REJECTION_DATE"));				
					getTemplSummaryJson.put(count, rowData);
					count++;
				}
				rs.close();
				rs=null;
				pstmt.close();
				pstmt=null;
			
			}
			System.out.println("RejectionDashboard.getTemplSummary()"+getTemplSummaryJson);
			
		} 
		catch (Exception e) 
		{
			System.out.println("In Catch block of EJB RejectionDashboard.getTemplSummary()");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally{
			try
			{
				if (con != null)
				{
					if (rs != null)
						rs.close();
						rs = null;
					if (pstmt != null)
						pstmt.close();
						pstmt = null;
						con.close();
						con = null;
				}
				con = null;
			} catch (Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception in :getTemplSummary:" + e.getMessage());
				throw new ITMException(e);
			}
		}
		
		return getTemplSummaryJson;
	}
	
	@SuppressWarnings("unchecked")
	public JSONObject getTemplDetail(String dataSourceName, String fromDate, String toDate, String templateID) throws RemoteException,ITMException 
	{
		JSONObject getTemplDetailJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		Connection con = null;
		ConnDriver connDriver = new ConnDriver();
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int count=0;
		
		try 
		{
			con = connDriver.getConnectDB(dataSourceName);
			connDriver=null;
		   if((templateID!=null && templateID.toString().length()>0))
			 {
				
			  sql =	"SELECT SDT.REF_ID,SDT.TEMPLATE_ID,I.DESCR,SDTD.QUANTITY" +
                    " FROM SAMPLE_DIST_TEMPL SDT" +
                    " INNER JOIN SAMPLE_DIST_TEMPL_DET SDTD ON SDT.TEMPLATE_ID=SDTD.TEMPLATE_ID" +
                    " INNER JOIN ITEM I ON I.ITEM_CODE=SDTD.ITEM_CODE" +
                    " WHERE SDT.TEMPLATE_ID ='"+templateID+"'";
			
			}
			pstmt = con.prepareStatement(sql);			
			rs = pstmt.executeQuery();			
			
			while(rs.next())
			{
				rowData = new JSONObject();
				rowData.put("ref_id", rs.getString("REF_ID"));
				rowData.put("template_id", rs.getString("TEMPLATE_ID"));
				rowData.put("descr", rs.getString("DESCR"));
				rowData.put("quantity", rs.getString("QUANTITY"));				
				getTemplDetailJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
			System.out.println("RejectionDashboard.getTemplDetail()"+getTemplDetailJson);
			
		} 
		catch (Exception e) 
		{
			System.out.println("In Catch block of EJB RejectionDashboard.getTemplDetail()");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally{
			try
			{
				if (con != null)
				{
					if (rs != null)
						rs.close();
						rs = null;
					if (pstmt != null)
						pstmt.close();
						pstmt = null;
						con.close();
						con = null;
				}
				con = null;
			} catch (Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception in :getTemplDetail:" + e.getMessage());
				throw new ITMException(e);
			}
		}
		
		return getTemplDetailJson;
	}
}
