
package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.util.*;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import java.text.SimpleDateFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.sql.Timestamp;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.ejb.Stateless; // added for ejb3
import ibase.webitm.ejb.ITMDBAccessEJB;
import org.w3c.dom.CDATASection;

import java.text.*; 
import java.sql.*;

@Stateless // added for ejb3

public class InvFreezeIC extends ValidatorEJB implements InvFreezeICLocal, InvFreezeICRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();	
	/**
	* The method is defined without any parameter and returns blank string
	*/
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}
	
	/**
	* The public method is used for converting the current form data into a document(DOM)
	* The currDom is then given as argument to the overloaded function wfValData to perform validation
	* Returns validation string if exists else returns null in XML format
	* @param currFrmXmlStr contains the current form data in XML format
	* @param hdrFrmXmlStr contains all the header information in the XML format
	* @param allFrmXmlStr contains the data of all the forms in XML format
	* @param objContext represents the form number
	* @param editFlag represents the mode of transaction(A-Add or E-Edit)
	* @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	*/
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = null;
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
		    
			System.out.println("Val xmlString :: " + xmlString );
			System.out.println("Val xmlString1 :: " + xmlString1 );
			System.out.println("Val xmlString2 :: " + xmlString2 );
			//long startTime = System.currentTimeMillis();
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
					
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException( e );
		}
		return (errString);
	}
	
	/**
	 * The public overloaded method takes a document as input and is used for the validation of specified fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currDom contains the current form data as a document object model
	 * @param hdrDom contains all the header information
	 * @param allDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
	  	NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0;
		int count = 0;
		String childNodeName = null;
		String errString = "";
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null , rs1 = null;
		String sql = "" ;
		String userId = "";
		int currentFormNo=0;
		int childNodeListLength;
		//Commented by Santosh on 14-06-2016
        //ConnDriver connDriver = new ConnDriver();
		String locCodeFrom = "";
		String locCodeTO = "";
		String itemSerFrom = "";
		String itemSerTo = "";
		String itemCodeFrom = "";
		String itemCodeTo = "";
	
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
				case 1 :
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
					    childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
					
						if( childNodeName.equalsIgnoreCase( "site_code" ))
						{ 
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString("site_code","NULLSITECO",userId);
								break;								
							}
							else
							{	
								 sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ?";
								 pstmt = conn.prepareStatement(sql);
								 pstmt.setString(1,getColumnValue("site_code",dom));
								 rs = pstmt.executeQuery();
								 if( rs.next() )
								 {
									count = rs.getInt("COUNT");
								 }
								 if( count == 0 )
								 {
									 errString = getErrorString("site_code","INVSITECOD",userId);
									 break;
								 }
								 if(pstmt != null)
								 {
									 pstmt.close();
									 pstmt = null;									 
								 }
								 
								 if(rs != null)
								 {
									 rs.close();
									 rs = null;
								 }
							 }
							 						
						}
						else if( childNodeName.equalsIgnoreCase( "eff_date" ))
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString("site_code","NULLEFFDT",userId);
								break;								
							}
						}
						else if( childNodeName.equalsIgnoreCase( "loc_code__from" ))
						{
							 locCodeFrom = getColumnValue("loc_code__from",dom);
							 if(locCodeFrom == null || locCodeFrom.trim().length()==0) 
							 {
								 errString = getErrorString("loc_code__from","NULLOCCODF",userId);
								 break;
							 }
							 else
							 {
								 sql = "SELECT COUNT(LOC_CODE) AS COUNT FROM LOCATION WHERE LOC_CODE = ?";
								 pstmt = conn.prepareStatement(sql);
								 pstmt.setString(1,getColumnValue("loc_code__from",dom));
								 rs = pstmt.executeQuery();
								 if( rs.next() )
								 {
									count = rs.getInt("COUNT");
								 }
								 if( count == 0 )
								 {			
									 errString = getErrorString("loc_code__from","INVLOCCODF",userId);
									 break;
								 }
								 
								 if(pstmt != null)
								 {
									 pstmt.close();
									 pstmt = null;									 
								 }
								 
								 if(rs != null)
								 {
									 rs.close();
									 rs = null;
								 }
								 
							 }
						}						
						else if( childNodeName.equalsIgnoreCase( "loc_code__to" ))
						{
							 
							 locCodeTO = getColumnValue("loc_code__to",dom);
							 if(locCodeTO==null || locCodeTO.trim().length()==0 ) 
							 {
								 errString = getErrorString("loc_code__to","NULLLOCODT",userId);
								 break;
							 }
							 else
							 {
								 sql = "SELECT COUNT(LOC_CODE) AS COUNT FROM LOCATION WHERE LOC_CODE = ?";
								 pstmt = conn.prepareStatement(sql);
								 pstmt.setString(1,getColumnValue("loc_code__to",dom));
								 rs = pstmt.executeQuery();
								 if( rs.next() )
								 {
									count = rs.getInt("COUNT");
								 }
								 if( count == 0 )
								 {			
									 errString = getErrorString("loc_code__to","INVLOCCODT",userId);
									 break;
								 }
								 if(pstmt != null)
								 {
									 pstmt.close();
									 pstmt = null;									 
								 }
								 
								 if(rs != null)
								 {
									 rs.close();
									 rs = null;
								 }
							 }
						}
						else if( childNodeName.equalsIgnoreCase( "item_ser__from" ))
						{
							 itemSerFrom = getColumnValue("item_ser__from",dom);
							 if(itemSerFrom == null || itemSerFrom.trim().length()==0) 
							 {
								 errString = getErrorString("item_ser__from","NULITMSERF",userId);
								 break;
							 }
							 else
							 {
								 sql = "SELECT COUNT(ITEM_SER) AS COUNT FROM ITEMSER WHERE ITEM_SER = ?";
								 pstmt = conn.prepareStatement(sql);
								 pstmt.setString(1,getColumnValue("item_ser__from",dom));
								 rs = pstmt.executeQuery();
								 if( rs.next() )
								 {
									count = rs.getInt("COUNT");
								 }
								 if( count == 0 )
								 {			
									 errString = getErrorString("item_ser__from","INVITMSERF",userId);
									 break;
								 }
								 if(pstmt != null)
								 {
									 pstmt.close();
									 pstmt = null;									 
								 }
								 
								 if(rs != null)
								 {
									 rs.close();
									 rs = null;
								 }
								 
							 }
						}
						else if( childNodeName.equalsIgnoreCase( "item_ser__to" ))
						{
							 itemSerTo = getColumnValue("item_ser__to",dom);							 
							 if(itemSerTo==null || itemSerTo.trim().length()==0) 
							 {
								 errString = getErrorString("item_ser__to","NULITMSERT",userId);
								 break;	
							 }
							 else
							 {
								 sql = "SELECT COUNT(ITEM_SER) AS COUNT FROM ITEMSER WHERE ITEM_SER = ?";
								 pstmt = conn.prepareStatement(sql);
								 pstmt.setString(1,getColumnValue("item_ser__to",dom));
								 rs = pstmt.executeQuery();
								 if( rs.next() )
								 {
									count = rs.getInt("COUNT");
								 }
								 if( count == 0 )
								 {			
									 errString = getErrorString("item_ser__to","INVITMSERT",userId);
									 break;
								 }
								 if(pstmt != null)
								 {
									 pstmt.close();
									 pstmt = null;									 
								 }
								 
								 if(rs != null)
								 {
									 rs.close();
									 rs = null;
								 }
								 
							 }
							 
						}
						/*--commented by gulzar on 21/12/11
						else if( childNodeName.equalsIgnoreCase( "item_code__from" ) )
						{
							 itemCodeFrom = getColumnValue("item_code__from",dom);							 
							 if(itemCodeFrom == null || itemCodeFrom.trim().length()==0 ) 
							 {
								 errString = getErrorString("item_code__from","NULITMCODF",userId);
								 break;
							 }
							 else
							 {
								 sql = "SELECT COUNT(ITEM_CODE) AS COUNT FROM ITEM WHERE ITEM_CODE = ?";
								 pstmt = conn.prepareStatement(sql);
								 pstmt.setString(1,getColumnValue("item_code__from",dom));
								 rs = pstmt.executeQuery();
								 if( rs.next() )
								 {
									count = rs.getInt("COUNT");
								 }
								 if( count == 0 )
								 {			
									 errString = getErrorString("item_code__from","INVITMCODF",userId);
									 break;
								 }
								 if(pstmt != null)
								 {
									 pstmt.close();
									 pstmt = null;									 
								 }
								 
								 if(rs != null)
								 {
									 rs.close();
									 rs = null;
								 }
								 
							 }
							 
						}
						else if( childNodeName.equalsIgnoreCase( "item_code__to" ))
						{
							 itemCodeTo = getColumnValue("item_code__to",dom);
							 if(itemCodeTo == null || itemCodeTo.trim().length()==0) 
							 {
								 errString = getErrorString("item_code__to","NULITMCODT",userId);
								 break;
							 }
							 else
							 {
								 sql = "SELECT COUNT(ITEM_CODE) AS COUNT FROM ITEM WHERE ITEM_CODE = ?";
								 pstmt = conn.prepareStatement(sql);
								 pstmt.setString(1,getColumnValue("item_code__to",dom));
								 rs = pstmt.executeQuery();
								 if( rs.next() )
								 {
									count = rs.getInt("COUNT");
								 }
								 if( count == 0 )
								 {			
									 errString = getErrorString("item_code__to","INVITMCODT",userId);
									 break;
								 }
								 if(pstmt != null)
								 {
									 pstmt.close();
									 pstmt = null;									 
								 }
								 
								 if(rs != null)
								 {
									 rs.close();
									 rs = null;
								 }
								 
							 }
						}
						*/
						//End commented by gulzar on 21/12/11
						/*else if( childNodeName.equalsIgnoreCase( "reason_code" ) )
						{
							reasCode = getColumnValue("reason_code",dom);
							
							if(reasCode != null)
							{
								 if(reasCode.length()>5) 
								 {
									errList.add("INVREASCD2");
									errFields.add("reason_code");
								 }
								 else
								 {
									 sql = "select * from gencodes where fld_value = ? and fld_name = 'REASON_CODE' and mod_name='W_PHY_INV_CNT'";
									 pstmt = conn.prepareStatement(sql);
									 pstmt.setString(1,getColumnValue("reason_code",dom));
									 rs = pstmt.executeQuery();
									 if(!rs.next())
									 {
										 errList.add("INVREASCD1");
										 errFields.add("reason_code");
									 }
									 rs.close();
									 rs = null;
									 pstmt.close();
									 pstmt = null;
								 }
							}
							else
							{
								errList.add("INVREASCD");
								errFields.add("reason_code");
							}
						}*/
						
                        						
					} // end for
					
					break;					
			} //END switch
			
			
		}//END TRY
		catch(Exception e)
		{
			e.printStackTrace();
			errString=e.getMessage();
			throw new ITMException( e );
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					if(rs != null )rs.close();
					if(rs1 != null )rs.close();
					rs = null;
					rs1 = null;
					if(pstmt != null )pstmt.close();
					pstmt =null;
					conn.close();
					conn = null;
				}
				conn = null;
			}catch(Exception d)
				{
				  d.printStackTrace();
				  throw new ITMException( d );
				}
		}
		
		return errString;
	}
	
	
	/**
	* The public method is defined without any parameters and returns blank string
	*/
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}
	
	/**
	* The public method is used for converting the current form data into a document(dom)
	* The currDom is then given as argument to the overloaded function wfValData to perform validation
	* Returns validation string if exists else returns null in XML format
	* @param currFrmXmlStr contains the current form data in XML format
	* @param hdrFrmXmlStr contains all the header information in the XML format
	* @param allFrmXmlStr contains the data of all the forms in XML format
	* @param objContext represents the form number
	* @param currentColumn represents the value of current field.
	* @param editFlag represents the mode of transaction(A-Add or E-Edit)
	* @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	*/
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{   
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			valueXmlString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
		}
		catch(Exception e)
		{
			System.out.println("Exception : [TrainingEJB][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
        return valueXmlString;
	}
	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currDom contains the current form data as a document object model
	 * @param hdrDom contains all the header information
	 * @param allDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param currentColumn represents the current field 
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information
	 * 
	 */
	
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String  sSQL = "";
		int currentFormNo = 0 ;
		int lineNo = 0 ;
		int count = 0;
		E12GenericUtility genericUtility = new E12GenericUtility();
		String siteCode = "";
		String locCodeFrom = "", locCodeTo = "", itemCode = "",locCode = "", lotNo = "", lotSl = "", quantity = "", unit = "";
		java.sql.Timestamp effDate = null;
		
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		try
		{   //Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			conn.setAutoCommit(false);
			//connDriver=null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			String effDateStr = genericUtility.getColumnValue("eff_date",dom1);
			effDateStr = genericUtility.getValidDateString(effDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
			effDate = java.sql.Timestamp.valueOf(effDateStr + " 00:00:00");
			
			locCodeFrom = genericUtility.getColumnValue("loc_code__from",dom1);
			locCodeTo = genericUtility.getColumnValue("loc_code__to",dom1);
			
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			

			switch(currentFormNo)
			{
			case 1 :
				valueXmlString.append("<Detail1>");		
				siteCode =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			    if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					
					valueXmlString.append("<confirmed protect=\"1\">").append("<![CDATA[N]]>").append("</confirmed>");
				    valueXmlString.append("<tran_date protect=\"1\">").append("<![CDATA["+simpleDateFormat.format(new Date())+"]]>").append("</tran_date>");
				    valueXmlString.append("<eff_date protect=\"1\">").append("<![CDATA["+simpleDateFormat.format(new Date())+"]]>").append("</eff_date>");
					valueXmlString.append("<site_code>").append("<![CDATA["+siteCode+"]]>").append("</site_code>");						
					valueXmlString.append("<ITEM_SER__FROM>").append("<![CDATA["+""+"]]>").append("</ITEM_SER__FROM>");						
					valueXmlString.append("<ITEM_SER__TO>").append("<![CDATA["+""+"]]>").append("</ITEM_SER__TO>");						
					valueXmlString.append("<LOC_CODE__FROM>").append("<![CDATA["+""+"]]>").append("</LOC_CODE__FROM>");						
					valueXmlString.append("<LOC_CODE__TO>").append("<![CDATA["+""+"]]>").append("</LOC_CODE__TO>");									
                }
				
				valueXmlString.append("</Detail1>");
              break;
				  case 2 :
					  if(currentColumn.trim().equalsIgnoreCase("itm_default"))
					  {
						System.out.println("In Itemchange Method Inv Detail2 FreeZe Inside Itemdefault..............................");
					
						siteCode = genericUtility.getColumnValue("site_code",dom1);
						
						sSQL = "SELECT S.SITE_CODE,S.ITEM_CODE,S.LOC_CODE,S.LOT_NO,S.LOT_SL,S.QUANTITY,S.UNIT " +
								"FROM STOCK S,PHY_CNT_SCH P,PHY_CNT_SCH_DET D " +
								"WHERE P.FROM_DATE <= ? AND P.TO_DATE >= ? " +
								"AND D.LOC_CODE >= ? AND D.LOC_CODE <= ? " +
								"AND S.SITE_CODE = ? " +
								"AND p.TRAN_ID = D.TRAN_ID " +
								"AND S.ITEM_CODE = D.ITEM_CODE " +
								"AND S.SITE_CODE = D.SITE_CODE " +
								"AND S.LOC_CODE = D.LOC_CODE " +
								"AND S.LOT_NO = D.LOT_NO " +
								"AND S.LOT_SL = D.LOT_SL ";
						System.out.println("** sSQL **["+sSQL+"]");
						pstmt = conn.prepareStatement(sSQL);
						pstmt.setTimestamp(1, effDate);
						pstmt.setTimestamp(2, effDate);
						pstmt.setString(3, locCodeFrom);
						pstmt.setString(4, locCodeTo);
						pstmt.setString(5, siteCode);
						rs = pstmt.executeQuery();							
						while(rs.next())
						{
							lineNo++;								
							itemCode = rs.getString("ITEM_CODE");
							siteCode = rs.getString("SITE_CODE");
							locCode = rs.getString("LOC_CODE");
							lotNo = rs.getString("LOT_NO");
							lotSl = rs.getString("LOT_SL");
							quantity  = rs.getString("QUANTITY");														
							unit = rs.getString("UNIT");														
							
							sSQL =  "SELECT COUNT(*) AS COUNT FROM INV_FREEZE_DET D, INV_FREEZE F WHERE D.ITEM_CODE = ? "+
									"AND D.SITE_CODE = ? "+
									"AND D.LOC_CODE = ? "+
									"AND D.LOT_NO = ? "+
									"AND D.LOT_SL = ? " +
									"AND F.EFF_DATE = ? "+
									"AND D.TRAN_ID = F.TRAN_ID "; 																	
					    	pstmt = conn.prepareStatement(sSQL);
					    	pstmt.setString(1, itemCode);
					    	pstmt.setString(2, siteCode);
					    	pstmt.setString(3, locCode);
					    	pstmt.setString(4, lotNo);
					    	pstmt.setString(5, lotSl);
					    	pstmt.setTimestamp(6, effDate);
					    	rs = pstmt.executeQuery();
					    	if( rs.next() )
							{
								count = rs.getInt("COUNT");
							}
							if( count == 0 )
							{
								valueXmlString.append("<Detail2 domID='"+lineNo+"'>\r\n" );									
								valueXmlString.append("<item_code>").append(itemCode).append("</item_code>");
								valueXmlString.append("<site_code>").append(siteCode).append("</site_code>");
								valueXmlString.append("<loc_code>").append(locCode).append("</loc_code>");
								valueXmlString.append("<lot_no>").append(lotNo).append("</lot_no>");
								valueXmlString.append("<lot_sl>").append(lotSl).append("</lot_sl>");
								valueXmlString.append("<quantity>").append(quantity).append("</quantity>");														
								valueXmlString.append("<unit>").append(unit).append("</unit>");														
								valueXmlString.append("<qty_physical>").append("0").append("</qty_physical>");
								valueXmlString.append("</Detail2>");
							}
							else
							{
								valueXmlString.append("<Detail2 domID='"+lineNo+"' objContext = '"+currentFormNo+"' objName=\"inv_freeze\" selected=\"Y\">\r\n" );
								valueXmlString.append("<attribute selected=\"Y\"/>\r\n" );									
								valueXmlString.append("<item_code>").append(itemCode).append("</item_code>");
								valueXmlString.append("<site_code>").append(siteCode).append("</site_code>");
								valueXmlString.append("<loc_code>").append(locCode).append("</loc_code>");
								valueXmlString.append("<lot_no>").append(lotNo).append("</lot_no>");
								valueXmlString.append("<lot_sl>").append(lotSl).append("</lot_sl>");
								valueXmlString.append("<quantity>").append(quantity).append("</quantity>");														
								valueXmlString.append("<unit>").append(unit).append("</unit>");											
								valueXmlString.append("<qty_physical>").append("0").append("</qty_physical>");
								valueXmlString.append("</Detail2>");
							}
						
						}
						if(pstmt != null)
						 {
							 pstmt.close();
							 pstmt = null;									 
						 }
						
						if(rs != null)
						{
							 rs.close();
							 rs = null;
						}
						
						
						break;
					  }
			}
			valueXmlString.append("</Root>");
			System.out.println(valueXmlString);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					if(pstmt != null)
					pstmt.close();
					if(rs != null)
					rs.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
				
			}
			catch(Exception d)
			{
			  d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}
}// END OF MAIN CLASS
		
		