package ibase.webitm.util.gst;

import java.io.IOException;
import java.text.SimpleDateFormat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.IMPS;
import ibase.webitm.bean.gst.InvLineItem;

public class IMPSSerializer extends JsonSerializer<IMPS>
{
	GSTCommonUtil gstCommonUtil = new GSTCommonUtil();
    final SimpleDateFormat gstFmt = new SimpleDateFormat(gstCommonUtil.getGSTDateFormat());
	
	@Override
	public void serialize(IMPS imps, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		
		if(imps.taxPayerAction != null && "D".equalsIgnoreCase(imps.taxPayerAction))
		{
			json.writeStringField("flag", imps.taxPayerAction);
			json.writeStringField("inum", imps.inum);
			json.writeStringField("idt", gstFmt.format(imps.idt));
		}
		else
		{
			json.writeStringField("inum", imps.inum);
			json.writeStringField("idt", gstFmt.format(imps.idt));
			json.writeNumberField("ival", imps.val);
			json.writeStringField("pos", imps.pos);
			
			json.writeFieldName("itms");
		
			json.writeStartArray();
			for(InvLineItem li : imps.items)
			{
				json.writeStartObject();
				
				json.writeNumberField("num", li.num);
				json.writeNumberField("txval", li.taxval);
				json.writeNumberField("rt", li.rate);
				if(li.iamt > 0.0)
	            {
	            	json.writeNumberField("iamt", li.iamt);
	            }
	            
	            if(li.camt > 0.0)
	            {
	            	json.writeNumberField("camt", li.camt);
	            }
	        	
	            if(li.samt > 0.0)
	            {
	            	json.writeNumberField("samt", li.samt);
	            }
	            
	            if(li.csamt > 0.0)
	            {
	            	json.writeNumberField("csamt", li.csamt);
	            }
	            
				json.writeStringField("elg", li.itcType);
				json.writeNumberField("tx_i", li.igstInputTax);
				if(li.cgstInputTax > 0.0)
				{
					json.writeNumberField("tx_c", li.cgstInputTax);
				}
				if(li.sgstInputTax > 0.0)
				{
					json.writeNumberField("tx_s", li.sgstInputTax);
				}
	        	json.writeNumberField("tx_cs", li.cessInputTax);
	        	
	        	json.writeEndObject();
			}
			json.writeEndArray();
		}
		json.writeEndObject();
	}

}
