package ibase.webitm.ejb.adm;

import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;

import org.w3c.dom.*;


@javax.ejb.Stateless
public class AttdDailyPos extends ValidatorEJB implements AttdDailyPosLocal, AttdDailyPosRemote
{
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String xmlString, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{

		String empCode = "";
		String loginEmpCode = "";
		String paySite = "";
		String errString = "";
		String sql = "";
		String errCode = "";
		String userId = "";
		String chgTerm = "";
		String attdDateStr = "";
		String prevInTime = "";
		String newInTime = "";
		String prevOutTime = "";
		String newOutTime = "";
		String punchStr = "";
		
		int attdUpdCnt = 0;
		Timestamp attdDate = null ;
		Timestamp  currDate = null;

		PreparedStatement pstmt = null;		
		ResultSet rs = null;

		boolean toUpdate = false;

		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();		
		AdmCommon admCommon = new AdmCommon();
		GenericUtility genericUtility = GenericUtility.getInstance();

		SimpleDateFormat sdfAppl = null;

		Document headerDom = null;

		try
		{

			System.out.println("XML String :"+xmlString);
			headerDom = genericUtility.parseString(xmlString); 				

			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			loginEmpCode  = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");

			empCode = checkNullAndTrim(genericUtility.getColumnValue("emp_code",headerDom));
			attdDateStr = checkNullAndTrim(genericUtility.getColumnValue("attd_date",headerDom));
			prevInTime = checkNullAndTrim(genericUtility.getColumnValue("prev_in_time",headerDom));
			newInTime = checkNullAndTrim(genericUtility.getColumnValue("in_time",headerDom));
			prevOutTime = checkNullAndTrim(genericUtility.getColumnValue("prev_out_time",headerDom));
			newOutTime = checkNullAndTrim(genericUtility.getColumnValue("out_time",headerDom));
			punchStr = checkNullAndTrim(genericUtility.getColumnValue("punch_str",headerDom));

			if (!prevInTime.equalsIgnoreCase(newInTime))
			{
				punchStr = "*-" + newInTime + "," + punchStr;
				toUpdate = true;
			}
			if (!prevOutTime.equalsIgnoreCase(newOutTime))
			{
				if (punchStr.length() > 0 && punchStr.substring(punchStr.length()-1) != ",")
				{
					punchStr = punchStr + ",";
				}
				punchStr = punchStr + "*-" + newOutTime;
				toUpdate = true;
			}
			if (toUpdate)
			{
				attdDateStr = genericUtility.getValidDateString(attdDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
				attdDate = java.sql.Timestamp.valueOf(attdDateStr + " 00:00:00");
				sql = "UPDATE ATTENDANCE_DAY SET PUNCH_STR = ? WHERE EMP_CODE = ? AND ATTD_DATE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1 , punchStr);
				pstmt.setString(2 , empCode);
				pstmt.setTimestamp(3 , attdDate);
				attdUpdCnt = pstmt.executeUpdate();
				System.out.println("AttdDailyPos - ATTENDANCE_DAY UPDATE COUNT [" + attdUpdCnt + "]");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			try
			{

				System.out.println("Exception IN AttdDailyPos::::"+e.getMessage());
				e.printStackTrace();			
				throw new ITMException(e);
			}
			catch (Exception e1)
			{
				e1.printStackTrace();
				throw new ITMException(e1);
			}
		}
		finally
		{
			try
			{	
				if(errString != null && errString.trim().length() > 0)
				{
					{
						conn.rollback();
					}
				}

				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception "+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}

	private String checkNull( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal;
	}
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal.trim();
	}
}

