package ibase.e12ria.e12widgets.client;

import java.util.Date;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.modernizr.client.Modernizr;
import com.google.gwt.modernizr.client.Modernizr.InputType;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;

/***
 * This E12DateBox clase are created two components <BR>
 * 1. Native date <BR>
 * 2. Datebox of GWT <BR><BR>
 * 
 * Depend upon conditions.<BR>
 * 1. If native date supported the browser then will be created a native date component <BR>
 * 2. If native date is not supported the browser then will be created a DateBox of GWT component.
 * 
 * @author Dnyaneshwar Chavan
 *
 */
public class E12DateBox extends Composite 
{

	private TextBox textBox = null;
	private DateBox dateBox = null;
	private boolean isNativeSupport;
	private DateTimeFormat formatter;
	
	final private String standardPattern = "yyyy-MM-dd"; 
	
	public E12DateBox()
	{
		Widget widget = null;
		if( Modernizr.inputType( InputType.DATE ) )
		{
			textBox = new TextBox();
			textBox.getElement().setAttribute( "type", "date" );
			textBox.addFocusHandler( E12TextBox.focusHandler );
			textBox.addBlurHandler( E12TextBox.blurHandler );
			widget = textBox;
			isNativeSupport = true;
		}
		else
		{
			dateBox = new DateBox();
			dateBox.addHandler( E12TextBox.focusHandler, FocusEvent.getType() );
			dateBox.addHandler( E12TextBox.blurHandler, BlurEvent.getType() );
			widget = dateBox;
			isNativeSupport = false;
		}
		initWidget( widget );
	}
	public void setFormat(DateTimeFormat formatter) 
	{	
		this.formatter = formatter;
		if( isNativeSupport )
		{
			
		}
		else
		{
			
			dateBox.setFormat( new DateBox.DefaultFormat( formatter ) );
		}
	}
	
	public void setEnabled( boolean enabled )
	{
		if( isNativeSupport )
		{
			textBox.setEnabled(enabled);
		}
		else
		{
			dateBox.setEnabled(enabled);
		}
	}
	
	public void setValue( Date date )
	{
		if( date == null )
		{
			return;
		}
		if( isNativeSupport )
		{
			String formatDate = formatDate( standardPattern , date );
			textBox.setValue( formatDate );
		}
		else
		{
			dateBox.setValue( date );
		}
	}
	
	public String getValue()
	{
		String returnDate = null ;
		try {
			if( isNativeSupport )
			{
				String nativeDateValue = textBox.getValue();
				Date dateStandFormat = DateTimeFormat.getFormat( standardPattern ).parse( nativeDateValue );
				returnDate = formatDate( formatter.getPattern(),dateStandFormat );
			}
			else
			{
				returnDate = dateBox.getFormat().format(dateBox,dateBox.getValue());
			}
		} catch (IllegalArgumentException e) {
			Window.alert( "Exception :: E12DateBox : getValue ["+e.getMessage()+"]" );
		}
		return returnDate;
	}
	
	public boolean isEnabled()
	{
		if( isNativeSupport )
		{
			return textBox.isEnabled();
		}
		else
		{
			return dateBox.getTextBox().isEnabled();
			
		}
	}
	
	public void setFocus( boolean focused )
	{
		if( isNativeSupport )
		{
			textBox.setFocus(focused);
		}
		else
		{
			dateBox.setFocus(focused);
			
		}
		
	}
	
	public void showDatePicker()
	{
		if( isNativeSupport )
		{
			//e12TextBox.setFocus(focused);
		}
		else
		{
			dateBox.showDatePicker();
			
		}
	}
	
	private String formatDate( String pattern, Date date )
	{
		DateTimeFormat dtf = DateTimeFormat.getFormat(pattern);
		return dtf.format( date );
	}
	
}
