/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMBrowFormRemote;
import ibase.webitm.utility.I18NLabel;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.naming.InitialContext;
import org.w3c.dom.Document;

public class ITMBrowFormBean
implements Serializable {
    String objName;
    String pContext = "1";
    String objContext = "1";
    String editFlag = "V";
    String reqParamStr = "";
    String user_lang = "en";
    String user_country = "US";
    UserInfoBean userInfo = null;

    public void setObjName(String string) {
        this.objName = string;
    }

    public String getObjName() {
        return this.objName;
    }

    public void setPContext(String string) {
        if (string != null && !"null".equalsIgnoreCase(string) && string.length() > 0) {
            this.pContext = string;
        }
    }

    public String getPContext() {
        return this.pContext;
    }

    public void setObjContext(String string) {
        if (string != null && !"null".equalsIgnoreCase(string) && string.length() > 0) {
            this.objContext = string;
        }
    }

    public String getObjContext() {
        return this.objContext;
    }

    public void setEditFlag(String string) {
        if (string != null && !"null".equalsIgnoreCase(string) && string.length() > 0) {
            this.editFlag = string;
        }
    }

    public String getEditFlag() {
        return this.editFlag;
    }

    public void setRequestParamStr(String string) {
        if (string != null && !"null".equalsIgnoreCase(string) && string.length() > 0) {
            this.reqParamStr = string;
        }
    }

    public void setUserInfo(UserInfoBean userInfoBean) {
        this.userInfo = userInfoBean;
    }

    private String getDefaultPath() {
        String string = null;
        string = CommonConstants.APPLICATION_CONTEXT != null ? CommonConstants.APPLICATION_CONTEXT + "webitm" + File.separator : ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
        return string;
    }

    public String getXSLFileName() throws ITMException {
        String string = null;
        try {
            String string2 = this.getDefaultPath();
            String string3 = this.objName + this.pContext + this.objContext + "_" + this.user_lang + "_" + this.user_country + "_" + this.editFlag + ".xsl";
            File file = new File(string2 + "xsl", string3);
            System.out.println("Searching for XSL File Abs Name :[" + string2 + "xsl/" + string3 + "]");
            if (file.exists()) {
                System.out.println("XSL File Exists........");
                string = file.getName();
            } else {
                System.out.println("XSL File does not exist........");
                String string4 = this.getBrowFormXSLStr();
                if (!string4.endsWith(".xsl")) {
                    byte[] byArray = string4.getBytes();
                    int n = byArray.length;
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byArray, 0, n);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    fileOutputStream = null;
                    string = file.getName();
                } else {
                    string = string4;
                }
            }
        }
        catch (ITMException iTMException) {
            System.out.println("ITMException: ITMBrowFormBean: getXSLFileName :==>" + (Object)((Object)iTMException));
            string = null;
            throw iTMException;
        }
        catch (Exception exception) {
            System.out.println("Exception: ITMBrowFormBean :getXSLFileName :==>" + exception);
            string = null;
            exception.printStackTrace();
            throw new ITMException(exception);
        }
        System.out.println("Returning XSL File Name :[" + string + "]");
        return string;
    }

    public String getXMLStr() throws ITMException {
        System.out.println("Getting Brow Form XML String....");
        InitialContext initialContext = null;
        String string = null;
        try {
            AppConnectParm appConnectParm = new AppConnectParm();
            initialContext = new InitialContext(appConnectParm.getProperty());
            ITMBrowFormRemote iTMBrowFormRemote = (ITMBrowFormRemote)initialContext.lookup("ibase/ITMBrowFormEJB/remote");
            string = iTMBrowFormRemote.getBrowForm(this.objName, this.objContext, this.objName + this.pContext + this.objContext, this.reqParamStr, this.userInfo);
        }
        catch (ITMException iTMException) {
            System.out.println("ITMException :ITMBrowFormBean :getXmlStr :==>");
            throw iTMException;
        }
        catch (Exception exception) {
            System.out.println("Exception :ITMBrowFormBean :getXmlStr :==>");
            exception.printStackTrace();
            throw new ITMException(exception);
        }
        System.out.println("Returning XML String Length :[" + string.length() + "]bytes");
        return string;
    }

    private String getBrowFormXSLStr() throws Exception {
        System.out.println("Building XSL Str......");
        String string = null;
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("IS_TAX_APPL", new Boolean(false));
            hashMap.put("KEY_FLAG", new String());
            hashMap.put("EDIT_TMPLT", new Integer(1));
            hashMap.put("CONFIRM_COL", "");
            hashMap.put("CONFIRM_VAL", "");
            I18NLabel i18NLabel = new I18NLabel();
            Document document = null;
            document = i18NLabel.setLocaleLabels(this.objName, this.objContext, this.user_lang, this.user_country, this.pContext, this.editFlag, this.userInfo.getProfileIdRes());
            string = i18NLabel.getXSL(this.editFlag, CommonConstants.APPLICATION_CONTEXT, hashMap);
            StringBuffer stringBuffer = new StringBuffer(string);
            string = stringBuffer.toString();
        }
        catch (ITMException iTMException) {
            System.out.println("ITMException: ITMBrowFormBean :getBrowFormXSLStr:==>" + (Object)((Object)iTMException));
            throw iTMException;
        }
        catch (Exception exception) {
            System.out.println("Exception: ITMBrowFormBean :getBrowFormXSLStr:==>" + exception);
            exception.printStackTrace();
            throw new ITMException(exception);
        }
        System.out.println("Returning XSL String Length :[" + string.length() + "]bytes");
        return string;
    }
}

