/********************************************************
	Title : LogWriter
	Date Of Creation : 27/11/07 	
	Name of Developer : Nisar S. Khatib

	Description : How to use Log writer
					1. Set Log on by using method setLogOn(true);
					2. Use write() or writeException() method to write errorstring or exception resp.
					3. Set log off by using method setLogOn(false);

********************************************************/
package ibase.webitm.ejb.adm.adv;

import java.rmi.RemoteException;
import java.util.*;
import java.util.Date;
import java.text.*;
import java.sql.*;
import java.io.*;

public class LogWriter
{
	FileWriter fw = null;
	int count = 0;
	String logFileName = null;

	public void setNameOfLog(String logFileName)
	{
		this.logFileName = logFileName;
		System.out.println("Log File Name========================>"+logFileName);
	}

	public void write(String s)
	{//this method write string to trace file
		try
		{
			count++;
			fw.write(count+"  :  "+s+"\r\n");
			fw.flush();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	public void writeException(Exception e1)
	{//this method write exceptions to trace file
		try
		{
			count++;
			fw.write(count+"  :  "+e1+"\r\n");
			fw.flush();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	public void setLogOn(boolean status)
	{//this method set trace or log on if status is true
		try
		{
			if(status)
			{
				boolean retain = (new File("C:\\JTrace")).exists();
				if(!retain)
				{
					retain =(new File("C:\\JTrace")).mkdirs();				
				}
				fw=new FileWriter("C:\\JTrace\\"+logFileName+".log");	
				System.out.println("========================Name of Log File : C:\\JTrace\\"+logFileName+".log=====================");
				fw.write("<<<<<<<<<<<<<<<<<<<<<<<<Trace Created On : "+new java.sql.Timestamp(System.currentTimeMillis())+">>>>>>>>>>>>>>>>>>>>>>>>>>\r\n");
			}
			else
			{
				fw.close();
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	//==============end of code====================================
	public String getFormatedValue(double actVal,int prec)throws RemoteException
	{//this method is used to return double with appropriate precison
		NumberFormat numberFormat = NumberFormat.getIntegerInstance ();
		Double DoubleValue = new Double (actVal);
		numberFormat.setMaximumFractionDigits(prec);
		String strValue = numberFormat.format(DoubleValue);
		System.out.println(strValue);
		strValue = strValue.replaceAll(",","");
		return strValue;
	}

	public static void main(String[] args) 
	{
		System.out.println("Hello World!");
	}
}