package ibase.webitm.util.gst;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.CDNUR;
import ibase.webitm.bean.gst.InvLineItem;

public class CDNURSerializer extends JsonSerializer<CDNUR>
{
	final SimpleDateFormat gstFmt = new SimpleDateFormat("dd-MM-yyyy");
	@Override
	public void serialize(CDNUR cdnur, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		
		json.writeStringField("typ", cdnur.customerType);
		json.writeStringField("ntty", cdnur.cdnNoteType);
		json.writeStringField("nt_num", cdnur.cdNoteNumber);
		json.writeStringField("nt_dt", gstFmt.format(cdnur.cdNoteDate));
		json.writeStringField("inum", cdnur.invoiceNumber);
		json.writeStringField("idt", gstFmt.format(cdnur.invoiceDate));
		json.writeNumberField("val", cdnur.val);
		
		writeLineItems(cdnur.items, json);

		json.writeEndObject();
	}
	
	private void writeLineItems(List<InvLineItem> items, JsonGenerator json)
	{
		try 
		{
			json.writeFieldName("itms");
			json.writeStartArray();
	        
	        for(InvLineItem li : items)
	        {
	        	writeLineItem(li, json);
	        }

	        json.writeEndArray();
		} 
		catch (IOException e) 
		{
			System.out.println("CDNRSerializer.writeCDNLineItems()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}
	
	private void writeLineItem(InvLineItem li, JsonGenerator json) 
    {
        try 
        {
            json.writeStartObject();
            
        	json.writeNumberField("num", li.num);
        	
        	json.writeFieldName("itm_det");
        	json.writeStartObject();
        	
            json.writeNumberField("rt", li.rate);
            json.writeNumberField("txval", li.taxval);

            if(li.iamt > 0)
            {
            	json.writeNumberField("iamt", li.iamt);
            }
            if(li.camt > 0)
            {
            	json.writeNumberField("camt", li.camt);
            }
            if(li.samt > 0)
            {
            	json.writeNumberField("samt", li.samt);
            }
            if(li.csamt > 0)
            {
            	json.writeNumberField("csamt", li.csamt);
            }
            json.writeEndObject();
            
            json.writeEndObject();
        }
        catch (Exception e) 
        {
        	System.out.println("CDNRSerializer.writeLineItem()["+e.getMessage()+"]");
            e.printStackTrace();
        }
    }

}
