package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.AT;
import ibase.webitm.bean.gst.InvLineItem;

public class ATSerializer extends BaseSerializer<AT>
{
	@Override
	public void serialize(AT at, JsonGenerator json, SerializerProvider serializeProvider) throws IOException, JsonProcessingException
	{
		json.writeStartObject();
		
		json.writeStringField("pos", at.pos);
		json.writeStringField("sply_ty", at.supplyType);
		
		writeLineItems(at, json);
		
		json.writeEndObject();
	}
	
	 private void writeLineItems(AT at, JsonGenerator json) throws IOException 
	    {
	        json.writeFieldName("itms");
	        
	        json.writeStartArray();
	        
	        for(InvLineItem li : at.itms)
	        {
	        	writeLineItem(json, li);
	        }

	        json.writeEndArray();
	    }

	    private void writeLineItem(JsonGenerator json, InvLineItem li) 
	    {
	        try 
	        {
	            json.writeStartObject();
	            
	            json.writeNumberField("rt", li.rate);
	            json.writeNumberField("ad_amt", li.taxval);

	            if(li.iamt > 0)
	            {
	            	json.writeNumberField("iamt", li.iamt);
	            }
	            if(li.camt > 0)
	            {
	            	json.writeNumberField("camt", li.camt);
	            }
	            if(li.samt > 0)
	            {
	            	json.writeNumberField("samt", li.samt);
	            }
	            if(li.csamt > 0)
	            {
	            	json.writeNumberField("csamt", li.csamt);
	            }
	            
	            json.writeEndObject();
	        }
	        catch (Exception e) 
	        {
	        	System.out.println("ATSearializer.writeLineItem()["+e.getMessage()+"]");
	            e.printStackTrace();
	        }
	    }
}
